/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.exceptions.NoTableManagedException;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.ArrayMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedElementPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedValuePCMapping;
import org.datanucleus.store.mapped.mapping.InterfaceMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingFactory;
import org.datanucleus.store.mapped.mapping.MappingManager;
import org.datanucleus.store.mapped.mapping.ObjectMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.mapped.mapping.SerialisedElementPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.mapped.mapping.SerialisedValuePCMapping;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractMappingManager
implements MappingManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected final MappedStoreManager storeMgr;

    public AbstractMappingManager(MappedStoreManager storeMgr) {
        this.storeMgr = storeMgr;
    }

    public abstract void loadDatastoreMapping(PluginManager var1, ClassLoaderResolver var2, String var3);

    public JavaTypeMapping getMappingWithDatastoreMapping(Class c, boolean serialised, boolean embedded, ClassLoaderResolver clr) {
        try {
            DatastoreClass datastoreClass = this.storeMgr.getDatastoreClass(c.getName(), clr);
            return datastoreClass.getIDMapping();
        }
        catch (NoTableManagedException ex) {
            Class mc = this.getMappingClass(c, serialised, embedded, null);
            mc = this.getOverrideMappingClass(mc, null, -1);
            JavaTypeMapping m = MappingFactory.createMapping(mc, this.storeMgr.getDatastoreAdapter(), c.getName());
            if (m == null) {
                String name = mc.getName();
                name = name.substring(name.lastIndexOf(46) + 1);
                throw new NucleusUserException(LOCALISER.msg("041012", (Object)name));
            }
            if (m.hasSimpleDatastoreRepresentation()) {
                this.createDatastoreMapping(m, null, m.getJavaTypeForDatastoreMapping(0));
            }
            return m;
        }
    }

    public JavaTypeMapping getMapping(Class c) {
        return this.getMapping(c, false, false, null);
    }

    public JavaTypeMapping getMapping(Class c, boolean serialised, boolean embedded, String fieldName) {
        Class mc = this.getMappingClass(c, serialised, embedded, fieldName);
        JavaTypeMapping m = MappingFactory.createMapping(mc = this.getOverrideMappingClass(mc, null, -1), this.storeMgr.getDatastoreAdapter(), c.getName());
        if (m == null) {
            String name = mc.getName();
            name = name.substring(name.lastIndexOf(46) + 1);
            throw new NucleusUserException(LOCALISER.msg("041012", (Object)name));
        }
        return m;
    }

    public JavaTypeMapping getMapping(DatastoreContainerObject datastoreContainer, AbstractMemberMetaData fmd, DatastoreAdapter dba, ClassLoaderResolver clr, int fieldRole) {
        Class mc = null;
        if (fieldRole == 3 || fieldRole == 4) {
            mc = this.getElementMappingClass(datastoreContainer, fmd, dba, clr);
        } else if (fieldRole == 5) {
            mc = this.getKeyMappingClass(datastoreContainer, fmd, dba, clr);
        } else if (fieldRole == 6) {
            mc = this.getValueMappingClass(datastoreContainer, fmd, dba, clr);
        } else {
            String userMappingClassName = fmd.getValueForExtension("mapping-class");
            if (userMappingClassName != null) {
                try {
                    mc = clr.classForName(userMappingClassName);
                }
                catch (NucleusException jpe) {
                    throw new NucleusUserException(LOCALISER.msg("041014", (Object)fmd.getFullFieldName(), (Object)userMappingClassName)).setFatal();
                }
            } else {
                AbstractClassMetaData acmd = null;
                acmd = fmd.getType().isInterface() ? this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForInterface(fmd.getType(), clr) : this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(fmd.getType(), clr);
                mc = fmd.isSerialized() ? this.getMappingClass(fmd.getType(), true, false, fmd.getFullFieldName()) : (fmd.getEmbeddedMetaData() != null ? this.getMappingClass(fmd.getType(), false, true, fmd.getFullFieldName()) : (acmd != null && acmd.isEmbeddedOnly() ? this.getMappingClass(fmd.getType(), false, true, fmd.getFullFieldName()) : (fmd.isEmbedded() ? this.getMappingClass(fmd.getType(), true, false, fmd.getFullFieldName()) : this.getMappingClass(fmd.getType(), false, false, fmd.getFullFieldName()))));
            }
        }
        mc = this.getOverrideMappingClass(mc, fmd, fieldRole);
        JavaTypeMapping m = MappingFactory.createMapping(mc, dba, fmd, fieldRole, datastoreContainer, clr);
        if (m == null) {
            throw new NucleusException(LOCALISER.msg("041011", (Object)mc.getName())).setFatal();
        }
        return m;
    }

    protected Class getOverrideMappingClass(Class mappingClass, AbstractMemberMetaData fmd, int fieldRole) {
        return mappingClass;
    }

    protected Class getMappingClass(Class c, boolean serialised, boolean embedded, String fieldName) {
        Class superClass;
        Class mappingClass;
        ApiAdapter api = this.storeMgr.getApiAdapter();
        if (api.isPersistable(c)) {
            if (serialised) {
                return SerialisedPCMapping.class;
            }
            if (embedded) {
                return EmbeddedPCMapping.class;
            }
            return PersistableMapping.class;
        }
        if (c.isInterface() && !this.storeMgr.getMappedTypeManager().isSupportedMappedType(c.getName())) {
            if (serialised) {
                return SerialisedReferenceMapping.class;
            }
            if (embedded) {
                return EmbeddedPCMapping.class;
            }
            return InterfaceMapping.class;
        }
        if (c == Object.class) {
            if (serialised) {
                return SerialisedReferenceMapping.class;
            }
            if (embedded) {
                throw new NucleusUserException(LOCALISER.msg("041042", (Object)fieldName)).setFatal();
            }
            return ObjectMapping.class;
        }
        if (c.isArray()) {
            if (api.isPersistable(c.getComponentType())) {
                return ArrayMapping.class;
            }
            if (c.getComponentType().isInterface() && !this.storeMgr.getMappedTypeManager().isSupportedMappedType(c.getComponentType().getName())) {
                return ArrayMapping.class;
            }
            if (c.getComponentType() == Object.class) {
                return ArrayMapping.class;
            }
        }
        if ((mappingClass = this.getDefaultJavaTypeMapping(c)) == null) {
            for (superClass = c.getSuperclass(); superClass != null && !superClass.getName().equals(ClassNameConstants.Object) && mappingClass == null; superClass = superClass.getSuperclass()) {
                mappingClass = this.getDefaultJavaTypeMapping(superClass);
            }
        }
        if (mappingClass == null) {
            if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(c.getName())) {
                throw new NucleusUserException(LOCALISER.msg("041001", (Object)fieldName, (Object)c.getName()));
            }
            for (superClass = c; superClass != null && !superClass.getName().equals(ClassNameConstants.Object) && mappingClass == null; superClass = superClass.getSuperclass()) {
                Class<?>[] interfaces = superClass.getInterfaces();
                for (int i = 0; i < interfaces.length && mappingClass == null; ++i) {
                    mappingClass = this.getDefaultJavaTypeMapping(interfaces[i]);
                }
            }
            if (mappingClass == null) {
                mappingClass = SerialisedMapping.class;
            }
        }
        return mappingClass;
    }

    protected Class getElementMappingClass(DatastoreContainerObject container, AbstractMemberMetaData mmd, DatastoreAdapter dba, ClassLoaderResolver clr) {
        if (!mmd.hasCollection() && !mmd.hasArray()) {
            throw new NucleusException("Attempt to get element mapping for field " + mmd.getFullFieldName() + " that has no collection/array!").setFatal();
        }
        if (mmd.getJoinMetaData() == null) {
            AbstractMemberMetaData[] refMmds = mmd.getRelatedMemberMetaData(clr);
            if (refMmds == null || refMmds.length == 0) {
                throw new NucleusException("Attempt to get element mapping for field " + mmd.getFullFieldName() + " that has no join table defined for the collection/array").setFatal();
            }
            if (refMmds[0].getJoinMetaData() == null) {
                throw new NucleusException("Attempt to get element mapping for field " + mmd.getFullFieldName() + " that has no join table defined for the collection/array").setFatal();
            }
        }
        String userMappingClassName = null;
        if (mmd.getElementMetaData() != null) {
            userMappingClassName = mmd.getElementMetaData().getValueForExtension("mapping-class");
        }
        if (userMappingClassName != null) {
            try {
                return clr.classForName(userMappingClassName);
            }
            catch (NucleusException jpe) {
                throw new NucleusUserException(LOCALISER.msg("041014", (Object)userMappingClassName)).setFatal();
            }
        }
        boolean serialised = mmd.hasCollection() && mmd.getCollection().isSerializedElement() || mmd.hasArray() && mmd.getArray().isSerializedElement();
        boolean embeddedPC = mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null;
        boolean elementPC = mmd.hasCollection() && mmd.getCollection().elementIsPersistent() || mmd.hasArray() && mmd.getArray().elementIsPersistent();
        boolean embedded = true;
        if (mmd.hasCollection()) {
            embedded = mmd.getCollection().isEmbeddedElement();
        } else if (mmd.hasArray()) {
            embedded = mmd.getArray().isEmbeddedElement();
        }
        Class<?> elementCls = null;
        if (mmd.hasCollection()) {
            elementCls = clr.classForName(mmd.getCollection().getElementType());
        } else if (mmd.hasArray()) {
            elementCls = mmd.getType().getComponentType();
        }
        boolean elementReference = ClassUtils.isReferenceType(elementCls);
        Class mc = null;
        mc = serialised ? (elementPC ? SerialisedElementPCMapping.class : (elementReference ? SerialisedReferenceMapping.class : SerialisedMapping.class)) : (embedded ? (embeddedPC ? EmbeddedElementPCMapping.class : (elementPC ? PersistableMapping.class : this.getMappingClass(elementCls, serialised, embedded, mmd.getFullFieldName()))) : this.getMappingClass(elementCls, serialised, embedded, mmd.getFullFieldName()));
        return mc;
    }

    protected Class getKeyMappingClass(DatastoreContainerObject container, AbstractMemberMetaData mmd, DatastoreAdapter dba, ClassLoaderResolver clr) {
        if (mmd.getMap() == null) {
            throw new NucleusException("Attempt to get key mapping for field " + mmd.getFullFieldName() + " that has no map!").setFatal();
        }
        String userMappingClassName = null;
        if (mmd.getKeyMetaData() != null) {
            userMappingClassName = mmd.getKeyMetaData().getValueForExtension("mapping-class");
        }
        if (userMappingClassName != null) {
            try {
                return clr.classForName(userMappingClassName);
            }
            catch (NucleusException jpe) {
                throw new NucleusUserException(LOCALISER.msg("041014", (Object)userMappingClassName)).setFatal();
            }
        }
        boolean serialised = mmd.hasMap() && mmd.getMap().isSerializedKey();
        boolean embedded = mmd.hasMap() && mmd.getMap().isEmbeddedKey();
        boolean embeddedPC = mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getEmbeddedMetaData() != null;
        boolean keyPC = mmd.hasMap() && mmd.getMap().keyIsPersistent();
        Class keyCls = clr.classForName(mmd.getMap().getKeyType());
        boolean keyReference = ClassUtils.isReferenceType(keyCls);
        Class mc = null;
        mc = serialised ? (keyPC ? SerialisedKeyPCMapping.class : (keyReference ? SerialisedReferenceMapping.class : SerialisedMapping.class)) : (embedded ? (embeddedPC ? EmbeddedKeyPCMapping.class : (keyPC ? PersistableMapping.class : this.getMappingClass(keyCls, serialised, embedded, mmd.getFullFieldName()))) : this.getMappingClass(keyCls, serialised, embedded, mmd.getFullFieldName()));
        return mc;
    }

    protected Class getValueMappingClass(DatastoreContainerObject container, AbstractMemberMetaData mmd, DatastoreAdapter dba, ClassLoaderResolver clr) {
        if (mmd.getMap() == null) {
            throw new NucleusException("Attempt to get value mapping for field " + mmd.getFullFieldName() + " that has no map!").setFatal();
        }
        String userMappingClassName = null;
        if (mmd.getValueMetaData() != null) {
            userMappingClassName = mmd.getValueMetaData().getValueForExtension("mapping-class");
        }
        if (userMappingClassName != null) {
            try {
                return clr.classForName(userMappingClassName);
            }
            catch (NucleusException jpe) {
                throw new NucleusUserException(LOCALISER.msg("041014", (Object)userMappingClassName)).setFatal();
            }
        }
        boolean serialised = mmd.hasMap() && mmd.getMap().isSerializedValue();
        boolean embedded = mmd.hasMap() && mmd.getMap().isEmbeddedValue();
        boolean embeddedPC = mmd.getValueMetaData() != null && mmd.getValueMetaData().getEmbeddedMetaData() != null;
        boolean valuePC = mmd.hasMap() && mmd.getMap().valueIsPersistent();
        Class valueCls = clr.classForName(mmd.getMap().getValueType());
        boolean valueReference = ClassUtils.isReferenceType(valueCls);
        Class mc = null;
        mc = serialised ? (valuePC ? SerialisedValuePCMapping.class : (valueReference ? SerialisedReferenceMapping.class : SerialisedMapping.class)) : (embedded ? (embeddedPC ? EmbeddedValuePCMapping.class : (valuePC ? PersistableMapping.class : this.getMappingClass(valueCls, serialised, embedded, mmd.getFullFieldName()))) : this.getMappingClass(valueCls, serialised, embedded, mmd.getFullFieldName()));
        return mc;
    }

    protected Class getDefaultJavaTypeMapping(Class javaType) {
        Class cls = this.storeMgr.getMappedTypeManager().getMappingType(javaType.getName());
        if (cls == null) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("041000", (Object)javaType.getName()));
            return null;
        }
        return cls;
    }

    public abstract void registerDatastoreMapping(String var1, Class var2, String var3, String var4, boolean var5);

    protected class TypeMapping {
        Class javaMappingType;
        boolean isDefault;

        public TypeMapping(Class javaMappingType, boolean isDefault) {
            this.javaMappingType = javaMappingType;
            this.isDefault = isDefault;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }

        public Class getMappingType() {
            return this.javaMappingType;
        }
    }
}

