/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.NotSupportedException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.TransactionImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.connection.ConnectionResourceType;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.util.NucleusLogger;

public class JTATransactionImpl
extends TransactionImpl
implements Synchronization {
    private TransactionManager tm;
    private Transaction jtaTx;
    protected JoinStatus joinStatus = JoinStatus.NO_TXN;
    private UserTransaction userTransaction;
    private static boolean INSIDE_JBOSS = System.getProperty("jboss.server.name") != null;

    JTATransactionImpl(ObjectManager om) {
        super(om);
        PersistenceConfiguration conf = om.getOMFContext().getPersistenceConfiguration();
        if (!ConnectionResourceType.JTA.toString().equalsIgnoreCase(conf.getStringProperty("datanucleus.connection.resourceType")) || !ConnectionResourceType.JTA.toString().equalsIgnoreCase(conf.getStringProperty("datanucleus.connection2.resourceType"))) {
            throw new NucleusException("Internal error: either datanucleus.connection.resourceType or datanucleus.connection2.resourceType have not been set to JTA, this should have happened automatically.");
        }
        om.getOMFContext().getTransactionManager().setContainerManagedConnections(true);
        this.tm = this.obtainTransactionManager();
        this.checkTransactionJoin();
    }

    protected void checkTransactionJoin() {
        if (this.joinStatus != JoinStatus.JOINED) {
            try {
                Transaction txn = this.tm.getTransaction();
                int txnstat = this.tm.getStatus();
                if (this.jtaTx != null && !this.jtaTx.equals(txn)) {
                    if (this.joinStatus != JoinStatus.IMPOSSIBLE) {
                        throw new InternalError("JTA Transaction changed without being notified");
                    }
                    this.jtaTx = null;
                    this.joinStatus = JoinStatus.NO_TXN;
                    this.checkTransactionJoin();
                } else if (this.jtaTx == null) {
                    this.jtaTx = txn;
                    boolean allow_join = this.canJoinTransaction(txnstat);
                    if (allow_join) {
                        this.joinStatus = JoinStatus.IMPOSSIBLE;
                        this.execJoinTransaction();
                        this.joinStatus = JoinStatus.JOINED;
                    } else if (this.jtaTx != null) {
                        this.joinStatus = JoinStatus.IMPOSSIBLE;
                    }
                }
            }
            catch (SystemException e) {
                throw new NucleusTransactionException(LOCALISER.msg("015026"), e);
            }
        }
    }

    private void execJoinTransaction() {
        try {
            this.jtaTx.registerSynchronization((Synchronization)this);
            boolean was_active = super.isActive();
            if (!was_active) {
                this.internalBegin();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NucleusTransactionException("Cannot register Synchronization to a valid JTA Transaction");
        }
    }

    private boolean canJoinTransaction(int txnstat) {
        return txnstat == 0;
    }

    public boolean isActive() {
        if (this.joinStatus == JoinStatus.JOINED) {
            return super.isActive();
        }
        this.checkTransactionJoin();
        return super.isActive() || this.joinStatus == JoinStatus.IMPOSSIBLE;
    }

    public void begin() {
        UserTransaction utx;
        this.checkTransactionJoin();
        if (this.joinStatus != JoinStatus.NO_TXN) {
            throw new NucleusTransactionException("JTA Transaction is already active");
        }
        try {
            utx = this.getUserTransaction();
        }
        catch (NamingException e) {
            throw this.om.getApiAdapter().getExceptionForException("Failed to obtain UserTransaction", e);
        }
        try {
            utx.begin();
        }
        catch (NotSupportedException e) {
            throw this.om.getApiAdapter().getExceptionForException("Failed to begin UserTransaction", (Exception)((Object)e));
        }
        catch (SystemException e) {
            throw this.om.getApiAdapter().getExceptionForException("Failed to begin UserTransaction", (Exception)((Object)e));
        }
        this.checkTransactionJoin();
        if (this.joinStatus != JoinStatus.JOINED) {
            throw new NucleusTransactionException("Cannot join an auto started UserTransaction");
        }
        this.userTransaction = utx;
    }

    public void commit() {
        if (this.userTransaction == null) {
            throw new NucleusTransactionException("No internal UserTransaction");
        }
        try {
            try {
                this.userTransaction.commit();
            }
            catch (Exception e) {
                throw this.om.getApiAdapter().getExceptionForException("Failed to commit UserTransaction", e);
            }
            Object var3_1 = null;
            this.userTransaction = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.userTransaction = null;
            throw throwable;
        }
    }

    public void rollback() {
        if (this.userTransaction == null) {
            throw new NucleusTransactionException("No internal UserTransaction");
        }
        try {
            try {
                this.userTransaction.rollback();
            }
            catch (Exception e) {
                throw this.om.getApiAdapter().getExceptionForException("Failed to rollback UserTransaction", e);
            }
            Object var3_1 = null;
            this.userTransaction = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.userTransaction = null;
            throw throwable;
        }
    }

    public void setRollbackOnly() {
        if (this.userTransaction == null) {
            throw new NucleusTransactionException("No internal UserTransaction");
        }
        try {
            this.userTransaction.setRollbackOnly();
        }
        catch (Exception e) {
            throw this.om.getApiAdapter().getExceptionForException("Failed to rollback-only UserTransaction", e);
        }
    }

    private TransactionManager obtainTransactionManager() {
        TransactionManager tm = this.om.getOMFContext().getJtaTransactionManager();
        if (tm == null) {
            throw new NucleusTransactionException(LOCALISER.msg("015030"));
        }
        return tm;
    }

    private UserTransaction getUserTransaction() throws NamingException {
        InitialContext ctx = new InitialContext();
        UserTransaction ut = INSIDE_JBOSS ? (UserTransaction)ctx.lookup("UserTransaction") : (UserTransaction)ctx.lookup("java:comp/UserTransaction");
        return ut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion() {
        block6: {
            boolean success = false;
            try {
                this.flush();
                this.internalPreCommit();
                this.flush();
                success = true;
                Object var3_2 = null;
                if (success) break block6;
                NucleusLogger.TRANSACTION.error("Exception flushing work in JTA transaction. Mark for rollback");
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (!success) {
                    NucleusLogger.TRANSACTION.error("Exception flushing work in JTA transaction. Mark for rollback");
                    try {
                        this.jtaTx.setRollbackOnly();
                    }
                    catch (Exception e) {
                        NucleusLogger.TRANSACTION.fatal("Cannot mark transaction for rollback after exception in beforeCompletion. PersistenceManager might be in inconsistent state", e);
                    }
                }
                throw throwable;
            }
            try {
                this.jtaTx.setRollbackOnly();
            }
            catch (Exception e) {
                NucleusLogger.TRANSACTION.fatal("Cannot mark transaction for rollback after exception in beforeCompletion. PersistenceManager might be in inconsistent state", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterCompletion(int status) {
        boolean success = false;
        try {
            if (status == 4) {
                super.rollback();
            } else if (status == 3) {
                this.internalPostCommit();
            } else {
                NucleusLogger.TRANSACTION.fatal("Received unexpected transaction status + " + status);
            }
            success = true;
            Object var4_3 = null;
            this.jtaTx = null;
            this.joinStatus = JoinStatus.NO_TXN;
            if (!success) {
                NucleusLogger.TRANSACTION.error("Exception during afterCompletion in JTA transaction. PersistenceManager might be in inconsistent state");
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.jtaTx = null;
            this.joinStatus = JoinStatus.NO_TXN;
            if (!success) {
                NucleusLogger.TRANSACTION.error("Exception during afterCompletion in JTA transaction. PersistenceManager might be in inconsistent state");
            }
            throw throwable;
        }
        if (this.active) {
            throw new NucleusTransactionException("internal error, must not be active after afterCompletion()!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum JoinStatus {
        NO_TXN,
        IMPOSSIBLE,
        JOINED;

    }
}

