/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.awt.geom.Rectangle2D;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.SingleFieldMultiMapping;

public class Rectangle2dFloatMapping
extends SingleFieldMultiMapping {
    private static final Rectangle2D.Float sampleValue = new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f);

    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(dba, fmd, container, clr);
        this.addDatastoreField(ClassNameConstants.FLOAT);
        this.addDatastoreField(ClassNameConstants.FLOAT);
        this.addDatastoreField(ClassNameConstants.FLOAT);
        this.addDatastoreField(ClassNameConstants.FLOAT);
    }

    public Class getJavaType() {
        return Rectangle2D.Float.class;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return sampleValue;
    }

    public Object getValueForDataStoreMapping(ObjectManager om, int index, Object value) {
        Rectangle2D.Float rect = (Rectangle2D.Float)value;
        if (index == 0) {
            return rect.getX();
        }
        if (index == 1) {
            return rect.getY();
        }
        if (index == 2) {
            return rect.getWidth();
        }
        if (index == 3) {
            return rect.getHeight();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value) {
        Rectangle2D.Float rectangle = (Rectangle2D.Float)value;
        if (rectangle == null) {
            for (int i = 0; i < exprIndex.length; ++i) {
                this.getDataStoreMapping(i).setObject(preparedStatement, exprIndex[i], null);
            }
        } else {
            this.getDataStoreMapping(0).setFloat(preparedStatement, exprIndex[0], rectangle.x);
            this.getDataStoreMapping(1).setFloat(preparedStatement, exprIndex[1], rectangle.y);
            this.getDataStoreMapping(2).setFloat(preparedStatement, exprIndex[2], rectangle.width);
            this.getDataStoreMapping(3).setFloat(preparedStatement, exprIndex[3], rectangle.height);
        }
    }

    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
        if (this.getDataStoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        float x = this.getDataStoreMapping(0).getFloat(resultSet, exprIndex[0]);
        float y = this.getDataStoreMapping(1).getFloat(resultSet, exprIndex[1]);
        float width = this.getDataStoreMapping(2).getFloat(resultSet, exprIndex[2]);
        float height = this.getDataStoreMapping(3).getFloat(resultSet, exprIndex[3]);
        return new Rectangle2D.Float(x, y, width, height);
    }
}

