/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.awt.Polygon;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.SingleFieldMultiMapping;

public class PolygonMapping
extends SingleFieldMultiMapping {
    private static final Polygon sampleValue = new Polygon();

    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(dba, fmd, container, clr);
        this.addDatastoreField(ClassNameConstants.INT_ARRAY);
        this.addDatastoreField(ClassNameConstants.INT_ARRAY);
        this.addDatastoreField(ClassNameConstants.INT);
    }

    public Class getJavaType() {
        return Polygon.class;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return sampleValue;
    }

    public Object getValueForDataStoreMapping(ObjectManager om, int index, Object value) {
        Polygon poly = (Polygon)value;
        if (index == 0) {
            return poly.xpoints;
        }
        if (index == 1) {
            return poly.ypoints;
        }
        if (index == 2) {
            return poly.npoints;
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value) {
        Polygon poly = (Polygon)value;
        if (poly == null) {
            this.getDataStoreMapping(0).setObject(preparedStatement, exprIndex[0], null);
            this.getDataStoreMapping(1).setObject(preparedStatement, exprIndex[1], null);
            this.getDataStoreMapping(2).setObject(preparedStatement, exprIndex[2], null);
        } else {
            this.getDataStoreMapping(0).setObject(preparedStatement, exprIndex[0], poly.xpoints);
            this.getDataStoreMapping(1).setObject(preparedStatement, exprIndex[1], poly.ypoints);
            this.getDataStoreMapping(2).setInt(preparedStatement, exprIndex[2], poly.npoints);
        }
    }

    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
        if (this.getDataStoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        int[] xpoints = (int[])this.getDataStoreMapping(0).getObject(resultSet, exprIndex[0]);
        int[] ypoints = (int[])this.getDataStoreMapping(1).getObject(resultSet, exprIndex[1]);
        int npoints = this.getDataStoreMapping(2).getInt(resultSet, exprIndex[2]);
        return new Polygon(xpoints, ypoints, npoints);
    }
}

