/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.math.BigInteger;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.expression.IntegerLiteral;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringExpression;
import org.datanucleus.store.mapped.expression.StringLiteral;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class EnumMapping
extends SingleFieldMapping {
    protected String datastoreJavaType = ClassNameConstants.JAVA_LANG_STRING;

    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        ColumnMetaData[] colmds;
        if (fmd != null && fmd.isSerialized()) {
            this.datastoreJavaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
        } else if (fmd != null && (colmds = EnumMapping.getColumnMetaDataForMember(fmd, this.roleForMember)) != null && MetaDataUtils.isJdbcTypeNumeric(colmds[0].getJdbcType())) {
            this.datastoreJavaType = ClassNameConstants.JAVA_LANG_INTEGER;
        }
        super.initialize(dba, fmd, container, clr);
    }

    public Object[] getValidValues(int index) {
        if (this.mmd != null && this.mmd.getColumnMetaData() != null && this.mmd.getColumnMetaData().length > 0 && this.mmd.getColumnMetaData()[0].hasExtension("enum-check-constraint") && this.mmd.getColumnMetaData()[0].getValueForExtension("enum-check-constraint").equalsIgnoreCase("true")) {
            try {
                Enum[] values = (Enum[])this.mmd.getType().getMethod("values", null).invoke((Object)null, (Object[])null);
                if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_STRING)) {
                    Object[] valueStrings = new String[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        valueStrings[i] = values[i].toString();
                    }
                    return valueStrings;
                }
                Object[] valueInts = new Integer[values.length];
                for (int i = 0; i < values.length; ++i) {
                    valueInts[i] = values[i].ordinal();
                }
                return valueInts;
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.warn(StringUtils.getStringFromStackTrace(e));
            }
        }
        return super.getValidValues(index);
    }

    public String getJavaTypeForDatastoreMapping(int index) {
        return this.datastoreJavaType;
    }

    public Class getJavaType() {
        return Enum.class;
    }

    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value) {
        if (value == null) {
            this.getDataStoreMapping(0).setObject(preparedStatement, exprIndex[0], null);
        } else if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
            if (value instanceof Enum) {
                int intVal = ((Enum)value).ordinal();
                this.getDataStoreMapping(0).setInt(preparedStatement, exprIndex[0], intVal);
            } else if (value instanceof BigInteger) {
                this.getDataStoreMapping(0).setInt(preparedStatement, exprIndex[0], ((BigInteger)value).intValue());
            }
        } else if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_STRING)) {
            String stringVal = value instanceof String ? (String)value : ((Enum)value).name();
            this.getDataStoreMapping(0).setString(preparedStatement, exprIndex[0], stringVal);
        } else {
            super.setObject(om, preparedStatement, exprIndex, value);
        }
    }

    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        if (this.getDataStoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
            long longVal = this.getDataStoreMapping(0).getLong(resultSet, exprIndex[0]);
            Class enumType = null;
            if (this.mmd == null) {
                enumType = om.getClassLoaderResolver().classForName(this.type);
            } else {
                enumType = this.mmd.getType();
                if (this.roleForMember == 3) {
                    enumType = om.getClassLoaderResolver().classForName(this.mmd.getCollection().getElementType());
                } else if (this.roleForMember == 4) {
                    enumType = om.getClassLoaderResolver().classForName(this.mmd.getArray().getElementType());
                } else if (this.roleForMember == 5) {
                    enumType = om.getClassLoaderResolver().classForName(this.mmd.getMap().getKeyType());
                } else if (this.roleForMember == 6) {
                    enumType = om.getClassLoaderResolver().classForName(this.mmd.getMap().getValueType());
                }
            }
            return enumType.getEnumConstants()[(int)longVal];
        }
        if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_STRING)) {
            String stringVal = this.getDataStoreMapping(0).getString(resultSet, exprIndex[0]);
            Class enumType = null;
            if (this.mmd == null) {
                enumType = om.getClassLoaderResolver().classForName(this.type);
            } else {
                enumType = this.mmd.getType();
                if (this.roleForMember == 3) {
                    enumType = om.getClassLoaderResolver().classForName(this.mmd.getCollection().getElementType());
                } else if (this.roleForMember == 4) {
                    enumType = om.getClassLoaderResolver().classForName(this.mmd.getArray().getElementType());
                } else if (this.roleForMember == 5) {
                    enumType = om.getClassLoaderResolver().classForName(this.mmd.getMap().getKeyType());
                } else if (this.roleForMember == 6) {
                    enumType = om.getClassLoaderResolver().classForName(this.mmd.getMap().getValueType());
                }
            }
            return Enum.valueOf(enumType, stringVal);
        }
        return super.getObject(om, resultSet, exprIndex);
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        throw new UnsupportedOperationException();
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
            IntegerLiteral expr = new IntegerLiteral(qs, (JavaTypeMapping)this, BigInteger.valueOf(((Enum)value).ordinal()));
            ((Literal)expr).setRawValue(value);
            return expr;
        }
        if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_STRING)) {
            StringLiteral expr = new StringLiteral(qs, (JavaTypeMapping)this, ((Enum)value).name());
            ((Literal)expr).setRawValue(value);
            return expr;
        }
        return null;
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
            return new NumericExpression(qs, this, te);
        }
        if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_STRING)) {
            return new StringExpression(qs, this, te);
        }
        return null;
    }
}

