/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.datanucleus.FetchPlan;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.sco.SCO;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.state.DetachState;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.store.fieldmanager.AbstractFetchFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;

public class DetachFieldManager
extends AbstractFetchFieldManager {
    boolean copy = true;

    public DetachFieldManager(StateManager sm, boolean[] secondClassMutableFields, FetchPlan.FetchPlanForClass fpClass, FetchPlanState state, boolean copy) {
        super(sm, secondClassMutableFields, fpClass, state);
        this.copy = copy;
    }

    protected Object processPersistable(Object pc) {
        if (pc == null) {
            return null;
        }
        ApiAdapter api = this.sm.getObjectManager().getApiAdapter();
        if (!api.isPersistable(pc)) {
            return pc;
        }
        if (!api.isDetached(pc) && api.isPersistent(pc)) {
            if (this.copy) {
                return this.sm.getObjectManager().detachObjectCopy(pc, this.state);
            }
            this.sm.getObjectManager().detachObject(pc, this.state);
        }
        return pc;
    }

    protected Object internalFetchObjectField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        Object value = sfv.fetchObjectField(fieldNumber);
        ApiAdapter api = this.sm.getObjectManager().getApiAdapter();
        if (value == null) {
            return null;
        }
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (api.isPersistable(value)) {
            return this.processPersistable(value);
        }
        if (value instanceof Collection || value instanceof Map) {
            SCO sco;
            if (this.copy) {
                if (!(value instanceof SCO)) {
                    value = this.sm.wrapSCOField(fieldNumber, value, false, false, true);
                }
                return ((SCO)value).detachCopy(this.state);
            }
            if (!(value instanceof SCO)) {
                value = this.sm.wrapSCOField(fieldNumber, value, false, false, true);
            }
            if ((sco = (SCO)value) instanceof Collection) {
                SCOUtils.detachForCollection(this.sm, ((Collection)((Object)sco)).toArray(), this.state);
                sco.unsetOwner();
            } else if (sco instanceof Map) {
                SCOUtils.detachForMap(this.sm, ((Map)((Object)sco)).entrySet(), this.state);
                sco.unsetOwner();
            }
            if (SCOUtils.detachAsWrapped(this.sm)) {
                return sco;
            }
            return this.sm.unwrapSCOField(fieldNumber, value, true);
        }
        if (value instanceof Object[]) {
            if (!api.isPersistable(mmd.getType().getComponentType())) {
                return value;
            }
            Object[] arrValue = (Object[])value;
            Object[] arrDetached = (Object[])Array.newInstance(mmd.getType().getComponentType(), arrValue.length);
            for (int j = 0; j < arrValue.length; ++j) {
                arrDetached[j] = this.processPersistable(arrValue[j]);
            }
            return arrDetached;
        }
        if (this.secondClassMutableFields[fieldNumber]) {
            if (this.copy) {
                if (!(value instanceof SCO)) {
                    value = this.sm.wrapSCOField(fieldNumber, value, false, false, true);
                }
                return ((SCO)value).detachCopy(this.state);
            }
            if (!(value instanceof SCO)) {
                value = this.sm.wrapSCOField(fieldNumber, value, false, false, true);
            }
            SCO sco = (SCO)value;
            if (SCOUtils.detachAsWrapped(this.sm)) {
                return sco;
            }
            return this.sm.unwrapSCOField(fieldNumber, value, true);
        }
        return value;
    }

    protected Object endOfGraphOperation(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        Object value = sfv.fetchObjectField(fieldNumber);
        ApiAdapter api = this.sm.getObjectManager().getApiAdapter();
        if (api.isPersistable(value)) {
            Object detached = null;
            if (this.copy) {
                detached = ((DetachState)this.state).getDetachedCopyObject(value);
            }
            if (detached != null) {
                return detached;
            }
            if (!this.copy && this.sm.getObjectManager().getApiAdapter().isDetached(value)) {
                return value;
            }
        }
        throw new AbstractFetchFieldManager.EndOfFetchPlanGraphException();
    }
}

