/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.sco.SCOCollection;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    final StateManager ownerSM;
    final Object pc;
    final Map<Integer, Object> fieldChanges;

    public RelationshipManager(StateManager sm) {
        this.ownerSM = sm;
        this.pc = sm.getObject();
        this.fieldChanges = new HashMap<Integer, Object>();
        this.ownerSM.getObjectManager().markManagedRelationDirty(sm);
    }

    public void clearFields() {
        this.fieldChanges.clear();
    }

    public void relationChange(int fieldNumber, Object oldValue, Object newValue) {
        block14: {
            if (this.ownerSM.getObjectManager().isManagingRelations()) {
                return;
            }
            Integer fieldKey = new Integer(fieldNumber);
            AbstractClassMetaData cmd = this.ownerSM.getClassMetaData();
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            int relationType = mmd.getRelationType(this.ownerSM.getObjectManager().getClassLoaderResolver());
            if (relationType == 2 || relationType == 6) {
                if (!this.fieldChanges.containsKey(fieldKey)) {
                    this.fieldChanges.put(fieldKey, oldValue);
                }
                return;
            }
            ArrayList<RelationChange> changes = (ArrayList<RelationChange>)this.fieldChanges.get(fieldKey);
            if (changes == null) {
                changes = new ArrayList<RelationChange>();
                this.fieldChanges.put(fieldKey, changes);
            }
            if (relationType != 4 && relationType != 5 || !mmd.hasCollection() || oldValue == null && newValue == null) break block14;
            if (oldValue == null && newValue != null) {
                Iterator iter = ((Collection)newValue).iterator();
                while (iter.hasNext()) {
                    changes.add(new RelationChange(ChangeType.ADD_OBJECT, iter.next()));
                }
            } else if (oldValue != null && newValue == null) {
                Iterator iter = ((Collection)oldValue).iterator();
                while (iter.hasNext()) {
                    changes.add(new RelationChange(ChangeType.REMOVE_OBJECT, iter.next()));
                }
            } else {
                for (Object newElem : (Collection)newValue) {
                    Iterator oldIter = ((Collection)oldValue).iterator();
                    boolean alreadyExists = false;
                    while (oldIter.hasNext()) {
                        Object oldElem = oldIter.next();
                        if (newElem != oldElem) continue;
                        alreadyExists = true;
                        break;
                    }
                    if (alreadyExists) continue;
                    changes.add(new RelationChange(ChangeType.ADD_OBJECT, newElem));
                }
                for (Object oldElem : (Collection)oldValue) {
                    Iterator newIter = ((Collection)newValue).iterator();
                    boolean stillExists = false;
                    while (newIter.hasNext()) {
                        Object newElem = newIter.next();
                        if (oldElem != newElem) continue;
                        stillExists = true;
                        break;
                    }
                    if (stillExists) continue;
                    changes.add(new RelationChange(ChangeType.REMOVE_OBJECT, oldElem));
                }
            }
        }
    }

    public void relationAdd(int fieldNumber, Object val) {
        if (this.ownerSM.getObjectManager().isManagingRelations()) {
            return;
        }
        AbstractClassMetaData cmd = this.ownerSM.getClassMetaData();
        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        int relationType = mmd.getRelationType(this.ownerSM.getObjectManager().getClassLoaderResolver());
        if (relationType != 4 && relationType != 5) {
            return;
        }
        Integer fieldKey = new Integer(fieldNumber);
        Object changes = this.fieldChanges.get(fieldKey);
        ArrayList<RelationChange> changeList = null;
        changeList = changes == null ? new ArrayList<RelationChange>() : (ArrayList<RelationChange>)changes;
        RelationChange change = new RelationChange(ChangeType.ADD_OBJECT, val);
        changeList.add(change);
        this.fieldChanges.put(fieldKey, changeList);
    }

    public void relationRemove(int fieldNumber, Object val) {
        if (this.ownerSM.getObjectManager().isManagingRelations()) {
            return;
        }
        AbstractClassMetaData cmd = this.ownerSM.getClassMetaData();
        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        int relationType = mmd.getRelationType(this.ownerSM.getObjectManager().getClassLoaderResolver());
        if (relationType != 4 && relationType != 5) {
            return;
        }
        Integer fieldKey = new Integer(fieldNumber);
        Object changes = this.fieldChanges.get(fieldKey);
        ArrayList<RelationChange> changeList = null;
        if (changes == null) {
            changeList = new ArrayList<RelationChange>();
            this.fieldChanges.put(fieldKey, changeList);
        } else {
            changeList = (ArrayList<RelationChange>)changes;
        }
        RelationChange change = new RelationChange(ChangeType.REMOVE_OBJECT, val);
        changeList.add(change);
    }

    private boolean managesField(int fieldNumber) {
        return this.fieldChanges.containsKey(new Integer(fieldNumber));
    }

    public void checkConsistency() {
        Set<Map.Entry<Integer, Object>> entries = this.fieldChanges.entrySet();
        Iterator<Map.Entry<Integer, Object>> iter = entries.iterator();
        AbstractClassMetaData cmd = this.ownerSM.getClassMetaData();
        ObjectManager om = this.ownerSM.getObjectManager();
        while (iter.hasNext()) {
            List changes;
            Object newValue;
            Map.Entry<Integer, Object> entry = iter.next();
            int fieldNumber = entry.getKey();
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            ClassLoaderResolver clr = om.getClassLoaderResolver();
            Object oldValue = entry.getValue();
            int relationType = mmd.getRelationType(clr);
            if (relationType == 2) {
                newValue = this.ownerSM.provideField(fieldNumber);
                this.checkOneToOneBidirectionalRelation(mmd, clr, om, oldValue, newValue);
                continue;
            }
            if (relationType == 6) {
                newValue = this.ownerSM.provideField(fieldNumber);
                this.checkManyToOneBidirectionalRelation(mmd, clr, om, oldValue, newValue);
                continue;
            }
            if (relationType == 4) {
                changes = (List)oldValue;
                this.checkOneToManyBidirectionalRelation(mmd, clr, om, changes);
                continue;
            }
            if (relationType != 5) continue;
            changes = (List)oldValue;
            this.checkManyToManyBidirectionalRelation(mmd, clr, om, changes);
        }
    }

    public void process() {
        Set<Map.Entry<Integer, Object>> entries = this.fieldChanges.entrySet();
        Iterator<Map.Entry<Integer, Object>> iter = entries.iterator();
        AbstractClassMetaData cmd = this.ownerSM.getClassMetaData();
        ObjectManager om = this.ownerSM.getObjectManager();
        while (iter.hasNext()) {
            List changes;
            Object newValue;
            Map.Entry<Integer, Object> entry = iter.next();
            int fieldNumber = entry.getKey();
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            ClassLoaderResolver clr = om.getClassLoaderResolver();
            Object oldValue = entry.getValue();
            int relationType = mmd.getRelationType(clr);
            if (relationType == 2) {
                newValue = this.ownerSM.provideField(fieldNumber);
                this.processOneToOneBidirectionalRelation(mmd, clr, om, oldValue, newValue);
                continue;
            }
            if (relationType == 6) {
                newValue = this.ownerSM.provideField(fieldNumber);
                this.processManyToOneBidirectionalRelation(mmd, clr, om, oldValue, newValue);
                continue;
            }
            if (relationType == 4) {
                changes = (List)oldValue;
                this.processOneToManyBidirectionalRelation(mmd, clr, om, changes);
                continue;
            }
            if (relationType != 5) continue;
            changes = (List)oldValue;
            this.processManyToManyBidirectionalRelation(mmd, clr, om, changes);
        }
    }

    protected void checkOneToOneBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ObjectManager om, Object oldValue, Object newValue) {
        if (newValue != null) {
            AbstractMemberMetaData relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, newValue);
            StateManager newSM = om.findStateManager(newValue);
            if (newSM != null && relatedMmd != null) {
                RelationshipManager newRelMgr;
                Object newValueFieldValue;
                if (!newSM.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber())) {
                    newSM.loadField(relatedMmd.getAbsoluteFieldNumber());
                }
                if ((newValueFieldValue = newSM.provideField(relatedMmd.getAbsoluteFieldNumber())) != this.pc && (newRelMgr = newSM.getRelationshipManager()) != null && newRelMgr.managesField(relatedMmd.getAbsoluteFieldNumber())) {
                    if (newValueFieldValue == null) {
                        String msg = LOCALISER.msg("013003", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getName(), (Object)StringUtils.toJVMIDString(newValue), (Object)relatedMmd.getName());
                        NucleusLogger.PERSISTENCE.error(msg);
                        throw new NucleusUserException(msg);
                    }
                    String msg = LOCALISER.msg("013002", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getName(), (Object)StringUtils.toJVMIDString(newValue), (Object)relatedMmd.getName(), (Object)StringUtils.toJVMIDString(newValueFieldValue));
                    NucleusLogger.PERSISTENCE.error(msg);
                    throw new NucleusUserException(msg);
                }
            }
        }
    }

    protected void checkOneToManyBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ObjectManager om, List<RelationChange> changes) {
        for (RelationChange change : changes) {
            Object newValueFieldValue;
            RelationshipManager newElementRelMgr;
            StateManager newElementSM;
            AbstractMemberMetaData relatedMmd;
            if (change.type == ChangeType.ADD_OBJECT) {
                if (this.ownerSM.getObjectManager().getApiAdapter().isDeleted(change.value)) {
                    throw new NucleusUserException(LOCALISER.msg("013008", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getName(), (Object)StringUtils.toJVMIDString(change.value)));
                }
                relatedMmd = mmd.getRelatedMemberMetaData(clr)[0];
                newElementSM = om.findStateManager(change.value);
                if (newElementSM == null || !newElementSM.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber()) || (newElementRelMgr = newElementSM.getRelationshipManager()) == null || !newElementRelMgr.managesField(relatedMmd.getAbsoluteFieldNumber()) || (newValueFieldValue = newElementSM.provideField(relatedMmd.getAbsoluteFieldNumber())) == this.pc || newValueFieldValue == null) continue;
                throw new NucleusUserException(LOCALISER.msg("013009", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getName(), (Object)StringUtils.toJVMIDString(change.value), (Object)StringUtils.toJVMIDString(newValueFieldValue)));
            }
            if (change.type == ChangeType.REMOVE_OBJECT) {
                if (this.ownerSM.getObjectManager().getApiAdapter().isDeleted(change.value)) continue;
                relatedMmd = mmd.getRelatedMemberMetaData(clr)[0];
                newElementSM = om.findStateManager(change.value);
                if (newElementSM == null || !newElementSM.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber()) || (newElementRelMgr = newElementSM.getRelationshipManager()) == null || !newElementRelMgr.managesField(relatedMmd.getAbsoluteFieldNumber()) || (newValueFieldValue = newElementSM.provideField(relatedMmd.getAbsoluteFieldNumber())) != this.pc) continue;
                throw new NucleusUserException(LOCALISER.msg("013010", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getName(), (Object)StringUtils.toJVMIDString(change.value)));
            }
            if (change.type != ChangeType.REPLACE_VALUE) continue;
        }
    }

    protected void checkManyToOneBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ObjectManager om, Object oldValue, Object newValue) {
    }

    protected void checkManyToManyBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ObjectManager om, List<RelationChange> changes) {
    }

    protected void processOneToOneBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ObjectManager om, Object oldValue, Object newValue) {
        AbstractMemberMetaData relatedMmd;
        if (oldValue != null) {
            relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, oldValue);
            StateManager oldSM = om.findStateManager(oldValue);
            if (oldSM != null) {
                Object oldValueFieldValue;
                if (!oldSM.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber())) {
                    oldSM.loadField(relatedMmd.getAbsoluteFieldNumber());
                }
                if ((oldValueFieldValue = oldSM.provideField(relatedMmd.getAbsoluteFieldNumber())) != null && oldValueFieldValue == this.pc) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013004", (Object)StringUtils.toJVMIDString(oldValue), (Object)relatedMmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(this.pc), (Object)StringUtils.toJVMIDString(newValue)));
                    }
                    oldSM.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), null);
                }
            }
        }
        if (newValue != null) {
            relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, newValue);
            StateManager newSM = om.findStateManager(newValue);
            if (newSM != null && relatedMmd != null) {
                Object newValueFieldValue;
                if (!newSM.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber())) {
                    newSM.loadField(relatedMmd.getAbsoluteFieldNumber());
                }
                if ((newValueFieldValue = newSM.provideField(relatedMmd.getAbsoluteFieldNumber())) == null) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013005", (Object)StringUtils.toJVMIDString(newValue), (Object)relatedMmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(this.pc)));
                    }
                    newSM.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), this.pc);
                } else if (newValueFieldValue != this.pc) {
                    StateManager newValueFieldSM = om.findStateManager(newValueFieldValue);
                    if (newValueFieldSM != null) {
                        if (!newValueFieldSM.isFieldLoaded(mmd.getAbsoluteFieldNumber())) {
                            newValueFieldSM.loadField(mmd.getAbsoluteFieldNumber());
                        }
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013004", (Object)StringUtils.toJVMIDString(newValueFieldValue), (Object)mmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(newValue), (Object)StringUtils.toJVMIDString(this.pc)));
                        }
                        newValueFieldSM.replaceFieldValue(mmd.getAbsoluteFieldNumber(), null);
                    }
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013005", (Object)StringUtils.toJVMIDString(newValue), (Object)relatedMmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(this.pc)));
                    }
                    newSM.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), this.pc);
                }
            }
        }
    }

    protected void processOneToManyBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ObjectManager om, List<RelationChange> changes) {
        for (RelationChange change : changes) {
            Object currentVal;
            AbstractMemberMetaData relatedMmd;
            StateManager sm;
            if (change.type == ChangeType.ADD_OBJECT) {
                sm = om.findStateManager(change.value);
                if (sm == null || !sm.isFieldLoaded((relatedMmd = mmd.getRelatedMemberMetaData(clr)[0]).getAbsoluteFieldNumber()) || (currentVal = sm.provideField(relatedMmd.getAbsoluteFieldNumber())) == this.ownerSM.getObject()) continue;
                sm.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), this.ownerSM.getObject());
                continue;
            }
            if (change.type != ChangeType.REMOVE_OBJECT || (sm = om.findStateManager(change.value)) == null || !sm.isFieldLoaded((relatedMmd = mmd.getRelatedMemberMetaData(clr)[0]).getAbsoluteFieldNumber()) || (currentVal = sm.provideField(relatedMmd.getAbsoluteFieldNumber())) != this.ownerSM.getObject()) continue;
            sm.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), null);
        }
    }

    protected void processManyToOneBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ObjectManager om, Object oldValue, Object newValue) {
        AbstractMemberMetaData relatedMmd;
        if (oldValue != null) {
            Collection oldColl;
            Object oldContainerValue;
            relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, oldValue);
            StateManager oldSM = om.findStateManager(oldValue);
            if (oldSM != null && relatedMmd != null && oldSM.getLoadedFields()[relatedMmd.getAbsoluteFieldNumber()] && oldSM.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber()) && (oldContainerValue = oldSM.provideField(relatedMmd.getAbsoluteFieldNumber())) instanceof Collection && (oldColl = (Collection)oldContainerValue).contains(this.pc)) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013006", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getFullFieldName(), (Object)relatedMmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(oldValue)));
                }
                if (oldColl instanceof SCOCollection) {
                    ((SCOCollection)((Object)oldColl)).remove(this.pc, false);
                } else {
                    oldColl.remove(this.pc);
                }
            }
        }
        if (newValue != null) {
            Collection newColl;
            Object newContainerValue;
            relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, newValue);
            StateManager newSM = om.findStateManager(newValue);
            if (newSM != null && relatedMmd != null && newSM.getLoadedFields()[relatedMmd.getAbsoluteFieldNumber()] && newSM.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber()) && (newContainerValue = newSM.provideField(relatedMmd.getAbsoluteFieldNumber())) instanceof Collection && !(newColl = (Collection)newContainerValue).contains(this.pc)) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013007", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getFullFieldName(), (Object)relatedMmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(newValue)));
                }
                newColl.add(this.pc);
            }
        }
    }

    protected void processManyToManyBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ObjectManager om, List<RelationChange> changes) {
        for (RelationChange change : changes) {
            if (change.type == ChangeType.ADD_OBJECT) {
                NucleusLogger.PERSISTENCE.info(">> ManagedRelations.M_N " + (Object)((Object)change.type) + " object=" + StringUtils.toJVMIDString(change.value));
                continue;
            }
            if (change.type != ChangeType.REMOVE_OBJECT) continue;
            NucleusLogger.PERSISTENCE.info(">> ManagedRelations.M_N " + (Object)((Object)change.type) + " object=" + StringUtils.toJVMIDString(change.value));
        }
    }

    private class RelationChange {
        ChangeType type;
        Object value;

        public RelationChange(ChangeType type, Object val) {
            this.type = type;
            this.value = val;
        }

        public String toString() {
            return "RelationChange type=" + (Object)((Object)this.type) + " value=" + StringUtils.toJVMIDString(this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ChangeType {
        ADD_OBJECT,
        REMOVE_OBJECT,
        REPLACE_VALUE;

    }
}

