/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jdo;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jdo.Extent;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDONullIdentityException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.JDOUserException;
import javax.jdo.ObjectState;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.datastore.JDOConnection;
import javax.jdo.datastore.Sequence;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerImpl;
import org.datanucleus.Transaction;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.TransactionActiveOnCloseException;
import org.datanucleus.identity.SCOID;
import org.datanucleus.jdo.JDOConnectionImpl;
import org.datanucleus.jdo.JDOExtent;
import org.datanucleus.jdo.JDOFetchGroup;
import org.datanucleus.jdo.JDOFetchPlan;
import org.datanucleus.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.jdo.JDOQuery;
import org.datanucleus.jdo.JDOSequence;
import org.datanucleus.jdo.JDOTransaction;
import org.datanucleus.jdo.NucleusJDOHelper;
import org.datanucleus.jdo.exceptions.TransactionNotActiveException;
import org.datanucleus.jdo.exceptions.TransactionNotWritableException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FetchPlanMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.state.DetachState;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.NucleusSequence;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class JDOPersistenceManager
implements PersistenceManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManager.class.getClassLoader());
    protected static final Localiser LOCALISER_JDO = Localiser.getInstance("org.datanucleus.jdo.Localisation", JDOPersistenceManager.class.getClassLoader());
    private Map userObjectMap;
    private Object userObject;
    protected ObjectManager objectMgr;
    protected javax.jdo.Transaction jdotx;
    protected JDOPersistenceManagerFactory pmf;
    protected JDOFetchPlan fetchPlan = null;
    private Set<JDOFetchGroup> jdoFetchGroups = null;

    public JDOPersistenceManager(JDOPersistenceManagerFactory apmf, String userName, String password) {
        this.objectMgr = new ObjectManagerImpl(apmf, this, userName, password);
        this.pmf = apmf;
        this.userObject = null;
        this.userObjectMap = null;
        this.fetchPlan = new JDOFetchPlan(this.objectMgr.getFetchPlan());
        this.setTransaction(this.objectMgr.getTransaction());
    }

    public ObjectManager getObjectManager() {
        return this.objectMgr;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.pmf;
    }

    public boolean getDetachAllOnCommit() {
        return this.objectMgr.getDetachAllOnCommit();
    }

    public boolean getCopyOnAttach() {
        return this.objectMgr.getCopyOnAttach();
    }

    public javax.jdo.FetchPlan getFetchPlan() {
        return this.fetchPlan;
    }

    public boolean getIgnoreCache() {
        return this.objectMgr.getIgnoreCache();
    }

    public boolean getMultithreaded() {
        return this.objectMgr.getMultithreaded();
    }

    public void setDetachAllOnCommit(boolean flag) {
        this.objectMgr.setDetachAllOnCommit(flag);
    }

    public void setCopyOnAttach(boolean flag) {
        this.objectMgr.setCopyOnAttach(flag);
    }

    public void setIgnoreCache(boolean flag) {
        this.objectMgr.setIgnoreCache(flag);
    }

    public void setMultithreaded(boolean flag) {
        this.objectMgr.setMultithreaded(flag);
    }

    public Date getServerDate() {
        try {
            return this.objectMgr.getStoreManager().getDatastoreDate();
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public synchronized void close() {
        this.userObject = null;
        this.userObjectMap = null;
        if (this.jdoFetchGroups != null) {
            this.jdoFetchGroups.clear();
        }
        try {
            this.objectMgr.close();
            this.pmf.releasePersistenceManager(this);
            this.objectMgr.postClose();
        }
        catch (TransactionActiveOnCloseException tae) {
            throw new JDOUserException(tae.getMessage(), (Object)this);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public boolean isClosed() {
        return this.objectMgr.isClosed();
    }

    public javax.jdo.Transaction currentTransaction() {
        this.assertIsOpen();
        return this.jdotx;
    }

    protected void setTransaction(Transaction tx) {
        this.jdotx = new JDOTransaction(this, tx);
    }

    private void jdoEvict(Object obj) {
        try {
            this.objectMgr.evictObject(obj);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public synchronized void evict(Object obj) {
        this.assertIsOpen();
        this.jdoEvict(obj);
    }

    public synchronized void evictAll(Class cls, boolean subclasses) {
        try {
            this.objectMgr.evictObjects(cls, subclasses);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public synchronized void evictAll(boolean subclasses, Class cls) {
        try {
            this.objectMgr.evictObjects(cls, subclasses);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public synchronized void evictAll(Object ... pcs) {
        this.evictAll(Arrays.asList(pcs));
    }

    public synchronized void evictAll(Collection pcs) {
        this.assertIsOpen();
        ArrayList<JDOException> failures = new ArrayList<JDOException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.jdoEvict(i.next());
            }
            catch (JDOException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("010036"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public synchronized void evictAll() {
        this.assertIsOpen();
        this.objectMgr.evictAllObjects();
    }

    private void jdoRefresh(Object obj) {
        try {
            this.objectMgr.refreshObject(obj);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public synchronized void refresh(Object obj) {
        this.assertIsOpen();
        this.jdoRefresh(obj);
    }

    public synchronized void refreshAll(Object ... pcs) {
        this.refreshAll(Arrays.asList(pcs));
    }

    public synchronized void refreshAll(Collection pcs) {
        this.assertIsOpen();
        ArrayList<JDOException> failures = new ArrayList<JDOException>();
        Iterator iter = pcs.iterator();
        while (iter.hasNext()) {
            try {
                this.jdoRefresh(iter.next());
            }
            catch (JDOException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("010037"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public synchronized void refreshAll() {
        this.assertIsOpen();
        try {
            this.objectMgr.refreshAllObjects();
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public synchronized void refreshAll(JDOException exc) {
        Throwable[] nested_excs;
        Object obj = exc.getFailedObject();
        if (obj != null) {
            this.refresh(obj);
        }
        if ((nested_excs = exc.getNestedExceptions()) != null) {
            for (int i = 0; i < nested_excs.length; ++i) {
                if (!(nested_excs[i] instanceof JDOException)) continue;
                this.refreshAll((JDOException)nested_excs[i]);
            }
        }
    }

    private void jdoRetrieve(Object obj, boolean fgOnly) {
        try {
            this.objectMgr.retrieveObject(obj, fgOnly);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public synchronized void retrieve(Object pc, boolean fgOnly) {
        this.assertIsOpen();
        this.jdoRetrieve(pc, fgOnly);
    }

    public synchronized void retrieve(Object pc) {
        this.retrieve(pc, false);
    }

    public synchronized void retrieveAll(Object ... pcs) {
        this.retrieveAll(Arrays.asList(pcs), false);
    }

    public void retrieveAll(Object[] pcs, boolean fgOnly) {
        this.retrieveAll(Arrays.asList(pcs), fgOnly);
    }

    public void retrieveAll(boolean fgOnly, Object ... pcs) {
        this.retrieveAll(Arrays.asList(pcs), fgOnly);
    }

    public void retrieveAll(Collection pcs, boolean fgOnly) {
        this.assertIsOpen();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.jdoRetrieve(i.next(), fgOnly);
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("010038"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public synchronized void retrieveAll(Collection pcs) {
        this.retrieveAll(pcs.toArray(), false);
    }

    private Object jdoMakePersistent(Object obj) {
        try {
            return this.objectMgr.persistObject(obj);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public synchronized Object makePersistent(Object obj) {
        this.assertIsOpen();
        this.assertWritable();
        if (obj == null) {
            return null;
        }
        return this.jdoMakePersistent(obj);
    }

    public synchronized Object[] makePersistentAll(Object ... pcs) {
        return this.makePersistentAll(Arrays.asList(pcs)).toArray();
    }

    public synchronized Collection makePersistentAll(Collection pcs) {
        this.assertIsOpen();
        this.assertWritable();
        ArrayList<RuntimeException> failures = null;
        Iterator i = pcs.iterator();
        ArrayList<Object> persistedPcs = new ArrayList<Object>();
        while (i.hasNext()) {
            try {
                Object persistedPc = this.jdoMakePersistent(i.next());
                persistedPcs.add(persistedPc);
            }
            catch (RuntimeException e) {
                if (failures == null) {
                    failures = new ArrayList<RuntimeException>();
                }
                failures.add(e);
            }
        }
        if (failures != null) {
            throw new JDOUserException(LOCALISER.msg("010039"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
        return persistedPcs;
    }

    private void jdoDeletePersistent(Object obj) {
        try {
            this.objectMgr.deleteObject(obj);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public synchronized void deletePersistent(Object obj) {
        this.assertIsOpen();
        this.assertWritable();
        this.jdoDeletePersistent(obj);
    }

    public synchronized void deletePersistentAll(Object ... pcs) {
        this.deletePersistentAll(Arrays.asList(pcs));
    }

    public synchronized void deletePersistentAll(Collection pcs) {
        this.assertIsOpen();
        this.assertWritable();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.jdoDeletePersistent(i.next());
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("010040"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    private void jdoMakeTransient(Object pc, FetchPlanState state) {
        try {
            this.objectMgr.makeObjectTransient(pc, state);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public synchronized void makeTransient(Object pc, boolean useFetchPlan) {
        this.assertIsOpen();
        FetchPlanState state = null;
        if (useFetchPlan) {
            state = new FetchPlanState();
        }
        this.jdoMakeTransient(pc, state);
    }

    public synchronized void makeTransient(Object pc) {
        this.makeTransient(pc, false);
    }

    public synchronized void makeTransientAll(Object ... pcs) {
        this.makeTransientAll(Arrays.asList(pcs));
    }

    public synchronized void makeTransientAll(Object[] pcs, boolean includeFetchPlan) {
        this.makeTransientAll(Arrays.asList(pcs), includeFetchPlan);
    }

    public synchronized void makeTransientAll(boolean includeFetchPlan, Object ... pcs) {
        this.makeTransientAll(Arrays.asList(pcs), includeFetchPlan);
    }

    public synchronized void makeTransientAll(Collection pcs, boolean useFetchPlan) {
        this.assertIsOpen();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        FetchPlanState state = null;
        if (useFetchPlan) {
            state = new FetchPlanState();
        }
        while (i.hasNext()) {
            try {
                this.jdoMakeTransient(i.next(), state);
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("010041"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public synchronized void makeTransientAll(Collection pcs) {
        this.makeTransientAll(pcs, false);
    }

    private void jdoMakeTransactional(Object pc) {
        try {
            this.objectMgr.makeObjectTransactional(pc);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public synchronized void makeTransactional(Object pc) {
        this.assertIsOpen();
        this.jdoMakeTransactional(pc);
    }

    public synchronized void makeTransactionalAll(Object ... pcs) {
        this.makeTransactionalAll(Arrays.asList(pcs));
    }

    public synchronized void makeTransactionalAll(Collection pcs) {
        this.assertIsOpen();
        this.assertActiveTransaction();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.jdoMakeTransactional(i.next());
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("010042"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    private void jdoMakeNontransactional(Object obj) {
        try {
            this.objectMgr.makeObjectNontransactional(obj);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public synchronized void makeNontransactional(Object pc) {
        this.assertIsOpen();
        if (pc == null) {
            return;
        }
        if (this.objectMgr.getTransaction().isActive()) {
            this.assertActiveTransaction();
        }
        if (!((PersistenceCapable)pc).jdoIsTransactional() && !((PersistenceCapable)pc).jdoIsPersistent()) {
            throw new JDOUserException(LOCALISER_JDO.msg("011004"));
        }
        if (!((PersistenceCapable)pc).jdoIsTransactional() && ((PersistenceCapable)pc).jdoIsPersistent()) {
            return;
        }
        this.jdoMakeNontransactional(pc);
    }

    public synchronized void makeNontransactionalAll(Object ... pcs) {
        this.makeNontransactionalAll(Arrays.asList(pcs));
    }

    public synchronized void makeNontransactionalAll(Collection pcs) {
        this.assertIsOpen();
        this.assertActiveTransaction();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.jdoMakeNontransactional(i.next());
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("010043"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    private Object jdoDetachCopy(Object obj, FetchPlanState state) {
        try {
            return this.objectMgr.detachObjectCopy(obj, state);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public synchronized Object detachCopy(Object pc) {
        this.assertIsOpen();
        if (pc == null) {
            return null;
        }
        try {
            this.objectMgr.assertClassPersistable(pc.getClass());
            this.assertReadable("detachCopy");
            return this.jdoDetachCopy(pc, new DetachState(this.objectMgr.getApiAdapter()));
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public synchronized Object[] detachCopyAll(Object ... pcs) {
        return this.detachCopyAll(Arrays.asList(pcs)).toArray();
    }

    public synchronized Collection detachCopyAll(Collection pcs) {
        this.assertIsOpen();
        this.assertReadable("detachCopyAll");
        DetachState state = new DetachState(this.objectMgr.getApiAdapter());
        ArrayList<Object> detacheds = new ArrayList<Object>();
        for (Object obj : pcs) {
            if (obj == null) {
                detacheds.add(null);
                continue;
            }
            detacheds.add(this.jdoDetachCopy(obj, state));
        }
        return detacheds;
    }

    public synchronized javax.jdo.Query newQuery() {
        return this.newQuery("javax.jdo.query.JDOQL", null);
    }

    public synchronized javax.jdo.Query newQuery(Object obj) {
        if (obj != null && obj instanceof JDOQuery) {
            String language = ((JDOQuery)obj).getLanguage();
            return this.newQuery(language, obj);
        }
        return this.newQuery(null, obj);
    }

    public synchronized javax.jdo.Query newQuery(String query) {
        return this.newQuery("javax.jdo.query.JDOQL", (Object)query);
    }

    public synchronized javax.jdo.Query newQuery(String language, Object query) {
        this.assertIsOpen();
        String queryLanguage = language;
        if (queryLanguage == null) {
            queryLanguage = "JDOQL";
        } else if (queryLanguage.equals("javax.jdo.query.JDOQL")) {
            queryLanguage = "JDOQL";
        } else if (queryLanguage.equals("javax.jdo.query.SQL")) {
            queryLanguage = "SQL";
        } else if (queryLanguage.equals("javax.jdo.query.JPQL")) {
            queryLanguage = "JPQL";
        }
        if (!this.objectMgr.getStoreManager().supportsQueryLanguage(queryLanguage)) {
            throw new JDOUserException(LOCALISER_JDO.msg("011006", (Object)queryLanguage));
        }
        Query internalQuery = null;
        try {
            internalQuery = query != null && query instanceof JDOQuery ? this.getObjectManager().getOMFContext().getQueryManager().newQuery(queryLanguage, this.objectMgr, ((JDOQuery)query).getInternalQuery()) : (query instanceof String && StringUtils.isWhitespace((String)query) ? this.getObjectManager().getOMFContext().getQueryManager().newQuery(queryLanguage, this.objectMgr, null) : this.getObjectManager().getOMFContext().getQueryManager().newQuery(queryLanguage, this.objectMgr, query));
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
        return new JDOQuery(this, internalQuery, queryLanguage);
    }

    public synchronized javax.jdo.Query newQuery(Class cls) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cls);
        return query;
    }

    public synchronized javax.jdo.Query newQuery(Extent cln) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cln.getCandidateClass());
        query.setCandidates(cln);
        return query;
    }

    public synchronized javax.jdo.Query newQuery(Class cls, Collection cln) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cls);
        query.setCandidates(cln);
        return query;
    }

    public synchronized javax.jdo.Query newQuery(Class cls, String filter) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cls);
        query.setFilter(filter);
        return query;
    }

    public synchronized javax.jdo.Query newQuery(Class cls, Collection cln, String filter) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cls);
        query.setCandidates(cln);
        query.setFilter(filter);
        return query;
    }

    public synchronized javax.jdo.Query newQuery(Extent cln, String filter) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cln.getCandidateClass());
        query.setCandidates(cln);
        query.setFilter(filter);
        return query;
    }

    public synchronized javax.jdo.Query newNamedQuery(Class cls, String queryName) {
        FetchPlanMetaData fpmd;
        ExtensionMetaData[] extmds;
        this.assertIsOpen();
        if (queryName == null) {
            throw new JDOUserException(LOCALISER_JDO.msg("011005", (Object)queryName, (Object)cls));
        }
        ClassLoaderResolver clr = this.objectMgr.getClassLoaderResolver();
        QueryMetaData qmd = this.objectMgr.getMetaDataManager().getMetaDataForQuery(cls, clr, queryName);
        if (qmd == null) {
            throw new JDOUserException(LOCALISER_JDO.msg("011005", (Object)queryName, (Object)cls));
        }
        javax.jdo.Query query = this.newQuery(qmd.getLanguage(), (Object)qmd.getQuery());
        if (cls != null) {
            query.setClass(cls);
            if (!this.objectMgr.getStoreManager().managesClass(cls.getName())) {
                this.objectMgr.getStoreManager().addClass(cls.getName(), clr);
            }
        }
        if (qmd.getLanguage().equals(QueryLanguage.JDOQL.toString()) && (qmd.isUnique() || qmd.getResultClass() != null)) {
            throw new JDOUserException(LOCALISER_JDO.msg("011007", (Object)queryName));
        }
        if (qmd.isUnique()) {
            query.setUnique(true);
        }
        if (qmd.getResultClass() != null) {
            Class resultCls = null;
            try {
                resultCls = clr.classForName(qmd.getResultClass());
            }
            catch (ClassNotResolvedException cnre) {
                try {
                    String resultClassName = cls.getPackage().getName() + "." + qmd.getResultClass();
                    resultCls = clr.classForName(resultClassName);
                }
                catch (ClassNotResolvedException cnre2) {
                    throw new JDOUserException(LOCALISER_JDO.msg("011008", (Object)queryName, (Object)qmd.getResultClass()));
                }
            }
            query.setResultClass(resultCls);
        }
        if ((extmds = qmd.getExtensions()) != null) {
            for (int i = 0; i < extmds.length; ++i) {
                if (!extmds[i].getVendorName().equals("datanucleus")) continue;
                query.addExtension(extmds[i].getKey(), (Object)extmds[i].getValue());
            }
        }
        if (qmd.isUnmodifiable()) {
            query.setUnmodifiable();
        }
        if (qmd.getFetchPlanName() != null && (fpmd = this.getObjectManager().getMetaDataManager().getMetaDataForFetchPlan(qmd.getFetchPlanName())) != null) {
            FetchPlan fp = new FetchPlan(this.objectMgr, clr);
            fp.removeGroup("default");
            FetchGroupMetaData[] fgmds = fpmd.getFetchGroupMetaData();
            for (int i = 0; i < fgmds.length; ++i) {
                fp.addGroup(fgmds[i].getName());
            }
            fp.setMaxFetchDepth(fpmd.getMaxFetchDepth());
            fp.setFetchSize(fpmd.getFetchSize());
            JDOQuery jdoquery = (JDOQuery)query;
            jdoquery.getInternalQuery().setFetchPlan(fp);
        }
        return query;
    }

    public synchronized Extent getExtent(Class pcClass, boolean subclasses) {
        return new JDOExtent(this, this.objectMgr.getExtent(pcClass, subclasses));
    }

    public synchronized Extent getExtent(Class pcClass) {
        return this.getExtent(pcClass, true);
    }

    public Object newInstance(Class persistenceCapable) {
        try {
            return this.objectMgr.newInstance(persistenceCapable);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public Object newObjectIdInstance(Class pcClass, Object key) {
        try {
            return this.objectMgr.newObjectId(pcClass, key);
        }
        catch (NucleusException jpe) {
            return NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public Set getManagedObjects() {
        return this.objectMgr.getManagedObjects();
    }

    public Set getManagedObjects(Class ... classes) {
        return this.objectMgr.getManagedObjects(classes);
    }

    public Set getManagedObjects(EnumSet states) {
        if (states == null) {
            return null;
        }
        String[] stateNames = new String[states.size()];
        Iterator iter = states.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ObjectState state = (ObjectState)iter.next();
            stateNames[i++] = state.toString();
        }
        return this.objectMgr.getManagedObjects(stateNames);
    }

    public Set getManagedObjects(EnumSet states, Class ... classes) {
        if (states == null) {
            return null;
        }
        String[] stateNames = new String[states.size()];
        Iterator iter = states.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ObjectState state = (ObjectState)iter.next();
            stateNames[i++] = state.toString();
        }
        return this.objectMgr.getManagedObjects(stateNames, classes);
    }

    public synchronized Object getObjectById(Object id) {
        return this.getObjectById(id, true);
    }

    public synchronized Object getObjectById(Object id, boolean validate) {
        this.assertIsOpen();
        if (id == null) {
            throw new JDONullIdentityException(LOCALISER.msg("010044"));
        }
        try {
            return this.objectMgr.findObject(id, validate, validate, null);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public Collection getObjectsById(Collection oids, boolean validate) {
        this.assertIsOpen();
        if (oids == null || oids.size() == 0) {
            throw new JDOUserException(LOCALISER_JDO.msg("011002"));
        }
        ArrayList<Object> objects = new ArrayList<Object>(oids.size());
        for (Object oid : oids) {
            objects.add(this.getObjectById(oid, validate));
        }
        return objects;
    }

    public Object[] getObjectsById(boolean validate, Object ... oids) {
        return this.getObjectsById(oids, validate);
    }

    public Object[] getObjectsById(Object[] oids, boolean validate) {
        this.assertIsOpen();
        if (oids == null) {
            throw new JDOUserException(LOCALISER_JDO.msg("011002"));
        }
        Object[] objects = new Object[oids.length];
        for (int i = 0; i < oids.length; ++i) {
            objects[i] = this.getObjectById(oids[i], validate);
        }
        return objects;
    }

    public Collection getObjectsById(Collection oids) {
        return this.getObjectsById(oids, true);
    }

    public Object[] getObjectsById(Object ... oids) {
        return this.getObjectsById(oids, true);
    }

    public Object getObjectById(Class cls, Object key) {
        return this.getObjectById(this.newObjectIdInstance(cls, key), true);
    }

    public Object getObjectId(Object pc) {
        PersistenceCapable p;
        this.assertIsOpen();
        if (pc != null && pc instanceof PersistenceCapable && ((p = (PersistenceCapable)pc).jdoIsPersistent() || p.jdoIsDetached())) {
            return p.jdoGetObjectId();
        }
        return null;
    }

    public Object getTransactionalObjectId(Object pc) {
        this.assertIsOpen();
        return ((PersistenceCapable)pc).jdoGetTransactionalObjectId();
    }

    public Class getObjectIdClass(Class cls) {
        this.assertIsOpen();
        if (!this.getObjectManager().getOMFContext().getApiAdapter().isPersistable(cls) || !this.hasPersistenceInformationForClass(cls)) {
            return null;
        }
        ClassLoaderResolver clr = this.objectMgr.getClassLoaderResolver();
        AbstractClassMetaData cmd = this.objectMgr.getMetaDataManager().getMetaDataForClass(cls, clr);
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            return this.objectMgr.getOMFContext().getDatastoreIdentityClass();
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            try {
                return this.objectMgr.getClassLoaderResolver().classForName(this.objectMgr.getMetaDataManager().getMetaDataForClass(cls, clr).getObjectidClass(), null);
            }
            catch (ClassNotResolvedException e) {
                String msg = LOCALISER_JDO.msg("011009", (Object)cls.getName());
                NucleusLogger.JDO.error(msg);
                throw new JDOException(msg);
            }
        }
        if (cmd.isRequiresExtent()) {
            return this.objectMgr.getOMFContext().getDatastoreIdentityClass();
        }
        return SCOID.class;
    }

    public synchronized Object putUserObject(Object key, Object value) {
        this.assertIsOpen();
        if (key == null) {
            return null;
        }
        if (this.userObjectMap == null) {
            this.userObjectMap = new HashMap();
        }
        if (value == null) {
            return this.userObjectMap.remove(key);
        }
        return this.userObjectMap.put(key, value);
    }

    public synchronized Object getUserObject(Object key) {
        this.assertIsOpen();
        if (key == null) {
            return null;
        }
        if (this.userObjectMap == null) {
            return null;
        }
        return this.userObjectMap.get(key);
    }

    public synchronized Object removeUserObject(Object key) {
        this.assertIsOpen();
        if (key == null) {
            return null;
        }
        if (this.userObjectMap == null) {
            return null;
        }
        return this.userObjectMap.remove(key);
    }

    public synchronized void setUserObject(Object userObject) {
        this.assertIsOpen();
        this.userObject = userObject;
    }

    public synchronized Object getUserObject() {
        this.assertIsOpen();
        return this.userObject;
    }

    public synchronized void flush() {
        try {
            this.objectMgr.flush();
        }
        catch (NucleusException jpe) {
            if (jpe instanceof NucleusOptimisticException) {
                Throwable[] nested = jpe.getNestedExceptions();
                JDOOptimisticVerificationException[] jdoNested = new JDOOptimisticVerificationException[nested.length];
                for (int i = 0; i < nested.length; ++i) {
                    jdoNested[i] = (JDOOptimisticVerificationException)NucleusJDOHelper.getJDOExceptionForNucleusException((NucleusException)nested[i]);
                }
                throw new JDOOptimisticVerificationException(jpe.getMessage(), (Throwable[])jdoNested);
            }
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void checkConsistency() {
        this.assertIsOpen();
        if (!this.objectMgr.getTransaction().isActive()) {
            return;
        }
        if (this.objectMgr.getTransaction().getOptimistic()) {
            throw new JDOUserException("checkConsistency() not yet implemented for optimistic transactions");
        }
        this.flush();
    }

    public Sequence getSequence(String sequenceName) {
        this.assertIsOpen();
        SequenceMetaData seqmd = this.objectMgr.getMetaDataManager().getMetaDataForSequence(this.objectMgr.getClassLoaderResolver(), sequenceName);
        if (seqmd == null) {
            throw new JDOUserException(LOCALISER.msg("017000", (Object)sequenceName));
        }
        Sequence seq = null;
        if (seqmd.getFactoryClass() != null) {
            seq = this.pmf.getSequenceForFactoryClass(seqmd.getFactoryClass());
            if (seq == null) {
                Class factory = this.objectMgr.getClassLoaderResolver().classForName(seqmd.getFactoryClass());
                if (factory == null) {
                    throw new JDOUserException(LOCALISER.msg("017001", (Object)sequenceName, (Object)seqmd.getFactoryClass()));
                }
                Class[] argTypes = null;
                Object[] arguments = null;
                if (seqmd.getStrategy() != null) {
                    argTypes = new Class[]{String.class, String.class};
                    arguments = new Object[]{seqmd.getName(), seqmd.getStrategy().toString()};
                } else {
                    argTypes = new Class[]{String.class};
                    arguments = new Object[]{seqmd.getName()};
                }
                try {
                    Method newInstanceMethod = factory.getMethod("newInstance", argTypes);
                    seq = (Sequence)newInstanceMethod.invoke(null, arguments);
                }
                catch (Exception e) {
                    throw new JDOUserException(LOCALISER.msg("017002", (Object)seqmd.getFactoryClass(), (Object)e.getMessage()));
                }
                this.pmf.addSequenceForFactoryClass(seqmd.getFactoryClass(), seq);
            }
        } else {
            NucleusSequence nucSeq = this.objectMgr.getStoreManager().getNucleusSequence(this.objectMgr, seqmd);
            seq = new JDOSequence(nucSeq);
        }
        return seq;
    }

    public void addInstanceLifecycleListener(InstanceLifecycleListener listener, Class ... classes) {
        this.objectMgr.addListener(listener, classes);
    }

    public void removeInstanceLifecycleListener(InstanceLifecycleListener listener) {
        this.objectMgr.removeListener(listener);
    }

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(LOCALISER_JDO.msg("011000"));
        }
    }

    protected void assertActiveTransaction() {
        if (!this.objectMgr.getTransaction().isActive()) {
            throw new TransactionNotActiveException();
        }
    }

    protected void assertWritable() {
        if (!this.objectMgr.getTransaction().isActive() && !this.objectMgr.getTransaction().getNontransactionalWrite()) {
            throw new TransactionNotWritableException();
        }
    }

    protected void assertReadable(String operation) {
        if (!this.objectMgr.getTransaction().isActive() && !this.objectMgr.getTransaction().getNontransactionalRead()) {
            throw new JDOUserException(LOCALISER_JDO.msg("011001", (Object)operation));
        }
    }

    protected boolean hasPersistenceInformationForClass(Class cls) {
        return this.objectMgr.hasPersistenceInformationForClass(cls);
    }

    public JDOConnection getDataStoreConnection() {
        try {
            NucleusConnection nconn = this.objectMgr.getStoreManager().getNucleusConnection(this.objectMgr);
            if (nconn instanceof JDOConnection) {
                return (JDOConnection)nconn;
            }
            return new JDOConnectionImpl(nconn);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public javax.jdo.FetchGroup getFetchGroup(Class cls, String name) {
        JDOFetchGroup jdoGrp2;
        if (this.jdoFetchGroups == null) {
            this.jdoFetchGroups = new HashSet<JDOFetchGroup>();
        }
        for (JDOFetchGroup jdoGrp2 : this.jdoFetchGroups) {
            if (!jdoGrp2.getName().equals(name) || jdoGrp2.getType() != cls || jdoGrp2.isUnmodifiable()) continue;
            return jdoGrp2;
        }
        jdoGrp2 = (JDOFetchGroup)this.getPersistenceManagerFactory().getFetchGroup(cls, name);
        if (jdoGrp2 != null) {
            FetchGroup internalGrp = jdoGrp2.getInternalFetchGroup();
            FetchGroup internalCopy = new FetchGroup(internalGrp);
            jdoGrp2 = new JDOFetchGroup(internalCopy);
            this.objectMgr.addInternalFetchGroup(internalCopy);
            this.jdoFetchGroups.add(jdoGrp2);
            return jdoGrp2;
        }
        try {
            FetchGroup internalGrp = this.objectMgr.getInternalFetchGroup(cls, name);
            jdoGrp2 = new JDOFetchGroup(internalGrp);
            this.jdoFetchGroups.add(jdoGrp2);
            return jdoGrp2;
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public synchronized void setQueryTimeoutMillis(Integer timeout) {
        this.objectMgr.setQueryTimeoutMillis(timeout);
    }

    public Integer getQueryTimeoutMillis() {
        return this.objectMgr.getQueryTimeoutMillis();
    }
}

