/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.lang.reflect.Constructor;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchGroupManager;
import org.datanucleus.OMFContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.cache.NullLevel2Cache;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.FederationManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.util.NucleusLogger;

public class ObjectManagerFactoryImpl
extends PersistenceConfiguration {
    private static String versionNumber = null;
    private static String vendorName = null;
    protected OMFContext omfContext;
    protected Level2Cache cache;
    private boolean closed;
    private FetchGroupManager fetchGrpMgr;
    FederationManager fed;

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw new NucleusUserException(LOCALISER.msg("008002"));
        }
    }

    protected void logConfiguration() {
        NucleusLogger.PERSISTENCE.info("================= Persistence Configuration ===============");
        NucleusLogger.PERSISTENCE.info(LOCALISER.msg("008000", (Object)ObjectManagerFactoryImpl.getVendorName(), (Object)ObjectManagerFactoryImpl.getVersionNumber()));
        NucleusLogger.PERSISTENCE.info(LOCALISER.msg("008001", (Object)this.getStringProperty("datanucleus.ConnectionURL"), (Object)this.getStringProperty("datanucleus.ConnectionDriverName"), (Object)this.getStringProperty("datanucleus.ConnectionUserName")));
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            String timeZoneID;
            NucleusLogger.PERSISTENCE.debug("JDK : " + System.getProperty("java.version") + " on " + System.getProperty("os.name"));
            NucleusLogger.PERSISTENCE.debug("Persistence API : " + this.getOMFContext().getApi());
            NucleusLogger.PERSISTENCE.debug("Plugin Registry : " + this.getOMFContext().getPluginManager().getRegistryClassName());
            if (this.hasProperty("datanucleus.PersistenceUnitName")) {
                NucleusLogger.PERSISTENCE.debug("Persistence-Unit : " + this.getStringProperty("datanucleus.PersistenceUnitName"));
            }
            if ((timeZoneID = this.getStringProperty("datanucleus.ServerTimeZoneID")) == null) {
                timeZoneID = TimeZone.getDefault().getID();
            }
            NucleusLogger.PERSISTENCE.debug("Standard Options : " + (this.getBooleanProperty("datanucleus.Multithreaded") ? "multithreaded" : "singlethreaded") + (this.getBooleanProperty("datanucleus.RetainValues") ? ", retain-values" : "") + (this.getBooleanProperty("datanucleus.RestoreValues") ? ", restore-values" : "") + (this.getBooleanProperty("datanucleus.NontransactionalRead") ? ", nontransactional-read" : "") + (this.getBooleanProperty("datanucleus.NontransactionalWrite") ? ", nontransactional-write" : "") + (this.getBooleanProperty("datanucleus.IgnoreCache") ? ", ignoreCache" : "") + ", serverTimeZone=" + timeZoneID);
            NucleusLogger.PERSISTENCE.debug("Persistence Options :" + (this.getBooleanProperty("datanucleus.persistenceByReachabilityAtCommit") ? " reachability-at-commit" : "") + (this.getBooleanProperty("datanucleus.DetachAllOnCommit") ? " detach-all-on-commit" : "") + (this.getBooleanProperty("datanucleus.DetachOnClose") ? " detach-on-close" : "") + (this.getBooleanProperty("datanucleus.manageRelationships") ? (this.getBooleanProperty("datanucleus.manageRelationshipsChecks") ? " managed-relations(checked)" : "managed-relations(unchecked)") : "") + " deletion-policy=" + this.getStringProperty("datanucleus.deletionPolicy"));
            NucleusLogger.PERSISTENCE.debug("Transactions : type=" + this.getStringProperty("datanucleus.TransactionType") + " mode=" + (this.getBooleanProperty("datanucleus.Optimistic") ? "optimistic" : "datastore") + " isolation=" + this.getStringProperty("datanucleus.transactionIsolation"));
            NucleusLogger.PERSISTENCE.debug("Value Generation : txn-isolation=" + this.getStringProperty("datanucleus.valuegeneration.transactionIsolation") + " connection=" + (this.getStringProperty("datanucleus.valuegeneration.transactionAttribute").equalsIgnoreCase("New") ? "New" : "PM"));
            Object primCL = this.getProperty("datanucleus.primaryClassLoader");
            NucleusLogger.PERSISTENCE.debug("ClassLoading : " + this.getStringProperty("datanucleus.classLoaderResolverName") + (primCL != null ? "primary=" + primCL : ""));
            NucleusLogger.PERSISTENCE.debug("Cache : Level1 (" + this.getStringProperty("datanucleus.cache.level1.type") + ")" + (this.getBooleanProperty("datanucleus.cache.level2") ? ", Level2 (" + this.getStringProperty("datanucleus.cache.level2.type") + ")" : "") + (this.getBooleanProperty("datanucleus.cache.collections") ? ", Collections/Maps " : ""));
        }
        NucleusLogger.PERSISTENCE.info("===========================================================");
    }

    protected void initialiseOMFContext() {
        this.omfContext = new OMFContext(this);
    }

    protected void initialiseStoreManager(ClassLoaderResolver clr) {
        this.fed = new FederationManager(clr, this.getOMFContext());
    }

    public StoreManager getStoreManager() {
        return this.getOMFContext().getStoreManager();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initialiseLevel2Cache() {
        if (this.getBooleanProperty("datanucleus.cache.level2")) {
            String level2Type = this.getStringProperty("datanucleus.cache.level2.type");
            String level2ClassName = this.getOMFContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_level2", "name", level2Type, "class-name");
            if (level2ClassName == null) {
                throw new NucleusUserException(LOCALISER.msg("004000", (Object)level2Type)).setFatal();
            }
            try {
                Class<?> level2CacheClass = Class.forName(level2ClassName);
                Class[] ctrArgsClasses = new Class[]{OMFContext.class};
                Object[] ctrArgs = new Object[]{this.omfContext};
                Constructor<?> ctr = level2CacheClass.getConstructor(ctrArgsClasses);
                this.cache = (Level2Cache)ctr.newInstance(ctrArgs);
                if (!NucleusLogger.CACHE.isDebugEnabled()) return;
                NucleusLogger.CACHE.debug(LOCALISER.msg("004002", (Object)level2ClassName));
                return;
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("004001", (Object)level2Type, (Object)level2ClassName), e).setFatal();
            }
        } else {
            this.cache = new NullLevel2Cache();
        }
    }

    public synchronized void close() {
        if (this.getBooleanProperty("datanucleus.cache.level2") && this.cache != null) {
            this.cache.close();
            NucleusLogger.CACHE.info(LOCALISER.msg("004009"));
        }
        if (this.fetchGrpMgr != null) {
            this.getFetchGroupManager().clearFetchGroups();
        }
        if (this.omfContext != null) {
            this.omfContext.close();
            this.omfContext = null;
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public OMFContext getOMFContext() {
        if (this.omfContext == null) {
            this.initialiseOMFContext();
        }
        return this.omfContext;
    }

    public PersistenceConfiguration getPersistenceConfiguration() {
        return this;
    }

    public Level2Cache getLevel2Cache() {
        return this.cache;
    }

    public static String getVersionNumber() {
        if (versionNumber != null) {
            return versionNumber;
        }
        String version = "Unknown";
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.datanucleus.DataNucleusVersion");
            try {
                version = bundle.getString("datanucleus.version");
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        versionNumber = version;
        return versionNumber;
    }

    public static String getVendorName() {
        if (vendorName != null) {
            return vendorName;
        }
        String vendor = "DataNucleus";
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.datanucleus.DataNucleusVersion");
            try {
                vendor = bundle.getString("datanucleus.vendor");
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        vendorName = vendor;
        return vendorName;
    }

    protected FetchGroupManager getFetchGroupManager() {
        if (this.fetchGrpMgr == null) {
            this.fetchGrpMgr = new FetchGroupManager(this.getOMFContext());
        }
        return this.fetchGrpMgr;
    }

    protected void addInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().addFetchGroup(grp);
    }

    protected void removeInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().removeFetchGroup(grp);
    }

    public FetchGroup createInternalFetchGroup(Class cls, String name) {
        return this.getFetchGroupManager().createFetchGroup(cls, name);
    }

    public FetchGroup getInternalFetchGroup(Class cls, String name) {
        return this.getFetchGroupManager().getFetchGroup(cls, name);
    }

    public Set getFetchGroupsWithName(String name) {
        return this.getFetchGroupManager().getFetchGroupsWithName(name);
    }
}

