/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.IndexedValue;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.util.StringUtils;

public class VersionMetaData
extends MetaData {
    private VersionStrategy versionStrategy;
    private String columnName;
    protected final List<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
    protected IndexMetaData indexMetaData;
    protected IndexedValue indexed = null;
    protected String fieldName = null;
    protected ColumnMetaData[] columnMetaData;

    public VersionMetaData(String versionStrategy, String columnName, String indexed) {
        if (StringUtils.isWhitespace(versionStrategy) || VersionStrategy.getVersionStrategy(versionStrategy) == null) {
            throw new RuntimeException(LOCALISER.msg("044156"));
        }
        this.versionStrategy = VersionStrategy.getVersionStrategy(versionStrategy);
        this.columnName = StringUtils.isWhitespace(columnName) ? null : columnName;
        this.indexed = IndexedValue.getIndexedValue(indexed);
    }

    public VersionMetaData(String versionStrategy, String fieldName) {
        if (StringUtils.isWhitespace(versionStrategy) || VersionStrategy.getVersionStrategy(versionStrategy) == null) {
            throw new RuntimeException(LOCALISER.msg("044156"));
        }
        this.versionStrategy = VersionStrategy.getVersionStrategy(versionStrategy);
        this.fieldName = StringUtils.isWhitespace(fieldName) ? null : fieldName;
    }

    public void initialise() {
        String val;
        if (this.hasExtension("field-name") && !StringUtils.isWhitespace(val = this.getValueForExtension("field-name"))) {
            this.fieldName = val;
            this.columnName = null;
        }
        if (this.fieldName == null) {
            if (this.indexMetaData == null && this.columnMetaData != null && this.indexed != null && this.indexed != IndexedValue.FALSE) {
                this.indexMetaData = new IndexMetaData();
                this.indexMetaData.setUnique(this.indexed == IndexedValue.UNIQUE);
                for (int i = 0; i < this.columnMetaData.length; ++i) {
                    this.indexMetaData.addColumn(this.columnMetaData[i]);
                }
            }
            if (this.indexMetaData != null) {
                this.indexMetaData.initialise();
            }
            if (this.columns.size() == 0 && this.columnName != null) {
                this.columnMetaData = new ColumnMetaData[1];
                this.columnMetaData[0] = new ColumnMetaData(this.columnName);
                this.columnMetaData[0].parent = this;
            } else {
                this.columnMetaData = new ColumnMetaData[this.columns.size()];
                for (int i = 0; i < this.columnMetaData.length; ++i) {
                    this.columnMetaData[i] = this.columns.get(i);
                    this.columnMetaData[i].initialise();
                }
            }
        }
    }

    public final ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public final VersionStrategy getVersionStrategy() {
        return this.versionStrategy;
    }

    public final IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public final String getFieldName() {
        return this.fieldName;
    }

    public void addColumn(ColumnMetaData colmd) {
        this.columns.add(colmd);
        colmd.parent = this;
        this.columnMetaData = new ColumnMetaData[this.columns.size()];
        for (int i = 0; i < this.columnMetaData.length; ++i) {
            this.columnMetaData[i] = this.columns.get(i);
        }
    }

    public final void setIndexMetaData(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public IndexedValue getIndexed() {
        return this.indexed;
    }

    public void setIndexed(IndexedValue indexed) {
        this.indexed = indexed;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<version strategy=\"" + this.versionStrategy.toString() + "\"" + (this.indexed != null ? " indexed=\"" + this.indexed.toString() + "\"" : "") + ">\n");
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnMetaData c = this.columns.get(i);
            sb.append(c.toString(prefix + indent, indent));
        }
        if (this.indexMetaData != null) {
            sb.append(this.indexMetaData.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</version>\n");
        return sb.toString();
    }

    public Object getNextVersion(Object currentVersion) {
        if (this.versionStrategy == null) {
            return null;
        }
        if (this.versionStrategy == VersionStrategy.NONE) {
            if (currentVersion == null) {
                return new Long(1L);
            }
            return new Long((Long)currentVersion + 1L);
        }
        if (this.versionStrategy == VersionStrategy.DATE_TIME) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (this.versionStrategy == VersionStrategy.VERSION_NUMBER) {
            if (currentVersion == null) {
                return new Long(1L);
            }
            return new Long((Long)currentVersion + 1L);
        }
        if (this.versionStrategy == VersionStrategy.STATE_IMAGE) {
            throw new NucleusUserException("DataNucleus doesnt currently support version strategy \"state-image\"");
        }
        throw new NucleusUserException("Unknown version strategy - not supported");
    }
}

