/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.util.StringUtils;

public class PackageMetaData
extends MetaData {
    protected List<InterfaceMetaData> interfaces = null;
    protected List<ClassMetaData> classes = null;
    protected Collection<SequenceMetaData> sequences = null;
    protected Collection<TableGeneratorMetaData> tableGenerators = null;
    protected final String name;
    protected String catalog;
    protected String schema;

    public PackageMetaData(String name) {
        this.name = name;
        if (this.name == null) {
            throw new NucleusUserException(LOCALISER.msg("044041", (Object)"name", (Object)this.getFileMetaData().getFilename(), (Object)"package"));
        }
    }

    public void initialise() {
        if (this.catalog == null && ((FileMetaData)this.parent).getCatalog() != null) {
            this.catalog = ((FileMetaData)this.parent).getCatalog();
        }
        if (this.schema == null && ((FileMetaData)this.parent).getSchema() != null) {
            this.schema = ((FileMetaData)this.parent).getSchema();
        }
        super.initialise();
    }

    public FileMetaData getFileMetaData() {
        if (this.parent != null) {
            return (FileMetaData)this.parent;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public int getNoOfInterfaces() {
        return this.interfaces != null ? this.interfaces.size() : 0;
    }

    public InterfaceMetaData getInterface(int i) {
        return this.interfaces.get(i);
    }

    public InterfaceMetaData getInterface(String name) {
        for (InterfaceMetaData imd : this.interfaces) {
            if (!imd.getName().equals(name)) continue;
            return imd;
        }
        return null;
    }

    public int getNoOfClasses() {
        return this.classes != null ? this.classes.size() : 0;
    }

    public ClassMetaData getClass(int i) {
        return this.classes.get(i);
    }

    public ClassMetaData getClass(String name) {
        for (ClassMetaData cmd : this.classes) {
            if (!cmd.getName().equals(name)) continue;
            return cmd;
        }
        return null;
    }

    public int getNoOfSequences() {
        return this.sequences != null ? this.sequences.size() : 0;
    }

    public SequenceMetaData[] getSequences() {
        return this.sequences == null ? null : this.sequences.toArray(new SequenceMetaData[this.sequences.size()]);
    }

    public SequenceMetaData getSequence(String name) {
        for (SequenceMetaData seqmd : this.sequences) {
            if (!seqmd.getName().equals(name)) continue;
            return seqmd;
        }
        return null;
    }

    public int getNoOfTableGenerators() {
        return this.tableGenerators != null ? this.tableGenerators.size() : 0;
    }

    public TableGeneratorMetaData[] getTableGenerators() {
        return this.tableGenerators == null ? null : this.tableGenerators.toArray(new TableGeneratorMetaData[this.tableGenerators.size()]);
    }

    public TableGeneratorMetaData getTableGenerator(String name) {
        for (TableGeneratorMetaData tgmd : this.tableGenerators) {
            if (!tgmd.getName().equals(name)) continue;
            return tgmd;
        }
        return null;
    }

    public void addClass(ClassMetaData cmd) {
        if (cmd == null) {
            return;
        }
        if (this.classes == null) {
            this.classes = new ArrayList<ClassMetaData>();
        }
        this.classes.add(cmd);
        cmd.parent = this;
    }

    public void addInterface(InterfaceMetaData imd) {
        if (imd == null) {
            return;
        }
        if (this.interfaces == null) {
            this.interfaces = new ArrayList<InterfaceMetaData>();
        }
        this.interfaces.add(imd);
        imd.parent = this;
    }

    public void addSequence(SequenceMetaData seqmd) {
        if (seqmd == null) {
            return;
        }
        if (this.sequences == null) {
            this.sequences = new HashSet<SequenceMetaData>();
        }
        this.sequences.add(seqmd);
        seqmd.parent = this;
    }

    public void addTableGenerator(TableGeneratorMetaData tgmd) {
        if (tgmd == null) {
            return;
        }
        if (this.tableGenerators == null) {
            this.tableGenerators = new HashSet<TableGeneratorMetaData>();
        }
        this.tableGenerators.add(tgmd);
        tgmd.parent = this;
    }

    public void setCatalog(String catalog) {
        this.catalog = StringUtils.isWhitespace(catalog) ? null : catalog;
    }

    public void setSchema(String schema) {
        this.schema = StringUtils.isWhitespace(schema) ? null : schema;
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<package name=\"" + this.name + "\"");
        if (this.catalog != null) {
            sb.append(" catalog=\"" + this.catalog + "\"");
        }
        if (this.schema != null) {
            sb.append(" schema=\"" + this.schema + "\"");
        }
        sb.append(">\n");
        if (this.interfaces != null) {
            Iterator<InterfaceMetaData> int_iter = this.interfaces.iterator();
            while (int_iter.hasNext()) {
                sb.append(int_iter.next().toString(prefix + indent, indent));
            }
        }
        if (this.classes != null) {
            Iterator<ClassMetaData> cls_iter = this.classes.iterator();
            while (cls_iter.hasNext()) {
                sb.append(cls_iter.next().toString(prefix + indent, indent));
            }
        }
        if (this.sequences != null) {
            Iterator<SequenceMetaData> seq_iter = this.sequences.iterator();
            while (seq_iter.hasNext()) {
                sb.append(seq_iter.next().toString(prefix + indent, indent));
            }
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</package>\n");
        return sb.toString();
    }
}

