/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.Serializable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.StringUtils;

class ContainerComponent
implements Serializable {
    protected Boolean embedded;
    protected Boolean serialized;
    protected Boolean dependent;
    protected String type = "java.lang.Object";
    protected AbstractClassMetaData classMetaData;

    public ContainerComponent() {
    }

    public ContainerComponent(String type, String embedded, String serialized, String dependent) {
        if (!StringUtils.isWhitespace(type)) {
            this.type = type;
        }
        if (embedded != null) {
            if (embedded.equalsIgnoreCase("true")) {
                this.embedded = Boolean.TRUE;
            } else if (embedded.equalsIgnoreCase("false")) {
                this.embedded = Boolean.FALSE;
            }
        }
        if (dependent != null) {
            if (dependent.equalsIgnoreCase("true")) {
                this.dependent = Boolean.TRUE;
            } else if (dependent.equalsIgnoreCase("false")) {
                this.dependent = Boolean.FALSE;
            }
        }
        if (serialized != null) {
            if (serialized.equalsIgnoreCase("true")) {
                this.serialized = Boolean.TRUE;
            } else if (serialized.equalsIgnoreCase("false")) {
                this.serialized = Boolean.FALSE;
            }
        }
    }

    void populate(String packageName, ClassLoaderResolver clr, ClassLoader primary) {
        if (this.type != null && !ClassUtils.isPrimitiveArrayType(this.type) && !ClassUtils.isPrimitiveType(this.type)) {
            try {
                clr.classForName(this.type, primary, false);
            }
            catch (ClassNotResolvedException cnre) {
                String name = ClassUtils.createFullClassName(packageName, this.type);
                try {
                    clr.classForName(name, primary, false);
                    this.type = name;
                }
                catch (ClassNotResolvedException cnre2) {
                    name = ClassUtils.getJavaLangClassForType(this.type);
                    clr.classForName(name, primary, false);
                    this.type = name;
                }
            }
        }
    }

    public String toString() {
        return "Type=" + this.type + " embedded=" + this.embedded + " serialized=" + this.serialized + " dependent=" + this.dependent + " cmd=" + this.classMetaData;
    }
}

