/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ContainerComponent;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class CollectionMetaData
extends ContainerMetaData {
    protected ContainerComponent element;

    public CollectionMetaData(CollectionMetaData colmd) {
        this.element = new ContainerComponent();
        this.element.embedded = colmd.element.embedded;
        this.element.serialized = colmd.element.serialized;
        this.element.dependent = colmd.element.dependent;
        this.element.type = colmd.element.type;
        this.element.classMetaData = colmd.element.classMetaData;
    }

    public CollectionMetaData(String elementType, String embeddedElement, String dependentElement, String serializedElement) {
        this.element = new ContainerComponent(elementType, embeddedElement, serializedElement, dependentElement);
    }

    public void populate(ClassLoaderResolver clr, ClassLoader primary) {
        ElementMetaData elemmd;
        AbstractMemberMetaData mmd = (AbstractMemberMetaData)this.parent;
        if (!StringUtils.isWhitespace(this.element.type) && this.element.type.indexOf(44) > 0) {
            throw new InvalidMetaDataException(LOCALISER, "044131", (Object)mmd.getName(), mmd.getClassName());
        }
        this.element.populate(((AbstractMemberMetaData)this.parent).getAbstractClassMetaData().getPackageName(), clr, primary);
        Class field_type = this.getMemberMetaData().getType();
        if (!Collection.class.isAssignableFrom(field_type)) {
            throw new InvalidMetaDataException(LOCALISER, "044132", (Object)this.getFieldName(), this.getMemberMetaData().getClassName(false));
        }
        if (this.element.type == null) {
            throw new InvalidMetaDataException(LOCALISER, "044133", (Object)this.getFieldName(), this.getMemberMetaData().getClassName(false));
        }
        Class elementTypeClass = null;
        try {
            elementTypeClass = clr.classForName(this.element.type, primary);
        }
        catch (ClassNotResolvedException cnre) {
            throw new InvalidMetaDataException(LOCALISER, "044134", (Object)this.getFieldName(), (Object)this.getMemberMetaData().getClassName(false), this.element.type);
        }
        if (!elementTypeClass.getName().equals(this.element.type)) {
            NucleusLogger.METADATA.info(LOCALISER.msg("044135", (Object)this.getFieldName(), (Object)this.getMemberMetaData().getClassName(false), (Object)this.element.type, (Object)elementTypeClass.getName()));
            this.element.type = elementTypeClass.getName();
        }
        ApiAdapter api = this.getMetaDataManager().getApiAdapter();
        if (this.element.embedded == null) {
            this.element.embedded = this.getMetaDataManager().getOMFContext().getTypeManager().isDefaultEmbeddedType(elementTypeClass) ? Boolean.TRUE : (api.isPersistable(elementTypeClass) || Object.class.isAssignableFrom(elementTypeClass) || elementTypeClass.isInterface() ? Boolean.FALSE : Boolean.TRUE);
        }
        if (this.element.embedded == Boolean.FALSE && !api.isPersistable(elementTypeClass) && !elementTypeClass.isInterface() && elementTypeClass != Object.class) {
            this.element.embedded = Boolean.TRUE;
        }
        if ((elemmd = ((AbstractMemberMetaData)this.parent).getElementMetaData()) != null && elemmd.getEmbeddedMetaData() != null) {
            this.element.embedded = Boolean.TRUE;
        }
        if (this.element.dependent == Boolean.TRUE && !api.isPersistable(elementTypeClass) && !elementTypeClass.isInterface() && elementTypeClass != Object.class) {
            this.element.dependent = Boolean.FALSE;
        }
        this.element.classMetaData = this.getMemberMetaData().getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(elementTypeClass, clr);
        this.setPopulated();
    }

    public String getElementType() {
        return this.element.type;
    }

    public AbstractClassMetaData getElementClassMetaData() {
        if (this.element.classMetaData != null && !this.element.classMetaData.isInitialised()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CollectionMetaData.this.element.classMetaData.initialise();
                    return null;
                }
            });
        }
        return this.element.classMetaData;
    }

    public boolean isEmbeddedElement() {
        if (this.element.embedded == null) {
            return false;
        }
        return this.element.embedded;
    }

    public boolean isDependentElement() {
        if (this.element.dependent == null) {
            return false;
        }
        if (this.element.classMetaData == null) {
            return false;
        }
        return this.element.dependent;
    }

    public boolean isSerializedElement() {
        if (this.element.serialized == null) {
            return false;
        }
        return this.element.serialized;
    }

    void getReferencedClassMetaData(List orderedCMDs, Set referencedCMDs, ClassLoaderResolver clr) {
        AbstractClassMetaData element_cmd = this.getMetaDataManager().getMetaDataForClass(this.element.type, clr);
        if (element_cmd != null) {
            element_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, clr);
        }
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<collection element-type=\"").append(this.element.type).append("\"");
        if (this.element.embedded != null) {
            sb.append(" embedded-element=\"").append(this.element.embedded).append("\"");
        }
        if (this.element.dependent != null) {
            sb.append(" dependent-element=\"").append(this.element.dependent).append("\"");
        }
        if (this.element.serialized != null) {
            sb.append(" serialized-element=\"").append(this.element.serialized).append("\"");
        }
        sb.append(">\n");
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</collection>\n");
        return sb.toString();
    }
}

