/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.datanucleus.ObjectManager;
import org.datanucleus.TransactionImpl;
import org.datanucleus.exceptions.TransactionActiveOnBeginException;
import org.datanucleus.exceptions.TransactionNotActiveException;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.util.NucleusLogger;

public class JTATransactionImpl
extends TransactionImpl
implements Synchronization {
    private TransactionManager tm;
    private Transaction jtaTx;
    private boolean registeredSync = false;
    private boolean rollingback = false;
    private static boolean INSIDE_JBOSS = System.getProperty("jboss.server.name") != null;

    JTATransactionImpl(ObjectManager om) {
        super(om);
        om.getOMFContext().getTransactionManager().setContainerManagedConnections(true);
        this.joinTransaction();
    }

    public boolean isActive() {
        boolean isActive = super.isActive();
        if (isActive && this.registeredSync) {
            return true;
        }
        this.joinTransaction();
        return super.isActive();
    }

    public void begin() {
        UserTransaction utx;
        this.joinTransaction();
        if (this.active) {
            throw new TransactionActiveOnBeginException(this);
        }
        try {
            utx = this.getUserTransaction();
        }
        catch (NamingException e) {
            throw this.om.getApiAdapter().getExceptionForException("Failed to obtain UserTransaction", e);
        }
        try {
            utx.begin();
        }
        catch (NotSupportedException e) {
            throw this.om.getApiAdapter().getExceptionForException("Failed to begin UserTransaction", (Exception)((Object)e));
        }
        catch (SystemException e) {
            throw this.om.getApiAdapter().getExceptionForException("Failed to begin UserTransaction", (Exception)((Object)e));
        }
        this.joinTransaction();
    }

    public void commit() {
        UserTransaction utx;
        if (!this.active) {
            throw new TransactionNotActiveException();
        }
        try {
            utx = this.getUserTransaction();
        }
        catch (NamingException e) {
            throw this.om.getApiAdapter().getExceptionForException("Failed to obtain UserTransaction", e);
        }
        try {
            utx.commit();
        }
        catch (Exception e) {
            throw this.om.getApiAdapter().getExceptionForException("Failed to commit UserTransaction", e);
        }
        this.joinTransaction();
    }

    public void rollback() {
        UserTransaction utx;
        if (!this.active) {
            throw new TransactionNotActiveException();
        }
        try {
            utx = this.getUserTransaction();
        }
        catch (NamingException e) {
            throw this.om.getApiAdapter().getExceptionForException("Failed to obtain UserTransaction", e);
        }
        try {
            utx.rollback();
        }
        catch (Exception e) {
            throw this.om.getApiAdapter().getExceptionForException("Failed to rollback UserTransaction", e);
        }
    }

    public void setRollbackOnly() {
        UserTransaction utx;
        if (!this.active) {
            throw new TransactionNotActiveException();
        }
        try {
            utx = this.getUserTransaction();
        }
        catch (NamingException e) {
            throw this.om.getApiAdapter().getExceptionForException("Failed to obtain UserTransaction", e);
        }
        try {
            utx.setRollbackOnly();
        }
        catch (Exception e) {
            throw this.om.getApiAdapter().getExceptionForException("Failed to rollback-only UserTransaction", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void joinTransaction() {
        block15: {
            try {
                if (this.tm == null) {
                    this.tm = this.obtainTransactionManager();
                }
                this.jtaTx = this.tm.getTransaction();
                if (this.jtaTx != null) {
                    if (!this.om.getOMFContext().getPersistenceConfiguration().isJcaMode()) {
                        try {
                            this.jtaTx.registerSynchronization((Synchronization)this);
                            this.registeredSync = true;
                        }
                        catch (RollbackException rb) {
                            this.markedForRollbackAction();
                            return;
                        }
                    }
                    if (!this.active && this.jtaTx.getStatus() == 0) {
                        this.internalBegin();
                        return;
                    }
                    if (this.rollbackOnly && this.jtaTx.getStatus() == 4) {
                        this.rollback();
                    } else if (!this.rollbackOnly && this.jtaTx.getStatus() == 1) {
                        this.markedForRollbackAction();
                    } else if (this.rollbackOnly && this.jtaTx.getStatus() == 6) {
                        this.rollback();
                    }
                    break block15;
                }
                if (!this.active || !this.rollbackOnly || this.rollingback) break block15;
                this.rollingback = true;
                try {
                    super.rollback();
                    Object var3_3 = null;
                    this.rollingback = false;
                    this.active = false;
                    this.rollbackOnly = false;
                    this.registeredSync = false;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.rollingback = false;
                    this.active = false;
                    this.rollbackOnly = false;
                    this.registeredSync = false;
                    throw throwable;
                }
            }
            catch (SystemException se) {
                throw new NucleusTransactionException(LOCALISER.msg("015026"), se);
            }
        }
    }

    private void markedForRollbackAction() {
        if (!this.rollbackOnly) {
            NucleusLogger.TRANSACTION.warn("UserTransaction is marked for rollback, probably had a timeout. Any subsequent operation requiring a database connection will fail.");
            this.active = true;
            super.setRollbackOnly();
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.StartedForConnection"));
            }
        }
    }

    private TransactionManager obtainTransactionManager() {
        TransactionManager tm = this.om.getOMFContext().getJtaTransactionManager();
        if (tm == null) {
            throw new NucleusTransactionException(LOCALISER.msg("015030"));
        }
        return tm;
    }

    private UserTransaction getUserTransaction() throws NamingException {
        InitialContext ctx = new InitialContext();
        UserTransaction ut = INSIDE_JBOSS ? (UserTransaction)ctx.lookup("UserTransaction") : (UserTransaction)ctx.lookup("java:comp/UserTransaction");
        return ut;
    }

    public void beforeCompletion() {
        try {
            this.internalPreCommit();
            this.flush();
        }
        catch (Throwable th) {
            NucleusLogger.TRANSACTION.error("Exception flushing work in JTA transaction. Mark for rollback", th);
            try {
                this.jtaTx.setRollbackOnly();
            }
            catch (Exception e) {
                NucleusLogger.TRANSACTION.fatal("Cannot mark transaction for rollback after exception in beforeCompletion. PersistenceManager might be in inconsistent state", e);
            }
        }
    }

    protected void internalRollback() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterCompletion(int status) {
        try {
            block7: {
                try {
                    if (status == 4) {
                        super.rollback();
                        break block7;
                    }
                    if (status == 3) {
                        this.internalPostCommit();
                        break block7;
                    }
                    NucleusLogger.TRANSACTION.fatal("Received unexpected transaction status + " + status);
                }
                catch (Throwable th) {
                    NucleusLogger.TRANSACTION.error("Exception during afterCompletion in JTA transaction. PersistenceManager might be in inconsistent state");
                    Object var4_3 = null;
                    this.jtaTx = null;
                    this.registeredSync = false;
                }
            }
            Object var4_2 = null;
            this.jtaTx = null;
            this.registeredSync = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.jtaTx = null;
            this.registeredSync = false;
            throw throwable;
        }
        if (this.active) {
            throw new NucleusTransactionException("internal error, must not be active after afterCompletion()!");
        }
    }
}

