/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.valuegenerator;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.valuegenerator.AbstractDatastoreGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationConnectionProvider;
import org.datanucleus.store.valuegenerator.ValueGenerationException;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ValueGenerationManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = ValueGenerationManager.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    protected Map generatorsByName = new HashMap();
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Properties;

    public void clear() {
        this.generatorsByName.clear();
    }

    public synchronized ValueGenerator getValueGenerator(String name) {
        if (name == null) {
            return null;
        }
        return (ValueGenerator)this.generatorsByName.get(name);
    }

    public synchronized ValueGenerator createValueGenerator(String name, Class generatorClass, Properties props, StoreManager storeMgr, ValueGenerationConnectionProvider connectionProvider) {
        ValueGenerator generator;
        try {
            if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
                NucleusLogger.VALUEGENERATION.debug(LOCALISER.msg("040001", (Object)generatorClass.getName(), (Object)name));
            }
            Class[] argTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ValueGenerationManager.class$("java.lang.String")) : class$java$lang$String, class$java$util$Properties == null ? (class$java$util$Properties = ValueGenerationManager.class$("java.util.Properties")) : class$java$util$Properties};
            Object[] args = new Object[]{name, props};
            Constructor ctor = generatorClass.getConstructor(argTypes);
            generator = (ValueGenerator)ctor.newInstance(args);
        }
        catch (Exception e) {
            NucleusLogger.VALUEGENERATION.error(e);
            throw new ValueGenerationException(LOCALISER.msg("040000", (Object)generatorClass.getName(), (Object)e), e);
        }
        if (generator instanceof AbstractDatastoreGenerator && storeMgr != null) {
            ((AbstractDatastoreGenerator)generator).setStoreManager(storeMgr);
            ((AbstractDatastoreGenerator)generator).setConnectionProvider(connectionProvider);
        }
        this.generatorsByName.put(name, generator);
        return generator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

