/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ReachabilityFieldManager
extends AbstractFieldManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = ReachabilityFieldManager.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    private final StateManager sm;
    private Set reachables = null;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public ReachabilityFieldManager(StateManager sm, Set reachables) {
        this.sm = sm;
        this.reachables = reachables;
    }

    protected void processPersistable(Object obj, AbstractMemberMetaData fmd) {
        ApiAdapter api = this.sm.getObjectManager().getApiAdapter();
        StateManager sm = this.sm.getObjectManager().findStateManager(obj);
        if (sm != null) {
            sm.runReachability(this.reachables);
        } else if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
            NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007005", api.getIdForObject(obj), (Object)fmd.getFullFieldName()));
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData fmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (value != null) {
            boolean persistCascade = fmd.isCascadePersist();
            ApiAdapter api = this.sm.getObjectManager().getApiAdapter();
            if (persistCascade) {
                if (api.isPersistable(value)) {
                    if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                        NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007004", (Object)fmd.getFullFieldName()));
                    }
                    this.processPersistable(value, fmd);
                } else if (value instanceof Collection) {
                    if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                        NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007002", (Object)fmd.getFullFieldName()));
                    }
                    Collection coll = (Collection)value;
                    Iterator iter = coll.iterator();
                    while (iter.hasNext()) {
                        Object element = iter.next();
                        if (!api.isPersistable(element)) continue;
                        this.processPersistable(element, fmd);
                    }
                } else if (value instanceof Map) {
                    Map map = (Map)value;
                    if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                        NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007002", (Object)fmd.getFullFieldName()));
                    }
                    Set keys = map.keySet();
                    Iterator<Object> iter = keys.iterator();
                    while (iter.hasNext()) {
                        Object mapKey = iter.next();
                        if (!api.isPersistable(mapKey)) continue;
                        this.processPersistable(mapKey, fmd);
                    }
                    Collection values = map.values();
                    iter = values.iterator();
                    while (iter.hasNext()) {
                        Object mapValue = iter.next();
                        if (!api.isPersistable(mapValue)) continue;
                        this.processPersistable(mapValue, fmd);
                    }
                } else if (value instanceof Object[]) {
                    if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                        NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007003", (Object)fmd.getFullFieldName()));
                    }
                    Object[] array = (Object[])value;
                    for (int i = 0; i < array.length; ++i) {
                        Object element = array[i];
                        if (!api.isPersistable(element)) continue;
                        this.processPersistable(element, fmd);
                    }
                }
            }
        } else if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
            NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007001", (Object)fmd.getFullFieldName()));
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    public void storeByteField(int fieldNumber, byte value) {
    }

    public void storeCharField(int fieldNumber, char value) {
    }

    public void storeDoubleField(int fieldNumber, double value) {
    }

    public void storeFloatField(int fieldNumber, float value) {
    }

    public void storeIntField(int fieldNumber, int value) {
    }

    public void storeLongField(int fieldNumber, long value) {
    }

    public void storeShortField(int fieldNumber, short value) {
    }

    public void storeStringField(int fieldNumber, String value) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

