/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.sco.SCOCollection;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class RelationshipManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = RelationshipManager.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    final StateManager ownerSM;
    final Object pc;
    final Map fieldChanges;
    private static final int ADD_OBJECT = 1;
    private static final int REMOVE_OBJECT = 2;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public RelationshipManager(StateManager sm) {
        this.ownerSM = sm;
        this.pc = sm.getObject();
        this.fieldChanges = new HashMap();
        this.ownerSM.getObjectManager().markManagedRelationDirty(sm);
    }

    public void clearFields() {
        this.fieldChanges.clear();
    }

    public void relationChange(int fieldNumber, Object oldValue, Object newValue) {
        AbstractClassMetaData cmd;
        AbstractMemberMetaData mmd;
        int relationType;
        if (this.ownerSM.getObjectManager().isManagingRelations()) {
            return;
        }
        Integer fieldKey = new Integer(fieldNumber);
        if (!(this.fieldChanges.containsKey(fieldKey) || (relationType = (mmd = (cmd = this.ownerSM.getClassMetaData()).getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber)).getRelationType(this.ownerSM.getObjectManager().getClassLoaderResolver())) != 2 && relationType != 6)) {
            this.fieldChanges.put(fieldKey, oldValue);
        }
    }

    public void relationAdd(int fieldNumber, Object val) {
        if (this.ownerSM.getObjectManager().isManagingRelations()) {
            return;
        }
        AbstractClassMetaData cmd = this.ownerSM.getClassMetaData();
        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        int relationType = mmd.getRelationType(this.ownerSM.getObjectManager().getClassLoaderResolver());
        if (relationType != 4 && relationType != 5) {
            return;
        }
        Integer fieldKey = new Integer(fieldNumber);
        Object changes = this.fieldChanges.get(fieldKey);
        ArrayList<RelationChange> changeList = null;
        changeList = changes == null ? new ArrayList<RelationChange>() : (ArrayList<RelationChange>)changes;
        RelationChange change = new RelationChange(1, val);
        changeList.add(change);
        this.fieldChanges.put(fieldKey, changeList);
    }

    public void relationRemove(int fieldNumber, Object val) {
        if (this.ownerSM.getObjectManager().isManagingRelations()) {
            return;
        }
        AbstractClassMetaData cmd = this.ownerSM.getClassMetaData();
        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        int relationType = mmd.getRelationType(this.ownerSM.getObjectManager().getClassLoaderResolver());
        if (relationType != 4 && relationType != 5) {
            return;
        }
        Integer fieldKey = new Integer(fieldNumber);
        Object changes = this.fieldChanges.get(fieldKey);
        ArrayList<RelationChange> changeList = null;
        changeList = changes == null ? new ArrayList<RelationChange>() : (ArrayList<RelationChange>)changes;
        RelationChange change = new RelationChange(2, val);
        changeList.add(change);
    }

    private boolean managesField(int fieldNumber) {
        return this.fieldChanges.containsKey(new Integer(fieldNumber));
    }

    public void checkConsistency() {
        Set entries = this.fieldChanges.entrySet();
        Iterator iter = entries.iterator();
        AbstractClassMetaData cmd = this.ownerSM.getClassMetaData();
        ObjectManager om = this.ownerSM.getObjectManager();
        while (iter.hasNext()) {
            ArrayList changes;
            Object newValue;
            Map.Entry entry = iter.next();
            int fieldNumber = (Integer)entry.getKey();
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            ClassLoaderResolver clr = om.getClassLoaderResolver();
            Object oldValue = entry.getValue();
            int relationType = mmd.getRelationType(clr);
            if (relationType == 2) {
                newValue = this.ownerSM.provideField(fieldNumber);
                this.checkOneToOneBidirectionalRelation(mmd, clr, om, oldValue, newValue);
                continue;
            }
            if (relationType == 6) {
                newValue = this.ownerSM.provideField(fieldNumber);
                this.checkManyToOneBidirectionalRelation(mmd, clr, om, oldValue, newValue);
                continue;
            }
            if (relationType == 4) {
                changes = (ArrayList)oldValue;
                this.checkOneToManyBidirectionalRelation(mmd, clr, om, changes);
                continue;
            }
            if (relationType != 5) continue;
            changes = (ArrayList)oldValue;
            this.checkManyToManyBidirectionalRelation(mmd, clr, om, changes);
        }
    }

    public void process() {
        Set entries = this.fieldChanges.entrySet();
        Iterator iter = entries.iterator();
        AbstractClassMetaData cmd = this.ownerSM.getClassMetaData();
        ObjectManager om = this.ownerSM.getObjectManager();
        while (iter.hasNext()) {
            ArrayList changes;
            Object newValue;
            Map.Entry entry = iter.next();
            int fieldNumber = (Integer)entry.getKey();
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            ClassLoaderResolver clr = om.getClassLoaderResolver();
            Object oldValue = entry.getValue();
            int relationType = mmd.getRelationType(clr);
            if (relationType == 2) {
                newValue = this.ownerSM.provideField(fieldNumber);
                this.processOneToOneBidirectionalRelation(mmd, clr, om, oldValue, newValue);
                continue;
            }
            if (relationType == 6) {
                newValue = this.ownerSM.provideField(fieldNumber);
                this.processManyToOneBidirectionalRelation(mmd, clr, om, oldValue, newValue);
                continue;
            }
            if (relationType == 4) {
                changes = (ArrayList)oldValue;
                this.processOneToManyBidirectionalRelation(mmd, clr, om, changes);
                continue;
            }
            if (relationType != 5) continue;
            changes = (ArrayList)oldValue;
            this.processManyToManyBidirectionalRelation(mmd, clr, om, changes);
        }
    }

    protected void checkOneToOneBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ObjectManager om, Object oldValue, Object newValue) {
        if (newValue != null) {
            AbstractMemberMetaData relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, newValue);
            StateManager newSM = om.findStateManager(newValue);
            if (newSM != null && relatedMmd != null) {
                RelationshipManager newRelMgr;
                newSM.loadField(relatedMmd.getAbsoluteFieldNumber());
                Object newValueFieldValue = newSM.provideField(relatedMmd.getAbsoluteFieldNumber());
                if (newValueFieldValue != this.pc && (newRelMgr = newSM.getRelationshipManager()) != null && newRelMgr.managesField(relatedMmd.getAbsoluteFieldNumber())) {
                    if (newValueFieldValue == null) {
                        String msg = LOCALISER.msg("013003", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getName(), (Object)StringUtils.toJVMIDString(newValue), (Object)relatedMmd.getName());
                        NucleusLogger.PERSISTENCE.error(msg);
                        throw new NucleusUserException(msg);
                    }
                    String msg = LOCALISER.msg("013002", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getName(), (Object)StringUtils.toJVMIDString(newValue), (Object)relatedMmd.getName(), (Object)StringUtils.toJVMIDString(newValueFieldValue));
                    NucleusLogger.PERSISTENCE.error(msg);
                    throw new NucleusUserException(msg);
                }
            }
        }
    }

    protected void checkOneToManyBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ObjectManager om, ArrayList changes) {
        Iterator iter = ((AbstractList)changes).iterator();
        while (iter.hasNext()) {
            Object newValueFieldValue;
            RelationshipManager newElementRelMgr;
            StateManager newElementSM;
            AbstractMemberMetaData relatedMmd;
            RelationChange change = (RelationChange)iter.next();
            if (change.type == 1) {
                if (this.ownerSM.getObjectManager().getApiAdapter().isDeleted(change.value)) {
                    throw new NucleusUserException(LOCALISER.msg("013008", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getName(), (Object)StringUtils.toJVMIDString(change.value)));
                }
                relatedMmd = mmd.getRelatedMemberMetaData(clr)[0];
                newElementSM = om.findStateManager(change.value);
                if (newElementSM == null) continue;
                newElementSM.loadField(relatedMmd.getAbsoluteFieldNumber());
                newElementRelMgr = newElementSM.getRelationshipManager();
                if (newElementRelMgr == null || !newElementRelMgr.managesField(relatedMmd.getAbsoluteFieldNumber()) || (newValueFieldValue = newElementSM.provideField(relatedMmd.getAbsoluteFieldNumber())) == this.pc || newValueFieldValue == null) continue;
                throw new NucleusUserException(LOCALISER.msg("013009", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getName(), (Object)StringUtils.toJVMIDString(change.value), (Object)StringUtils.toJVMIDString(newValueFieldValue)));
            }
            if (change.type != 2 || this.ownerSM.getObjectManager().getApiAdapter().isDeleted(change.value)) continue;
            relatedMmd = mmd.getRelatedMemberMetaData(clr)[0];
            newElementSM = om.findStateManager(change.value);
            if (newElementSM == null) continue;
            newElementSM.loadField(relatedMmd.getAbsoluteFieldNumber());
            newElementRelMgr = newElementSM.getRelationshipManager();
            if (newElementRelMgr == null || !newElementRelMgr.managesField(relatedMmd.getAbsoluteFieldNumber()) || (newValueFieldValue = newElementSM.provideField(relatedMmd.getAbsoluteFieldNumber())) != this.pc) continue;
            throw new NucleusUserException(LOCALISER.msg("013010", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getName(), (Object)StringUtils.toJVMIDString(change.value)));
        }
    }

    protected void checkManyToOneBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ObjectManager om, Object oldValue, Object newValue) {
    }

    protected void checkManyToManyBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ObjectManager om, ArrayList changes) {
    }

    protected void processOneToOneBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ObjectManager om, Object oldValue, Object newValue) {
        AbstractMemberMetaData relatedMmd;
        if (oldValue != null) {
            relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, oldValue);
            StateManager oldSM = om.findStateManager(oldValue);
            if (oldSM != null) {
                oldSM.loadField(relatedMmd.getAbsoluteFieldNumber());
                Object oldValueFieldValue = oldSM.provideField(relatedMmd.getAbsoluteFieldNumber());
                if (oldValueFieldValue != null && oldValueFieldValue == this.pc) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013004", (Object)StringUtils.toJVMIDString(oldValue), (Object)relatedMmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(this.pc), (Object)StringUtils.toJVMIDString(newValue)));
                    }
                    oldSM.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), null);
                }
            }
        }
        if (newValue != null) {
            relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, newValue);
            StateManager newSM = om.findStateManager(newValue);
            if (newSM != null && relatedMmd != null) {
                newSM.loadField(relatedMmd.getAbsoluteFieldNumber());
                Object newValueFieldValue = newSM.provideField(relatedMmd.getAbsoluteFieldNumber());
                if (newValueFieldValue == null) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013005", (Object)StringUtils.toJVMIDString(newValue), (Object)relatedMmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(this.pc)));
                    }
                    newSM.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), this.pc);
                } else if (newValueFieldValue != this.pc) {
                    StateManager newValueFieldSM = om.findStateManager(newValueFieldValue);
                    if (newValueFieldSM != null) {
                        newValueFieldSM.loadField(mmd.getAbsoluteFieldNumber());
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013004", (Object)StringUtils.toJVMIDString(newValueFieldValue), (Object)mmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(newValue), (Object)StringUtils.toJVMIDString(this.pc)));
                        }
                        newValueFieldSM.replaceFieldValue(mmd.getAbsoluteFieldNumber(), null);
                    }
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013005", (Object)StringUtils.toJVMIDString(newValue), (Object)relatedMmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(this.pc)));
                    }
                    newSM.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), this.pc);
                }
            }
        }
    }

    protected void processOneToManyBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ObjectManager om, ArrayList changes) {
        Iterator iter = ((AbstractList)changes).iterator();
        while (iter.hasNext()) {
            RelationChange change = (RelationChange)iter.next();
            if (change.type != 1 && change.type != 2) continue;
        }
    }

    protected void processManyToOneBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ObjectManager om, Object oldValue, Object newValue) {
        AbstractMemberMetaData relatedMmd;
        if (oldValue != null) {
            relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, oldValue);
            StateManager oldSM = om.findStateManager(oldValue);
            if (oldSM != null && relatedMmd != null && oldSM.getLoadedFields()[relatedMmd.getAbsoluteFieldNumber()]) {
                Collection oldColl;
                oldSM.loadField(relatedMmd.getAbsoluteFieldNumber());
                Object oldContainerValue = oldSM.provideField(relatedMmd.getAbsoluteFieldNumber());
                if (oldContainerValue instanceof Collection && (oldColl = (Collection)oldContainerValue).contains(this.pc)) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013006", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getFullFieldName(), (Object)relatedMmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(oldValue)));
                    }
                    if (oldColl instanceof SCOCollection) {
                        ((SCOCollection)((Object)oldColl)).remove(this.pc, false);
                    } else {
                        oldColl.remove(this.pc);
                    }
                }
            }
        }
        if (newValue != null) {
            relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, newValue);
            StateManager newSM = om.findStateManager(newValue);
            if (newSM != null && relatedMmd != null && newSM.getLoadedFields()[relatedMmd.getAbsoluteFieldNumber()]) {
                Collection newColl;
                newSM.loadField(relatedMmd.getAbsoluteFieldNumber());
                Object newContainerValue = newSM.provideField(relatedMmd.getAbsoluteFieldNumber());
                if (newContainerValue instanceof Collection && !(newColl = (Collection)newContainerValue).contains(this.pc)) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013007", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getFullFieldName(), (Object)relatedMmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(newValue)));
                    }
                    newColl.add(this.pc);
                }
            }
        }
    }

    protected void processManyToManyBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ObjectManager om, ArrayList changes) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RelationChange {
        int type;
        Object value;

        public RelationChange(int type, Object val) {
            this.type = type;
            this.value = val;
        }
    }
}

