/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.sco;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerHelper;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.sco.SCO;
import org.datanucleus.sco.SCOContainer;
import org.datanucleus.sco.SCOList;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.scostore.CollectionStore;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.scostore.SetStore;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.JavaUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class SCOUtils {
    private static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = SCOUtils.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;
    static /* synthetic */ Class class$org$datanucleus$StateManager;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Queue;

    public static SCO newSCOInstance(StateManager ownerSM, AbstractMemberMetaData fmd, Class declaredType, Class instantiatedType, Object value, boolean forInsert, boolean forUpdate, boolean replaceField) {
        if (!fmd.getType().isAssignableFrom(declaredType)) {
            throw new NucleusUserException(LOCALISER.msg("023010", (Object)declaredType.getName(), (Object)fmd.getName(), (Object)fmd.getType()));
        }
        String typeName = declaredType.getName();
        if (instantiatedType != null) {
            typeName = instantiatedType.getName();
        }
        if (value != null) {
            typeName = value.getClass().getName();
        }
        TypeManager typeMgr = fmd.getMetaDataManager().getOMFContext().getTypeManager();
        boolean fullWrapper = ownerSM.getStoreManager().getSupportedOptions().contains("BackedSCO");
        Class wrapperType = null;
        wrapperType = fullWrapper ? typeMgr.getWrappedTypeBackedForType(typeName) : typeMgr.getWrapperTypeForType(typeName);
        if (wrapperType == null) {
            if (value != null && typeMgr.isSecondClassWrapper(typeName)) {
                SCO sco = (SCO)value;
                if (replaceField) {
                    ownerSM.replaceField(fmd.getAbsoluteFieldNumber(), sco, false);
                }
                return sco;
            }
            if (instantiatedType != null) {
                wrapperType = fullWrapper ? typeMgr.getWrappedTypeBackedForType(instantiatedType.getName()) : typeMgr.getWrapperTypeForType(instantiatedType.getName());
            }
            if (wrapperType == null) {
                wrapperType = fullWrapper ? typeMgr.getWrappedTypeBackedForType(declaredType.getName()) : typeMgr.getWrapperTypeForType(declaredType.getName());
            }
        }
        if (wrapperType == null) {
            throw new NucleusUserException(LOCALISER.msg("023011", (Object)declaredType.getName(), (Object)StringUtils.toJVMIDString(value), (Object)fmd.getFullFieldName()));
        }
        SCO sco = (SCO)ClassUtils.newInstance(wrapperType, new Class[]{class$org$datanucleus$StateManager == null ? (class$org$datanucleus$StateManager = SCOUtils.class$("org.datanucleus.StateManager")) : class$org$datanucleus$StateManager, class$java$lang$String == null ? (class$java$lang$String = SCOUtils.class$("java.lang.String")) : class$java$lang$String}, new Object[]{ownerSM, fmd.getName()});
        if (replaceField) {
            ownerSM.replaceField(fmd.getAbsoluteFieldNumber(), sco, false);
        }
        if (value != null) {
            sco.initialise(value, forInsert, forUpdate);
        } else {
            sco.initialise();
        }
        return sco;
    }

    public static String getContainerInfoMessage(StateManager ownerSM, String fieldName, SCOContainer cont, boolean useCache, boolean queued, boolean allowNulls, boolean lazyLoading) {
        String msg = LOCALISER.msg("023004", (Object)StringUtils.toJVMIDString(ownerSM.getObject()), (Object)fieldName, (Object)cont.getClass().getName(), (Object)("[cache-values=" + useCache + ", lazy-loading=" + SCOUtils.useCachedLazyLoading(ownerSM, fieldName) + ", queued-operations=" + queued + ", allow-nulls=" + allowNulls + "]"));
        return msg;
    }

    public static String getSCOWrapperOptionsMessage(boolean useCache, boolean queued, boolean allowNulls, boolean lazyLoading) {
        StringBuffer str = new StringBuffer();
        if (useCache) {
            str.append("cached");
        }
        if (lazyLoading) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("lazy-loaded");
        }
        if (queued) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("queued");
        }
        if (allowNulls) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("allowNulls");
        }
        return str.toString();
    }

    public static boolean allowNullsInContainer(boolean defaultValue, AbstractMemberMetaData fmd) {
        boolean allow = defaultValue;
        if (fmd.hasExtension("allow-nulls")) {
            String extValue = fmd.getValueForExtension("allow-nulls");
            if (extValue.equalsIgnoreCase("true")) {
                allow = true;
            } else if (extValue.equalsIgnoreCase("false")) {
                allow = false;
            }
        }
        return allow;
    }

    public static boolean useContainerQueueing(StateManager ownerSM) {
        if (ownerSM.getObjectManager().getTransaction().getOptimistic()) {
            return true;
        }
        return ownerSM.getObjectManager().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.datastoreTransactionDelayOperations");
    }

    public static boolean useContainerCache(StateManager ownerSM, String fieldName) {
        if (ownerSM == null) {
            return false;
        }
        boolean useCache = ownerSM.getObjectManager().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.cache.collections");
        AbstractMemberMetaData fmd = ownerSM.getMetaDataManager().getMetaDataForMember(ownerSM.getObject().getClass(), ownerSM.getObjectManager().getClassLoaderResolver(), fieldName);
        if (fmd.getOrderMetaData() != null && !fmd.getOrderMetaData().isIndexedList()) {
            useCache = true;
        } else if (fmd.getContainer() != null && fmd.getContainer().hasExtension("cache")) {
            useCache = new Boolean(fmd.getContainer().getValueForExtension("cache"));
        }
        return useCache;
    }

    public static boolean useCachedLazyLoading(StateManager ownerSM, String fieldName) {
        if (ownerSM == null) {
            return false;
        }
        boolean lazy = false;
        AbstractClassMetaData cmd = ownerSM.getClassMetaData();
        AbstractMemberMetaData fmd = cmd.getMetaDataForMember(fieldName);
        Boolean lazyCollections = ownerSM.getObjectManager().getOMFContext().getPersistenceConfiguration().getBooleanObjectProperty("datanucleus.cache.collections.lazy");
        if (lazyCollections != null) {
            lazy = lazyCollections;
        } else if (fmd.getContainer() != null && fmd.getContainer().hasExtension("cache-lazy-loading")) {
            lazy = new Boolean(fmd.getContainer().getValueForExtension("cache-lazy-loading"));
        } else {
            boolean inFP = false;
            int[] fpFields = ownerSM.getObjectManager().getFetchPlan().getFetchPlanForClass(cmd).getFieldsInActualFetchPlan();
            int fieldNo = fmd.getAbsoluteFieldNumber();
            if (fpFields != null && fpFields.length > 0) {
                for (int i = 0; i < fpFields.length; ++i) {
                    if (fpFields[i] != fieldNo) continue;
                    inFP = true;
                    break;
                }
            }
            lazy = !inFP;
        }
        return lazy;
    }

    public static boolean collectionHasElementsWithoutIdentity(AbstractMemberMetaData fmd) {
        boolean elementsWithoutIdentity = false;
        if (fmd.isSerialized()) {
            elementsWithoutIdentity = true;
        } else if (fmd.getElementMetaData() != null && fmd.getElementMetaData().getEmbeddedMetaData() != null && fmd.getJoinMetaData() != null) {
            elementsWithoutIdentity = true;
        } else if (fmd.getCollection() != null && fmd.getCollection().isEmbeddedElement()) {
            elementsWithoutIdentity = true;
        }
        return elementsWithoutIdentity;
    }

    public static boolean mapHasKeysWithoutIdentity(AbstractMemberMetaData fmd) {
        boolean keysWithoutIdentity = false;
        if (fmd.isSerialized()) {
            keysWithoutIdentity = true;
        } else if (fmd.getKeyMetaData() != null && fmd.getKeyMetaData().getEmbeddedMetaData() != null && fmd.getJoinMetaData() != null) {
            keysWithoutIdentity = true;
        } else if (fmd.getMap() != null && fmd.getMap().isEmbeddedKey()) {
            keysWithoutIdentity = true;
        }
        return keysWithoutIdentity;
    }

    public static boolean mapHasValuesWithoutIdentity(AbstractMemberMetaData fmd) {
        boolean valuesWithoutIdentity = false;
        if (fmd.isSerialized()) {
            valuesWithoutIdentity = true;
        } else if (fmd.getValueMetaData() != null && fmd.getValueMetaData().getEmbeddedMetaData() != null && fmd.getJoinMetaData() != null) {
            valuesWithoutIdentity = true;
        } else if (fmd.getMap() != null && fmd.getMap().isEmbeddedValue()) {
            valuesWithoutIdentity = true;
        }
        return valuesWithoutIdentity;
    }

    public static boolean collectionHasSerialisedElements(AbstractMemberMetaData fmd) {
        boolean serialised = fmd.isSerialized();
        if (fmd.getCollection() != null && fmd.getCollection().isEmbeddedElement() && fmd.getJoinMetaData() == null) {
            serialised = true;
        }
        return serialised;
    }

    public static boolean arrayIsStoredInSingleColumn(AbstractMemberMetaData fmd) {
        boolean singleColumn = fmd.isSerialized();
        if (!singleColumn && fmd.getArray() != null && fmd.getJoinMetaData() == null) {
            if (fmd.getArray().isEmbeddedElement()) {
                singleColumn = true;
            }
            Class<?> elementClass = fmd.getType().getComponentType();
            ApiAdapter api = fmd.getMetaDataManager().getApiAdapter();
            if (!elementClass.isInterface() && !api.isPersistable(elementClass)) {
                singleColumn = true;
            }
        }
        return singleColumn;
    }

    public static boolean mapHasSerialisedKeysAndValues(AbstractMemberMetaData fmd) {
        boolean inverseKeyField = false;
        if (fmd.getKeyMetaData() != null && fmd.getKeyMetaData().getMappedBy() != null) {
            inverseKeyField = true;
        }
        boolean inverseValueField = false;
        if (fmd.getValueMetaData() != null && fmd.getValueMetaData().getMappedBy() != null) {
            inverseValueField = true;
        }
        boolean serialised = fmd.isSerialized();
        if (fmd.getMap() != null && fmd.getJoinMetaData() == null && fmd.getMap().isEmbeddedKey() && fmd.getMap().isEmbeddedValue() && !inverseKeyField && !inverseValueField) {
            serialised = true;
        }
        return serialised;
    }

    public static void updateCollectionWithCollection(ApiAdapter api, Collection coll, Collection newColl) {
        if (coll == null) {
            return;
        }
        if (newColl == null) {
            coll.clear();
            return;
        }
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (api.isPersistable(element)) {
                Object id = api.getIdForObject(element);
                if (id != null) {
                    boolean present = false;
                    Iterator newIter = newColl.iterator();
                    while (newIter.hasNext()) {
                        Object newElement = newIter.next();
                        Object newId = api.getIdForObject(newElement);
                        if (!id.equals(newId)) continue;
                        present = true;
                        break;
                    }
                    if (present) continue;
                    iter.remove();
                    continue;
                }
                if (newColl.contains(element)) continue;
                iter.remove();
                continue;
            }
            if (newColl.contains(element)) continue;
            iter.remove();
        }
        Iterator newIter = newColl.iterator();
        while (newIter.hasNext()) {
            Object newElement = newIter.next();
            if (api.isPersistable(newElement)) {
                Object newId = api.getIdForObject(newElement);
                if (newId != null) {
                    boolean present = false;
                    iter = coll.iterator();
                    while (iter.hasNext()) {
                        Object element = iter.next();
                        Object id = api.getIdForObject(element);
                        if (!newId.equals(id)) continue;
                        present = true;
                        break;
                    }
                    if (present) continue;
                    coll.add(newElement);
                    continue;
                }
                if (coll.contains(newElement)) continue;
                coll.add(newElement);
                continue;
            }
            if (coll.contains(newElement)) continue;
            coll.add(newElement);
        }
    }

    public static void updateStoreWithCollection(CollectionStore store, StateManager ownerSM, Collection newColl) {
        if (store == null || ownerSM == null) {
            return;
        }
        if (newColl == null) {
            store.clear(ownerSM);
            return;
        }
        HashSet coll = new HashSet();
        ApiAdapter api = ownerSM.getObjectManager().getApiAdapter();
        Iterator iter = store.iterator(ownerSM);
        while (iter.hasNext()) {
            coll.add(iter.next());
        }
        iter = coll.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (api.isPersistable(element)) {
                Object id = api.getIdForObject(element);
                if (id != null) {
                    boolean present = false;
                    Iterator newIter = newColl.iterator();
                    while (newIter.hasNext()) {
                        Object newElement = newIter.next();
                        Object newId = api.getIdForObject(newElement);
                        if (!id.equals(newId)) continue;
                        present = true;
                        break;
                    }
                    if (present) continue;
                    store.remove(ownerSM, element, -1, true);
                    continue;
                }
                if (newColl.contains(element)) continue;
                store.remove(ownerSM, element, -1, true);
                continue;
            }
            if (newColl.contains(element)) continue;
            store.remove(ownerSM, element, -1, true);
        }
        Iterator newIter = newColl.iterator();
        while (newIter.hasNext()) {
            Object newElement = newIter.next();
            if (api.isPersistable(newElement)) {
                Object newId = api.getIdForObject(newElement);
                if (newId != null) {
                    boolean present = false;
                    iter = coll.iterator();
                    while (iter.hasNext()) {
                        Object element = iter.next();
                        Object id = api.getIdForObject(element);
                        if (!newId.equals(id)) continue;
                        present = true;
                        break;
                    }
                    if (present) continue;
                    store.add(ownerSM, newElement, -1);
                    continue;
                }
                if (coll.contains(newElement)) continue;
                store.add(ownerSM, newElement, -1);
                continue;
            }
            if (coll.contains(newElement)) continue;
            store.add(ownerSM, newElement, -1);
        }
    }

    public static boolean updateCollectionWithCollectionElements(Collection coll, Collection elements) {
        boolean updated = false;
        Iterator attachedIter = coll.iterator();
        while (attachedIter.hasNext()) {
            Object attachedElement = attachedIter.next();
            if (elements.contains(attachedElement)) continue;
            attachedIter.remove();
            updated = true;
        }
        Iterator elementsIter = elements.iterator();
        while (elementsIter.hasNext()) {
            Object element = elementsIter.next();
            if (coll.contains(element)) continue;
            coll.add(element);
            updated = true;
        }
        return updated;
    }

    public static boolean updateListWithListElements(List list, List elements) {
        boolean updated = false;
        ArrayList newCopy = new ArrayList(elements);
        Iterator attachedIter = list.iterator();
        while (attachedIter.hasNext()) {
            Object attachedElement = attachedIter.next();
            if (newCopy.remove(attachedElement)) continue;
            attachedIter.remove();
            updated = true;
        }
        ArrayList oldCopy = new ArrayList(list);
        Iterator elementsIter = elements.iterator();
        while (elementsIter.hasNext()) {
            Object element = elementsIter.next();
            if (oldCopy.remove(element)) continue;
            list.add(element);
            updated = true;
        }
        elementsIter = elements.iterator();
        int position = 0;
        while (elementsIter.hasNext()) {
            Object element = elementsIter.next();
            Object currentElement = list.get(position);
            boolean updatePosition = false;
            if (element == null && currentElement != null || element != null && currentElement == null) {
                updatePosition = true;
            } else if (element != null && currentElement != null && !currentElement.equals(element)) {
                updatePosition = true;
            }
            if (updatePosition) {
                ((SCOList)((Object)list)).set(position, element, false);
                updated = true;
            }
            ++position;
        }
        return updated;
    }

    public static boolean updateMapWithMapKeysValues(ApiAdapter api, Map map, Map keysValues) {
        boolean updated = false;
        HashMap copy = new HashMap(map);
        Iterator attachedIter = copy.entrySet().iterator();
        while (attachedIter.hasNext()) {
            Map.Entry entry = attachedIter.next();
            Object key = entry.getKey();
            if (keysValues.containsKey(key)) continue;
            map.remove(key);
            updated = true;
        }
        Iterator keysIter = keysValues.entrySet().iterator();
        while (keysIter.hasNext()) {
            Map.Entry entry = keysIter.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!map.containsKey(key)) {
                map.put(key, keysValues.get(key));
                updated = true;
                continue;
            }
            Object oldValue = map.get(key);
            if (api.isPersistable(value) && api.getIdForObject(value) != api.getIdForObject(oldValue)) {
                map.put(key, value);
                continue;
            }
            if ((oldValue != null || value == null) && (oldValue == null || oldValue.equals(value))) continue;
            map.put(key, value);
        }
        return updated;
    }

    public static void populateMapDelegateWithStoreData(Map delegate, MapStore store, StateManager ownerSM) {
        HashSet keys = new HashSet();
        if (!store.keysAreEmbedded() && !store.keysAreSerialised()) {
            SetStore keystore = store.keySetStore(ownerSM.getObjectManager().getClassLoaderResolver());
            Iterator keyIter = keystore.iterator(ownerSM);
            while (keyIter.hasNext()) {
                keys.add(keyIter.next());
            }
        }
        HashSet values = new HashSet();
        if (!store.valuesAreEmbedded() && !store.valuesAreSerialised()) {
            SetStore valuestore = store.valueSetStore(ownerSM.getObjectManager().getClassLoaderResolver());
            Iterator valueIter = valuestore.iterator(ownerSM);
            while (valueIter.hasNext()) {
                values.add(valueIter.next());
            }
        }
        ApiAdapter api = ownerSM.getObjectManager().getApiAdapter();
        SetStore entries = store.entrySetStore();
        Iterator entryIter = entries.iterator(ownerSM);
        while (entryIter.hasNext()) {
            Map.Entry entry = (Map.Entry)entryIter.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object trueKey = null;
            if (store.keysAreEmbedded() || store.keysAreSerialised()) {
                trueKey = key;
            } else {
                Object pcKeyId = api.getIdForObject(key);
                Iterator keyIter = keys.iterator();
                while (keyIter.hasNext()) {
                    Object obj = keyIter.next();
                    if (!api.getIdForObject(obj).equals(pcKeyId)) continue;
                    trueKey = obj;
                    break;
                }
            }
            Object trueValue = null;
            if (store.valuesAreEmbedded() || store.valuesAreSerialised()) {
                trueValue = value;
            } else {
                Object pcValueId = api.getIdForObject(value);
                Iterator valueIter = values.iterator();
                while (valueIter.hasNext()) {
                    Object obj = valueIter.next();
                    if (!api.getIdForObject(obj).equals(pcValueId)) continue;
                    trueValue = obj;
                }
            }
            delegate.put(trueKey, trueValue);
        }
        keys.clear();
        values.clear();
    }

    public static Object[] toArray(CollectionStore backingStore, StateManager sm) {
        Object[] result = new Object[backingStore.size(sm)];
        Iterator it = backingStore.iterator(sm);
        int i = 0;
        while (it.hasNext()) {
            result[i] = it.next();
            ++i;
        }
        return result;
    }

    public static Object[] toArray(CollectionStore backingStore, StateManager sm, Object[] a) {
        int size = backingStore.size(sm);
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator it = backingStore.iterator(sm);
        for (int i = 0; i < size; ++i) {
            a[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public static Comparator getComparator(AbstractMemberMetaData fmd, ClassLoaderResolver clr) {
        Comparator comparator = null;
        String comparatorName = null;
        if (fmd.hasMap() && fmd.getMap().hasExtension("comparator-name")) {
            comparatorName = fmd.getMap().getValueForExtension("comparator-name");
        } else if (fmd.hasCollection() && fmd.getCollection().hasExtension("comparator-name")) {
            comparatorName = fmd.getCollection().getValueForExtension("comparator-name");
        } else if (fmd.hasMap() && fmd.getMap().hasExtension("comparatorName")) {
            comparatorName = fmd.getMap().getValueForExtension("comparatorName");
        } else if (fmd.hasCollection() && fmd.getCollection().hasExtension("comparatorName")) {
            comparatorName = fmd.getCollection().getValueForExtension("comparatorName");
        }
        if (comparatorName != null) {
            Class comparatorCls = null;
            try {
                comparatorCls = clr.classForName(comparatorName);
                comparator = (Comparator)ClassUtils.newInstance(comparatorCls, null, null);
            }
            catch (NucleusException jpe) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023012", (Object)fmd.getFullFieldName(), (Object)comparatorName));
            }
        }
        return comparator;
    }

    public static void refreshFetchPlanFieldsForCollection(StateManager ownerSM, Object[] elements) {
        ApiAdapter api = ownerSM.getObjectManager().getApiAdapter();
        for (int i = 0; i < elements.length; ++i) {
            if (!api.isPersistable(elements[i])) continue;
            ownerSM.getObjectManager().refreshObject(elements[i]);
        }
    }

    public static void refreshFetchPlanFieldsForMap(StateManager ownerSM, Set entries) {
        ApiAdapter api = ownerSM.getObjectManager().getApiAdapter();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(key)) {
                ownerSM.getObjectManager().refreshObject(key);
            }
            if (!api.isPersistable(val)) continue;
            ownerSM.getObjectManager().refreshObject(val);
        }
    }

    public static void detachForCollection(StateManager ownerSM, Object[] elements, FetchPlanState state) {
        ApiAdapter api = ownerSM.getObjectManager().getApiAdapter();
        for (int i = 0; i < elements.length; ++i) {
            if (!api.isPersistable(elements[i])) continue;
            ownerSM.getObjectManager().detachObject(elements[i], state);
        }
    }

    public static void detachCopyForCollection(StateManager ownerSM, Object[] elements, FetchPlanState state, Collection detached) {
        ApiAdapter api = ownerSM.getObjectManager().getApiAdapter();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null) {
                detached.add(null);
                continue;
            }
            Object object = elements[i];
            if (api.isPersistable(object)) {
                detached.add(ownerSM.getObjectManager().detachObjectCopy(object, state));
                continue;
            }
            detached.add(object);
        }
    }

    public static void attachForCollection(StateManager ownerSM, Object[] elements, boolean elementsWithoutIdentity) {
        ApiAdapter api = ownerSM.getObjectManager().getApiAdapter();
        for (int i = 0; i < elements.length; ++i) {
            if (!api.isPersistable(elements[i])) continue;
            ownerSM.getObjectManager().attachObject(elements[i], elementsWithoutIdentity);
        }
    }

    public static void attachCopyForCollection(StateManager ownerSM, Object[] detachedElements, Collection attached, boolean elementsWithoutIdentity) {
        ApiAdapter api = ownerSM.getObjectManager().getApiAdapter();
        for (int i = 0; i < detachedElements.length; ++i) {
            if (api.isPersistable(detachedElements[i]) && api.isDetachable(detachedElements[i])) {
                attached.add(ownerSM.getObjectManager().attachObjectCopy(detachedElements[i], elementsWithoutIdentity));
                continue;
            }
            attached.add(detachedElements[i]);
        }
    }

    public static void detachForMap(StateManager ownerSM, Set entries, FetchPlanState state) {
        ApiAdapter api = ownerSM.getObjectManager().getApiAdapter();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(key)) {
                ownerSM.getObjectManager().detachObject(key, state);
            }
            if (!api.isPersistable(val)) continue;
            ownerSM.getObjectManager().detachObject(val, state);
        }
    }

    public static void detachCopyForMap(StateManager ownerSM, Set entries, FetchPlanState state, Map detached) {
        ApiAdapter api = ownerSM.getObjectManager().getApiAdapter();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(val)) {
                val = ownerSM.getObjectManager().detachObjectCopy(val, state);
            }
            if (api.isPersistable(key)) {
                key = ownerSM.getObjectManager().detachObjectCopy(key, state);
            }
            detached.put(key, val);
        }
    }

    public static void attachForMap(StateManager ownerSM, Set entries, boolean keysWithoutIdentity, boolean valuesWithoutIdentity) {
        ApiAdapter api = ownerSM.getObjectManager().getApiAdapter();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(key)) {
                ownerSM.getObjectManager().attachObject(key, keysWithoutIdentity);
            }
            if (!api.isPersistable(val)) continue;
            ownerSM.getObjectManager().attachObject(val, valuesWithoutIdentity);
        }
    }

    public static void attachCopyForMap(StateManager ownerSM, Set detachedEntries, Map attached, boolean keysWithoutIdentity, boolean valuesWithoutIdentity) {
        Iterator iter = detachedEntries.iterator();
        ApiAdapter api = ownerSM.getObjectManager().getApiAdapter();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(val) && api.isDetachable(val)) {
                val = ownerSM.getObjectManager().attachObjectCopy(val, valuesWithoutIdentity);
            }
            if (api.isPersistable(key) && api.isDetachable(key)) {
                key = ownerSM.getObjectManager().attachObjectCopy(key, keysWithoutIdentity);
            }
            attached.put(key, val);
        }
    }

    public static boolean validateObjectForWriting(ObjectManager om, Object object, FieldValues fieldValues) {
        boolean persisted = false;
        ApiAdapter api = om.getApiAdapter();
        if (api.isPersistable(object)) {
            ObjectManager objectOM = ObjectManagerHelper.getObjectManager(object);
            if (objectOM != null && om != objectOM) {
                throw new NucleusUserException(LOCALISER.msg("023009", (Object)StringUtils.toJVMIDString(object)), api.getIdForObject(object));
            }
            if (!api.isPersistent(object)) {
                boolean exists = false;
                if (api.isDetached(object)) {
                    if (om.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.attachSameDatastore")) {
                        exists = true;
                    } else {
                        try {
                            StateManager objSM;
                            Object obj = om.findObject(api.getIdForObject(object), true, false, object.getClass().getName());
                            if (obj != null && (objSM = om.findStateManager(obj)) != null) {
                                om.evictFromTransaction(objSM);
                            }
                            exists = true;
                        }
                        catch (NucleusObjectNotFoundException onfe) {
                            exists = false;
                        }
                    }
                }
                if (!exists) {
                    om.persistObjectInternal(object, fieldValues, null, -1, 0);
                    persisted = true;
                }
            } else {
                StateManager objectSM = om.findStateManager(object);
                if (objectSM.isWaitingToBeFlushedToDatastore()) {
                    if (fieldValues != null) {
                        objectSM.loadFieldValues(fieldValues);
                    }
                    objectSM.flush();
                }
            }
        }
        return persisted;
    }

    public static void validateObjectsForWriting(ObjectManager om, Object objects) {
        block3: {
            block4: {
                if (objects == null) break block3;
                if (!objects.getClass().isArray()) break block4;
                if (objects.getClass().getComponentType().isPrimitive()) break block3;
                Object[] obj = (Object[])objects;
                for (int i = 0; i < obj.length; ++i) {
                    SCOUtils.validateObjectForWriting(om, obj[i], null);
                }
                break block3;
            }
            if (objects instanceof Collection) {
                Collection col = (Collection)objects;
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    SCOUtils.validateObjectForWriting(om, it.next(), null);
                }
            }
        }
    }

    public static boolean isListBased(Class type) {
        if (type == null) {
            return false;
        }
        if ((class$java$util$List == null ? (class$java$util$List = SCOUtils.class$("java.util.List")) : class$java$util$List).isAssignableFrom(type)) {
            return true;
        }
        return JavaUtils.isJRE1_5OrAbove() && (class$java$util$Queue == null ? (class$java$util$Queue = SCOUtils.class$("java.util.Queue")) : class$java$util$Queue).isAssignableFrom(type);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

