/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.evaluator.memory;

import java.math.BigDecimal;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.evaluator.memory.InMemoryExpressionEvaluator;
import org.datanucleus.query.evaluator.memory.InvocationEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.util.Localiser;

public class AbsFunctionEvaluator
implements InvocationEvaluator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = AbsFunctionEvaluator.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        String method = expr.getOperation();
        Object param = expr.getArguments().get(0);
        Object paramValue = null;
        if (param instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)param;
            paramValue = eval.getValueForPrimaryExpression(primExpr);
        } else if (param instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)param;
            paramValue = QueryUtils.getValueForParameterExpression(eval.getSymbolTable(), paramExpr);
        } else if (param instanceof Literal) {
            paramValue = ((Literal)param).getLiteral();
        } else {
            throw new NucleusException(method + "(num) where num is instanceof " + param.getClass().getName() + " not supported");
        }
        Number result = null;
        if (paramValue instanceof Double) {
            result = new Double(Math.abs((Double)paramValue));
        } else if (paramValue instanceof Float) {
            result = new Float(Math.abs(((Float)paramValue).floatValue()));
        } else if (paramValue instanceof BigDecimal) {
            result = new BigDecimal(Math.abs(((BigDecimal)paramValue).doubleValue()));
        } else if (paramValue instanceof Integer) {
            result = new Integer(Math.abs((Integer)paramValue));
        } else if (paramValue instanceof Long) {
            result = new Long(Math.abs((Long)paramValue));
        } else {
            throw new NucleusException("Not possible to use Math.abs() on value of type " + paramValue.getClass().getName());
        }
        return result;
    }

    public boolean supportsType(Class cls) {
        return cls == null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

