/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.evaluator;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.CreatorExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;

public class AbstractExpressionEvaluator
implements ExpressionEvaluator {
    public Object evaluate(Expression expr) {
        return this.compileOrExpression(expr);
    }

    protected Object compileOrExpression(Expression expr) {
        if (expr.getOperator() == Expression.OP_OR) {
            return this.processOrExpression(expr);
        }
        return this.compileAndExpression(expr);
    }

    protected Object compileAndExpression(Expression expr) {
        if (expr.getOperator() == Expression.OP_AND) {
            return this.processAndExpression(expr);
        }
        return this.compileEqualityExpression(expr);
    }

    protected Object compileEqualityExpression(Expression expr) {
        if (expr.getOperator() == Expression.OP_EQ) {
            return this.processEqExpression(expr);
        }
        if (expr.getOperator() == Expression.OP_NOTEQ) {
            return this.processNoteqExpression(expr);
        }
        if (expr.getOperator() == Expression.OP_LIKE) {
            return this.processLikeExpression(expr);
        }
        return this.compileRelationalExpression(expr);
    }

    protected Object compileRelationalExpression(Expression expr) {
        if (expr.getOperator() == Expression.OP_GTEQ) {
            return this.processGteqExpression(expr);
        }
        if (expr.getOperator() == Expression.OP_LTEQ) {
            return this.processLteqExpression(expr);
        }
        if (expr.getOperator() == Expression.OP_GT) {
            return this.processGtExpression(expr);
        }
        if (expr.getOperator() == Expression.OP_LT) {
            return this.processLtExpression(expr);
        }
        if (expr.getOperator() == Expression.OP_IS) {
            return this.processIsExpression(expr);
        }
        return this.compileAdditiveExpression(expr);
    }

    protected Object compileAdditiveExpression(Expression expr) {
        if (expr.getOperator() == Expression.OP_ADD) {
            return this.processAddExpression(expr);
        }
        if (expr.getOperator() == Expression.OP_SUB) {
            return this.processSubExpression(expr);
        }
        return this.compileMultiplicativeExpression(expr);
    }

    protected Object compileMultiplicativeExpression(Expression expr) {
        if (expr.getOperator() == Expression.OP_MUL) {
            return this.processMulExpression(expr);
        }
        if (expr.getOperator() == Expression.OP_DIV) {
            return this.processDivExpression(expr);
        }
        if (expr.getOperator() == Expression.OP_MOD) {
            return this.processModExpression(expr);
        }
        return this.compileUnaryExpression(expr);
    }

    protected Object compileUnaryExpression(Expression expr) {
        if (expr.getOperator() == Expression.OP_NEG) {
            return this.processNegExpression(expr);
        }
        return this.compileUnaryExpressionNotPlusMinus(expr);
    }

    protected Object compileUnaryExpressionNotPlusMinus(Expression expr) {
        if (expr.getOperator() == Expression.OP_COM) {
            return this.processComExpression(expr);
        }
        if (expr.getOperator() == Expression.OP_NOT) {
            return this.processNotExpression(expr);
        }
        return this.compilePrimaryExpression(expr);
    }

    protected Object compilePrimaryExpression(Expression expr) {
        if (expr instanceof CreatorExpression) {
            return this.processCreatorExpression((CreatorExpression)expr);
        }
        if (expr instanceof PrimaryExpression) {
            return this.processPrimaryExpression((PrimaryExpression)expr);
        }
        if (expr instanceof ParameterExpression) {
            return this.processParameterExpression((ParameterExpression)expr);
        }
        if (expr instanceof InvokeExpression) {
            return this.processInvokeExpression((InvokeExpression)expr);
        }
        if (expr instanceof Literal) {
            return this.processLiteral((Literal)expr);
        }
        return null;
    }

    protected Object processOrExpression(Expression expr) {
        throw new NucleusException("Operation OR is not supported by this mapper");
    }

    protected Object processAndExpression(Expression expr) {
        throw new NucleusException("Operation AND is not supported by this mapper");
    }

    protected Object processEqExpression(Expression expr) {
        throw new NucleusException("Operation EQ is not supported by this mapper");
    }

    protected Object processNoteqExpression(Expression expr) {
        throw new NucleusException("Operation NOTEQ is not supported by this mapper");
    }

    protected Object processLikeExpression(Expression expr) {
        throw new NucleusException("Operation LIKE is not supported by this mapper");
    }

    protected Object processGtExpression(Expression expr) {
        throw new NucleusException("Operation GT is not supported by this mapper");
    }

    protected Object processLtExpression(Expression expr) {
        throw new NucleusException("Operation LT is not supported by this mapper");
    }

    protected Object processGteqExpression(Expression expr) {
        throw new NucleusException("Operation GTEQ is not supported by this mapper");
    }

    protected Object processLteqExpression(Expression expr) {
        throw new NucleusException("Operation LTEQ is not supported by this mapper");
    }

    protected Object processIsExpression(Expression expr) {
        throw new NucleusException("Operation IS (instanceof) is not supported by this mapper");
    }

    protected Object processAddExpression(Expression expr) {
        throw new NucleusException("Operation ADD is not supported by this mapper");
    }

    protected Object processSubExpression(Expression expr) {
        throw new NucleusException("Operation SUB is not supported by this mapper");
    }

    protected Object processMulExpression(Expression expr) {
        throw new NucleusException("Operation MUL is not supported by this mapper");
    }

    protected Object processDivExpression(Expression expr) {
        throw new NucleusException("Operation DIV is not supported by this mapper");
    }

    protected Object processModExpression(Expression expr) {
        throw new NucleusException("Operation MOD is not supported by this mapper");
    }

    protected Object processNegExpression(Expression expr) {
        throw new NucleusException("Operation NEG is not supported by this mapper");
    }

    protected Object processComExpression(Expression expr) {
        throw new NucleusException("Operation COM is not supported by this mapper");
    }

    protected Object processNotExpression(Expression expr) {
        throw new NucleusException("Operation NOT is not supported by this mapper");
    }

    protected Object processCreatorExpression(CreatorExpression expr) {
        throw new NucleusException("Creator expression is not supported by this mapper");
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        throw new NucleusException("Primary expression is not supported by this mapper");
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        throw new NucleusException("Parameter expression is not supported by this mapper");
    }

    protected Object processInvokeExpression(InvokeExpression expr) {
        throw new NucleusException("Invoke expression is not supported by this mapper");
    }

    protected Object processLiteral(Literal expr) {
        throw new NucleusException("Literals are not supported by this mapper");
    }
}

