/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.IndexedValue;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class DiscriminatorMetaData
extends MetaData {
    protected DiscriminatorStrategy strategy = null;
    protected String columnName = null;
    protected String value = null;
    protected ColumnMetaData columnMetaData = null;
    protected IndexedValue indexed = null;
    protected IndexMetaData indexMetaData;

    public DiscriminatorMetaData(InheritanceMetaData parent, String columnName, String value, String strategy, String indexed) {
        super(parent);
        this.columnName = StringUtils.isWhitespace(columnName) ? null : columnName;
        this.strategy = DiscriminatorStrategy.getDiscriminatorStrategy(strategy);
        if (value != null && strategy == null) {
            this.strategy = DiscriminatorStrategy.VALUE_MAP;
        } else if (strategy == null) {
            this.strategy = DiscriminatorStrategy.CLASS_NAME;
        }
        this.indexed = IndexedValue.getIndexedValue(indexed);
        if (StringUtils.isWhitespace(value)) {
            if (this.strategy == DiscriminatorStrategy.VALUE_MAP) {
                String className = ((AbstractClassMetaData)parent.getParent()).getFullClassName();
                NucleusLogger.METADATA.warn(MetaData.LOCALISER.msg("044103", (Object)className));
                this.value = className;
            } else {
                this.value = null;
            }
        } else {
            this.value = value;
        }
    }

    public DiscriminatorMetaData(InheritanceMetaData parent, DiscriminatorMetaData dmd) {
        super(parent);
        this.columnName = dmd.columnName;
        this.value = dmd.value;
        this.strategy = dmd.strategy;
        this.indexed = dmd.indexed;
        this.columnMetaData = new ColumnMetaData((MetaData)this, dmd.columnMetaData);
        if (dmd.indexMetaData != null) {
            this.indexMetaData = new IndexMetaData(dmd.indexMetaData);
        }
    }

    public void initialise() {
        if (this.indexMetaData == null && this.columnMetaData != null && this.indexed != null && this.indexed != IndexedValue.FALSE) {
            this.indexMetaData = new IndexMetaData(null, null, this.indexed == IndexedValue.UNIQUE ? "true" : "false");
            this.indexMetaData.addColumn(this.columnMetaData);
        }
        if (this.indexMetaData != null) {
            this.indexMetaData.initialise();
        }
        if (this.columnMetaData == null && this.columnName != null) {
            this.columnMetaData = new ColumnMetaData((MetaData)this, this.columnName);
            this.columnMetaData.initialise();
        }
        this.setInitialised();
    }

    public ColumnMetaData getColumnMetaData() {
        return this.columnMetaData;
    }

    public void setColumnMetaData(ColumnMetaData columnMetaData) {
        this.columnMetaData = columnMetaData;
        this.columnMetaData.parent = this;
    }

    public final IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public final void setIndexMetaData(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
    }

    public String getValue() {
        return this.value;
    }

    public String getColumnName() {
        if (this.columnMetaData != null && this.columnMetaData.getName() != null) {
            return this.columnMetaData.getName();
        }
        return this.columnName;
    }

    public final DiscriminatorStrategy getStrategy() {
        return this.strategy;
    }

    public final IndexedValue getIndexedValue() {
        return this.indexed;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<discriminator");
        if (this.strategy != null) {
            sb.append(" strategy=\"" + this.strategy.toString() + "\"");
        }
        if (this.columnName != null && this.columnMetaData == null) {
            sb.append(" column=\"" + this.columnName + "\"");
        }
        if (this.value != null) {
            sb.append(" value=\"" + this.value + "\"");
        }
        if (this.indexed != null) {
            sb.append(" indexed=\"" + this.indexed.toString() + "\"");
        }
        sb.append(">\n");
        if (this.columnMetaData != null) {
            sb.append(this.columnMetaData.toString(prefix + indent, indent));
        }
        if (this.indexMetaData != null) {
            sb.append(this.indexMetaData.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</discriminator>\n");
        return sb.toString();
    }
}

