/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jdo;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Collection;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalDataStoreException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.transaction.xa.XAException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.ClassNotPersistableException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUnsupportedOptionException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.jdo.AbstractPersistenceManagerFactory;
import org.datanucleus.jdo.JDOPersistenceManager;
import org.datanucleus.jdo.exceptions.ClassNotPersistenceCapableException;
import org.datanucleus.jdo.exceptions.NoPersistenceInformationException;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.exceptions.DatastoreReadOnlyException;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryResultsMetaData;
import org.datanucleus.transaction.HeuristicRollbackException;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class NucleusJDOHelper
extends JDOHelper {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = NucleusJDOHelper.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;
    static /* synthetic */ Class class$org$datanucleus$store$query$AbstractJavaQuery;
    static /* synthetic */ Class class$java$lang$String;

    public static ClassMetaData getMetaDataForClass(PersistenceManagerFactory pmf, Class cls) {
        if (pmf == null || cls == null) {
            return null;
        }
        if (!(pmf instanceof AbstractPersistenceManagerFactory)) {
            return null;
        }
        AbstractPersistenceManagerFactory jpoxPMF = (AbstractPersistenceManagerFactory)pmf;
        MetaDataManager mdmgr = jpoxPMF.getOMFContext().getMetaDataManager();
        return (ClassMetaData)mdmgr.getMetaDataForClass(cls, jpoxPMF.getOMFContext().getClassLoaderResolver(null));
    }

    public static String[] getClassesWithMetaData(PersistenceManagerFactory pmf) {
        if (pmf == null || !(pmf instanceof AbstractPersistenceManagerFactory)) {
            return null;
        }
        AbstractPersistenceManagerFactory jpoxPMF = (AbstractPersistenceManagerFactory)pmf;
        Collection classes = jpoxPMF.getOMFContext().getMetaDataManager().getClassesWithMetaData();
        return classes.toArray(new String[classes.size()]);
    }

    public static QueryResultsMetaData getMetaDataForQueryResults(Query query) {
        if ((class$org$datanucleus$store$query$AbstractJavaQuery == null ? (class$org$datanucleus$store$query$AbstractJavaQuery = NucleusJDOHelper.class$("org.datanucleus.store.query.AbstractJavaQuery")) : class$org$datanucleus$store$query$AbstractJavaQuery).isAssignableFrom(query.getClass())) {
            return ((AbstractJavaQuery)query).getResultSetMetaData();
        }
        throw new NucleusUserException("MetaData only available for query results for JDOQL/JPQL");
    }

    public static String getObjectStateAsString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (JDOHelper.isDetached((Object)obj) && JDOHelper.isDirty((Object)obj)) {
            return "detached-dirty";
        }
        if (JDOHelper.isDetached((Object)obj) && !JDOHelper.isDirty((Object)obj)) {
            return "detached-clean";
        }
        if (JDOHelper.isPersistent((Object)obj) && JDOHelper.isDirty((Object)obj) && !JDOHelper.isNew((Object)obj) && JDOHelper.isTransactional((Object)obj) && !JDOHelper.isDeleted((Object)obj)) {
            return "persistent-dirty";
        }
        if (JDOHelper.isPersistent((Object)obj) && !JDOHelper.isNew((Object)obj) && !JDOHelper.isDirty((Object)obj) && JDOHelper.isTransactional((Object)obj) && !JDOHelper.isDeleted((Object)obj)) {
            return "persistent-clean";
        }
        if (JDOHelper.isPersistent((Object)obj) && JDOHelper.isNew((Object)obj) && JDOHelper.isDirty((Object)obj) && JDOHelper.isTransactional((Object)obj) && !JDOHelper.isDeleted((Object)obj)) {
            return "persistent-new";
        }
        if (JDOHelper.isPersistent((Object)obj) && JDOHelper.isNew((Object)obj) && JDOHelper.isDirty((Object)obj) && JDOHelper.isTransactional((Object)obj) && JDOHelper.isDeleted((Object)obj)) {
            return "persistent-new-deleted";
        }
        if (JDOHelper.isPersistent((Object)obj) && !JDOHelper.isNew((Object)obj) && JDOHelper.isDirty((Object)obj) && JDOHelper.isTransactional((Object)obj) && JDOHelper.isDeleted((Object)obj)) {
            return "persistent-deleted";
        }
        if (!(!JDOHelper.isPersistent((Object)obj) || JDOHelper.isNew((Object)obj) || JDOHelper.isDirty((Object)obj) || JDOHelper.isDeleted((Object)obj) || JDOHelper.isTransactional((Object)obj))) {
            return "hollow / persistent-nontransactional";
        }
        if (JDOHelper.isPersistent((Object)obj) && !JDOHelper.isNew((Object)obj) && JDOHelper.isDirty((Object)obj) && !JDOHelper.isDeleted((Object)obj) && !JDOHelper.isTransactional((Object)obj)) {
            return "persistent-nontransactional-dirty";
        }
        if (!JDOHelper.isPersistent((Object)obj) && !JDOHelper.isNew((Object)obj) && JDOHelper.isDirty((Object)obj) && JDOHelper.isTransactional((Object)obj) && !JDOHelper.isDeleted((Object)obj)) {
            return "transient-dirty";
        }
        if (!(JDOHelper.isPersistent((Object)obj) || JDOHelper.isNew((Object)obj) || JDOHelper.isDirty((Object)obj) || !JDOHelper.isTransactional((Object)obj) || JDOHelper.isDeleted((Object)obj))) {
            return "transient-clean";
        }
        if (!(JDOHelper.isPersistent((Object)obj) || JDOHelper.isNew((Object)obj) || JDOHelper.isDirty((Object)obj) || JDOHelper.isTransactional((Object)obj) || JDOHelper.isDeleted((Object)obj))) {
            return "transient-clean";
        }
        return "transient";
    }

    public static String[] getDetachedObjectDirtyFields(Object obj, PersistenceManager pm) {
        if (obj == null) {
            return null;
        }
        if (!JDOHelper.isDetached((Object)obj)) {
            throw new NucleusUserException(LOCALISER.msg("010008"));
        }
        PersistenceCapable pc = (PersistenceCapable)obj;
        ObjectManager thePM = ((JDOPersistenceManager)pm).getObjectManager();
        StateManager sm = StateManagerFactory.newStateManagerForDetached(thePM, pc, JDOHelper.getObjectId((Object)pc), null);
        pc.jdoReplaceStateManager((javax.jdo.spi.StateManager)sm);
        sm.retrieveDetachState(sm);
        String[] dirtyFieldNames = sm.getDirtyFieldNames();
        pc.jdoReplaceStateManager(null);
        return dirtyFieldNames;
    }

    public static String[] getDetachedObjectLoadedFields(Object obj, PersistenceManager pm) {
        if (obj == null) {
            return null;
        }
        if (!JDOHelper.isDetached((Object)obj)) {
            throw new NucleusUserException(LOCALISER.msg("010008"));
        }
        PersistenceCapable pc = (PersistenceCapable)obj;
        ObjectManager thePM = ((JDOPersistenceManager)pm).getObjectManager();
        StateManager sm = StateManagerFactory.newStateManagerForDetached(thePM, pc, JDOHelper.getObjectId((Object)pc), null);
        pc.jdoReplaceStateManager((javax.jdo.spi.StateManager)sm);
        sm.retrieveDetachState(sm);
        String[] loadedFieldNames = sm.getLoadedFieldNames();
        pc.jdoReplaceStateManager(null);
        return loadedFieldNames;
    }

    public static JDOException getJDOExceptionForNucleusException(NucleusException jpe) {
        if (jpe instanceof ClassNotPersistableException) {
            return new ClassNotPersistenceCapableException(jpe.getMessage(), jpe);
        }
        if (jpe instanceof org.datanucleus.exceptions.NoPersistenceInformationException) {
            return new NoPersistenceInformationException(jpe.getMessage(), jpe);
        }
        if (jpe instanceof NucleusUnsupportedOptionException) {
            return new JDOUnsupportedOptionException(jpe.getMessage(), (Throwable)jpe);
        }
        if (jpe instanceof DatastoreReadOnlyException) {
            ClassLoaderResolver clr = ((DatastoreReadOnlyException)jpe).getClassLoaderResolver();
            try {
                Class cls = clr.classForName("javax.jdo.JDOReadOnlyException");
                throw (JDOUserException)ClassUtils.newInstance(cls, new Class[]{class$java$lang$String == null ? (class$java$lang$String = NucleusJDOHelper.class$("java.lang.String")) : class$java$lang$String}, new Object[]{jpe.getMessage()});
            }
            catch (NucleusException ne) {
                throw new JDOUserException(jpe.getMessage());
            }
        }
        if (jpe instanceof NucleusDataStoreException) {
            if (jpe.isFatal()) {
                if (jpe.getFailedObject() != null) {
                    return new JDOFatalDataStoreException(jpe.getMessage(), jpe.getFailedObject());
                }
                if (jpe.getNestedExceptions() != null) {
                    return new JDOFatalDataStoreException(jpe.getMessage(), jpe.getNestedExceptions());
                }
                return new JDOFatalDataStoreException(jpe.getMessage(), (Throwable)jpe);
            }
            if (jpe.getNestedExceptions() != null) {
                if (jpe.getFailedObject() != null) {
                    return new JDODataStoreException(jpe.getMessage(), jpe.getNestedExceptions(), jpe.getFailedObject());
                }
                return new JDODataStoreException(jpe.getMessage(), jpe.getNestedExceptions());
            }
            if (jpe.getFailedObject() != null) {
                NucleusLogger.JDO.info("Exception thrown", jpe);
                return new JDODataStoreException(jpe.getMessage(), jpe.getFailedObject());
            }
            NucleusLogger.JDO.info("Exception thrown", jpe);
            return new JDODataStoreException(jpe.getMessage(), (Throwable)jpe);
        }
        if (jpe instanceof NucleusObjectNotFoundException) {
            if (jpe.getFailedObject() != null) {
                return new JDOObjectNotFoundException(jpe.getMessage(), jpe.getFailedObject());
            }
            if (jpe.getNestedExceptions() != null) {
                return new JDOObjectNotFoundException(jpe.getMessage(), jpe.getNestedExceptions());
            }
            return new JDOObjectNotFoundException(jpe.getMessage(), new Throwable[]{jpe});
        }
        if (jpe instanceof NucleusUserException) {
            if (jpe.isFatal()) {
                if (jpe.getNestedExceptions() != null) {
                    if (jpe.getFailedObject() != null) {
                        return new JDOFatalUserException(jpe.getMessage(), jpe.getNestedExceptions(), jpe.getFailedObject());
                    }
                    return new JDOFatalUserException(jpe.getMessage(), jpe.getNestedExceptions());
                }
                if (jpe.getFailedObject() != null) {
                    NucleusLogger.JDO.info("Exception thrown", jpe);
                    return new JDOFatalUserException(jpe.getMessage(), jpe.getFailedObject());
                }
                NucleusLogger.JDO.info("Exception thrown", jpe);
                return new JDOFatalUserException(jpe.getMessage(), (Throwable)jpe);
            }
            if (jpe.getNestedExceptions() != null) {
                if (jpe.getFailedObject() != null) {
                    return new JDOUserException(jpe.getMessage(), jpe.getNestedExceptions(), jpe.getFailedObject());
                }
                return new JDOUserException(jpe.getMessage(), jpe.getNestedExceptions());
            }
            if (jpe.getFailedObject() != null) {
                NucleusLogger.JDO.info("Exception thrown", jpe);
                return new JDOUserException(jpe.getMessage(), jpe.getFailedObject());
            }
            NucleusLogger.JDO.info("Exception thrown", jpe);
            return new JDOUserException(jpe.getMessage(), (Throwable)jpe);
        }
        if (jpe instanceof NucleusOptimisticException) {
            if (jpe.getFailedObject() != null) {
                return new JDOOptimisticVerificationException(jpe.getMessage(), jpe.getFailedObject());
            }
            if (jpe.getNestedExceptions() != null) {
                return new JDOOptimisticVerificationException(jpe.getMessage(), jpe.getNestedExceptions());
            }
            return new JDOOptimisticVerificationException(jpe.getMessage(), (Object)jpe);
        }
        if (jpe instanceof HeuristicRollbackException && jpe.getNestedExceptions().length == 1 && jpe.getNestedExceptions()[0].getCause() instanceof SQLException) {
            return new JDODataStoreException(jpe.getMessage(), ((XAException)jpe.getNestedExceptions()[0]).getCause());
        }
        if (jpe.isFatal()) {
            if (jpe.getNestedExceptions() != null) {
                return new JDOFatalInternalException(jpe.getMessage(), jpe.getNestedExceptions());
            }
            return new JDOFatalInternalException(jpe.getMessage(), (Throwable)jpe);
        }
        if (jpe.getNestedExceptions() != null) {
            return new JDOException(jpe.getMessage(), jpe.getNestedExceptions());
        }
        return new JDOException(jpe.getMessage(), (Throwable)jpe);
    }

    public static JDOImplHelper getJDOImplHelper() {
        return (JDOImplHelper)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return JDOImplHelper.getInstance();
                }
                catch (SecurityException e) {
                    throw new JDOFatalUserException(LOCALISER.msg("026000"), (Throwable)e);
                }
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

