/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EventListenerMetaData;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class MetaDataMerger {
    protected static Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = MetaDataMerger.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public static void mergeFileORMData(FileMetaData primaryFmd, FileMetaData ormFmd) {
        if (ormFmd == null || primaryFmd == null) {
            return;
        }
        if (primaryFmd.isInitialised() || primaryFmd.isPopulated()) {
            throw new NucleusException(LOCALISER.msg("MetaData.File.AlreadyPopulatedError", (Object)primaryFmd.getFilename())).setFatal();
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044056", (Object)primaryFmd.getFilename()));
        }
        if (ormFmd.getCatalog() != null) {
            primaryFmd.setCatalog(ormFmd.getCatalog());
        }
        if (ormFmd.getSchema() != null) {
            primaryFmd.setSchema(ormFmd.getSchema());
        }
    }

    public static void mergeClassORMData(AbstractClassMetaData primaryCmd, AbstractClassMetaData ormCmd) {
        Iterator iter;
        if (ormCmd == null || primaryCmd == null) {
            return;
        }
        if (primaryCmd.isInitialised() || primaryCmd.isPopulated()) {
            throw new NucleusException(LOCALISER.msg("044068", (Object)primaryCmd.name)).setFatal();
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044096", (Object)primaryCmd.getFullClassName()));
        }
        if (ormCmd.getCatalog() != null) {
            primaryCmd.catalog = ormCmd.getCatalog();
        }
        if (ormCmd.getSchema() != null) {
            primaryCmd.schema = ormCmd.getSchema();
        }
        if (ormCmd.getTable() != null) {
            primaryCmd.table = ormCmd.getTable();
        }
        if (ormCmd.detachable) {
            primaryCmd.detachable = true;
        }
        if (!ormCmd.requiresExtent) {
            primaryCmd.requiresExtent = false;
        }
        if (ormCmd.embeddedOnly) {
            primaryCmd.embeddedOnly = true;
        }
        if (ormCmd.getPrimaryKeyMetaData() != null) {
            primaryCmd.setPrimaryKeyMetaData(ormCmd.getPrimaryKeyMetaData());
        }
        if (ormCmd.getInheritanceMetaData() != null) {
            primaryCmd.setInheritanceMetaData(ormCmd.getInheritanceMetaData());
        }
        if (ormCmd.getIdentityMetaData() != null) {
            primaryCmd.setIdentityMetaData(ormCmd.getIdentityMetaData());
        }
        if (ormCmd.getVersionMetaData() != null) {
            primaryCmd.setVersionMetaData(ormCmd.getVersionMetaData());
        }
        if (ormCmd.listeners != null) {
            if (primaryCmd.listeners == null) {
                primaryCmd.listeners = new ArrayList();
            }
            primaryCmd.listeners.addAll(ormCmd.listeners);
        }
        if (ormCmd.queries != null) {
            if (primaryCmd.queries == null) {
                primaryCmd.queries = new ArrayList();
            } else {
                primaryCmd.queries.clear();
            }
            primaryCmd.queries.addAll(ormCmd.queries);
        }
        if (ormCmd.joins.size() > 0) {
            primaryCmd.joins.clear();
            iter = ormCmd.joins.iterator();
            while (iter.hasNext()) {
                primaryCmd.addJoin((JoinMetaData)iter.next());
            }
        }
        if (ormCmd.indexes.size() > 0) {
            primaryCmd.indexes.clear();
            iter = ormCmd.indexes.iterator();
            while (iter.hasNext()) {
                primaryCmd.addIndex((IndexMetaData)iter.next());
            }
        }
        if (ormCmd.foreignKeys.size() > 0) {
            primaryCmd.foreignKeys.clear();
            iter = ormCmd.foreignKeys.iterator();
            while (iter.hasNext()) {
                primaryCmd.addForeignKey((ForeignKeyMetaData)iter.next());
            }
        }
        if (ormCmd.uniqueConstraints.size() > 0) {
            primaryCmd.uniqueConstraints.clear();
            iter = ormCmd.uniqueConstraints.iterator();
            while (iter.hasNext()) {
                primaryCmd.addUniqueConstraint((UniqueMetaData)iter.next());
            }
        }
        if (ormCmd.fetchGroups.size() > 0) {
            primaryCmd.fetchGroups.clear();
            iter = ormCmd.fetchGroups.iterator();
            while (iter.hasNext()) {
                primaryCmd.addFetchGroup((FetchGroupMetaData)iter.next());
            }
        }
        for (int i = 0; i < ormCmd.getNoOfMembers(); ++i) {
            AbstractMemberMetaData ormFmd = ormCmd.getMetaDataForMemberAtRelativePosition(i);
            AbstractMemberMetaData primaryFmd = primaryCmd.getMetaDataForMember(ormFmd.getName());
            if (primaryFmd == null) {
                AbstractMemberMetaData fmd = null;
                if (ormFmd.className != null) {
                    AbstractMemberMetaData jdoFmd = primaryCmd.getMetaDataManager().readMetaDataForMember(ormFmd.className, ormFmd.name);
                    if (jdoFmd == null) {
                        jdoFmd = primaryCmd.getMetaDataManager().readMetaDataForMember(ormCmd.getPackageName() + "." + ormFmd.className, ormFmd.name);
                    }
                    if (jdoFmd != null) {
                        fmd = jdoFmd instanceof FieldMetaData ? primaryCmd.getMetaDataManager().getMetaDataFactory().newFieldObject(primaryCmd, jdoFmd) : primaryCmd.getMetaDataManager().getMetaDataFactory().newPropertyObject(primaryCmd, (PropertyMetaData)jdoFmd);
                        fmd.className = ormFmd.className;
                        MetaDataMerger.mergeFieldORMData(fmd, ormFmd);
                    } else {
                        fmd = ormFmd instanceof FieldMetaData ? primaryCmd.getMetaDataManager().getMetaDataFactory().newFieldObject(primaryCmd, ormFmd) : primaryCmd.getMetaDataManager().getMetaDataFactory().newPropertyObject(primaryCmd, (PropertyMetaData)ormFmd);
                        fmd.className = ormFmd.className;
                    }
                } else {
                    fmd = ormFmd instanceof FieldMetaData ? primaryCmd.getMetaDataManager().getMetaDataFactory().newFieldObject(primaryCmd, ormFmd) : primaryCmd.getMetaDataManager().getMetaDataFactory().newPropertyObject(primaryCmd, (PropertyMetaData)ormFmd);
                }
                primaryCmd.addMember(fmd);
                continue;
            }
            MetaDataMerger.mergeFieldORMData(primaryFmd, ormFmd);
        }
        ExtensionMetaData[] ormExtensions = ormCmd.getExtensions();
        if (ormExtensions != null) {
            for (int i = 0; i < ormExtensions.length; ++i) {
                primaryCmd.addExtension(ormExtensions[i].vendorName, ormExtensions[i].key, ormExtensions[i].value);
            }
        }
    }

    public static void mergeFieldORMData(AbstractMemberMetaData primaryFmd, AbstractMemberMetaData ormFmd) {
        ExtensionMetaData[] ormExtensions;
        ColumnMetaData[] ormColumns;
        if (ormFmd == null || primaryFmd == null) {
            return;
        }
        if (primaryFmd.isInitialised() || primaryFmd.isPopulated()) {
            throw new NucleusException(LOCALISER.msg("044107", (Object)primaryFmd.name, (Object)ormFmd.getAbstractClassMetaData().getFullClassName())).setFatal();
        }
        if (ormFmd.className != null) {
            primaryFmd.className = ormFmd.className;
        }
        if (ormFmd.container != null) {
            primaryFmd.container = ormFmd.container;
            primaryFmd.container.parent = primaryFmd;
        }
        if (ormFmd.defaultFetchGroup != null) {
            primaryFmd.defaultFetchGroup = ormFmd.defaultFetchGroup;
        }
        if (primaryFmd.primaryKey == Boolean.FALSE && ormFmd.primaryKey == Boolean.TRUE) {
            primaryFmd.primaryKey = ClassUtils.booleanValueOf(ormFmd.isPrimaryKey());
        }
        if (ormFmd.getTable() != null) {
            primaryFmd.table = ormFmd.getTable();
        }
        if (ormFmd.getCatalog() != null) {
            primaryFmd.catalog = ormFmd.getCatalog();
        }
        if (ormFmd.getSchema() != null) {
            primaryFmd.schema = ormFmd.getSchema();
        }
        if (ormFmd.getColumn() != null) {
            primaryFmd.column = ormFmd.getColumn();
        }
        if (ormFmd.dependent != null) {
            primaryFmd.dependent = ormFmd.dependent;
        }
        if (ormFmd.getMappedBy() != null) {
            primaryFmd.mappedBy = ormFmd.getMappedBy();
        }
        if (ormFmd.getValueStrategy() != null) {
            primaryFmd.valueStrategy = ormFmd.getValueStrategy();
        }
        if (ormFmd.getSequence() != null) {
            primaryFmd.sequence = ormFmd.getSequence();
        }
        if (ormFmd.indexed != null) {
            primaryFmd.indexed = ormFmd.indexed;
        }
        if (ormFmd.nullValue != NullValue.NONE) {
            primaryFmd.nullValue = ormFmd.nullValue;
        }
        if (ormFmd.getJoinMetaData() != null) {
            primaryFmd.setJoinMetaData(ormFmd.joinMetaData);
        }
        if (ormFmd.getEmbeddedMetaData() != null) {
            primaryFmd.setEmbeddedMetaData(ormFmd.embeddedMetaData);
        }
        if (ormFmd.getElementMetaData() != null) {
            primaryFmd.setElementMetaData(ormFmd.elementMetaData);
        }
        if (ormFmd.getKeyMetaData() != null) {
            primaryFmd.setKeyMetaData(ormFmd.keyMetaData);
        }
        if (ormFmd.getValueMetaData() != null) {
            primaryFmd.setValueMetaData(ormFmd.valueMetaData);
        }
        if (ormFmd.getOrderMetaData() != null) {
            primaryFmd.setOrderMetaData(ormFmd.orderMetaData);
        }
        if (ormFmd.getForeignKeyMetaData() != null) {
            primaryFmd.foreignKeyMetaData = ormFmd.getForeignKeyMetaData();
            if (primaryFmd.foreignKeyMetaData != null) {
                primaryFmd.foreignKeyMetaData.parent = primaryFmd;
            }
        }
        if (ormFmd.getIndexMetaData() != null) {
            primaryFmd.indexMetaData = ormFmd.getIndexMetaData();
            if (primaryFmd.indexMetaData != null) {
                primaryFmd.indexMetaData.parent = primaryFmd;
            }
        }
        if (ormFmd.getUniqueMetaData() != null) {
            primaryFmd.uniqueMetaData = ormFmd.getUniqueMetaData();
            if (primaryFmd.uniqueMetaData != null) {
                primaryFmd.uniqueMetaData.parent = primaryFmd;
            }
        }
        if ((ormColumns = ormFmd.getColumnMetaData()) != null) {
            primaryFmd.columns.clear();
            for (int i = 0; i < ormColumns.length; ++i) {
                primaryFmd.columns.add(ormColumns[i]);
            }
        }
        if ((ormExtensions = ormFmd.getExtensions()) != null) {
            for (int i = 0; i < ormExtensions.length; ++i) {
                primaryFmd.addExtension(ormExtensions[i].vendorName, ormExtensions[i].key, ormExtensions[i].value);
            }
        }
    }

    public static void mergeClassAnnotationsData(AbstractClassMetaData primaryCmd, AbstractClassMetaData annotCmd) {
        Iterator iter;
        if (annotCmd == null || primaryCmd == null) {
            return;
        }
        if (primaryCmd.isInitialised() || primaryCmd.isPopulated()) {
            throw new NucleusException(LOCALISER.msg("044068", (Object)primaryCmd.name)).setFatal();
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044095", (Object)primaryCmd.getFullClassName()));
        }
        if (primaryCmd.entityName == null && annotCmd.entityName != null) {
            primaryCmd.entityName = annotCmd.entityName;
        }
        if (annotCmd.detachable) {
            primaryCmd.detachable = true;
        }
        if (!annotCmd.requiresExtent) {
            primaryCmd.requiresExtent = false;
        }
        if (annotCmd.embeddedOnly) {
            primaryCmd.embeddedOnly = true;
        }
        if (primaryCmd.identityType == null && annotCmd.identityType != null) {
            primaryCmd.identityType = annotCmd.identityType;
        }
        if (primaryCmd.objectidClass == null && annotCmd.objectidClass != null) {
            primaryCmd.objectidClass = annotCmd.objectidClass;
        }
        if (primaryCmd.catalog == null && annotCmd.catalog != null) {
            primaryCmd.catalog = annotCmd.catalog;
        }
        if (primaryCmd.schema == null && annotCmd.schema != null) {
            primaryCmd.schema = annotCmd.schema;
        }
        if (primaryCmd.table == null && annotCmd.table != null) {
            primaryCmd.table = annotCmd.table;
        }
        if (primaryCmd.versionMetaData == null && annotCmd.versionMetaData != null) {
            primaryCmd.setVersionMetaData(annotCmd.versionMetaData);
        }
        if (primaryCmd.identityMetaData == null && annotCmd.identityMetaData != null) {
            primaryCmd.setIdentityMetaData(annotCmd.identityMetaData);
        }
        if (primaryCmd.inheritanceMetaData == null && annotCmd.inheritanceMetaData != null) {
            primaryCmd.setInheritanceMetaData(annotCmd.inheritanceMetaData);
        }
        if (primaryCmd.primaryKeyMetaData == null && annotCmd.primaryKeyMetaData != null) {
            primaryCmd.setPrimaryKeyMetaData(annotCmd.primaryKeyMetaData);
        }
        if (primaryCmd.listeners == null && annotCmd.listeners != null) {
            iter = annotCmd.listeners.iterator();
            while (iter.hasNext()) {
                primaryCmd.addListener((EventListenerMetaData)iter.next());
            }
        } else if (primaryCmd.listeners != null && annotCmd.listeners != null) {
            if (primaryCmd.getListenerForClass(primaryCmd.getFullClassName()) == null) {
                if (annotCmd.getListenerForClass(primaryCmd.getFullClassName()) != null) {
                    primaryCmd.addListener(annotCmd.getListenerForClass(primaryCmd.getFullClassName()));
                }
            } else if (primaryCmd.getListenerForClass(primaryCmd.getFullClassName()) != null && primaryCmd.getListeners().size() == 1) {
                List annotListeners = annotCmd.getListeners();
                Iterator annotIter = annotListeners.iterator();
                while (annotIter.hasNext()) {
                    EventListenerMetaData elmd = (EventListenerMetaData)annotIter.next();
                    if (elmd.getClassName().equals(primaryCmd.getFullClassName())) continue;
                    primaryCmd.addListener(elmd);
                }
            }
        }
        if (annotCmd.excludeDefaultListeners != null && primaryCmd.excludeDefaultListeners == null) {
            primaryCmd.excludeDefaultListeners = annotCmd.excludeDefaultListeners;
        }
        if (annotCmd.excludeSuperClassListeners != null && primaryCmd.excludeSuperClassListeners == null) {
            primaryCmd.excludeSuperClassListeners = annotCmd.excludeSuperClassListeners;
        }
        if (primaryCmd.queries == null && annotCmd.queries != null) {
            iter = annotCmd.queries.iterator();
            while (iter.hasNext()) {
                primaryCmd.addQuery((QueryMetaData)iter.next());
            }
        }
        if (primaryCmd.joins.size() == 0 && annotCmd.joins.size() > 0) {
            iter = annotCmd.joins.iterator();
            while (iter.hasNext()) {
                primaryCmd.addJoin((JoinMetaData)iter.next());
            }
        }
        if (primaryCmd.indexes.size() == 0 && annotCmd.indexes.size() > 0) {
            iter = annotCmd.indexes.iterator();
            while (iter.hasNext()) {
                primaryCmd.addIndex((IndexMetaData)iter.next());
            }
        }
        if (primaryCmd.foreignKeys.size() == 0 && annotCmd.foreignKeys.size() > 0) {
            iter = annotCmd.foreignKeys.iterator();
            while (iter.hasNext()) {
                primaryCmd.addForeignKey((ForeignKeyMetaData)iter.next());
            }
        }
        if (primaryCmd.uniqueConstraints.size() == 0 && annotCmd.uniqueConstraints.size() > 0) {
            iter = annotCmd.uniqueConstraints.iterator();
            while (iter.hasNext()) {
                primaryCmd.addUniqueConstraint((UniqueMetaData)iter.next());
            }
        }
        if (primaryCmd.fetchGroups.size() == 0 && annotCmd.fetchGroups.size() > 0) {
            iter = annotCmd.fetchGroups.iterator();
            while (iter.hasNext()) {
                primaryCmd.addFetchGroup((FetchGroupMetaData)iter.next());
            }
        }
        for (int i = 0; i < annotCmd.getNoOfMembers(); ++i) {
            AbstractMemberMetaData annotFmd = annotCmd.getMetaDataForMemberAtRelativePosition(i);
            AbstractMemberMetaData primaryFmd = primaryCmd.getMetaDataForMember(annotFmd.getName());
            if (primaryFmd == null) {
                AbstractMemberMetaData fmd = null;
                if (annotFmd.className != null) {
                    AbstractMemberMetaData baseFmd = primaryCmd.getMetaDataManager().readMetaDataForMember(annotFmd.className, annotFmd.name);
                    if (baseFmd == null) {
                        baseFmd = primaryCmd.getMetaDataManager().readMetaDataForMember(annotCmd.getPackageName() + "." + annotFmd.className, annotFmd.name);
                    }
                    if (baseFmd != null) {
                        fmd = baseFmd instanceof FieldMetaData ? primaryCmd.getMetaDataManager().getMetaDataFactory().newFieldObject(primaryCmd, baseFmd) : primaryCmd.getMetaDataManager().getMetaDataFactory().newPropertyObject(primaryCmd, (PropertyMetaData)baseFmd);
                        fmd.className = annotFmd.className;
                        MetaDataMerger.mergeFieldAnnotationsData(fmd, annotFmd);
                    } else {
                        fmd = annotFmd instanceof FieldMetaData ? primaryCmd.getMetaDataManager().getMetaDataFactory().newFieldObject(primaryCmd, annotFmd) : primaryCmd.getMetaDataManager().getMetaDataFactory().newPropertyObject(primaryCmd, (PropertyMetaData)annotFmd);
                        fmd.className = annotFmd.className;
                    }
                } else {
                    fmd = annotFmd instanceof FieldMetaData ? primaryCmd.getMetaDataManager().getMetaDataFactory().newFieldObject(primaryCmd, annotFmd) : primaryCmd.getMetaDataManager().getMetaDataFactory().newPropertyObject(primaryCmd, (PropertyMetaData)annotFmd);
                }
                primaryCmd.addMember(fmd);
                continue;
            }
            MetaDataMerger.mergeFieldAnnotationsData(primaryFmd, annotFmd);
        }
        ExtensionMetaData[] ormExtensions = annotCmd.getExtensions();
        if (ormExtensions != null) {
            for (int i = 0; i < ormExtensions.length; ++i) {
                primaryCmd.addExtension(ormExtensions[i].vendorName, ormExtensions[i].key, ormExtensions[i].value);
            }
        }
    }

    public static void mergeFieldAnnotationsData(AbstractMemberMetaData primaryFmd, AbstractMemberMetaData annotFmd) {
        ExtensionMetaData[] annotExtensions;
        int i;
        ColumnMetaData[] annotColumns;
        if (annotFmd == null || primaryFmd == null) {
            return;
        }
        if (primaryFmd.isInitialised() || primaryFmd.isPopulated()) {
            throw new NucleusException(LOCALISER.msg("044107", (Object)primaryFmd.name, (Object)annotFmd.getAbstractClassMetaData().getFullClassName())).setFatal();
        }
        if (primaryFmd.className == null && annotFmd.className != null) {
            primaryFmd.className = annotFmd.className;
        }
        if (primaryFmd.container == null && annotFmd.container != null) {
            primaryFmd.container = annotFmd.container;
            primaryFmd.container.parent = primaryFmd;
        }
        if (annotFmd.persistenceModifier != FieldPersistenceModifier.DEFAULT && primaryFmd.persistenceModifier == FieldPersistenceModifier.DEFAULT) {
            primaryFmd.persistenceModifier = annotFmd.persistenceModifier;
        }
        if (annotFmd.defaultFetchGroup != null && primaryFmd.defaultFetchGroup == null) {
            primaryFmd.defaultFetchGroup = annotFmd.defaultFetchGroup;
        }
        if (annotFmd.primaryKey != null) {
            primaryFmd.primaryKey = annotFmd.primaryKey;
        }
        if (primaryFmd.table == null && annotFmd.table != null) {
            primaryFmd.table = annotFmd.table;
        }
        if (primaryFmd.catalog == null && annotFmd.catalog != null) {
            primaryFmd.catalog = annotFmd.catalog;
        }
        if (primaryFmd.schema == null && annotFmd.schema != null) {
            primaryFmd.schema = annotFmd.schema;
        }
        if (primaryFmd.column == null && annotFmd.column != null) {
            primaryFmd.column = annotFmd.column;
        }
        if (primaryFmd.dependent == null && annotFmd.dependent != null) {
            primaryFmd.dependent = annotFmd.dependent;
        }
        if (primaryFmd.mappedBy == null && annotFmd.mappedBy != null) {
            primaryFmd.mappedBy = annotFmd.mappedBy;
        }
        if (primaryFmd.valueStrategy == null && annotFmd.valueStrategy != null) {
            primaryFmd.valueStrategy = annotFmd.valueStrategy;
        }
        if (primaryFmd.sequence == null && annotFmd.sequence != null) {
            primaryFmd.sequence = annotFmd.sequence;
        }
        if (primaryFmd.indexed == null && annotFmd.indexed != null) {
            primaryFmd.indexed = annotFmd.indexed;
        }
        if (annotFmd.nullValue != NullValue.NONE) {
            primaryFmd.nullValue = annotFmd.nullValue;
        }
        if (primaryFmd.joinMetaData == null && annotFmd.joinMetaData != null) {
            primaryFmd.setJoinMetaData(annotFmd.joinMetaData);
        }
        if (primaryFmd.embeddedMetaData == null && annotFmd.embeddedMetaData != null) {
            primaryFmd.setEmbeddedMetaData(annotFmd.embeddedMetaData);
        }
        if (primaryFmd.elementMetaData == null && annotFmd.elementMetaData != null) {
            primaryFmd.setElementMetaData(annotFmd.elementMetaData);
        }
        if (primaryFmd.keyMetaData == null && annotFmd.keyMetaData != null) {
            primaryFmd.setKeyMetaData(annotFmd.keyMetaData);
        }
        if (primaryFmd.valueMetaData == null && annotFmd.valueMetaData != null) {
            primaryFmd.setValueMetaData(annotFmd.valueMetaData);
        }
        if (primaryFmd.orderMetaData == null && annotFmd.orderMetaData != null) {
            primaryFmd.setOrderMetaData(annotFmd.orderMetaData);
        }
        if (primaryFmd.foreignKeyMetaData == null && annotFmd.foreignKeyMetaData != null) {
            primaryFmd.foreignKeyMetaData = annotFmd.foreignKeyMetaData;
            if (primaryFmd.foreignKeyMetaData != null) {
                primaryFmd.foreignKeyMetaData.parent = primaryFmd;
            }
        }
        if (primaryFmd.indexMetaData == null && annotFmd.indexMetaData != null) {
            primaryFmd.indexMetaData = annotFmd.indexMetaData;
            if (primaryFmd.indexMetaData != null) {
                primaryFmd.indexMetaData.parent = primaryFmd;
            }
        }
        if (primaryFmd.uniqueMetaData == null && annotFmd.uniqueMetaData != null) {
            primaryFmd.uniqueMetaData = annotFmd.uniqueMetaData;
            if (primaryFmd.uniqueMetaData != null) {
                primaryFmd.uniqueMetaData.parent = primaryFmd;
            }
        }
        if (primaryFmd.columns.size() == 0 && annotFmd.columns.size() > 0 && (annotColumns = annotFmd.getColumnMetaData()) != null) {
            for (i = 0; i < annotColumns.length; ++i) {
                primaryFmd.columns.add(annotColumns[i]);
            }
        }
        if ((annotExtensions = annotFmd.getExtensions()) != null) {
            for (i = 0; i < annotExtensions.length; ++i) {
                primaryFmd.addExtension(annotExtensions[i].vendorName, annotExtensions[i].key, annotExtensions[i].value);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

