/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ConnectionFactoryRegistry;
import org.datanucleus.ConnectionManager;
import org.datanucleus.ImplementationCreator;
import org.datanucleus.JDOClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.api.ApiAdapterFactory;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.jta.TransactionManagerFinder;
import org.datanucleus.management.ManagementManager;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.transaction.TransactionManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class OMFContext {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManager == null ? (class$org$datanucleus$ObjectManager = OMFContext.class$("org.datanucleus.ObjectManager")) : class$org$datanucleus$ObjectManager).getClassLoader());
    private ImplementationCreator ic;
    private boolean implementationCreatorInitialised = false;
    private StoreManager storeMgr = null;
    private MetaDataManager metaDataManager = null;
    private TransactionManager txManager = null;
    private javax.transaction.TransactionManager jtaTxManager = null;
    private final PersistenceConfiguration persistenceConfig;
    private ManagementManager mgmtManager = null;
    private final PluginManager pluginManager;
    private final TypeManager typeManager;
    private ApiAdapter apiAdapter;
    private String apiName = "JDO";
    private Map classLoaderResolverMap = new HashMap();
    private String classLoaderResolverClassName = null;
    private Class datastoreIdentityClass = null;
    private String domainName;
    private String instanceName;
    private ConnectionFactoryRegistry connFactoryRegistry;
    private ConnectionManager connmgr;
    private QueryManager queryManager;
    private List objectManagerListeners = new ArrayList();
    static /* synthetic */ Class class$org$datanucleus$ObjectManager;
    static /* synthetic */ Class class$org$datanucleus$OMFContext;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public OMFContext(PersistenceConfiguration persistenceConfig) {
        this.persistenceConfig = persistenceConfig;
        JDOClassLoaderResolver clr = new JDOClassLoaderResolver(this.getClass().getClassLoader());
        clr.registerUserClassLoader((ClassLoader)persistenceConfig.getProperty("datanucleus.primaryClassLoader"));
        this.pluginManager = new PluginManager(this.persistenceConfig, clr);
        this.pluginManager.registerExtensionPoints();
        this.pluginManager.registerExtensions();
        this.pluginManager.resolveConstraints();
        persistenceConfig.setDefaultProperties(this.pluginManager);
        this.domainName = this.persistenceConfig.getStringProperty("datanucleus.PersistenceUnitName");
        if (this.domainName == null) {
            this.domainName = "datanucleus";
        }
        this.instanceName = "datanucleus-" + new Random().nextInt();
        this.apiAdapter = ApiAdapterFactory.getInstance().getApiAdapter(this.apiName, this.pluginManager);
        this.typeManager = new TypeManager(this.apiAdapter, this.pluginManager, this.getClassLoaderResolver(null));
        this.mgmtManager = this.getManagement();
        this.txManager = new TransactionManager();
        if (this.mgmtManager != null) {
            this.txManager.registerMbean(this.getDomainName(), this.getInstanceName(), this.getManagement().getManagementServer());
        }
        this.connFactoryRegistry = new ConnectionFactoryRegistry(this);
        this.queryManager = new QueryManager(this);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public synchronized void close() {
        if (this.storeMgr != null) {
            this.storeMgr.close();
            this.storeMgr = null;
        }
        if (this.metaDataManager != null) {
            this.metaDataManager.close();
            this.metaDataManager = null;
        }
        if (this.mgmtManager != null) {
            this.mgmtManager.close();
            this.mgmtManager = null;
        }
        if (this.queryManager != null) {
            this.queryManager.close();
        }
        this.classLoaderResolverMap.clear();
        this.classLoaderResolverMap = null;
        this.classLoaderResolverClassName = null;
        this.datastoreIdentityClass = null;
    }

    public Class getDatastoreIdentityClass() {
        if (this.datastoreIdentityClass == null) {
            String dsidName = this.persistenceConfig.getStringProperty("datanucleus.datastoreIdentityType");
            String datastoreIdentityClassName = this.pluginManager.getAttributeValueForExtension("org.datanucleus.store_datastoreidentity", "name", dsidName, "class-name");
            if (datastoreIdentityClassName == null) {
                throw new NucleusUserException(LOCALISER.msg("002001", (Object)dsidName)).setFatal();
            }
            ClassLoaderResolver clr = this.getClassLoaderResolver(null);
            try {
                this.datastoreIdentityClass = clr.classForName(datastoreIdentityClassName, (class$org$datanucleus$OMFContext == null ? (class$org$datanucleus$OMFContext = OMFContext.class$("org.datanucleus.OMFContext")) : class$org$datanucleus$OMFContext).getClassLoader());
            }
            catch (ClassNotResolvedException cnre) {
                throw new NucleusUserException(LOCALISER.msg("002002", (Object)dsidName, (Object)datastoreIdentityClassName)).setFatal();
            }
        }
        return this.datastoreIdentityClass;
    }

    public ManagementManager getManagement() {
        if (this.mgmtManager == null && this.persistenceConfig.getBooleanProperty("datanucleus.managedRuntime")) {
            this.mgmtManager = new ManagementManager(this);
        }
        return this.mgmtManager;
    }

    public ClassLoaderResolver getClassLoaderResolver(ClassLoader primaryLoader) {
        ClassLoaderResolver clr;
        String clrName = this.persistenceConfig.getStringProperty("datanucleus.classLoaderResolverName");
        this.classLoaderResolverClassName = this.pluginManager.getAttributeValueForExtension("org.datanucleus.classloader_resolver", "name", clrName, "class-name");
        if (this.classLoaderResolverClassName == null) {
            throw new NucleusUserException(LOCALISER.msg("001001", (Object)clrName)).setFatal();
        }
        String key = this.classLoaderResolverClassName;
        if (primaryLoader != null) {
            key = key + ":[" + StringUtils.toJVMIDString(primaryLoader) + "]";
        }
        if ((clr = (ClassLoaderResolver)this.classLoaderResolverMap.get(key)) == null) {
            try {
                Class<?> cls = Class.forName(this.classLoaderResolverClassName);
                Class[] ctrArgs = null;
                Object[] ctrParams = null;
                if (primaryLoader != null) {
                    ctrArgs = new Class[]{class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = OMFContext.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
                    ctrParams = new Object[]{primaryLoader};
                }
                Constructor<?> ctor = cls.getConstructor(ctrArgs);
                clr = (ClassLoaderResolver)ctor.newInstance(ctrParams);
                clr.registerUserClassLoader((ClassLoader)this.persistenceConfig.getProperty("datanucleus.primaryClassLoader"));
            }
            catch (ClassNotFoundException cnfe) {
                throw new NucleusUserException(LOCALISER.msg("001002", (Object)this.classLoaderResolverClassName), cnfe).setFatal();
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("001003", (Object)this.classLoaderResolverClassName), e).setFatal();
            }
            this.classLoaderResolverMap.put(key, clr);
        }
        return clr;
    }

    public ImplementationCreator getImplementationCreator() {
        if (!this.implementationCreatorInitialised) {
            String implCreatorName = this.persistenceConfig.getStringProperty("datanucleus.implementationCreatorName");
            try {
                Class<?> cls = null;
                ConfigurationElement elem = this.getPluginManager().getConfigurationElementForExtension("org.datanucleus.implementation_creator", "name", implCreatorName);
                if (elem != null) {
                    try {
                        cls = Class.forName(elem.getAttribute("class-name"), true, (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = OMFContext.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
                        this.ic = (ImplementationCreator)cls.newInstance();
                    }
                    catch (Exception e) {
                        NucleusLogger.PERSISTENCE.info(LOCALISER.msg("008006", (Object)implCreatorName));
                    }
                }
                if (this.ic == null) {
                    Extension[] exts = this.getPluginManager().getExtensionPoint("org.datanucleus.implementation_creator").getExtensions();
                    block7: for (int i = 0; this.ic == null && i < exts.length; ++i) {
                        for (int j = 0; this.ic == null && j < exts[i].getConfigurationElements().length; ++j) {
                            cls = Class.forName(exts[i].getConfigurationElements()[j].getAttribute("class-name"), true, (class$org$datanucleus$ObjectManagerFactoryImpl == null ? OMFContext.class$("org.datanucleus.ObjectManagerFactoryImpl") : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
                            this.ic = (ImplementationCreator)cls.newInstance();
                            if (this.ic != null) continue block7;
                        }
                    }
                }
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    if (this.ic == null) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("008007"));
                    } else {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("008008", (Object)cls.getName()));
                    }
                }
            }
            catch (InstantiationException e) {
                throw new NucleusException(e.toString(), e).setFatal();
            }
            catch (IllegalAccessException e) {
                throw new NucleusException(e.toString(), e).setFatal();
            }
            catch (ClassNotFoundException e) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("008006", (Object)implCreatorName));
                this.ic = null;
            }
            catch (NoClassDefFoundError e) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("008006", (Object)implCreatorName));
                this.ic = null;
            }
        }
        this.implementationCreatorInitialised = true;
        return this.ic;
    }

    public synchronized MetaDataManager getMetaDataManager() {
        if (this.metaDataManager == null) {
            try {
                this.metaDataManager = (MetaDataManager)this.getPluginManager().createExecutableExtension("org.datanucleus.metadata_manager", new String[]{"name"}, new String[]{this.apiName}, "class", new Class[]{class$org$datanucleus$OMFContext == null ? (class$org$datanucleus$OMFContext = OMFContext.class$("org.datanucleus.OMFContext")) : class$org$datanucleus$OMFContext}, new Object[]{this});
            }
            catch (Exception e) {
                throw new NucleusException(LOCALISER.msg("008010", (Object)this.apiName, (Object)e.getMessage()), e);
            }
            if (this.metaDataManager == null) {
                throw new NucleusException(LOCALISER.msg("008009", (Object)this.apiName));
            }
        }
        return this.metaDataManager;
    }

    public PersistenceConfiguration getPersistenceConfiguration() {
        return this.persistenceConfig;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public TransactionManager getTransactionManager() {
        return this.txManager;
    }

    public javax.transaction.TransactionManager getJtaTransactionManager() {
        if (this.jtaTxManager == null) {
            this.jtaTxManager = new TransactionManagerFinder(this).getTransactionManager(this.getClassLoaderResolver((ClassLoader)this.persistenceConfig.getProperty("datanucleus.primaryClassLoader")));
            if (this.jtaTxManager == null) {
                throw new NucleusTransactionException(LOCALISER.msg("015030"));
            }
        }
        return this.jtaTxManager;
    }

    public StoreManager getStoreManager() {
        return this.storeMgr;
    }

    public void setStoreManager(StoreManager storeMgr) {
        if (this.storeMgr == null) {
            this.storeMgr = storeMgr;
        }
    }

    public ApiAdapter getApiAdapter() {
        return this.apiAdapter;
    }

    public String getApi() {
        return this.apiName;
    }

    public void setApi(String name) {
        this.apiName = name;
        ApiAdapter adapter = ApiAdapterFactory.getInstance().getApiAdapter(name, this.pluginManager);
        if (adapter != null) {
            this.apiAdapter = adapter;
        } else {
            NucleusLogger.JDO.warn(LOCALISER.msg("008003", (Object)name));
        }
    }

    public ConnectionFactoryRegistry getConnectionFactoryRegistry() {
        return this.connFactoryRegistry;
    }

    public ConnectionManager getConnectionManager() {
        return this.connmgr;
    }

    public void setConnectionManager(ConnectionManager connmgr) {
        this.connmgr = connmgr;
    }

    public ObjectManager.ObjectManagerListener[] getObjectManagerListeners() {
        return this.objectManagerListeners.toArray(new ObjectManager.ObjectManagerListener[this.objectManagerListeners.size()]);
    }

    public void addObjectManagerListener(ObjectManager.ObjectManagerListener listener) {
        this.objectManagerListeners.add(listener);
    }

    public void removeObjectManagerListener(ObjectManager.ObjectManagerListener listener) {
        this.objectManagerListeners.remove(listener);
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

