/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.datanucleus.util.NucleusLogger;

public class Localiser {
    private static boolean displayCodesInMessages = false;
    private static Hashtable helpers = new Hashtable();
    private static Locale locale = Locale.getDefault();
    private ResourceBundle bundle = null;
    private static Hashtable msgFormats = new Hashtable();
    static /* synthetic */ Class class$java$lang$Throwable;

    private Localiser(String bundle_name, ClassLoader class_loader) {
        try {
            this.bundle = ResourceBundle.getBundle(bundle_name, locale, class_loader);
        }
        catch (MissingResourceException mre) {
            NucleusLogger.GENERAL.error("ResourceBundle " + bundle_name + " for locale " + locale + " was not found!");
        }
    }

    public static void setDisplayCodesInMessages(boolean display) {
        displayCodesInMessages = display;
    }

    public static Localiser getInstance(String bundle_name, ClassLoader class_loader) {
        Localiser localiser = (Localiser)helpers.get(bundle_name);
        if (localiser != null) {
            return localiser;
        }
        localiser = new Localiser(bundle_name, class_loader);
        helpers.put(bundle_name, localiser);
        return localiser;
    }

    public String msg(boolean includeCode, String messageKey) {
        return Localiser.getMessage(includeCode, this.bundle, messageKey, null);
    }

    public String msg(boolean includeCode, String messageKey, long arg) {
        Object[] args = new Object[]{String.valueOf(arg)};
        return Localiser.getMessage(true, this.bundle, messageKey, args);
    }

    public String msg(boolean includeCode, String messageKey, Object arg1) {
        Object[] args = new Object[]{arg1};
        return Localiser.getMessage(includeCode, this.bundle, messageKey, args);
    }

    public String msg(boolean includeCode, String messageKey, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return Localiser.getMessage(includeCode, this.bundle, messageKey, args);
    }

    public String msg(boolean includeCode, String messageKey, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return Localiser.getMessage(includeCode, this.bundle, messageKey, args);
    }

    public String msg(boolean includeCode, String messageKey, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4};
        return Localiser.getMessage(includeCode, this.bundle, messageKey, args);
    }

    public String msg(boolean includeCode, String messageKey, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4, arg5};
        return Localiser.getMessage(includeCode, this.bundle, messageKey, args);
    }

    public String msg(String messageKey) {
        return this.msg(true, messageKey);
    }

    public String msg(String messageKey, Object arg1) {
        return this.msg(true, messageKey, arg1);
    }

    public String msg(String messageKey, Object arg1, Object arg2) {
        return this.msg(true, messageKey, arg1, arg2);
    }

    public String msg(String messageKey, Object arg1, Object arg2, Object arg3) {
        return this.msg(true, messageKey, arg1, arg2, arg3);
    }

    public String msg(String messageKey, Object arg1, Object arg2, Object arg3, Object arg4) {
        return this.msg(true, messageKey, arg1, arg2, arg3, arg4);
    }

    public String msg(String messageKey, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return this.msg(true, messageKey, arg1, arg2, arg3, arg4, arg5);
    }

    public String msg(String messageKey, long arg) {
        return this.msg(true, messageKey, arg);
    }

    private static final String getMessage(boolean includeCode, ResourceBundle bundle, String messageKey, Object[] msgArgs) {
        if (messageKey == null) {
            NucleusLogger.GENERAL.error("Attempt to retrieve resource with NULL name !");
            return null;
        }
        if (msgArgs != null) {
            for (int i = 0; i < msgArgs.length; ++i) {
                if (msgArgs[i] == null) {
                    msgArgs[i] = "";
                }
                if (!(class$java$lang$Throwable == null ? Localiser.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(msgArgs[i].getClass())) continue;
                msgArgs[i] = Localiser.getStringFromException((Throwable)msgArgs[i]);
            }
        }
        try {
            char c;
            String stringForKey = bundle.getString(messageKey);
            if (includeCode && displayCodesInMessages && (c = messageKey.charAt(0)) >= '0' && c <= '9') {
                stringForKey = "[JPOX-" + messageKey + "] " + stringForKey;
            }
            if (msgArgs != null) {
                MessageFormat formatter = (MessageFormat)msgFormats.get(stringForKey);
                if (formatter == null) {
                    formatter = new MessageFormat(stringForKey);
                    msgFormats.put(stringForKey, formatter);
                }
                return formatter.format(msgArgs);
            }
            return stringForKey;
        }
        catch (MissingResourceException mre) {
            NucleusLogger.GENERAL.error("Parameter " + messageKey + " doesn't exist for bundle " + bundle);
            return null;
        }
    }

    private static String getStringFromException(Throwable exception) {
        StringBuffer msg = new StringBuffer();
        if (exception != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.close();
            try {
                stringWriter.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            msg.append(exception.getMessage());
            msg.append('\n');
            msg.append(stringWriter.toString());
            if (exception instanceof SQLException) {
                if (((SQLException)exception).getNextException() != null) {
                    msg.append('\n');
                    msg.append(Localiser.getStringFromException(((SQLException)exception).getNextException()));
                }
            } else if (exception instanceof InvocationTargetException && ((InvocationTargetException)exception).getTargetException() != null) {
                msg.append('\n');
                msg.append(Localiser.getStringFromException(((InvocationTargetException)exception).getTargetException()));
            }
        }
        return msg.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

