/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractXMLEntityResolver
implements EntityResolver {
    protected static Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = AbstractXMLEntityResolver.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    protected HashMap publicIdEntities = new HashMap();
    protected HashMap systemIdEntities = new HashMap();
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;
    static /* synthetic */ Class class$org$datanucleus$util$AbstractXMLEntityResolver;

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            String internalEntity;
            if (publicId != null && (internalEntity = (String)this.publicIdEntities.get(publicId)) != null) {
                return this.getLocalInputSource(publicId, systemId, internalEntity);
            }
            if (systemId != null) {
                internalEntity = (String)this.systemIdEntities.get(systemId);
                if (internalEntity != null) {
                    return this.getLocalInputSource(publicId, systemId, internalEntity);
                }
                if (systemId.startsWith("file://")) {
                    String localPath = systemId.substring(7);
                    File file = new File(localPath);
                    if (file.exists()) {
                        if (NucleusLogger.METADATA.isDebugEnabled()) {
                            NucleusLogger.METADATA.debug(LOCALISER.msg("028001", (Object)publicId, (Object)systemId));
                        }
                        FileInputStream in = new FileInputStream(file);
                        return new InputSource(in);
                    }
                    return null;
                }
                if (systemId.startsWith("file:")) {
                    return this.getLocalInputSource(publicId, systemId, systemId.substring(5));
                }
                if (systemId.startsWith("http:")) {
                    try {
                        if (NucleusLogger.METADATA.isDebugEnabled()) {
                            NucleusLogger.METADATA.debug(LOCALISER.msg("028001", (Object)publicId, (Object)systemId));
                        }
                        URL url = new URL(systemId);
                        InputStream url_stream = url.openStream();
                        return new InputSource(url_stream);
                    }
                    catch (Exception e) {
                        NucleusLogger.METADATA.error(e);
                    }
                }
            }
            NucleusLogger.METADATA.error(LOCALISER.msg("028002", (Object)publicId, (Object)systemId));
            return null;
        }
        catch (Exception e) {
            NucleusLogger.METADATA.error(LOCALISER.msg("028003", (Object)publicId, (Object)systemId), e);
            throw new SAXException(e.getMessage(), e);
        }
    }

    protected InputSource getLocalInputSource(String publicId, String systemId, String localPath) throws FileNotFoundException {
        InputStream in;
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("028000", (Object)publicId, (Object)systemId, (Object)localPath));
        }
        if ((in = (class$org$datanucleus$util$AbstractXMLEntityResolver == null ? (class$org$datanucleus$util$AbstractXMLEntityResolver = AbstractXMLEntityResolver.class$("org.datanucleus.util.AbstractXMLEntityResolver")) : class$org$datanucleus$util$AbstractXMLEntityResolver).getResourceAsStream(localPath)) == null) {
            NucleusLogger.METADATA.fatal("local resource \"" + localPath + "\" does not exist!!!");
            throw new FileNotFoundException("Unable to load resource: " + localPath);
        }
        return new InputSource(new InputStreamReader(in));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

