/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.Extent;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.query.QueryResultsMetaData;
import org.datanucleus.util.Imports;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractJavaQuery
extends Query {
    protected transient Extent candidateExtent = null;
    protected transient Collection candidateCollection = null;
    protected String singleString = null;
    protected transient QueryResultsMetaData resultMetaData;
    protected static transient Map userDefinedScalarExpressions = new Hashtable();

    public AbstractJavaQuery(ObjectManager om) {
        super(om);
        this.registerScalarExpressions(om.getOMFContext().getPluginManager(), om.getClassLoaderResolver());
    }

    public void setCandidates(Extent pcs) {
        this.discardCompiled();
        this.assertIsModifiable();
        if (pcs == null) {
            NucleusLogger.QUERY.warn(Query.LOCALISER.msg("021073"));
            return;
        }
        this.setSubclasses(pcs.hasSubclasses());
        this.setClass(pcs.getCandidateClass());
        this.candidateExtent = pcs;
        this.candidateCollection = null;
    }

    public void setCandidates(Collection pcs) {
        this.discardCompiled();
        this.assertIsModifiable();
        if (pcs == null) {
            NucleusLogger.QUERY.warn(Query.LOCALISER.msg("021072"));
            return;
        }
        this.candidateExtent = null;
        this.candidateCollection = pcs;
    }

    public Extent getCandidateExtent() {
        return this.candidateExtent;
    }

    public Collection getCandidateCollection() {
        return this.candidateCollection;
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.singleString = null;
        this.parsedImports = null;
    }

    public Imports getParsedImports() {
        if (this.parsedImports == null) {
            super.getParsedImports();
            Iterator it = userDefinedScalarExpressions.keySet().iterator();
            while (it.hasNext()) {
                this.parsedImports.importClass((String)it.next());
            }
        }
        return this.parsedImports;
    }

    public QueryResultsMetaData getResultSetMetaData() {
        if (this.resultMetaData == null) {
            throw new NucleusUserException("You must compile the query before calling this method.");
        }
        return this.resultMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long performDeletePersistentAll(Map parameters) {
        Collection results;
        boolean requiresUnique;
        block12: {
            block11: {
                requiresUnique = this.unique;
                if (this.unique) {
                    this.unique = false;
                    this.discardCompiled();
                }
                this.compileInternal(true, parameters);
                if (this.candidateCollection == null || !this.candidateCollection.isEmpty()) break block11;
                long l = 0L;
                Object var9_5 = null;
                if (requiresUnique != this.unique) {
                    this.unique = requiresUnique;
                    this.discardCompiled();
                }
                return l;
            }
            results = (Collection)this.performExecute(parameters);
            if (results != null) break block12;
            long l = 0L;
            Object var9_6 = null;
            if (requiresUnique != this.unique) {
                this.unique = requiresUnique;
                this.discardCompiled();
            }
            return l;
        }
        try {
            int number = results.size();
            if (requiresUnique && number > 1) {
                throw new NucleusUserException(Query.LOCALISER.msg("021032"));
            }
            Iterator resultsIter = results.iterator();
            while (resultsIter.hasNext()) {
                this.om.findStateManager(resultsIter.next()).flush();
            }
            this.om.deleteObjects(results);
            if (results instanceof QueryResult) {
                ((QueryResult)results).close();
            }
            long l = number;
            Object var9_7 = null;
            if (requiresUnique != this.unique) {
                this.unique = requiresUnique;
                this.discardCompiled();
            }
            return l;
        }
        catch (Throwable throwable) {
            block13: {
                Object var9_8 = null;
                if (requiresUnique == this.unique) break block13;
                this.unique = requiresUnique;
                this.discardCompiled();
            }
            throw throwable;
        }
    }

    public abstract String getSingleStringQuery();

    public String toString() {
        return this.getSingleStringQuery();
    }

    public static void registerScalarExpression(Class literal, Class scalarExpressionClass, String name) {
        userDefinedScalarExpressions.put(name == null ? literal.getName() : name, scalarExpressionClass);
    }

    protected void registerScalarExpressions(PluginManager pluginMgr, ClassLoaderResolver clr) {
        if (userDefinedScalarExpressions.isEmpty()) {
            Extension[] ex = pluginMgr.getExtensionPoint("org.datanucleus.store_expression_scalarexpression").getExtensions();
            for (int i = 0; i < ex.length; ++i) {
                ConfigurationElement[] confElm = ex[i].getConfigurationElements();
                for (int c = 0; c < confElm.length; ++c) {
                    Class literalClass = null;
                    if (confElm[c].getAttribute("literal-class") != null) {
                        literalClass = pluginMgr.loadClass(confElm[c].getExtension().getPlugin().getSymbolicName(), confElm[c].getAttribute("literal-class"));
                    }
                    Class scalarExpression = null;
                    if (confElm[c].getAttribute("scalar-expression-class") != null) {
                        scalarExpression = pluginMgr.loadClass(confElm[c].getExtension().getPlugin().getSymbolicName(), confElm[c].getAttribute("scalar-expression-class"));
                    }
                    AbstractJavaQuery.registerScalarExpression(literalClass, scalarExpression, confElm[c].getAttribute("name"));
                }
            }
        }
    }

    public static Map getUserDefinedScalarExpressions() {
        return userDefinedScalarExpressions;
    }
}

