/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.AbstractAutoStartMechanism;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.exceptions.DatastoreInitialisationException;

public class ClassesAutoStarter
extends AbstractAutoStartMechanism {
    protected String classNames;

    public ClassesAutoStarter(StoreManager storeMgr, ClassLoaderResolver clr) {
        this.classNames = storeMgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.autoStartClassNames");
    }

    public Collection getAllClassData() throws DatastoreInitialisationException {
        HashSet<StoreData> classes = new HashSet<StoreData>();
        if (this.classNames == null) {
            return classes;
        }
        StringTokenizer tokeniser = new StringTokenizer(this.classNames, ",");
        while (tokeniser.hasMoreTokens()) {
            classes.add(new StoreData(tokeniser.nextToken().trim(), null, 1, null));
        }
        return classes;
    }

    public void addClass(StoreData data) {
    }

    public void deleteClass(String className) {
    }

    public void deleteAllClasses() {
    }

    public String getStorageDescription() {
        return AbstractAutoStartMechanism.LOCALISER.msg("034100");
    }
}

