/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.io.PrintStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ConnectionFactory;
import org.datanucleus.ConnectionFactoryRegistry;
import org.datanucleus.ManagedConnection;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NoPersistenceInformationException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.SCOID;
import org.datanucleus.jdo.JDOSequenceImpl;
import org.datanucleus.management.ManagementServer;
import org.datanucleus.management.runtime.StoreManagerRuntime;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.store.AutoStartMechanism;
import org.datanucleus.store.Extent;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.NucleusSequence;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreDataManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.exceptions.DatastoreInitialisationException;
import org.datanucleus.store.exceptions.DatastoreReadOnlyException;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.store.valuegenerator.AbstractDatastoreGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationConnectionProvider;
import org.datanucleus.store.valuegenerator.ValueGenerationManager;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.TypeConversionHelper;

public abstract class AbstractStoreManager
implements StoreManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = AbstractStoreManager.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    protected final String storeManagerKey;
    protected final boolean readOnlyDatastore;
    protected final String readOnlyDatastoreAction;
    protected final boolean fixedDatastore;
    protected AutoStartMechanism starter = null;
    protected boolean starterInitialised = false;
    protected final OMFContext omfContext;
    protected final ValueGenerationManager poidManager;
    protected StoreManagerRuntime storeManagerRuntime;
    protected StoreDataManager storeDataMgr = new StoreDataManager();
    protected String autoStartMechanism = null;
    protected StorePersistenceHandler persistenceHandler = null;
    protected StoreSchemaHandler schemaHandler = null;
    protected String txConnectionFactoryName;
    protected String nontxConnectionFactoryName;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;
    static /* synthetic */ Class class$org$datanucleus$OMFContext;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$datanucleus$store$StoreManager;
    static /* synthetic */ Class class$org$datanucleus$ClassLoaderResolver;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractStoreManager(String key, ClassLoaderResolver clr, OMFContext omfContext) {
        ConnectionFactory cf;
        ConfigurationElement cfElem;
        this.storeManagerKey = key;
        this.omfContext = omfContext;
        PersistenceConfiguration conf = omfContext.getPersistenceConfiguration();
        this.readOnlyDatastore = conf.getBooleanProperty("datanucleus.readOnlyDatastore");
        this.readOnlyDatastoreAction = conf.getStringProperty("datanucleus.readOnlyDatastoreAction");
        this.fixedDatastore = conf.getBooleanProperty("datanucleus.fixedDatastore");
        this.autoStartMechanism = conf.getStringProperty("datanucleus.autoStartMechanism");
        omfContext.setStoreManager(this);
        this.poidManager = new ValueGenerationManager();
        if (omfContext.getManagement() != null) {
            ManagementServer mgntServer = omfContext.getManagement().getManagementServer();
            this.storeManagerRuntime = new StoreManagerRuntime();
            String mbeanName = omfContext.getDomainName() + ":InstanceName=" + omfContext.getInstanceName() + ",Type=" + ClassUtils.getClassNameForClass(this.storeManagerRuntime.getClass()) + ",Name=StoreManagerRuntime";
            mgntServer.registerMBean(this.storeManagerRuntime, mbeanName);
        }
        if ((cfElem = omfContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_connectionfactory", new String[]{"datastore", "transactional"}, new String[]{this.storeManagerKey, "true"})) == null) throw new NucleusException("Error creating transactional connection factory. No connection factory plugin defined");
        this.txConnectionFactoryName = cfElem.getAttribute("name");
        try {
            cf = (ConnectionFactory)omfContext.getPluginManager().createExecutableExtension("org.datanucleus.store_connectionfactory", new String[]{"datastore", "transactional"}, new String[]{this.storeManagerKey, "true"}, "class-name", new Class[]{class$org$datanucleus$OMFContext == null ? (class$org$datanucleus$OMFContext = AbstractStoreManager.class$("org.datanucleus.OMFContext")) : class$org$datanucleus$OMFContext, class$java$lang$String == null ? (class$java$lang$String = AbstractStoreManager.class$("java.lang.String")) : class$java$lang$String}, new Object[]{omfContext, "tx"});
            omfContext.getConnectionFactoryRegistry().registerConnectionFactory(this.txConnectionFactoryName, cf);
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug(LOCALISER.msg("032018", (Object)this.txConnectionFactoryName));
            }
        }
        catch (Exception e) {
            throw new NucleusException("Error creating transactional connection factory", e).setFatal();
        }
        cfElem = omfContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_connectionfactory", new String[]{"datastore", "transactional"}, new String[]{this.storeManagerKey, "false"});
        if (cfElem == null) return;
        this.nontxConnectionFactoryName = cfElem.getAttribute("name");
        try {
            cf = (ConnectionFactory)omfContext.getPluginManager().createExecutableExtension("org.datanucleus.store_connectionfactory", new String[]{"datastore", "transactional"}, new String[]{this.storeManagerKey, "false"}, "class-name", new Class[]{class$org$datanucleus$OMFContext == null ? (class$org$datanucleus$OMFContext = AbstractStoreManager.class$("org.datanucleus.OMFContext")) : class$org$datanucleus$OMFContext, class$java$lang$String == null ? (class$java$lang$String = AbstractStoreManager.class$("java.lang.String")) : class$java$lang$String}, new Object[]{omfContext, "nontx"});
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug(LOCALISER.msg("032019", (Object)this.nontxConnectionFactoryName));
            }
            omfContext.getConnectionFactoryRegistry().registerConnectionFactory(this.nontxConnectionFactoryName, cf);
            return;
        }
        catch (Exception e) {
            throw new NucleusException("Error creating nontransactional connection factory", e).setFatal();
        }
    }

    public void close() {
        this.poidManager.clear();
        this.storeDataMgr.clear();
        this.starterInitialised = false;
        this.starter = null;
        if (this.persistenceHandler != null) {
            this.persistenceHandler.close();
            this.persistenceHandler = null;
        }
    }

    public ManagedConnection getConnection(ObjectManager om) {
        ConnectionFactoryRegistry registry = om.getOMFContext().getConnectionFactoryRegistry();
        ConnectionFactory connFactory = registry.lookupConnectionFactory(this.txConnectionFactoryName);
        return connFactory.getConnection(om, null);
    }

    public StoreManagerRuntime getRuntimeManager() {
        return this.storeManagerRuntime;
    }

    public StorePersistenceHandler getPersistenceHandler() {
        return this.persistenceHandler;
    }

    public StoreSchemaHandler getSchemaHandler() {
        return this.schemaHandler;
    }

    public NucleusSequence getNucleusSequence(ObjectManager om, SequenceMetaData seqmd) {
        return new JDOSequenceImpl(om, this, seqmd);
    }

    public abstract NucleusConnection getNucleusConnection(ObjectManager var1);

    public ValueGenerationManager getPoidManager() {
        return this.poidManager;
    }

    public ApiAdapter getApiAdapter() {
        return this.omfContext.getApiAdapter();
    }

    public String getStoreManagerKey() {
        return this.storeManagerKey;
    }

    public OMFContext getOMFContext() {
        return this.omfContext;
    }

    public MetaDataManager getMetaDataManager() {
        return this.omfContext.getMetaDataManager();
    }

    public abstract Date getDatastoreDate();

    protected void registerStoreData(StoreData data) {
        this.storeDataMgr.registerStoreData(data);
        if (this.starter != null && this.starterInitialised) {
            this.starter.addClass(data);
        }
    }

    protected void deregisterAllStoreData() {
        this.storeDataMgr.clear();
        this.starterInitialised = false;
        this.clearAutoStarter();
    }

    protected void logConfiguration() {
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            PersistenceConfiguration conf = this.omfContext.getPersistenceConfiguration();
            NucleusLogger.DATASTORE.debug("======================= Datastore =========================");
            NucleusLogger.DATASTORE.debug("StoreManager : \"" + this.storeManagerKey + "\" (" + this.getClass().getName() + ")");
            if (this.autoStartMechanism != null) {
                String classNames = conf.getStringProperty("datanucleus.autoStartClassNames");
                NucleusLogger.DATASTORE.debug("AutoStart : mechanism=" + this.autoStartMechanism + ", mode=" + conf.getStringProperty("datanucleus.autoStartMechanismMode") + (classNames != null ? ", classes=" + classNames : ""));
            }
            String url = this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionURL");
            NucleusLogger.DATASTORE.debug(LOCALISER.msg("032020", (Object)this.storeManagerKey, (Object)url, (Object)(this.readOnlyDatastore ? "read-only" : "read-write"), (Object)(this.fixedDatastore ? ", fixed" : "")));
            Object[] queryLanguages = this.omfContext.getPluginManager().getAttributeValuesForExtension("org.datanucleus.store_query_query", "datastore", this.storeManagerKey, "name");
            NucleusLogger.DATASTORE.debug("Query Languages : " + (queryLanguages != null ? StringUtils.objectArrayToString(queryLanguages) : "none"));
            NucleusLogger.DATASTORE.debug("===========================================================");
        }
    }

    public void printInformation(String category, PrintStream ps) throws Exception {
        if (category.equalsIgnoreCase("DATASTORE")) {
            String url = this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionURL");
            ps.println(LOCALISER.msg("032020", (Object)this.storeManagerKey, (Object)url, (Object)(this.readOnlyDatastore ? "read-only" : "read-write"), (Object)(this.fixedDatastore ? ", fixed" : "")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseAutoStart(ClassLoaderResolver clr) throws DatastoreInitialisationException {
        if (this.starterInitialised) {
            return;
        }
        if (this.autoStartMechanism == null) {
            this.autoStartMechanism = "None";
            this.starterInitialised = true;
            return;
        }
        String autoStarterClassName = this.getOMFContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.autostart", "name", this.autoStartMechanism, "class-name");
        if (autoStarterClassName != null) {
            String mode = this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.autoStartMechanismMode");
            Class[] argsClass = new Class[]{class$org$datanucleus$store$StoreManager == null ? (class$org$datanucleus$store$StoreManager = AbstractStoreManager.class$("org.datanucleus.store.StoreManager")) : class$org$datanucleus$store$StoreManager, class$org$datanucleus$ClassLoaderResolver == null ? (class$org$datanucleus$ClassLoaderResolver = AbstractStoreManager.class$("org.datanucleus.ClassLoaderResolver")) : class$org$datanucleus$ClassLoaderResolver};
            Object[] args = new Object[]{this, clr};
            try {
                this.starter = (AutoStartMechanism)this.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.autostart", "name", this.autoStartMechanism, "class-name", argsClass, args);
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.error(StringUtils.getStringFromStackTrace(e));
            }
            this.starter.setMode(mode);
        }
        if (this.starter == null) {
            this.starterInitialised = true;
            return;
        }
        boolean illegalState = false;
        try {
            Collection existingData;
            if (!this.starter.isOpen()) {
                this.starter.open();
            }
            if ((existingData = this.starter.getAllClassData()) != null && existingData.size() > 0) {
                ArrayList<String> classesNeedingAdding = new ArrayList<String>();
                Iterator existingDataIter = existingData.iterator();
                while (existingDataIter.hasNext()) {
                    Class classFound;
                    StoreData data;
                    block28: {
                        data = (StoreData)existingDataIter.next();
                        if (!data.isFCO()) continue;
                        classFound = null;
                        try {
                            classFound = clr.classForName(data.getName());
                        }
                        catch (ClassNotResolvedException cnre) {
                            if (data.getInterfaceName() == null) break block28;
                            try {
                                this.getOMFContext().getImplementationCreator().newInstance(clr.classForName(data.getInterfaceName()), this.getMetaDataManager(), clr);
                                classFound = clr.classForName(data.getName());
                            }
                            catch (ClassNotResolvedException cnre2) {
                                // empty catch block
                            }
                        }
                    }
                    if (classFound != null) {
                        NucleusLogger.PERSISTENCE.info(LOCALISER.msg("032003", (Object)data.getName()));
                        classesNeedingAdding.add(data.getName());
                        if (data.getMetaData() != null) continue;
                        AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(classFound, clr);
                        if (acmd != null) {
                            data.setMetaData(acmd);
                            continue;
                        }
                        String msg = LOCALISER.msg("034004", (Object)data.getName());
                        if (this.starter.getMode().equals("Checked")) {
                            NucleusLogger.PERSISTENCE.error(msg);
                            throw new DatastoreInitialisationException(msg);
                        }
                        if (this.starter.getMode().equals("Ignored")) {
                            NucleusLogger.PERSISTENCE.warn(msg);
                            continue;
                        }
                        if (!this.starter.getMode().equals("Quiet")) continue;
                        NucleusLogger.PERSISTENCE.warn(msg);
                        NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034001", (Object)data.getName()));
                        this.starter.deleteClass(data.getName());
                        continue;
                    }
                    String msg = LOCALISER.msg("034000", (Object)data.getName());
                    if (this.starter.getMode().equals("Checked")) {
                        NucleusLogger.PERSISTENCE.error(msg);
                        throw new DatastoreInitialisationException(msg);
                    }
                    if (this.starter.getMode().equals("Ignored")) {
                        NucleusLogger.PERSISTENCE.warn(msg);
                        continue;
                    }
                    if (!this.starter.getMode().equals("Quiet")) continue;
                    NucleusLogger.PERSISTENCE.warn(msg);
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034001", (Object)data.getName()));
                    this.starter.deleteClass(data.getName());
                }
                String[] classesToLoad = new String[classesNeedingAdding.size()];
                Iterator classesNeedingAddingIter = classesNeedingAdding.iterator();
                int n = 0;
                while (classesNeedingAddingIter.hasNext()) {
                    classesToLoad[n++] = (String)classesNeedingAddingIter.next();
                }
                try {
                    this.addClasses(classesToLoad, clr);
                }
                catch (Exception e) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034002", e));
                    illegalState = true;
                }
            }
            Object var12_17 = null;
            if (this.starter.isOpen()) {
                this.starter.close();
            }
            if (illegalState) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034003"));
                this.starter = null;
            }
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            if (this.starter.isOpen()) {
                this.starter.close();
            }
            if (illegalState) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034003"));
                this.starter = null;
            }
            throw throwable;
        }
        this.starterInitialised = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAutoStarter() {
        if (this.starter != null) {
            try {
                if (!this.starter.isOpen()) {
                    this.starter.open();
                }
                this.starter.deleteAllClasses();
                Object var2_1 = null;
                if (this.starter.isOpen()) {
                    this.starter.close();
                }
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.starter.isOpen()) {
                    this.starter.close();
                }
                throw throwable;
            }
        }
    }

    public AutoStartMechanism getAutoStartMechanism() {
        return this.starter;
    }

    public boolean managesClass(String className) {
        return this.storeDataMgr.managesClass(className);
    }

    public void addClass(String className, ClassLoaderResolver clr) {
        this.addClasses(new String[]{className}, clr);
    }

    public void addClasses(String[] classNames, ClassLoaderResolver clr) {
        if (classNames == null) {
            return;
        }
        String[] filteredClassNames = this.getOMFContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        Iterator iter = this.getReferencedClasses(filteredClassNames, clr).iterator();
        while (iter.hasNext()) {
            ClassMetaData cmd = (ClassMetaData)iter.next();
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                return;
            }
            StoreData sd = this.storeDataMgr.get(cmd.getFullClassName());
            if (sd != null) continue;
            StoreData storeData = new StoreData(cmd.getFullClassName(), cmd, 1, null);
            this.registerStoreData(storeData);
        }
    }

    public void removeAllClasses(ClassLoaderResolver clr) {
    }

    protected List getReferencedClasses(String[] classNames, ClassLoaderResolver clr) {
        ArrayList cmds = new ArrayList();
        for (int i = 0; i < classNames.length; ++i) {
            Class cls = null;
            try {
                cls = clr.classForName(classNames[i]);
                if (cls.isInterface()) continue;
                AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(classNames[i], clr);
                if (cmd == null) {
                    NucleusLogger.DATASTORE.warn("Class Invalid " + classNames[i]);
                    throw new NoPersistenceInformationException(classNames[i]);
                }
                cmds.addAll(this.getMetaDataManager().getReferencedClassMetaData(cmd, null, clr));
                continue;
            }
            catch (ClassNotResolvedException cnre) {
                NucleusLogger.DATASTORE.warn("Class " + classNames[i] + " not found so being ignored");
            }
        }
        return cmds;
    }

    public String manageClassForIdentity(Object id, ClassLoaderResolver clr) {
        String className = null;
        if (id instanceof OID) {
            className = ((OID)id).getPcClass();
            AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
            if (cmd.getIdentityType() != IdentityType.DATASTORE) {
                throw new NucleusUserException(LOCALISER.msg("038001", id, (Object)cmd.getFullClassName()));
            }
        } else if (this.getApiAdapter().isSingleFieldIdentity(id)) {
            className = this.getApiAdapter().getTargetClassNameForSingleFieldIdentity(id);
            AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
            if (cmd.getIdentityType() != IdentityType.APPLICATION || !cmd.getObjectidClass().equals(id.getClass().getName())) {
                throw new NucleusUserException(LOCALISER.msg("038001", id, (Object)cmd.getFullClassName()));
            }
        } else {
            throw new NucleusException("StoreManager.manageClassForIdentity called for id=" + id + " yet should only be called for datastore-identity/SingleFieldIdentity");
        }
        if (!this.managesClass(className)) {
            this.addClass(className, clr);
        }
        return className;
    }

    public abstract Extent getExtent(ObjectManager var1, Class var2, boolean var3);

    public boolean supportsQueryLanguage(String language) {
        if (language == null) {
            return false;
        }
        String name = this.getOMFContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{language, this.storeManagerKey}, "name");
        return name != null;
    }

    public boolean supportsValueStrategy(String strategy) {
        ConfigurationElement elem = this.omfContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "unique"}, new String[]{strategy, "true"});
        if (elem != null) {
            return true;
        }
        elem = this.omfContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{strategy, this.storeManagerKey});
        return elem != null;
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ObjectManager om) {
        Iterator iter;
        if (id instanceof SCOID) {
            return ((SCOID)id).getSCOClass();
        }
        if (id instanceof OID) {
            return ((OID)id).getPcClass();
        }
        if (this.getApiAdapter().isSingleFieldIdentity(id)) {
            return this.getApiAdapter().getTargetClassNameForSingleFieldIdentity(id);
        }
        Collection c = this.storeDataMgr.getByPrimaryKeyClass(id.getClass().getName());
        if (c != null && (iter = c.iterator()).hasNext()) {
            StoreData store_data = (StoreData)iter.next();
            return store_data.getName();
        }
        return null;
    }

    public boolean isStrategyDatastoreAttributed(IdentityStrategy identityStrategy, boolean datastoreIdentityField) {
        if (identityStrategy == null) {
            return false;
        }
        return identityStrategy == IdentityStrategy.IDENTITY;
    }

    public Object getStrategyValue(ObjectManager om, AbstractClassMetaData cmd, int absoluteFieldNumber) {
        ValueGenerator generator;
        AbstractMemberMetaData mmd = null;
        String fieldName = null;
        IdentityStrategy strategy = null;
        String sequence = null;
        String valueGeneratorName = null;
        TableGeneratorMetaData tableGeneratorMetaData = null;
        SequenceMetaData sequenceMetaData = null;
        if (absoluteFieldNumber >= 0) {
            mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
            fieldName = mmd.getFullFieldName();
            strategy = mmd.getValueStrategy();
            sequence = mmd.getSequence();
            valueGeneratorName = mmd.getValueGeneratorName();
        } else {
            fieldName = cmd.getFullClassName() + " (datastore id)";
            strategy = cmd.getIdentityMetaData().getValueStrategy();
            sequence = cmd.getIdentityMetaData().getSequence();
            valueGeneratorName = cmd.getIdentityMetaData().getValueGeneratorName();
        }
        if (valueGeneratorName != null) {
            if (strategy == IdentityStrategy.INCREMENT) {
                tableGeneratorMetaData = this.getMetaDataManager().getMetaDataForTableGenerator(om.getClassLoaderResolver(), valueGeneratorName);
                if (tableGeneratorMetaData == null) {
                    throw new NucleusUserException(LOCALISER.msg("038005", (Object)fieldName, (Object)valueGeneratorName));
                }
            } else if (strategy == IdentityStrategy.SEQUENCE && (sequenceMetaData = this.getMetaDataManager().getMetaDataForSequence(om.getClassLoaderResolver(), valueGeneratorName)) == null) {
                throw new NucleusUserException(LOCALISER.msg("038006", (Object)fieldName, (Object)valueGeneratorName));
            }
        } else if (strategy == IdentityStrategy.SEQUENCE && sequence != null && (sequenceMetaData = this.getMetaDataManager().getMetaDataForSequence(om.getClassLoaderResolver(), sequence)) == null) {
            NucleusLogger.DATASTORE.warn("Field " + fieldName + " has been specified to use sequence " + sequence + " but there is no <sequence> specified in the MetaData. " + "Falling back to use a sequence in the datastore with this name directly.");
        }
        String strategyName = strategy.toString();
        if (strategy.equals(IdentityStrategy.CUSTOM)) {
            strategyName = strategy.getCustomName();
        } else if (strategy.equals(IdentityStrategy.NATIVE)) {
            strategyName = this.getStrategyForNative(sequence);
        }
        String poidGeneratorName = null;
        String generatorNameKeyInManager = null;
        ConfigurationElement elem = this.omfContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "unique"}, new String[]{strategyName, "true"});
        if (elem != null) {
            generatorNameKeyInManager = poidGeneratorName = elem.getAttribute("name");
        } else {
            elem = this.omfContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{strategyName, this.storeManagerKey});
            if (elem != null) {
                poidGeneratorName = elem.getAttribute("name");
            }
        }
        if (generatorNameKeyInManager == null) {
            generatorNameKeyInManager = absoluteFieldNumber >= 0 ? mmd.getFullFieldName() : cmd.getBaseAbstractClassMetaData().getFullClassName();
        }
        if ((generator = this.poidManager.getValueGenerator(generatorNameKeyInManager)) == null) {
            if (poidGeneratorName == null) {
                throw new NucleusUserException(LOCALISER.msg("038004", strategy));
            }
            Properties props = this.getPropertiesForGenerator(cmd, absoluteFieldNumber, om, sequenceMetaData, tableGeneratorMetaData);
            Class cls = null;
            if (elem != null) {
                cls = this.omfContext.getPluginManager().loadClass(elem.getExtension().getPlugin().getSymbolicName(), elem.getAttribute("class-name"));
            }
            if (cls == null) {
                throw new NucleusException("Cannot create Poid Generator for strategy " + poidGeneratorName);
            }
            generator = this.poidManager.createValueGenerator(generatorNameKeyInManager, cls, props, this, null);
        }
        Object oid = this.getStrategyValueForGenerator(generator, om);
        if (mmd != null) {
            Object convertedValue = TypeConversionHelper.convertTo(oid, mmd.getType());
            if (convertedValue == null) {
                throw new NucleusException(LOCALISER.msg("038003", (Object)mmd.getFullFieldName(), oid)).setFatal();
            }
            oid = convertedValue;
        }
        if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
            NucleusLogger.VALUEGENERATION.debug(LOCALISER.msg("038002", (Object)fieldName, (Object)strategy, (Object)generator.getClass().getName(), oid));
        }
        return oid;
    }

    protected String getStrategyForNative(String sequence) {
        return "increment";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getStrategyValueForGenerator(ValueGenerator generator, final ObjectManager om) {
        Object oid = null;
        ValueGenerator valueGenerator = generator;
        synchronized (valueGenerator) {
            if (generator instanceof AbstractDatastoreGenerator) {
                ValueGenerationConnectionProvider connProvider = new ValueGenerationConnectionProvider(){

                    public ManagedConnection retrieveConnection() {
                        return AbstractStoreManager.this.getConnection(om);
                    }

                    public void releaseConnection() {
                    }
                };
                ((AbstractDatastoreGenerator)generator).setConnectionProvider(connProvider);
            }
            oid = generator.next();
        }
        return oid;
    }

    protected Properties getPropertiesForGenerator(AbstractClassMetaData cmd, int absoluteFieldNumber, ObjectManager om, SequenceMetaData seqmd, TableGeneratorMetaData tablegenmd) {
        ExtensionMetaData[] extensions = null;
        if (absoluteFieldNumber >= 0) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
            extensions = mmd.getExtensions();
        } else {
            extensions = cmd.getIdentityMetaData().getExtensions();
        }
        Properties properties = new Properties();
        properties.setProperty("class-name", cmd.getFullClassName());
        ((Hashtable)properties).put("root-class-name", cmd.getBaseAbstractClassMetaData().getFullClassName());
        if (cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber) != null) {
            properties.setProperty("field-name", cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber).getFullFieldName());
        }
        if (extensions != null) {
            for (int i = 0; i < extensions.length; ++i) {
                ((Hashtable)properties).put(extensions[i].getKey(), extensions[i].getValue());
            }
        }
        return properties;
    }

    public void performVersionCheck(StateManager sm, Object versionDatastore, VersionMetaData versionMetaData) {
        boolean valid;
        Object versionObject = sm.getTransactionalVersion(sm.getObject());
        if (versionObject == null) {
            return;
        }
        if (versionMetaData == null) {
            NucleusLogger.JDO.info(sm.getClassMetaData().getFullClassName() + " has no version metadata so no check of version is required, since this will not have the version flag in its table");
            return;
        }
        if (versionMetaData.getVersionStrategy() == VersionStrategy.DATE_TIME) {
            valid = ((Timestamp)versionObject).getTime() == ((Timestamp)versionDatastore).getTime();
        } else if (versionMetaData.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
            valid = ((Number)versionObject).longValue() == ((Number)versionDatastore).longValue();
        } else {
            if (versionMetaData.getVersionStrategy() == VersionStrategy.STATE_IMAGE) {
                throw new NucleusUserException(LOCALISER.msg("032017", (Object)sm.getClassMetaData().getFullClassName(), (Object)versionMetaData.getVersionStrategy()));
            }
            throw new NucleusUserException(LOCALISER.msg("032017", (Object)sm.getClassMetaData().getFullClassName(), (Object)versionMetaData.getVersionStrategy()));
        }
        if (!valid) {
            String msg = LOCALISER.msg("032016", (Object)StringUtils.toJVMIDString(sm.getObject()), sm.getInternalObjectId(), (Object)("" + versionDatastore), (Object)("" + versionObject));
            NucleusLogger.PERSISTENCE.error(msg);
            throw new NucleusOptimisticException(msg, sm.getObject());
        }
    }

    public HashSet getSubClassesForClass(String className, boolean includeDescendents, ClassLoaderResolver clr) {
        HashSet<String> subclasses = new HashSet<String>();
        String[] subclassNames = this.getMetaDataManager().getSubclassesForClass(className, includeDescendents);
        if (subclassNames != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                if (!this.storeDataMgr.managesClass(subclassNames[i])) {
                    this.addClass(subclassNames[i], clr);
                }
                subclasses.add(subclassNames[i]);
            }
        }
        return subclasses;
    }

    public void notifyObjectIsOutdated(StateManager sm) {
    }

    public Store getBackingStoreForField(ClassLoaderResolver clr, AbstractMemberMetaData fmd, Class type) {
        throw new UnsupportedOperationException("Backing stores are not supported in this datastore");
    }

    public Collection getSupportedOptions() {
        return Collections.EMPTY_SET;
    }

    public void assertReadOnlyForUpdateOfObject(StateManager sm) {
        PersistenceConfiguration conf = this.getOMFContext().getPersistenceConfiguration();
        if (conf.getBooleanProperty("datanucleus.readOnlyDatastore")) {
            if (conf.getStringProperty("datanucleus.readOnlyDatastoreAction").equalsIgnoreCase("EXCEPTION")) {
                throw new DatastoreReadOnlyException(LOCALISER.msg("032004", (Object)StringUtils.toJVMIDString(sm.getObject())), sm.getObjectManager().getClassLoaderResolver());
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("032005", (Object)StringUtils.toJVMIDString(sm.getObject())));
            }
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

