/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.sco.simple;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.sco.NullsNotAllowedException;
import org.datanucleus.sco.SCOCollection;
import org.datanucleus.sco.SCOCollectionIterator;
import org.datanucleus.sco.SCOMtoN;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class Queue
extends AbstractQueue
implements SCOCollection,
SCOMtoN,
Cloneable,
Serializable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$sco$simple$PriorityQueue == null ? (class$org$datanucleus$sco$simple$PriorityQueue = Queue.class$("org.datanucleus.sco.simple.PriorityQueue")) : class$org$datanucleus$sco$simple$PriorityQueue).getClassLoader());
    protected Object owner;
    protected StateManager ownerSM;
    protected String fieldName;
    protected int fieldNumber;
    protected boolean allowNulls;
    protected java.util.Queue delegate;
    static /* synthetic */ Class class$org$datanucleus$sco$simple$PriorityQueue;

    public Queue(StateManager ownerSM, String fieldName) {
        this.ownerSM = ownerSM;
        this.fieldName = fieldName;
        this.allowNulls = false;
        if (ownerSM != null) {
            AbstractMemberMetaData fmd = ownerSM.getClassMetaData().getMetaDataForMember(fieldName);
            this.owner = ownerSM.getObject();
            this.fieldNumber = fmd.getAbsoluteFieldNumber();
        }
    }

    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Collection c = (Collection)o;
        if (c != null) {
            this.initialiseDelegate();
            this.delegate.addAll(c);
        } else {
            this.initialiseDelegate();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName, (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, this.allowNulls, false)));
        }
    }

    public void initialise() {
        this.initialiseDelegate();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName, (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, this.allowNulls, false)));
        }
    }

    protected void initialiseDelegate() {
        AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
        Comparator comparator = SCOUtils.getComparator(fmd, this.ownerSM.getObjectManager().getClassLoaderResolver());
        this.delegate = comparator != null ? new PriorityQueue(5, comparator) : new PriorityQueue();
    }

    public Object getValue() {
        return this.delegate;
    }

    public void load() {
    }

    public boolean isLoaded() {
        return true;
    }

    public void flush() {
    }

    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOwner() {
        return this.owner;
    }

    public synchronized void unsetOwner() {
        if (this.ownerSM != null) {
            this.owner = null;
            this.ownerSM = null;
            this.fieldName = null;
        }
    }

    public void makeDirty() {
        if (this.ownerSM != null) {
            this.ownerSM.makeDirty(this.fieldNumber);
        }
    }

    public Object detachCopy(FetchPlanState state) {
        PriorityQueue detached = new PriorityQueue();
        SCOUtils.detachCopyForCollection(this.ownerSM, this.toArray(), state, detached);
        return detached;
    }

    public void attachCopy(Object value) {
        Collection c = (Collection)value;
        AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(fmd);
        HashSet attachedElements = new HashSet(c.size());
        SCOUtils.attachCopyForCollection(this.ownerSM, c.toArray(), attachedElements, elementsWithoutIdentity);
        SCOUtils.updateCollectionWithCollectionElements(this, attachedElements);
    }

    public Object clone() {
        return null;
    }

    public synchronized boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    public synchronized boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    public synchronized boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public synchronized int hashCode() {
        return this.delegate.hashCode();
    }

    public synchronized boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public synchronized Iterator iterator() {
        return new SCOCollectionIterator(this, this.ownerSM, this.delegate, null, true);
    }

    public synchronized Object peek() {
        return this.delegate.peek();
    }

    public synchronized int size() {
        return this.delegate.size();
    }

    public synchronized Object[] toArray() {
        return this.delegate.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }

    public synchronized boolean add(Object element) {
        if (element == null && !this.allowNulls) {
            throw new NullsNotAllowedException(this.ownerSM, this.fieldName);
        }
        boolean success = this.delegate.add(element);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public synchronized boolean addAll(Collection elements) {
        boolean success = this.delegate.addAll(elements);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public synchronized void clear() {
        this.delegate.clear();
        this.makeDirty();
    }

    public synchronized boolean offer(Object element) {
        boolean success = this.delegate.offer(element);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public synchronized Object poll() {
        Object obj = this.delegate.poll();
        this.makeDirty();
        return obj;
    }

    public synchronized boolean remove(Object element) {
        return this.remove(element, true);
    }

    public synchronized boolean remove(Object element, boolean allowCascadeDelete) {
        boolean success = this.delegate.remove(element);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public synchronized boolean removeAll(Collection elements) {
        boolean success = this.delegate.removeAll(elements);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public synchronized boolean retainAll(Collection c) {
        boolean success = this.delegate.retainAll(c);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new PriorityQueue(this.delegate);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

