/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.sco;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.StateManager;
import org.datanucleus.store.scostore.ListStore;

public class SCOListIterator
implements ListIterator {
    private final ListIterator iter;
    private Object last = null;
    private int currentIndex = -1;
    private List ownerSCO;

    public SCOListIterator(List sco, StateManager sm, List theDelegate, ListStore theStore, boolean useDelegate, int startIndex) {
        this.ownerSCO = sco;
        ArrayList entries = new ArrayList();
        Iterator i = null;
        i = useDelegate ? theDelegate.iterator() : (theStore != null ? theStore.iterator(sm) : theDelegate.iterator());
        while (i.hasNext()) {
            entries.add(i.next());
        }
        this.iter = startIndex >= 0 ? ((AbstractList)entries).listIterator(startIndex) : ((AbstractList)entries).listIterator();
        this.currentIndex = startIndex;
    }

    public void add(Object o) {
        this.currentIndex = this.iter.nextIndex();
        this.ownerSCO.add(this.currentIndex, o);
        this.last = null;
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public boolean hasPrevious() {
        return this.iter.hasPrevious();
    }

    public Object next() {
        ++this.currentIndex;
        this.last = this.iter.next();
        return this.last;
    }

    public int nextIndex() {
        return this.iter.nextIndex();
    }

    public Object previous() {
        --this.currentIndex;
        this.last = this.iter.previous();
        return this.last;
    }

    public int previousIndex() {
        return this.iter.previousIndex();
    }

    public void remove() {
        if (this.last == null) {
            throw new IllegalStateException();
        }
        this.ownerSCO.remove(this.currentIndex);
        this.last = null;
        --this.currentIndex;
    }

    public synchronized void set(Object o) {
        if (this.last == null) {
            throw new IllegalStateException("No entry to replace");
        }
        this.ownerSCO.set(this.currentIndex, o);
        this.iter.set(o);
        this.last = o;
    }
}

