/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.evaluator.memory;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.evaluator.memory.InMemoryExpressionEvaluator;
import org.datanucleus.query.evaluator.memory.InvocationEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.util.Localiser;

public class TrimFunctionEvaluator
implements InvocationEvaluator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = TrimFunctionEvaluator.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        String method = expr.getOperation();
        Object param = expr.getParameters().get(0);
        char trimChar = ' ';
        if (expr.getParameters().size() == 2) {
            trimChar = ((Character)((Literal)expr.getParameters().get(1)).getLiteral()).charValue();
        }
        String paramValue = null;
        if (param instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)param;
            paramValue = (String)eval.getValueForPrimaryExpression(primExpr);
        } else if (param instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)param;
            paramValue = (String)QueryUtils.getValueForParameterExpression(eval.getSymbolTable(), paramExpr);
        } else if (param instanceof Literal) {
            paramValue = (String)((Literal)param).getLiteral();
        } else {
            throw new NucleusException(method + "(str1) where str1 is instanceof " + param.getClass().getName() + " not supported");
        }
        if (paramValue == null) {
            return null;
        }
        if (method.equals("TRIM")) {
            int substringStart = 0;
            for (int i = 0; i < paramValue.length() && paramValue.charAt(i) == trimChar; ++i) {
                ++substringStart;
            }
            int substringEnd = paramValue.length();
            for (int i = paramValue.length() - 1; i >= 0 && paramValue.charAt(i) == trimChar; --i) {
                --substringEnd;
            }
            return paramValue.substring(substringStart, substringEnd);
        }
        if (method.equals("TRIM_LEADING")) {
            int substringPos = 0;
            for (int i = 0; i < paramValue.length() && paramValue.charAt(i) == trimChar; ++i) {
                ++substringPos;
            }
            return paramValue.substring(substringPos);
        }
        if (method.equals("TRIM_TRAILING")) {
            int substringPos = paramValue.length();
            for (int i = paramValue.length() - 1; i >= 0 && paramValue.charAt(i) == trimChar; --i) {
                --substringPos;
            }
            return paramValue.substring(0, substringPos);
        }
        return null;
    }

    public boolean supportsType(Class cls) {
        return cls == null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

