/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractElementMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.util.ClassUtils;

public class ValueMetaData
extends AbstractElementMetaData {
    public ValueMetaData(MetaData parent, ValueMetaData vmd) {
        super(parent, vmd);
    }

    public ValueMetaData(MetaData parent, String column, String deleteAction, String updateAction, String indexed, String unique, String mappedBy) {
        super(parent, column, deleteAction, updateAction, indexed, unique, mappedBy);
    }

    public void populate(ClassLoaderResolver clr, ClassLoader primary) {
        AbstractMemberMetaData fmd = (AbstractMemberMetaData)this.parent;
        if (fmd.getMap() == null) {
            throw new NucleusUserException("The field " + fmd.getFullFieldName() + " is defined with <value>, however no <map> definition was found.").setFatal();
        }
        String valueType = fmd.getMap().getValueType();
        Class valueTypeClass = null;
        try {
            valueTypeClass = clr.classForName(valueType, primary);
        }
        catch (ClassNotResolvedException cnre) {
            try {
                valueTypeClass = clr.classForName(ClassUtils.getJavaLangClassForType(valueType), primary, false);
                fmd.getMap().value.type = valueTypeClass.getName();
            }
            catch (ClassNotResolvedException cnre2) {
                throw new InvalidMetaDataException(MetaData.LOCALISER, "044150", (Object)fmd.getFullFieldName(), (Object)fmd.getClassName(false), valueType);
            }
        }
        if (this.embeddedMetaData != null && (valueTypeClass.isInterface() || valueTypeClass.getName().equals("java.lang.Object"))) {
            throw new InvalidMetaDataException(MetaData.LOCALISER, "044152", (Object)fmd.getFullFieldName(), valueTypeClass.getName());
        }
        if (this.embeddedMetaData == null && ((AbstractMemberMetaData)this.parent).hasMap() && ((AbstractMemberMetaData)this.parent).getMap().isEmbeddedValue() && ((AbstractMemberMetaData)this.parent).getJoinMetaData() != null && ((AbstractMemberMetaData)this.parent).getMap().getValueClassMetaData() != null) {
            this.embeddedMetaData = new EmbeddedMetaData(this, null, null, null);
        }
        super.populate(clr, primary);
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<value");
        if (this.mappedBy != null) {
            sb.append(" mapped-by=\"" + this.mappedBy + "\"");
        }
        if (this.columnName != null) {
            sb.append("\n");
            sb.append(prefix).append("       column=\"" + this.columnName + "\"");
        }
        sb.append(">\n");
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnMetaData colmd = (ColumnMetaData)this.columns.get(i);
            sb.append(colmd.toString(prefix + indent, indent));
        }
        if (this.indexMetaData != null) {
            sb.append(this.indexMetaData.toString(prefix + indent, indent));
        }
        if (this.uniqueMetaData != null) {
            sb.append(this.uniqueMetaData.toString(prefix + indent, indent));
        }
        if (this.embeddedMetaData != null) {
            sb.append(this.embeddedMetaData.toString(prefix + indent, indent));
        }
        if (this.foreignKeyMetaData != null) {
            sb.append(this.foreignKeyMetaData.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</value>\n");
        return sb.toString();
    }
}

