/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jdo.metadata;

import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractElementMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FetchPlanMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.ImplementsMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.xml.AbstractMetaDataHandler;
import org.datanucleus.util.NucleusLogger;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class JDOMetaDataHandler
extends AbstractMetaDataHandler {
    public JDOMetaDataHandler(MetaDataManager mgr, String filename, EntityResolver resolver) {
        super(mgr, filename, resolver);
        this.metadata = new FileMetaData(filename, mgr, null, null);
        this.pushStack(this.metadata);
    }

    protected ClassMetaData newClassObject(PackageMetaData pmd, Attributes attrs) {
        ClassMetaData cmd = this.mgr.getMetaDataFactory().newClassObject(pmd, this.getAttr(attrs, "name"), this.getAttr(attrs, "identity-type"), this.getAttr(attrs, "objectid-class"), this.getAttr(attrs, "requires-extent"), this.getAttr(attrs, "detachable"), this.getAttr(attrs, "embedded-only"), this.getAttr(attrs, "persistence-modifier"), this.getAttr(attrs, "persistence-capable-superclass"), this.getAttr(attrs, "catalog"), this.getAttr(attrs, "schema"), this.getAttr(attrs, "table"), null);
        String cacheableAttr = this.getAttr(attrs, "cacheable");
        if (cacheableAttr != null) {
            cmd.setCacheable(!cacheableAttr.equalsIgnoreCase("false"));
        }
        return cmd;
    }

    protected InterfaceMetaData newInterfaceObject(PackageMetaData pmd, Attributes attrs) {
        InterfaceMetaData imd = this.mgr.getMetaDataFactory().newInterfaceObject(pmd, this.getAttr(attrs, "name"), this.getAttr(attrs, "identity-type"), this.getAttr(attrs, "objectid-class"), this.getAttr(attrs, "requires-extent"), this.getAttr(attrs, "detachable"), this.getAttr(attrs, "embedded-only"), this.getAttr(attrs, "catalog"), this.getAttr(attrs, "schema"), this.getAttr(attrs, "table"), null);
        String cacheableAttr = this.getAttr(attrs, "cacheable");
        if (cacheableAttr != null) {
            imd.setCacheable(!cacheableAttr.equalsIgnoreCase("false"));
        }
        return imd;
    }

    protected FieldMetaData newFieldObject(MetaData md, Attributes attrs) {
        FieldMetaData fmd = this.mgr.getMetaDataFactory().newFieldObject(md, this.getAttr(attrs, "name"), this.getAttr(attrs, "primary-key"), this.getAttr(attrs, "persistence-modifier"), this.getAttr(attrs, "default-fetch-group"), this.getAttr(attrs, "null-value"), this.getAttr(attrs, "embedded"), this.getAttr(attrs, "serialized"), this.getAttr(attrs, "dependent"), this.getAttr(attrs, "mapped-by"), this.getAttr(attrs, "column"), this.getAttr(attrs, "table"), null, null, this.getAttr(attrs, "delete-action"), this.getAttr(attrs, "indexed"), this.getAttr(attrs, "unique"), this.getAttr(attrs, "recursion-depth"), this.getAttr(attrs, "load-fetch-group"), this.getAttr(attrs, "value-strategy"), this.getAttr(attrs, "sequence"), this.getAttr(attrs, "field-type"));
        String cacheableAttr = this.getAttr(attrs, "cacheable");
        if (cacheableAttr != null) {
            fmd.setCacheable(!cacheableAttr.equalsIgnoreCase("false"));
        }
        return fmd;
    }

    protected PropertyMetaData newPropertyObject(MetaData md, Attributes attrs) {
        PropertyMetaData pmd = this.mgr.getMetaDataFactory().newPropertyObject(md, this.getAttr(attrs, "name"), this.getAttr(attrs, "primary-key"), this.getAttr(attrs, "persistence-modifier"), this.getAttr(attrs, "default-fetch-group"), this.getAttr(attrs, "null-value"), this.getAttr(attrs, "embedded"), this.getAttr(attrs, "serialized"), this.getAttr(attrs, "dependent"), this.getAttr(attrs, "mapped-by"), this.getAttr(attrs, "column"), this.getAttr(attrs, "table"), null, null, this.getAttr(attrs, "delete-action"), this.getAttr(attrs, "indexed"), this.getAttr(attrs, "unique"), this.getAttr(attrs, "recursion-depth"), this.getAttr(attrs, "load-fetch-group"), this.getAttr(attrs, "value-strategy"), this.getAttr(attrs, "sequence"), this.getAttr(attrs, "field-type"), this.getAttr(attrs, "field-name"));
        String cacheableAttr = this.getAttr(attrs, "cacheable");
        if (cacheableAttr != null) {
            pmd.setCacheable(!cacheableAttr.equalsIgnoreCase("false"));
        }
        return pmd;
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        block131: {
            if (this.charactersBuffer.length() > 0) {
                String currentString = this.getString().trim();
                if (this.getStack() instanceof QueryMetaData) {
                    ((QueryMetaData)this.getStack()).setQuery(currentString.trim());
                }
            }
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("<" + qName);
                for (int i = 0; i < attrs.getLength(); ++i) {
                    sb.append(" ");
                    sb.append(attrs.getQName(i)).append("=\"").append(attrs.getValue(i)).append("\"");
                }
                sb.append(">");
                NucleusLogger.METADATA.debug(AbstractMetaDataHandler.LOCALISER.msg("044034", (Object)sb.toString(), (Object)("" + this.stack.size())));
            }
            if (localName.length() < 1) {
                localName = qName;
            }
            try {
                AbstractMemberMetaData fmd;
                MetaData emd;
                MetaData parent;
                AbstractClassMetaData cmd;
                MetaData md;
                PackageMetaData pmd;
                FileMetaData filemd;
                if (localName.equals("jdo")) {
                    filemd = (FileMetaData)this.getStack();
                    filemd.setType(1);
                    filemd.setCatalog(this.getAttr(attrs, "catalog"));
                    filemd.setSchema(this.getAttr(attrs, "schema"));
                    break block131;
                }
                if (localName.equals("orm")) {
                    filemd = (FileMetaData)this.getStack();
                    filemd.setType(2);
                    filemd.setCatalog(this.getAttr(attrs, "catalog"));
                    filemd.setSchema(this.getAttr(attrs, "schema"));
                    break block131;
                }
                if (localName.equals("jdoquery")) {
                    filemd = (FileMetaData)this.getStack();
                    filemd.setType(3);
                    break block131;
                }
                if (localName.equals("fetch-plan")) {
                    filemd = (FileMetaData)this.getStack();
                    FetchPlanMetaData fpmd = new FetchPlanMetaData(filemd, this.getAttr(attrs, "name"), this.getAttr(attrs, "max-fetch-depth"), this.getAttr(attrs, "fetch-size"));
                    ((FileMetaData)this.metadata).addFetchPlan(fpmd);
                    this.pushStack(fpmd);
                    break block131;
                }
                if (localName.equals("package")) {
                    filemd = (FileMetaData)this.getStack();
                    PackageMetaData pmd2 = new PackageMetaData(filemd, this.getAttr(attrs, "name"), this.getAttr(attrs, "catalog"), this.getAttr(attrs, "schema"));
                    ((FileMetaData)this.metadata).addPackage(pmd2);
                    this.pushStack(pmd2);
                    break block131;
                }
                if (localName.equals("class")) {
                    pmd = (PackageMetaData)this.getStack();
                    ClassMetaData cmd2 = this.newClassObject(pmd, attrs);
                    pmd.addClass(cmd2);
                    this.pushStack(cmd2);
                    break block131;
                }
                if (localName.equals("interface")) {
                    pmd = (PackageMetaData)this.getStack();
                    InterfaceMetaData imd = this.newInterfaceObject(pmd, attrs);
                    pmd.addInterface(imd);
                    this.pushStack(imd);
                    break block131;
                }
                if (localName.equals("primary-key")) {
                    md = this.getStack();
                    PrimaryKeyMetaData pkmd = new PrimaryKeyMetaData(md, this.getAttr(attrs, "name"), this.getAttr(attrs, "column"));
                    if (md instanceof AbstractClassMetaData) {
                        ((AbstractClassMetaData)md).setPrimaryKeyMetaData(pkmd);
                    } else if (md instanceof JoinMetaData) {
                        ((JoinMetaData)md).setPrimaryKeyMetaData(pkmd);
                    }
                    this.pushStack(pkmd);
                    break block131;
                }
                if (localName.equals("implements")) {
                    cmd = (ClassMetaData)this.getStack();
                    ImplementsMetaData imd = new ImplementsMetaData((ClassMetaData)cmd, this.getAttr(attrs, "name"));
                    ((ClassMetaData)cmd).addImplements(imd);
                    this.pushStack(imd);
                    break block131;
                }
                if (localName.equals("property")) {
                    parent = this.getStack();
                    if (parent instanceof AbstractClassMetaData) {
                        AbstractClassMetaData acmd = (AbstractClassMetaData)parent;
                        PropertyMetaData propmd = this.newPropertyObject(acmd, attrs);
                        acmd.addMember(propmd);
                        this.pushStack(propmd);
                    } else if (parent instanceof EmbeddedMetaData) {
                        EmbeddedMetaData emd2 = (EmbeddedMetaData)parent;
                        PropertyMetaData propmd = this.newPropertyObject(emd2, attrs);
                        emd2.addMember(propmd);
                        this.pushStack(propmd);
                    } else if (parent instanceof ImplementsMetaData) {
                        ImplementsMetaData implmd = (ImplementsMetaData)parent;
                        PropertyMetaData propmd = this.newPropertyObject(implmd, attrs);
                        implmd.addProperty(propmd);
                        this.pushStack(propmd);
                    } else if (parent instanceof FetchGroupMetaData) {
                        FetchGroupMetaData fgmd = (FetchGroupMetaData)parent;
                        PropertyMetaData propmd = this.newPropertyObject(fgmd, attrs);
                        fgmd.addMember(propmd);
                        this.pushStack(propmd);
                    }
                    break block131;
                }
                if (localName.equals("datastore-identity")) {
                    AbstractClassMetaData acmd = (AbstractClassMetaData)this.getStack();
                    IdentityMetaData imd = new IdentityMetaData(acmd, this.getAttr(attrs, "column"), this.getAttr(attrs, "strategy"), this.getAttr(attrs, "sequence"));
                    acmd.setIdentityMetaData(imd);
                    this.pushStack(imd);
                    break block131;
                }
                if (localName.equals("inheritance")) {
                    parent = this.getStack();
                    AbstractClassMetaData acmd = (AbstractClassMetaData)parent;
                    InheritanceMetaData imd = new InheritanceMetaData(acmd, this.getAttr(attrs, "strategy"));
                    acmd.setInheritanceMetaData(imd);
                    this.pushStack(imd);
                    break block131;
                }
                if (localName.equals("discriminator")) {
                    InheritanceMetaData imd = (InheritanceMetaData)this.getStack();
                    DiscriminatorMetaData dismd = new DiscriminatorMetaData(imd, this.getAttr(attrs, "column"), this.getAttr(attrs, "value"), this.getAttr(attrs, "strategy"), this.getAttr(attrs, "indexed"));
                    imd.setDiscriminatorMetaData(dismd);
                    this.pushStack(dismd);
                    break block131;
                }
                if (localName.equals("query")) {
                    QueryMetaData qmd = new QueryMetaData(emd, (emd = this.getStack()) instanceof ClassMetaData ? ((ClassMetaData)emd).getFullClassName() : null, this.getAttr(attrs, "name"), this.getAttr(attrs, "language"), this.getAttr(attrs, "unmodifiable"), this.getAttr(attrs, "result-class"), null, this.getAttr(attrs, "unique"), this.getAttr(attrs, "fetch-plan"));
                    if (emd instanceof ClassMetaData) {
                        ClassMetaData cmd3 = (ClassMetaData)emd;
                        cmd3.addQuery(qmd);
                    } else if (emd instanceof FileMetaData) {
                        FileMetaData fmd2 = (FileMetaData)emd;
                        fmd2.addQuery(qmd);
                    }
                    this.pushStack(qmd);
                    break block131;
                }
                if (localName.equals("sequence")) {
                    emd = this.getStack();
                    SequenceMetaData seqmd = new SequenceMetaData(emd, this.getAttr(attrs, "name"), this.getAttr(attrs, "datastore-sequence"), this.getAttr(attrs, "factory-class"), this.getAttr(attrs, "strategy"), null, null);
                    if (emd instanceof PackageMetaData) {
                        PackageMetaData pmd3 = (PackageMetaData)emd;
                        pmd3.addSequence(seqmd);
                    }
                    this.pushStack(seqmd);
                    break block131;
                }
                if (localName.equals("field")) {
                    md = this.getStack();
                    FieldMetaData fmd3 = this.newFieldObject(md, attrs);
                    if (md instanceof ClassMetaData) {
                        ClassMetaData cmd4 = (ClassMetaData)md;
                        cmd4.addMember(fmd3);
                    } else if (md instanceof FetchGroupMetaData) {
                        FetchGroupMetaData fgmd = (FetchGroupMetaData)md;
                        fgmd.addMember(fmd3);
                    } else if (md instanceof EmbeddedMetaData) {
                        EmbeddedMetaData emd3 = (EmbeddedMetaData)md;
                        emd3.addMember(fmd3);
                    } else if (md instanceof ForeignKeyMetaData) {
                        ForeignKeyMetaData fkmd = (ForeignKeyMetaData)md;
                        fkmd.addMember(fmd3);
                    } else if (md instanceof IndexMetaData) {
                        IndexMetaData imd = (IndexMetaData)md;
                        imd.addMember(fmd3);
                    } else if (md instanceof UniqueMetaData) {
                        UniqueMetaData umd = (UniqueMetaData)md;
                        umd.addMember(fmd3);
                    }
                    this.pushStack(fmd3);
                    break block131;
                }
                if (localName.equals("join")) {
                    parent = this.getStack();
                    JoinMetaData jnmd = new JoinMetaData(parent, this.getAttr(attrs, "table"), null, null, this.getAttr(attrs, "column"), this.getAttr(attrs, "outer"), this.getAttr(attrs, "delete-action"), this.getAttr(attrs, "indexed"), this.getAttr(attrs, "unique"));
                    if (parent instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd4 = (AbstractMemberMetaData)parent;
                        fmd4.setJoinMetaData(jnmd);
                    } else if (parent instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd5 = (AbstractClassMetaData)parent;
                        cmd5.addJoin(jnmd);
                    } else if (parent instanceof InheritanceMetaData) {
                        InheritanceMetaData imd = (InheritanceMetaData)parent;
                        imd.setJoinMetaData(jnmd);
                    }
                    this.pushStack(jnmd);
                    break block131;
                }
                if (localName.equals("map")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    MapMetaData map = new MapMetaData(fmd, this.getAttr(attrs, "key-type"), this.getAttr(attrs, "embedded-key"), this.getAttr(attrs, "dependent-key"), this.getAttr(attrs, "serialized-key"), this.getAttr(attrs, "value-type"), this.getAttr(attrs, "embedded-value"), this.getAttr(attrs, "dependent-value"), this.getAttr(attrs, "serialized-value"));
                    fmd.setContainer(map);
                    this.pushStack(map);
                    break block131;
                }
                if (localName.equals("array")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    ArrayMetaData amd = new ArrayMetaData(fmd, this.getAttr(attrs, "element-type"), this.getAttr(attrs, "embedded-element"), this.getAttr(attrs, "dependent-element"), this.getAttr(attrs, "serialized-element"));
                    fmd.setContainer(amd);
                    this.pushStack(amd);
                    break block131;
                }
                if (localName.equals("collection")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    CollectionMetaData colmd = new CollectionMetaData(fmd, this.getAttr(attrs, "element-type"), this.getAttr(attrs, "embedded-element"), this.getAttr(attrs, "dependent-element"), this.getAttr(attrs, "serialized-element"));
                    fmd.setContainer(colmd);
                    this.pushStack(colmd);
                    break block131;
                }
                if (localName.equals("column")) {
                    md = this.getStack();
                    ColumnMetaData clnmd = new ColumnMetaData(md, this.getAttr(attrs, "name"), this.getAttr(attrs, "target"), this.getAttr(attrs, "target-field"), this.getAttr(attrs, "jdbc-type"), this.getAttr(attrs, "sql-type"), this.getAttr(attrs, "length"), this.getAttr(attrs, "scale"), this.getAttr(attrs, "allows-null"), this.getAttr(attrs, "default-value"), this.getAttr(attrs, "insert-value"), null, null, null);
                    if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd5 = (AbstractMemberMetaData)md;
                        fmd5.addColumn(clnmd);
                    } else if (md instanceof AbstractElementMetaData) {
                        AbstractElementMetaData elemd = (AbstractElementMetaData)md;
                        elemd.addColumn(clnmd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData jnmd = (JoinMetaData)md;
                        jnmd.addColumn(clnmd);
                    } else if (md instanceof IdentityMetaData) {
                        IdentityMetaData idmd = (IdentityMetaData)md;
                        idmd.addColumn(clnmd);
                    } else if (md instanceof ForeignKeyMetaData) {
                        ForeignKeyMetaData fkmd = (ForeignKeyMetaData)md;
                        fkmd.addColumn(clnmd);
                    } else if (md instanceof IndexMetaData) {
                        IndexMetaData idxmd = (IndexMetaData)md;
                        idxmd.addColumn(clnmd);
                    } else if (md instanceof UniqueMetaData) {
                        UniqueMetaData unimd = (UniqueMetaData)md;
                        unimd.addColumn(clnmd);
                    } else if (md instanceof OrderMetaData) {
                        OrderMetaData ormd = (OrderMetaData)md;
                        ormd.addColumn(clnmd);
                    } else if (md instanceof DiscriminatorMetaData) {
                        DiscriminatorMetaData dismd = (DiscriminatorMetaData)md;
                        dismd.setColumnMetaData(clnmd);
                    } else if (md instanceof VersionMetaData) {
                        VersionMetaData vermd = (VersionMetaData)md;
                        vermd.addColumn(clnmd);
                    } else if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd6 = (AbstractClassMetaData)md;
                        cmd6.addUnmappedColumn(clnmd);
                    } else if (md instanceof PrimaryKeyMetaData) {
                        PrimaryKeyMetaData pkmd = (PrimaryKeyMetaData)md;
                        pkmd.addColumn(clnmd);
                    }
                    this.pushStack(clnmd);
                    break block131;
                }
                if (localName.equals("element")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    ElementMetaData elemd = new ElementMetaData(fmd, this.getAttr(attrs, "column"), this.getAttr(attrs, "delete-action"), this.getAttr(attrs, "update-action"), this.getAttr(attrs, "indexed"), this.getAttr(attrs, "unique"), this.getAttr(attrs, "mapped-by"));
                    fmd.setElementMetaData(elemd);
                    this.pushStack(elemd);
                    break block131;
                }
                if (localName.equals("key")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    KeyMetaData keymd = new KeyMetaData(fmd, this.getAttr(attrs, "column"), this.getAttr(attrs, "delete-action"), this.getAttr(attrs, "update-action"), this.getAttr(attrs, "indexed"), this.getAttr(attrs, "unique"), this.getAttr(attrs, "mapped-by"));
                    fmd.setKeyMetaData(keymd);
                    this.pushStack(keymd);
                    break block131;
                }
                if (localName.equals("value")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    ValueMetaData valuemd = new ValueMetaData(fmd, this.getAttr(attrs, "column"), this.getAttr(attrs, "delete-action"), this.getAttr(attrs, "update-action"), this.getAttr(attrs, "indexed"), this.getAttr(attrs, "unique"), this.getAttr(attrs, "mapped-by"));
                    fmd.setValueMetaData(valuemd);
                    this.pushStack(valuemd);
                    break block131;
                }
                if (localName.equals("fetch-group")) {
                    md = this.getStack();
                    FetchGroupMetaData fgmd = new FetchGroupMetaData(md, this.getAttr(attrs, "post-load"), this.getAttr(attrs, "name"));
                    if (md instanceof FetchGroupMetaData) {
                        FetchGroupMetaData fgmdParent = (FetchGroupMetaData)md;
                        fgmdParent.addFetchGroup(fgmd);
                    } else if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd7 = (AbstractClassMetaData)md;
                        cmd7.addFetchGroup(fgmd);
                    } else if (md instanceof FetchPlanMetaData) {
                        FetchPlanMetaData fpmd = (FetchPlanMetaData)md;
                        fpmd.addFetchGroup(fgmd);
                    }
                    this.pushStack(fgmd);
                    break block131;
                }
                if (localName.equals("extension")) {
                    md = this.getStack();
                    md.addExtension(this.getAttr(attrs, "vendor-name"), this.getAttr(attrs, "key"), this.getAttr(attrs, "value"));
                    break block131;
                }
                if (localName.equals("version")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    VersionMetaData vermd = new VersionMetaData(this.getAttr(attrs, "strategy"), this.getAttr(attrs, "column"), this.getAttr(attrs, "indexed"));
                    cmd.setVersionMetaData(vermd);
                    this.pushStack(vermd);
                    break block131;
                }
                if (localName.equals("index")) {
                    md = this.getStack();
                    IndexMetaData idxmd = new IndexMetaData(this.getAttr(attrs, "name"), this.getAttr(attrs, "table"), this.getAttr(attrs, "unique"));
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd8 = (AbstractClassMetaData)md;
                        cmd8.addIndex(idxmd);
                    } else if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd6 = (AbstractMemberMetaData)md;
                        fmd6.setIndexMetaData(idxmd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData jmd = (JoinMetaData)md;
                        jmd.setIndexMetaData(idxmd);
                    } else if (md instanceof AbstractElementMetaData) {
                        AbstractElementMetaData elmd = (AbstractElementMetaData)md;
                        elmd.setIndexMetaData(idxmd);
                    } else if (md instanceof OrderMetaData) {
                        OrderMetaData omd = (OrderMetaData)md;
                        omd.setIndexMetaData(idxmd);
                    } else if (md instanceof VersionMetaData) {
                        VersionMetaData vermd = (VersionMetaData)md;
                        vermd.setIndexMetaData(idxmd);
                    } else if (md instanceof DiscriminatorMetaData) {
                        DiscriminatorMetaData dismd = (DiscriminatorMetaData)md;
                        dismd.setIndexMetaData(idxmd);
                    }
                    this.pushStack(idxmd);
                    break block131;
                }
                if (localName.equals("unique")) {
                    md = this.getStack();
                    UniqueMetaData unimd = new UniqueMetaData(this.getAttr(attrs, "name"), this.getAttr(attrs, "table"), this.getAttr(attrs, "deferred"));
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd9 = (AbstractClassMetaData)md;
                        cmd9.addUniqueConstraint(unimd);
                    } else if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd7 = (AbstractMemberMetaData)md;
                        fmd7.setUniqueMetaData(unimd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData jmd = (JoinMetaData)md;
                        jmd.setUniqueMetaData(unimd);
                    } else if (md instanceof AbstractElementMetaData) {
                        AbstractElementMetaData elmd = (AbstractElementMetaData)md;
                        elmd.setUniqueMetaData(unimd);
                    }
                    this.pushStack(unimd);
                    break block131;
                }
                if (localName.equals("foreign-key")) {
                    md = this.getStack();
                    ForeignKeyMetaData fkmd = new ForeignKeyMetaData(this.getAttr(attrs, "name"), this.getAttr(attrs, "table"), this.getAttr(attrs, "unique"), this.getAttr(attrs, "deferred"), this.getAttr(attrs, "delete-action"), this.getAttr(attrs, "update-action"));
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd10 = (AbstractClassMetaData)md;
                        cmd10.addForeignKey(fkmd);
                    } else if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd8 = (AbstractMemberMetaData)md;
                        fmd8.setForeignKeyMetaData(fkmd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData jmd = (JoinMetaData)md;
                        jmd.setForeignKeyMetaData(fkmd);
                    } else if (md instanceof AbstractElementMetaData) {
                        AbstractElementMetaData elmd = (AbstractElementMetaData)md;
                        elmd.setForeignKeyMetaData(fkmd);
                    }
                    this.pushStack(fkmd);
                    break block131;
                }
                if (localName.equals("order")) {
                    OrderMetaData ormd = new OrderMetaData(this.getAttr(attrs, "column"), this.getAttr(attrs, "indexed"), this.getAttr(attrs, "mapped-by"));
                    AbstractMemberMetaData fmd9 = (AbstractMemberMetaData)this.getStack();
                    fmd9.setOrderMetaData(ormd);
                    this.pushStack(ormd);
                    break block131;
                }
                if (localName.equals("embedded")) {
                    md = this.getStack();
                    EmbeddedMetaData emd4 = new EmbeddedMetaData(md, this.getAttr(attrs, "owner-field"), this.getAttr(attrs, "null-indicator-column"), this.getAttr(attrs, "null-indicator-value"));
                    if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd10 = (AbstractMemberMetaData)md;
                        fmd10.setEmbeddedMetaData(emd4);
                    } else if (md instanceof KeyMetaData) {
                        KeyMetaData kmd = (KeyMetaData)md;
                        kmd.setEmbeddedMetaData(emd4);
                    } else if (md instanceof ValueMetaData) {
                        ValueMetaData vmd = (ValueMetaData)md;
                        vmd.setEmbeddedMetaData(emd4);
                    } else if (md instanceof ElementMetaData) {
                        ElementMetaData elmd = (ElementMetaData)md;
                        elmd.setEmbeddedMetaData(emd4);
                    }
                    this.pushStack(emd4);
                    break block131;
                }
                String message = AbstractMetaDataHandler.LOCALISER.msg("044037", (Object)qName);
                NucleusLogger.METADATA.error(message);
                throw new RuntimeException(message);
            }
            catch (RuntimeException ex) {
                NucleusLogger.METADATA.error(AbstractMetaDataHandler.LOCALISER.msg("044042", (Object)qName, (Object)this.getStack(), (Object)uri), ex);
                throw ex;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentString;
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(AbstractMetaDataHandler.LOCALISER.msg("044035", (Object)("<" + qName + ">"), (Object)("" + this.stack.size())));
        }
        if (localName.length() < 1) {
            localName = qName;
        }
        if ((currentString = this.getString().trim()).length() > 0) {
            MetaData md = this.getStack();
            if (localName.equals("query")) {
                ((QueryMetaData)md).setQuery(currentString);
            }
        }
        if (localName.equals("package") || localName.equals("fetch-plan") || localName.equals("class") || localName.equals("interface") || localName.equals("implements") || localName.equals("property") || localName.equals("datastore-identity") || localName.equals("inheritance") || localName.equals("primary-key") || localName.equals("version") || localName.equals("unmapped") || localName.equals("query") || localName.equals("sequence") || localName.equals("field") || localName.equals("map") || localName.equals("element") || localName.equals("embedded") || localName.equals("key") || localName.equals("value") || localName.equals("array") || localName.equals("collection") || localName.equals("join") || localName.equals("index") || localName.equals("unique") || localName.equals("foreign-key") || localName.equals("order") || localName.equals("fetch-group") || localName.equals("column") || localName.equals("discriminator")) {
            this.popStack();
        }
    }
}

