/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra;

import com.datastax.driver.core.Session;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.cassandra.CassandraPersistenceHandler;
import org.datanucleus.store.cassandra.CassandraSchemaHandler;
import org.datanucleus.store.cassandra.SchemaVerifierImpl;
import org.datanucleus.store.cassandra.SessionStatementProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.schema.SchemaAwareStoreManager;
import org.datanucleus.store.schema.naming.NamingCase;
import org.datanucleus.store.schema.table.CompleteClassTable;
import org.datanucleus.store.schema.table.SchemaVerifier;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class CassandraStoreManager
extends AbstractStoreManager
implements SchemaAwareStoreManager {
    public static final String PROPERTY_CASSANDRA_ENFORCE_UNIQUENESS_IN_APPLICATION = "datanucleus.cassandra.enforceUniquenessInApplication";
    public static final String EXTENSION_CASSANDRA_INSERT_USING = "cassandra.insert.using";
    public static final String EXTENSION_CASSANDRA_UPDATE_USING = "cassandra.update.using";
    public static final String EXTENSION_CASSANDRA_DELETE_USING = "cassandra.delete.using";
    SessionStatementProvider stmtProvider = new SessionStatementProvider();
    public static final String RESERVED_WORDS = "ADD,ALLOW,ALTER,AND,ANY,APPLY,ASC,AUTHORIZE,BATCH,BEGIN,BY,COLUMNFAMILY,CREATE,DELETE,DESC,DROP,FROM,GRANT,IN,INDEX,INET,INSERT,INTO,KEYSPACE,KEYSPACES,LIMIT,MODIFY,NORECURSIVE,OF,ON,ONE,ORDER,PASSWORD,PRIMARY,QUORUM,RENAME,REVOKE,SCHEMA,SELECT,SET,TABLE,TO,TOKEN,THREE,TRUNCATE,TWO,UNLOGGED,UPDATE,USE,USING,WHERE,WITH";

    public CassandraStoreManager(ClassLoaderResolver clr, PersistenceNucleusContext nucleusCtx, Map<String, Object> props) {
        super("cassandra", clr, nucleusCtx, props);
        nucleusCtx.getTypeManager().setDefaultTypeConverterForType(BufferedImage.class, "dn.bufferedimage-bytebuffer");
        this.getNamingFactory().setReservedKeywords(StringUtils.convertCommaSeparatedStringToSet((String)RESERVED_WORDS));
        String namingCase = this.getStringProperty("datanucleus.identifier.case");
        if (!StringUtils.isWhitespace((String)namingCase)) {
            if (namingCase.equalsIgnoreCase("UPPERCASE")) {
                this.getNamingFactory().setNamingCase(NamingCase.UPPER_CASE_QUOTED);
            } else if (namingCase.equalsIgnoreCase("lowercase")) {
                this.getNamingFactory().setNamingCase(NamingCase.LOWER_CASE);
            } else {
                this.getNamingFactory().setNamingCase(NamingCase.MIXED_CASE_QUOTED);
            }
        } else {
            this.getNamingFactory().setNamingCase(NamingCase.LOWER_CASE);
        }
        this.schemaHandler = new CassandraSchemaHandler(this);
        this.persistenceHandler = new CassandraPersistenceHandler((StoreManager)this);
        this.logConfiguration();
    }

    public Collection<String> getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationId");
        set.add("ApplicationCompositeId");
        set.add("DatastoreId");
        set.add("ORM");
        set.add("ORM.EmbeddedPC");
        set.add("ORM.SerialisedPC");
        set.add("Datastore.Time.Millisecs");
        set.add("Query.JDOQL.BulkDelete");
        set.add("Query.JPQL.BulkDelete");
        set.add("ORM.Inheritance.CompleteTable");
        return set;
    }

    public String getNativeQueryLanguage() {
        return "CQL";
    }

    public SessionStatementProvider getStatementProvider() {
        return this.stmtProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manageClasses(ClassLoaderResolver clr, String ... classNames) {
        if (classNames == null) {
            return;
        }
        ManagedConnection mconn = this.connectionMgr.getConnection(-1);
        try {
            Session session = (Session)mconn.getConnection();
            this.manageClasses(classNames, clr, session);
        }
        finally {
            mconn.release();
        }
    }

    public void manageClasses(String[] classNames, ClassLoaderResolver clr, Session session) {
        if (classNames == null) {
            return;
        }
        String[] filteredClassNames = this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        HashSet<String> clsNameSet = new HashSet<String>();
        for (ClassMetaData cmd : this.getMetaDataManager().getReferencedClasses(filteredClassNames, clr)) {
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd.isEmbeddedOnly() || cmd.isAbstract() || this.storeDataMgr.managesClass(cmd.getFullClassName())) continue;
            StoreData sd = this.storeDataMgr.get(cmd.getFullClassName());
            if (sd == null) {
                CompleteClassTable table = new CompleteClassTable((StoreManager)this, (AbstractClassMetaData)cmd, (SchemaVerifier)new SchemaVerifierImpl((StoreManager)this, (AbstractClassMetaData)cmd, clr));
                sd = this.newStoreData(cmd, clr);
                sd.setTable((Table)table);
                this.registerStoreData(sd);
            }
            clsNameSet.add(cmd.getFullClassName());
        }
        this.schemaHandler.createSchemaForClasses(clsNameSet, null, (Object)session);
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        if (id == null) {
            return null;
        }
        if (id instanceof SCOID) {
            return ((SCOID)id).getSCOClass();
        }
        String rootClassName = super.getClassNameForObjectID(id, clr, ec);
        if (rootClassName != null) {
            String[] subclasses = this.getMetaDataManager().getSubclassesForClass(rootClassName, true);
            if (subclasses == null || subclasses.length == 0) {
                return rootClassName;
            }
            return rootClassName;
        }
        return null;
    }

    public void createDatabase(String catalogName, String schemaName, Properties props) {
        this.schemaHandler.createDatabase(catalogName, schemaName, props, null);
    }

    public void deleteDatabase(String catalogName, String schemaName, Properties props) {
        this.schemaHandler.deleteDatabase(catalogName, schemaName, props, null);
    }

    public void createSchemaForClasses(Set<String> classNames, Properties props) {
        this.schemaHandler.createSchemaForClasses(classNames, props, null);
    }

    public void deleteSchemaForClasses(Set<String> classNames, Properties props) {
        this.schemaHandler.deleteSchemaForClasses(classNames, props, null);
    }

    public void validateSchemaForClasses(Set<String> classNames, Properties props) {
        this.schemaHandler.validateSchema(classNames, props, null);
    }

    static {
        Localiser.registerBundle((String)"org.datanucleus.store.cassandra.Localisation", (ClassLoader)CassandraStoreManager.class.getClassLoader());
    }
}

