/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.query;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.query.evaluator.JPQLEvaluator;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.cassandra.CassandraStoreManager;
import org.datanucleus.store.cassandra.CassandraUtils;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.NucleusLogger;

public class JPQLQuery
extends AbstractJPQLQuery {
    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (Object)((JPQLQuery)null));
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, Object q) {
        super(storeMgr, ec, (AbstractJPQLQuery)((JPQLQuery)((Object)q)));
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        ManagedConnection mconn = this.getStoreManager().getConnection(this.ec);
        try {
            Session session = (Session)mconn.getConnection();
            long startTime = 0L;
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JPQL", (Object)this.getSingleStringQuery(), null));
            }
            ArrayList candidates = null;
            candidates = this.candidateCollection == null ? this.getCandidatesForQuery(session) : new ArrayList(this.candidateCollection);
            JPQLEvaluator resultMapper = new JPQLEvaluator((Query)this, candidates, this.compilation, parameters, this.ec.getClassLoaderResolver());
            Collection results = resultMapper.execute(true, true, true, true, true);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)"JPQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            if (this.type == 2) {
                this.ec.deleteObjects(results.toArray());
                Long l = results.size();
                return l;
            }
            if (this.type == 1) {
                throw new NucleusException("Bulk Update is not yet supported");
            }
            Collection collection = results;
            return collection;
        }
        finally {
            mconn.release();
        }
    }

    protected List getCandidatesForQuery(Session session) {
        ArrayList<Object> candidateObjs = new ArrayList<Object>();
        CassandraStoreManager storeMgr = (CassandraStoreManager)this.storeMgr;
        List cmds = MetaDataUtils.getMetaDataForCandidates((Class)this.getCandidateClass(), (boolean)this.isSubclasses(), (ExecutionContext)this.ec);
        for (AbstractClassMetaData cmd : cmds) {
            storeMgr.manageClasses(this.clr, cmd.getFullClassName());
            StringBuilder stmtBuilder = new StringBuilder("SELECT * FROM ");
            Table table = (Table)storeMgr.getStoreDataForClass(cmd.getFullClassName()).getProperties().get("tableObject");
            stmtBuilder.append(table.getSchemaName()).append('.').append(table.getIdentifier());
            if (storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
                String multitenancyValue = storeMgr.getStringProperty("datanucleus.TenantID");
                stmtBuilder.append(" WHERE ").append(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.MULTITENANCY_COLUMN)).append("='").append(multitenancyValue).append("'");
            }
            CassandraUtils.logCqlStatement(stmtBuilder.toString(), null, NucleusLogger.DATASTORE_NATIVE);
            ResultSet rs = session.execute(stmtBuilder.toString());
            for (Row row : rs) {
                candidateObjs.add(CassandraUtils.getPojoForRowForCandidate(row, cmd, this.ec, this.getFetchPlan().getFetchPlanForClass(cmd).getMemberNumbers(), this.getIgnoreCache()));
            }
        }
        return candidateObjs;
    }
}

