/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.query;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.query.evaluator.JDOQLEvaluator;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.cassandra.CassandraStoreManager;
import org.datanucleus.store.cassandra.CassandraUtils;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.NucleusLogger;

public class JDOQLQuery
extends AbstractJDOQLQuery {
    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (JDOQLQuery)null);
    }

    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec, JDOQLQuery q) {
        super(storeMgr, ec, (AbstractJDOQLQuery)q);
    }

    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        ManagedConnection mconn = this.getStoreManager().getConnection(this.ec);
        try {
            Session session = (Session)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JDOQL", (Object)this.getSingleStringQuery(), null));
            }
            ArrayList candidates = null;
            candidates = this.candidateCollection == null ? this.getCandidatesForQuery(session) : new ArrayList(this.candidateCollection);
            JDOQLEvaluator resultMapper = new JDOQLEvaluator((Query)this, candidates, this.compilation, parameters, this.ec.getClassLoaderResolver());
            Collection results = resultMapper.execute(true, true, true, true, true);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)"JDOQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            Collection collection = results;
            return collection;
        }
        finally {
            mconn.release();
        }
    }

    protected List getCandidatesForQuery(Session session) {
        ArrayList<Object> candidateObjs = new ArrayList<Object>();
        CassandraStoreManager storeMgr = (CassandraStoreManager)this.storeMgr;
        List cmds = MetaDataUtils.getMetaDataForCandidates((Class)this.getCandidateClass(), (boolean)this.isSubclasses(), (ExecutionContext)this.ec);
        for (AbstractClassMetaData cmd : cmds) {
            storeMgr.manageClasses(this.clr, cmd.getFullClassName());
            StringBuilder stmtBuilder = new StringBuilder("SELECT * FROM ");
            Table table = (Table)storeMgr.getStoreDataForClass(cmd.getFullClassName()).getProperties().get("tableObject");
            stmtBuilder.append(table.getSchemaName()).append('.').append(table.getIdentifier());
            if (storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
                String multitenancyValue = storeMgr.getStringProperty("datanucleus.TenantID");
                stmtBuilder.append(" WHERE ").append(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.MULTITENANCY_COLUMN)).append("='").append(multitenancyValue).append("'");
            }
            CassandraUtils.logCqlStatement(stmtBuilder.toString(), null, NucleusLogger.DATASTORE_NATIVE);
            ResultSet rs = session.execute(stmtBuilder.toString());
            for (Row row : rs) {
                candidateObjs.add(CassandraUtils.getPojoForRowForCandidate(row, cmd, this.ec, this.getFetchPlan().getFetchPlanForClass(cmd).getMemberNumbers(), this.getIgnoreCache()));
            }
        }
        return candidateObjs;
    }
}

