/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra;

import com.datastax.driver.core.Row;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.cassandra.fieldmanager.FetchFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class CassandraUtils {
    static Map<String, String> cassandraTypeByJavaType = new HashMap<String, String>();

    public static String getCassandraColumnTypeForMember(AbstractMemberMetaData mmd, TypeManager typeMgr, ClassLoaderResolver clr) {
        Class type;
        String cTypeName;
        String jdbcType;
        ColumnMetaData[] colmds = mmd.getColumnMetaData();
        if (colmds != null && colmds.length == 1 && !StringUtils.isWhitespace((String)(jdbcType = colmds[0].getJdbcType()))) {
            if (jdbcType.equalsIgnoreCase("varchar") || jdbcType.equalsIgnoreCase("longvarchar")) {
                return "varchar";
            }
            if (jdbcType.equalsIgnoreCase("bigint")) {
                return "bigint";
            }
            if (jdbcType.equalsIgnoreCase("blob")) {
                return "blob";
            }
            if (jdbcType.equalsIgnoreCase("decimal")) {
                return "double";
            }
            if (jdbcType.equalsIgnoreCase("integer")) {
                return "int";
            }
        }
        if ((cTypeName = cassandraTypeByJavaType.get((type = mmd.getType()).getName())) != null) {
            return cTypeName;
        }
        if (mmd.isSerialized() && Serializable.class.isAssignableFrom(type)) {
            return "blob";
        }
        if (Enum.class.isAssignableFrom(type)) {
            return "int";
        }
        RelationType relType = mmd.getRelationType(clr);
        if (RelationType.isRelationSingleValued((RelationType)relType)) {
            return mmd.isSerialized() ? "blob" : "varchar";
        }
        if (RelationType.isRelationMultiValued((RelationType)relType)) {
            if (mmd.hasCollection()) {
                if (List.class.isAssignableFrom(mmd.getType())) {
                    return mmd.getCollection().isSerializedElement() ? "list<blob>" : "list<varchar>";
                }
                if (Set.class.isAssignableFrom(mmd.getType())) {
                    return mmd.getCollection().isSerializedElement() ? "set<blob>" : "set<varchar>";
                }
                if (mmd.getOrderMetaData() != null) {
                    return mmd.getCollection().isSerializedElement() ? "list<blob>" : "list<varchar>";
                }
                return mmd.getCollection().isSerializedElement() ? "set<blob>" : "set<varchar>";
            }
            if (mmd.hasMap()) {
                String keyType = null;
                String valType = null;
                keyType = mmd.getMap().keyIsPersistent() ? (mmd.getMap().isSerializedKey() ? "blob" : "varchar") : cassandraTypeByJavaType.get(mmd.getMap().getKeyType());
                valType = mmd.getMap().valueIsPersistent() ? (mmd.getMap().isSerializedValue() ? "blob" : "varchar") : cassandraTypeByJavaType.get(mmd.getMap().getValueType());
                return "map<" + keyType + "," + valType + ">";
            }
        } else {
            if (mmd.hasCollection()) {
                String cqlElementType;
                String elementType = mmd.getCollection().getElementType();
                String string = cqlElementType = mmd.getCollection().isSerializedElement() ? "blob" : cassandraTypeByJavaType.get(elementType);
                if (cqlElementType != null) {
                    if (List.class.isAssignableFrom(mmd.getType())) {
                        return "list<" + cqlElementType + ">";
                    }
                    if (Set.class.isAssignableFrom(mmd.getType())) {
                        return "set<" + cqlElementType + ">";
                    }
                    if (mmd.getOrderMetaData() != null) {
                        return "list<" + cqlElementType + ">";
                    }
                    return "set<" + cqlElementType + ">";
                }
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)("Unable to generate schema for collection element of type " + elementType + ". Please report this"));
            } else if (mmd.hasMap()) {
                String cqlValType;
                String keyType = mmd.getMap().getKeyType();
                String valType = mmd.getMap().getValueType();
                String cqlKeyType = mmd.getMap().isSerializedKey() ? "blob" : cassandraTypeByJavaType.get(keyType);
                String string = cqlValType = mmd.getMap().isSerializedValue() ? "blob" : cassandraTypeByJavaType.get(valType);
                if (cqlKeyType != null && cqlValType != null) {
                    return "map<" + cqlKeyType + "," + cqlValType + ">";
                }
                if (cqlKeyType == null) {
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)("Unable to generate schema for map key of type " + keyType + ". Please report this"));
                }
                if (cqlValType == null) {
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)("Unable to generate schema for map value of type " + valType + ". Please report this"));
                }
            }
            TypeConverter stringConverter = typeMgr.getTypeConverterForType(type, String.class);
            if (stringConverter != null) {
                return "varchar";
            }
            TypeConverter longConverter = typeMgr.getTypeConverterForType(type, Long.class);
            if (longConverter != null) {
                return "bigint";
            }
            TypeConverter intConverter = typeMgr.getTypeConverterForType(type, Integer.class);
            if (intConverter != null) {
                return "int";
            }
            if (Serializable.class.isAssignableFrom(type)) {
                return "blob";
            }
        }
        return "varchar";
    }

    public static String getCassandraTypeForNonPersistableType(Class type, boolean serialised, TypeManager typeMgr, String jdbcType) {
        String cTypeName = cassandraTypeByJavaType.get(type.getName());
        if (cTypeName != null) {
            return cTypeName;
        }
        if (serialised && Serializable.class.isAssignableFrom(type)) {
            return "blob";
        }
        if (Enum.class.isAssignableFrom(type)) {
            if (jdbcType != null && jdbcType.equalsIgnoreCase("varchar")) {
                return "varchar";
            }
            return "int";
        }
        TypeConverter stringConverter = typeMgr.getTypeConverterForType(type, String.class);
        if (stringConverter != null) {
            return "varchar";
        }
        TypeConverter longConverter = typeMgr.getTypeConverterForType(type, Long.class);
        if (longConverter != null) {
            return "bigint";
        }
        TypeConverter intConverter = typeMgr.getTypeConverterForType(type, Integer.class);
        if (intConverter != null) {
            return "int";
        }
        if (Serializable.class.isAssignableFrom(type)) {
            return "blob";
        }
        return "varchar";
    }

    public static Object getDatastoreValueForNonPersistableValue(Object value, String datastoreType, boolean serialised, TypeManager typeMgr) {
        TypeConverter stringConverter;
        if (value == null) {
            return value;
        }
        if (serialised && value instanceof Serializable) {
            TypeConverter serialConv = typeMgr.getTypeConverterForType(Serializable.class, byte[].class);
            return serialConv.toDatastoreType(value);
        }
        if (value.getClass() == Character.class) {
            return "" + value;
        }
        if (value.getClass() == Byte.class) {
            return ((Byte)value).intValue();
        }
        if (value.getClass() == Short.class) {
            return ((Short)value).intValue();
        }
        if (ClassUtils.isPrimitiveWrapperType((String)value.getClass().getName())) {
            return value;
        }
        if (value.getClass() == BigInteger.class) {
            return ((BigInteger)value).longValue();
        }
        if (value.getClass() == BigDecimal.class) {
            return ((BigDecimal)value).doubleValue();
        }
        if (value instanceof Enum) {
            if (datastoreType.equals("varchar")) {
                return ((Enum)value).name();
            }
            return ((Enum)value).ordinal();
        }
        if (value instanceof Calendar) {
            TypeConverter stringConverter2;
            if (datastoreType.equals("varchar") && (stringConverter2 = typeMgr.getTypeConverterForType(Calendar.class, String.class)) != null) {
                return stringConverter2.toDatastoreType(value);
            }
            return ((Calendar)value).getTime();
        }
        if (value instanceof java.util.Date) {
            if (datastoreType.equals("varchar")) {
                Class<java.util.Date> valueType = java.util.Date.class;
                if (value instanceof Time) {
                    valueType = Time.class;
                } else if (value instanceof Date) {
                    valueType = Date.class;
                } else if (value instanceof Timestamp) {
                    valueType = Timestamp.class;
                }
                TypeConverter stringConverter3 = typeMgr.getTypeConverterForType(valueType, String.class);
                if (stringConverter3 != null) {
                    return stringConverter3.toDatastoreType(value);
                }
            }
            return value;
        }
        if (value instanceof TimeZone && (stringConverter = typeMgr.getTypeConverterForType(TimeZone.class, String.class)) != null) {
            return stringConverter.toDatastoreType(value);
        }
        stringConverter = typeMgr.getTypeConverterForType(value.getClass(), String.class);
        if (stringConverter != null) {
            return stringConverter.toDatastoreType(value);
        }
        TypeConverter longConverter = typeMgr.getTypeConverterForType(value.getClass(), Long.class);
        if (longConverter != null) {
            return longConverter.toDatastoreType(value);
        }
        return value;
    }

    public static Object getPojoForRowForCandidate(Row row, AbstractClassMetaData cmd, ExecutionContext ec, int[] fpMembers, boolean ignoreCache) {
        if (cmd.hasDiscriminatorStrategy()) {
            // empty if block
        }
        Object pojo = null;
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            pojo = CassandraUtils.getObjectUsingApplicationIdForRow(row, cmd, ec, ignoreCache, fpMembers);
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            pojo = CassandraUtils.getObjectUsingDatastoreIdForRow(row, cmd, ec, ignoreCache, fpMembers);
        } else {
            throw new NucleusUserException("Attempt to get candidate for class " + cmd.getFullClassName() + " but uses nondurable-identity and this is not supported by this datastore");
        }
        return pojo;
    }

    private static Object getObjectUsingApplicationIdForRow(Row row, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        final FetchFieldManager fm = new FetchFieldManager(ec, row, cmd);
        Object id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)false, (FieldManager)fm);
        StoreManager storeMgr = ec.getStoreManager();
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject(id, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, (FieldManager)fm);
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, (FieldManager)fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        if (cmd.isVersioned()) {
            ObjectProvider op = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = op.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = row.getInt(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN));
            }
            op.setVersion(version);
        }
        return pc;
    }

    private static Object getObjectUsingDatastoreIdForRow(Row row, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        Long idKey = null;
        StoreManager storeMgr = ec.getStoreManager();
        if (!storeMgr.isStrategyDatastoreAttributed(cmd, -1)) {
            idKey = row.getLong(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN));
        }
        final FetchFieldManager fm = new FetchFieldManager(ec, row, cmd);
        OID oid = OIDFactory.getInstance((PersistenceNucleusContext)ec.getNucleusContext(), (String)cmd.getFullClassName(), (Object)idKey);
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject((Object)oid, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, (FieldManager)fm);
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, (FieldManager)fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        if (cmd.isVersioned()) {
            ObjectProvider op = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = op.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = row.getInt(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN));
            }
            op.setVersion(version);
        }
        return pc;
    }

    public static void logCqlStatement(String stmt, Object[] values, NucleusLogger logger) {
        if (values == null || values.length == 0) {
            logger.debug((Object)stmt);
            return;
        }
        StringBuilder str = new StringBuilder();
        int paramNo = 0;
        int currentPos = 0;
        boolean moreParams = true;
        while (moreParams) {
            int pos = stmt.indexOf(63, currentPos);
            if (pos > 0) {
                str.append(stmt.substring(currentPos, pos));
                str.append('<').append("" + values[paramNo]).append('>');
                ++paramNo;
                currentPos = pos + 1;
                continue;
            }
            moreParams = false;
        }
        str.append(stmt.substring(currentPos));
        logger.debug((Object)str.toString());
    }

    static {
        cassandraTypeByJavaType.put(Boolean.TYPE.getName(), "boolean");
        cassandraTypeByJavaType.put(Byte.TYPE.getName(), "int");
        cassandraTypeByJavaType.put(Character.TYPE.getName(), "varchar");
        cassandraTypeByJavaType.put(Double.TYPE.getName(), "double");
        cassandraTypeByJavaType.put(Float.TYPE.getName(), "float");
        cassandraTypeByJavaType.put(Integer.TYPE.getName(), "int");
        cassandraTypeByJavaType.put(Long.TYPE.getName(), "bigint");
        cassandraTypeByJavaType.put(Short.TYPE.getName(), "int");
        cassandraTypeByJavaType.put(Boolean.class.getName(), "boolean");
        cassandraTypeByJavaType.put(Byte.class.getName(), "int");
        cassandraTypeByJavaType.put(Character.class.getName(), "varchar");
        cassandraTypeByJavaType.put(Double.class.getName(), "double");
        cassandraTypeByJavaType.put(Float.class.getName(), "float");
        cassandraTypeByJavaType.put(Integer.class.getName(), "int");
        cassandraTypeByJavaType.put(Long.class.getName(), "bigint");
        cassandraTypeByJavaType.put(Short.class.getName(), "int");
        cassandraTypeByJavaType.put(String.class.getName(), "varchar");
        cassandraTypeByJavaType.put(BigDecimal.class.getName(), "double");
        cassandraTypeByJavaType.put(BigInteger.class.getName(), "bigint");
        cassandraTypeByJavaType.put(java.util.Date.class.getName(), "timestamp");
        cassandraTypeByJavaType.put(Time.class.getName(), "timestamp");
        cassandraTypeByJavaType.put(Date.class.getName(), "timestamp");
        cassandraTypeByJavaType.put(Timestamp.class.getName(), "timestamp");
        cassandraTypeByJavaType.put(Calendar.class.getName(), "timestamp");
        cassandraTypeByJavaType.put(TimeZone.class.getName(), "varchar");
    }
}

