/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.state;

import org.datanucleus.FetchPlan;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.transaction.Transaction;

class PersistentClean
extends LifeCycleState {
    protected PersistentClean() {
        this.isPersistent = true;
        this.isDirty = false;
        this.isNew = false;
        this.isDeleted = false;
        this.isTransactional = true;
        this.stateType = 2;
    }

    public LifeCycleState transitionDeletePersistent(DNStateManager sm) {
        return this.changeState(sm, 8);
    }

    public LifeCycleState transitionMakeNontransactional(DNStateManager sm) {
        sm.clearSavedFields();
        return this.changeState(sm, 9);
    }

    public LifeCycleState transitionMakeTransient(DNStateManager sm, boolean useFetchPlan, boolean detachAllOnCommit) {
        if (useFetchPlan) {
            sm.loadUnloadedFieldsInFetchPlan();
        }
        return this.changeState(sm, 0);
    }

    public LifeCycleState transitionCommit(DNStateManager sm, Transaction tx) {
        sm.clearSavedFields();
        if (tx.getRetainValues()) {
            return this.changeState(sm, 9);
        }
        if (sm.getClassMetaData().getIdentityType() != IdentityType.NONDURABLE) {
            sm.clearNonPrimaryKeyFields();
        }
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionRollback(DNStateManager sm, Transaction tx) {
        if (tx.getRestoreValues()) {
            sm.restoreFields();
            return this.changeState(sm, 9);
        }
        if (sm.getClassMetaData().getIdentityType() != IdentityType.NONDURABLE) {
            sm.clearNonPrimaryKeyFields();
        }
        sm.clearSavedFields();
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionEvict(DNStateManager sm) {
        sm.clearNonPrimaryKeyFields();
        sm.clearSavedFields();
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionWriteField(DNStateManager sm) {
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (tx.getRestoreValues()) {
            sm.saveFields();
        }
        return this.changeState(sm, 3);
    }

    public LifeCycleState transitionRefresh(DNStateManager sm) {
        sm.clearSavedFields();
        sm.refreshFieldsInFetchPlan();
        sm.unloadNonFetchPlanFields();
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (tx.isActive()) {
            return this.changeState(sm, 2);
        }
        return this.changeState(sm, 9);
    }

    public LifeCycleState transitionRetrieve(DNStateManager sm, boolean fgOnly) {
        if (fgOnly) {
            sm.loadUnloadedFieldsInFetchPlan();
        } else {
            sm.loadUnloadedFields();
        }
        return this;
    }

    public LifeCycleState transitionRetrieve(DNStateManager sm, FetchPlan fetchPlan) {
        sm.loadUnloadedFieldsOfClassInFetchPlan(fetchPlan);
        return this;
    }

    public LifeCycleState transitionDetach(DNStateManager sm) {
        return this.changeState(sm, 11);
    }

    public String toString() {
        return "P_CLEAN";
    }
}

