/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.QueryTimeoutException;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import org.datanucleus.api.jpa.JPAAdapter;
import org.datanucleus.api.jpa.JPAEntityGraph;
import org.datanucleus.api.jpa.JPAEntityManager;
import org.datanucleus.api.jpa.JPAEntityManagerFactory;
import org.datanucleus.api.jpa.JPAFetchPlan;
import org.datanucleus.api.jpa.JPAQueryParameter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.NoQueryResultsException;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryInvalidParametersException;
import org.datanucleus.store.query.QueryNotUniqueException;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.query.compiler.QueryCompilation;
import org.datanucleus.store.query.compiler.Symbol;
import org.datanucleus.store.query.compiler.SymbolTable;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class JPAQuery<X>
implements TypedQuery<X> {
    public static final String QUERY_HINT_TIMEOUT = "javax.persistence.query.timeout";
    public static final String QUERY_HINT_FETCH_SIZE = "datanucleus.query.fetchSize".toLowerCase();
    public static final String QUERY_HINT_IGNORE_CACHE = "datanucleus.query.ignoreCache".toLowerCase();
    JPAEntityManager em;
    String language;
    org.datanucleus.store.query.Query query;
    FlushModeType flushMode = FlushModeType.AUTO;
    LockModeType lockMode = null;
    private int startPosition = 0;
    private int maxResults = -1;
    boolean parametersLoaded = false;
    Set<Parameter<?>> parameters = null;
    JPAFetchPlan fetchPlan;

    public JPAQuery(JPAEntityManager em, org.datanucleus.store.query.Query query, String language) {
        this.em = em;
        this.query = query;
        this.language = language;
        this.flushMode = em.getFlushMode();
        this.query.setCacheResults(false);
        this.fetchPlan = new JPAFetchPlan(query.getFetchPlan());
        this.query.addExtension(org.datanucleus.store.query.Query.EXTENSION_CLOSE_RESULTS_AT_EC_CLOSE, (Object)"true");
    }

    public JPAFetchPlan getFetchPlan() {
        this.assertIsOpen();
        return this.fetchPlan;
    }

    public int executeUpdate() {
        this.assertIsOpen();
        if (this.query.getType() == Query.QueryType.SELECT) {
            throw new IllegalStateException(Localiser.msg((String)"Query.ExecuteUpdateForSelectInvalid"));
        }
        try {
            Object result;
            if (this.flushMode == FlushModeType.AUTO && this.em.isTransactionActive()) {
                this.em.flush();
            }
            if (this.lockMode == LockModeType.PESSIMISTIC_READ || this.lockMode == LockModeType.PESSIMISTIC_WRITE) {
                this.query.setSerializeRead(Boolean.TRUE);
            }
            if ((result = this.query.executeWithMap(null)) != null) {
                return ((Long)result).intValue();
            }
            throw new NucleusException("Invalid return from query for an update/delete. Expected Long");
        }
        catch (NoQueryResultsException nqre) {
            return 0;
        }
        catch (QueryInvalidParametersException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        catch (org.datanucleus.store.query.QueryTimeoutException qte) {
            throw new QueryTimeoutException();
        }
        catch (NucleusException jpe) {
            throw JPAAdapter.getJPAExceptionForNucleusException(jpe);
        }
    }

    public List getResultList() {
        this.assertIsOpen();
        if (this.query.getType() != Query.QueryType.SELECT) {
            throw new IllegalStateException(Localiser.msg((String)"Query.GetResultForUpdateInvalid"));
        }
        try {
            if (this.flushMode == FlushModeType.AUTO && this.em.isTransactionActive()) {
                this.em.flush();
            }
            if (this.lockMode == LockModeType.PESSIMISTIC_READ || this.lockMode == LockModeType.PESSIMISTIC_WRITE) {
                this.query.setSerializeRead(Boolean.TRUE);
            }
            if (QueryUtils.queryReturnsSingleRow((org.datanucleus.store.query.Query)this.query)) {
                Object res = this.query.executeWithMap(null);
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(res);
                return l;
            }
            return (List)this.query.executeWithMap(null);
        }
        catch (NoQueryResultsException nqre) {
            return null;
        }
        catch (QueryInvalidParametersException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        catch (org.datanucleus.store.query.QueryTimeoutException qte) {
            throw new QueryTimeoutException();
        }
        catch (NucleusException jpe) {
            throw JPAAdapter.getJPAExceptionForNucleusException(jpe);
        }
    }

    public X getSingleResult() {
        this.assertIsOpen();
        if (this.query.getType() != Query.QueryType.SELECT) {
            throw new IllegalStateException(Localiser.msg((String)"Query.GetResultForUpdateInvalid"));
        }
        try {
            if (this.flushMode == FlushModeType.AUTO && this.em.isTransactionActive()) {
                this.em.flush();
            }
            if (this.lockMode == LockModeType.PESSIMISTIC_READ || this.lockMode == LockModeType.PESSIMISTIC_WRITE) {
                this.query.setSerializeRead(Boolean.TRUE);
            }
            this.query.setUnique(true);
            return (X)this.query.executeWithMap(null);
        }
        catch (NoQueryResultsException nqre) {
            throw new NoResultException("No results for query: " + this.query.toString());
        }
        catch (QueryNotUniqueException ex) {
            throw new NonUniqueResultException("Expected a single result for query: " + this.query.toString() + " : " + StringUtils.getStringFromStackTrace((Throwable)ex));
        }
        catch (QueryInvalidParametersException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        catch (org.datanucleus.store.query.QueryTimeoutException qte) {
            throw new QueryTimeoutException();
        }
        catch (NucleusException jpe) {
            throw JPAAdapter.getJPAExceptionForNucleusException(jpe);
        }
    }

    public TypedQuery<X> setFirstResult(int startPosition) {
        this.assertIsOpen();
        if (startPosition < 0) {
            throw new IllegalArgumentException(Localiser.msg((String)"Query.StartPositionInvalid"));
        }
        this.startPosition = startPosition;
        if (this.maxResults == -1) {
            this.query.setRange((long)this.startPosition, Long.MAX_VALUE);
        } else {
            this.query.setRange((long)this.startPosition, (long)(this.startPosition + this.maxResults));
        }
        return this;
    }

    public TypedQuery<X> setMaxResults(int max) {
        this.assertIsOpen();
        if (max < 0) {
            throw new IllegalArgumentException(Localiser.msg((String)"Query.MaxResultsInvalid"));
        }
        this.maxResults = max;
        this.query.setRange((long)this.startPosition, (long)(this.startPosition + max));
        return this;
    }

    public int getMaxResults() {
        this.assertIsOpen();
        long queryMin = this.query.getRangeFromIncl();
        long queryMax = this.query.getRangeToExcl();
        long max = queryMax - queryMin;
        if (max > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)max;
    }

    public int getFirstResult() {
        this.assertIsOpen();
        return (int)this.query.getRangeFromIncl();
    }

    public TypedQuery<X> setFlushMode(FlushModeType mode) {
        this.assertIsOpen();
        this.flushMode = mode;
        return this;
    }

    public FlushModeType getFlushMode() {
        this.assertIsOpen();
        return this.flushMode;
    }

    public TypedQuery<X> setHint(String hintName, Object value) {
        this.assertIsOpen();
        if (hintName == null) {
            return this;
        }
        if (hintName.equalsIgnoreCase(QUERY_HINT_TIMEOUT)) {
            this.query.setDatastoreReadTimeoutMillis((Integer)value);
        } else if (hintName.equalsIgnoreCase("javax.persistence.fetchgraph")) {
            JPAEntityGraph eg = (JPAEntityGraph)value;
            String egName = eg.getName();
            if (eg.getName() == null) {
                JPAEntityManagerFactory emf = (JPAEntityManagerFactory)this.em.getEntityManagerFactory();
                String tmpEntityGraphName = emf.getDefinedEntityGraphName();
                emf.registerEntityGraph(eg, tmpEntityGraphName);
                egName = tmpEntityGraphName;
            }
            this.query.getFetchPlan().setGroup(egName);
        } else if (hintName.equalsIgnoreCase("javax.persistence.loadgraph")) {
            JPAEntityGraph eg = (JPAEntityGraph)value;
            String egName = eg.getName();
            if (eg.getName() == null) {
                JPAEntityManagerFactory emf = (JPAEntityManagerFactory)this.em.getEntityManagerFactory();
                String tmpEntityGraphName = emf.getDefinedEntityGraphName();
                emf.registerEntityGraph(eg, tmpEntityGraphName);
                egName = tmpEntityGraphName;
            }
            this.query.getFetchPlan().addGroup(egName);
        } else if (hintName.equalsIgnoreCase(QUERY_HINT_FETCH_SIZE)) {
            if (value instanceof Integer) {
                this.query.getFetchPlan().setFetchSize(((Integer)value).intValue());
            } else if (value instanceof Long) {
                this.query.getFetchPlan().setFetchSize(((Long)value).intValue());
            }
        } else if (hintName.equalsIgnoreCase(QUERY_HINT_IGNORE_CACHE)) {
            if (value instanceof String) {
                this.query.setIgnoreCache(Boolean.valueOf((String)value).booleanValue());
            } else if (value instanceof Boolean) {
                this.query.setIgnoreCache(((Boolean)value).booleanValue());
            }
        }
        this.query.addExtension(hintName, value);
        return this;
    }

    public Map<String, Object> getHints() {
        this.assertIsOpen();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map extensions = this.query.getExtensions();
        if (extensions != null && !extensions.isEmpty()) {
            map.putAll(extensions);
        }
        return map;
    }

    public Set<String> getSupportedHints() {
        this.assertIsOpen();
        Set supportedExtensions = this.query.getSupportedExtensions();
        supportedExtensions.add(QUERY_HINT_FETCH_SIZE);
        supportedExtensions.add(QUERY_HINT_IGNORE_CACHE);
        supportedExtensions.add(QUERY_HINT_TIMEOUT);
        supportedExtensions.add("javax.persistence.fetchgraph");
        supportedExtensions.add("javax.persistence.loadgraph");
        return supportedExtensions;
    }

    public <T> TypedQuery<X> setParameter(Parameter<T> param, T value) {
        this.assertIsOpen();
        if (param == null) {
            throw new IllegalArgumentException("Parameter object is null");
        }
        if (param.getName() != null) {
            try {
                this.query.setImplicitParameter(param.getName(), value);
            }
            catch (QueryInvalidParametersException ipe) {
                throw new IllegalArgumentException(ipe.getMessage(), ipe);
            }
            return this;
        }
        try {
            if (this.isNativeQuery()) {
                this.query.setImplicitParameter(param.getPosition().intValue(), value);
            } else {
                this.query.setImplicitParameter("" + param.getPosition(), value);
            }
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage(), ipe);
        }
        return this;
    }

    public TypedQuery<X> setParameter(String name, Object value) {
        this.assertIsOpen();
        try {
            this.query.setImplicitParameter(name, value);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage(), ipe);
        }
        return this;
    }

    public TypedQuery<X> setParameter(int position, Object value) {
        this.assertIsOpen();
        try {
            if (this.isNativeQuery()) {
                this.query.setImplicitParameter(position, value);
            } else {
                this.query.setImplicitParameter("" + position, value);
            }
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage(), ipe);
        }
        return this;
    }

    public TypedQuery<X> setParameter(String name, Date value, TemporalType temporalType) {
        this.assertIsOpen();
        Date paramValue = value;
        if (temporalType == TemporalType.TIME && !(value instanceof Time)) {
            paramValue = new Time(value.getTime());
        } else if (temporalType == TemporalType.TIMESTAMP && !(value instanceof Timestamp)) {
            paramValue = new Timestamp(value.getTime());
        }
        try {
            this.query.setImplicitParameter(name, (Object)paramValue);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public TypedQuery<X> setParameter(String name, Calendar value, TemporalType temporalType) {
        this.assertIsOpen();
        Comparable<Calendar> paramValue = value;
        if (value != null) {
            if (temporalType == TemporalType.DATE) {
                paramValue = value.getTime();
            } else if (temporalType == TemporalType.TIME) {
                paramValue = new Time(value.getTime().getTime());
            } else if (temporalType == TemporalType.TIMESTAMP) {
                paramValue = new Timestamp(value.getTime().getTime());
            }
        }
        try {
            this.query.setImplicitParameter(name, (Object)paramValue);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public TypedQuery<X> setParameter(int position, Date value, TemporalType temporalType) {
        this.assertIsOpen();
        Date paramValue = value;
        if (value != null) {
            if (temporalType == TemporalType.TIME && !(value instanceof Time)) {
                paramValue = new Time(value.getTime());
            } else if (temporalType == TemporalType.TIMESTAMP && !(value instanceof Timestamp)) {
                paramValue = new Timestamp(value.getTime());
            }
        }
        try {
            if (this.isNativeQuery()) {
                this.query.setImplicitParameter(position, (Object)paramValue);
            } else {
                this.query.setImplicitParameter("" + position, (Object)paramValue);
            }
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public TypedQuery<X> setParameter(int position, Calendar value, TemporalType temporalType) {
        this.assertIsOpen();
        Comparable<Calendar> paramValue = value;
        if (value != null) {
            if (temporalType == TemporalType.DATE) {
                paramValue = value.getTime();
            } else if (temporalType == TemporalType.TIME) {
                paramValue = new Time(value.getTime().getTime());
            } else if (temporalType == TemporalType.TIMESTAMP) {
                paramValue = new Timestamp(value.getTime().getTime());
            }
        }
        try {
            if (this.isNativeQuery()) {
                this.query.setImplicitParameter(position, (Object)paramValue);
            } else {
                this.query.setImplicitParameter("" + position, (Object)paramValue);
            }
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public JPAQuery<X> setParameter(Parameter<Calendar> param, Calendar cal, TemporalType type) {
        this.assertIsOpen();
        if (param.getName() != null) {
            this.setParameter(param.getName(), cal, type);
        } else {
            this.setParameter((int)param.getPosition(), cal, type);
        }
        return this;
    }

    public TypedQuery<X> setParameter(Parameter<Date> param, Date date, TemporalType type) {
        this.assertIsOpen();
        if (param.getName() != null) {
            this.setParameter(param.getName(), date, type);
        } else {
            this.setParameter((int)param.getPosition(), date, type);
        }
        return this;
    }

    public org.datanucleus.store.query.Query getInternalQuery() {
        return this.query;
    }

    public <T> T unwrap(Class<T> cls) {
        this.assertIsOpen();
        if (cls == org.datanucleus.store.query.Query.class) {
            return (T)this.query;
        }
        throw new PersistenceException("Not supported unwrapping of query to " + cls.getName());
    }

    public String getLanguage() {
        return this.language;
    }

    public Set<Parameter<?>> getParameters() {
        this.assertIsOpen();
        if (this.isNativeQuery()) {
            throw new IllegalStateException("Not supported on native query");
        }
        this.loadParameters();
        if (this.parameters == null) {
            return Collections.EMPTY_SET;
        }
        HashSet params = new HashSet();
        params.addAll(this.parameters);
        return params;
    }

    protected void loadParameters() {
        if (this.parametersLoaded) {
            return;
        }
        if (this.query.getCompilation() == null) {
            try {
                ((AbstractJavaQuery)this.query).compileGeneric(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.query.getCompilation() != null) {
            QueryCompilation compilation = this.query.getCompilation();
            this.loadParametersForCompilation(compilation);
            String[] subqueryAliases = compilation.getSubqueryAliases();
            if (subqueryAliases != null && subqueryAliases.length > 0) {
                for (int i = 0; i < subqueryAliases.length; ++i) {
                    QueryCompilation subqCompilation = compilation.getCompilationForSubquery(subqueryAliases[i]);
                    this.loadParametersForCompilation(subqCompilation);
                }
            }
        }
        this.parametersLoaded = true;
    }

    protected void loadParametersForCompilation(QueryCompilation compilation) {
        SymbolTable symTbl = compilation.getSymbolTable();
        for (String symName : symTbl.getSymbolNames()) {
            Symbol sym = symTbl.getSymbol(symName);
            if (sym.getType() != 1) continue;
            if (this.parameters == null) {
                this.parameters = new HashSet();
            }
            JPAQueryParameter param = null;
            if (this.query.toString().indexOf("?" + sym.getQualifiedName()) >= 0) {
                try {
                    param = new JPAQueryParameter(Integer.valueOf(sym.getQualifiedName()), sym.getValueType());
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                param = new JPAQueryParameter(sym.getQualifiedName(), sym.getValueType());
            }
            this.parameters.add(param);
        }
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        this.assertIsOpen();
        if (this.isNativeQuery()) {
            throw new IllegalStateException("Not supported on native query");
        }
        this.loadParameters();
        if (this.parameters == null) {
            throw new IllegalArgumentException("No parameter with name " + name + " and type=" + type.getName());
        }
        for (Parameter<?> param : this.parameters) {
            if (param.getName() == null || !param.getName().equals(name)) continue;
            return param;
        }
        throw new IllegalArgumentException("No parameter with name " + name + " and type=" + type.getName());
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        this.assertIsOpen();
        if (this.isNativeQuery()) {
            throw new IllegalStateException("Not supported on native query");
        }
        this.loadParameters();
        if (this.parameters == null) {
            throw new IllegalArgumentException("No parameter at position=" + position + " and type=" + type.getName());
        }
        for (Parameter<?> param : this.parameters) {
            if (param.getPosition() == null || param.getPosition() != position) continue;
            return param;
        }
        throw new IllegalArgumentException("No parameter at position=" + position + " and type=" + type.getName());
    }

    public Parameter<?> getParameter(int position) {
        this.assertIsOpen();
        if (this.isNativeQuery()) {
            throw new IllegalStateException("Not supported on native query");
        }
        this.loadParameters();
        if (this.parameters == null) {
            throw new IllegalArgumentException("No parameter at position=" + position);
        }
        for (Parameter<?> param : this.parameters) {
            if (param.getPosition() == null || param.getPosition() != position) continue;
            return param;
        }
        throw new IllegalArgumentException("No parameter at position=" + position);
    }

    public Parameter<?> getParameter(String name) {
        this.assertIsOpen();
        if (this.isNativeQuery()) {
            throw new IllegalStateException("Not supported on native query");
        }
        this.loadParameters();
        if (this.parameters == null) {
            throw new IllegalArgumentException("No parameter with name " + name);
        }
        for (Parameter<?> param : this.parameters) {
            if (param.getName() == null || !param.getName().equals(name)) continue;
            return param;
        }
        throw new IllegalArgumentException("No parameter with name " + name);
    }

    public <T> T getParameterValue(Parameter<T> param) {
        this.assertIsOpen();
        if (param.getName() != null) {
            if (this.query.getImplicitParameters() == null) {
                throw new IllegalArgumentException("No parameter with name " + param.getName());
            }
            if (this.query.getImplicitParameters().containsKey(param.getName())) {
                return (T)this.query.getImplicitParameters().get(param.getName());
            }
        } else {
            if (this.query.getImplicitParameters() == null) {
                throw new IllegalArgumentException("No parameter at position " + param.getPosition());
            }
            if (this.isNativeQuery()) {
                if (this.query.getImplicitParameters().containsKey(param.getPosition())) {
                    return (T)this.query.getImplicitParameters().get(param.getPosition());
                }
            } else if (this.query.getImplicitParameters().containsKey("" + param.getPosition())) {
                return (T)this.query.getImplicitParameters().get("" + param.getPosition());
            }
        }
        throw new IllegalStateException("No parameter matching " + param + " bound to this query");
    }

    public Object getParameterValue(int position) {
        this.assertIsOpen();
        if (this.query.getImplicitParameters() == null) {
            throw new IllegalArgumentException("No parameter at position " + position);
        }
        if (this.isNativeQuery()) {
            if (this.query.getImplicitParameters().containsKey(position)) {
                return this.query.getImplicitParameters().get(position);
            }
        } else if (this.query.getImplicitParameters().containsKey("" + position)) {
            return this.query.getImplicitParameters().get("" + position);
        }
        throw new IllegalArgumentException("No parameter at position " + position);
    }

    public Object getParameterValue(String name) {
        this.assertIsOpen();
        if (this.query.getImplicitParameters() == null) {
            throw new IllegalArgumentException("No parameter with name " + name);
        }
        if (this.query.getImplicitParameters().containsKey(name)) {
            return this.query.getImplicitParameters().get(name);
        }
        throw new IllegalArgumentException("No parameter with name " + name);
    }

    public boolean isBound(Parameter<?> param) {
        this.assertIsOpen();
        if (this.parameters == null) {
            return false;
        }
        return param.getName() != null ? this.query.getImplicitParameters().containsKey(param.getName()) : (this.isNativeQuery() ? this.query.getImplicitParameters().containsKey(param.getPosition()) : this.query.getImplicitParameters().containsKey("" + param.getPosition()));
    }

    public LockModeType getLockMode() {
        this.assertIsOpen();
        if (this.query.getType() != Query.QueryType.SELECT || !this.query.getLanguage().equals("JPQL")) {
            throw new IllegalStateException("Query has to be a SELECT JPQL query to allow locking");
        }
        return this.lockMode;
    }

    public TypedQuery<X> setLockMode(LockModeType lock) {
        this.assertIsOpen();
        if (this.query.getType() != Query.QueryType.SELECT || !this.query.getLanguage().equals("JPQL")) {
            throw new IllegalStateException("Query has to be a SELECT JPQL query to allow locking");
        }
        this.lockMode = lock;
        return this;
    }

    TypedQuery<X> setResultClass(Class resultClass) {
        if (resultClass == Object[].class) {
            this.query.setResultClass(null);
        } else {
            this.query.setResultClass(resultClass);
        }
        return this;
    }

    public String toString() {
        this.assertIsOpen();
        return this.query.toString();
    }

    public Object getNativeQuery() {
        return this.query.getNativeQuery();
    }

    public void saveAsNamedQuery(String name) {
        this.em.getEntityManagerFactory().addNamedQuery(name, (Query)this);
    }

    protected boolean isNativeQuery() {
        return this.language.equals(this.em.getExecutionContext().getStoreManager().getNativeQueryLanguage());
    }

    private void assertIsOpen() {
        if (!this.em.isOpen()) {
            throw new IllegalStateException(Localiser.msg((String)"EM.IsClosed"));
        }
    }
}

