/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.SynchronizationType;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.Configuration;
import org.datanucleus.DetachState;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlanState;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.api.jpa.JPAAdapter;
import org.datanucleus.api.jpa.JPAEntityGraph;
import org.datanucleus.api.jpa.JPAEntityManagerFactory;
import org.datanucleus.api.jpa.JPAEntityTransaction;
import org.datanucleus.api.jpa.JPAFetchPlan;
import org.datanucleus.api.jpa.JPAPropertyNames;
import org.datanucleus.api.jpa.JPAQuery;
import org.datanucleus.api.jpa.JPAQueryTuple;
import org.datanucleus.api.jpa.JPAStoredProcedureQuery;
import org.datanucleus.api.jpa.criteria.CriteriaBuilderImpl;
import org.datanucleus.api.jpa.criteria.CriteriaDeleteImpl;
import org.datanucleus.api.jpa.criteria.CriteriaQueryImpl;
import org.datanucleus.api.jpa.criteria.CriteriaUpdateImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.flush.FlushMode;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.metadata.StoredProcQueryMetaData;
import org.datanucleus.metadata.StoredProcQueryParameterMetaData;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.LockMode;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.query.AbstractStoredProcedureQuery;
import org.datanucleus.store.query.compiler.QueryCompilation;
import org.datanucleus.transaction.jta.JTATransactionImpl;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class JPAEntityManager
implements EntityManager {
    protected boolean closed = false;
    protected ExecutionContext ec;
    protected JPAEntityManagerFactory emf;
    protected EntityTransaction tx;
    protected FlushModeType flushMode = FlushModeType.AUTO;
    protected PersistenceContextType persistenceContextType;
    protected SynchronizationType syncType;
    protected JPAFetchPlan fetchPlan = null;

    public JPAEntityManager(JPAEntityManagerFactory theEMF, PersistenceNucleusContext nucleusCtx, PersistenceContextType contextType, SynchronizationType syncType) {
        this.emf = theEMF;
        this.persistenceContextType = contextType;
        this.syncType = syncType;
        HashMap<String, String> options = null;
        if (this.syncType == SynchronizationType.UNSYNCHRONIZED) {
            options = new HashMap<String, String>();
            options.put("jta_autojoin", "false");
        }
        this.ec = nucleusCtx.getExecutionContext((Object)this, options);
        if (nucleusCtx.getConfiguration().getStringProperty("datanucleus.transaction.type").equalsIgnoreCase(TransactionType.RESOURCE_LOCAL.toString())) {
            this.tx = new JPAEntityTransaction(this.ec);
        }
        this.fetchPlan = new JPAFetchPlan(this.ec.getFetchPlan());
    }

    public void clear() {
        this.assertIsOpen();
        this.ec.detachAll();
        this.ec.clearDirty();
        this.ec.evictAllObjects();
    }

    public boolean isContainerManaged() {
        return this.emf.isContainerManaged();
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public ExecutionContext getExecutionContext() {
        return this.ec;
    }

    public void close() {
        this.assertIsOpen();
        try {
            this.ec.close();
        }
        catch (NucleusException ne) {
            throw JPAAdapter.getJPAExceptionForNucleusException(ne);
        }
        this.fetchPlan = null;
        this.ec = null;
        this.emf = null;
        this.closed = true;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    public JPAFetchPlan getFetchPlan() {
        return this.fetchPlan;
    }

    public boolean contains(Object entity) {
        this.assertIsOpen();
        this.assertEntity(entity);
        if (this.ec.getApiAdapter().getExecutionContext(entity) != this.ec) {
            return false;
        }
        if (this.ec.getApiAdapter().isDeleted(entity)) {
            return false;
        }
        return !this.ec.getApiAdapter().isDetached(entity);
    }

    public Object find(Class entityClass, Object primaryKey) {
        return this.find(entityClass, primaryKey, null, null);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return this.find(entityClass, primaryKey, null, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lock) {
        return this.find(entityClass, primaryKey, lock, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lock, Map<String, Object> properties) {
        Object pc;
        this.assertIsOpen();
        this.assertLockModeValid(lock);
        this.assertEntity(entityClass);
        String tmpEntityGraphName = null;
        try {
            AbstractClassMetaData cmd;
            boolean fetchGraphSpecified = false;
            if (properties != null) {
                String egName;
                EntityGraph eg;
                if (properties.containsKey("javax.persistence.fetchgraph")) {
                    eg = (EntityGraph)properties.get("javax.persistence.fetchgraph");
                    egName = eg.getName();
                    if (eg.getName() == null) {
                        tmpEntityGraphName = this.emf.getDefinedEntityGraphName();
                        this.emf.registerEntityGraph((JPAEntityGraph)eg, tmpEntityGraphName);
                        egName = tmpEntityGraphName;
                    }
                    this.ec.getFetchPlan().setGroup(egName);
                    fetchGraphSpecified = true;
                }
                if (properties.containsKey("javax.persistence.loadgraph")) {
                    eg = (EntityGraph)properties.get("javax.persistence.loadgraph");
                    egName = eg.getName();
                    if (eg.getName() == null) {
                        tmpEntityGraphName = this.emf.getDefinedEntityGraphName();
                        this.emf.registerEntityGraph((JPAEntityGraph)eg, tmpEntityGraphName);
                        egName = tmpEntityGraphName;
                    }
                    this.ec.getFetchPlan().addGroup(egName);
                    fetchGraphSpecified = true;
                }
                this.ec.setProperties(properties);
            }
            if ((cmd = this.ec.getMetaDataManager().getMetaDataForClass(entityClass, this.ec.getClassLoaderResolver())) == null) {
                this.throwException((RuntimeException)new EntityNotFoundException());
            }
            try {
                if (lock != null && lock != LockModeType.NONE) {
                    Object id = primaryKey;
                    if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                        if (!IdentityUtils.isDatastoreIdentity((Object)id)) {
                            id = this.ec.getNucleusContext().getIdentityManager().getDatastoreId(cmd.getFullClassName(), primaryKey);
                        }
                    } else if (!primaryKey.getClass().getName().equals(cmd.getObjectidClass())) {
                        try {
                            id = this.ec.newObjectId(entityClass, primaryKey);
                        }
                        catch (NucleusException ne) {
                            throw new IllegalArgumentException(ne);
                        }
                    }
                    this.ec.getLockManager().lock(id, JPAEntityManager.getLockModeForJPALockModeType(lock));
                }
                if ((pc = this.ec.findObject(entityClass, primaryKey)) != null && fetchGraphSpecified) {
                    this.ec.findStateManager(pc).loadUnloadedFieldsInFetchPlan();
                }
            }
            catch (NucleusObjectNotFoundException ex) {
                T ne = null;
                if (tmpEntityGraphName != null) {
                    this.emf.deregisterEntityGraph(tmpEntityGraphName);
                }
                this.ec.getFetchPlan().setGroup("default");
                return ne;
            }
        }
        catch (Throwable throwable) {
            if (tmpEntityGraphName != null) {
                this.emf.deregisterEntityGraph(tmpEntityGraphName);
            }
            this.ec.getFetchPlan().setGroup("default");
            throw throwable;
        }
        if (this.ec.getApiAdapter().isTransactional(pc)) {
            DNStateManager sm = this.ec.findStateManager(pc);
            if (this.ec.getApiAdapter().isDeleted(pc)) {
                try {
                    sm.locate();
                }
                catch (NucleusObjectNotFoundException ex) {
                    T t = null;
                    if (tmpEntityGraphName != null) {
                        this.emf.deregisterEntityGraph(tmpEntityGraphName);
                    }
                    this.ec.getFetchPlan().setGroup("default");
                    return t;
                }
            }
        }
        if (tmpEntityGraphName != null) {
            this.emf.deregisterEntityGraph(tmpEntityGraphName);
        }
        this.ec.getFetchPlan().setGroup("default");
        return (T)pc;
    }

    public <T> T findByUnique(Class<T> cls, String[] fieldNames, Object[] fieldValues) {
        try {
            return (T)this.ec.findObjectByUnique(cls, fieldNames, fieldValues);
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException("Exception finding object by unique values", ne);
        }
    }

    public Object getDelegate() {
        this.assertIsOpen();
        return this.ec;
    }

    public <T> T unwrap(Class<T> cls) {
        if (ClassConstants.EXECUTION_CONTEXT.isAssignableFrom(cls)) {
            return (T)this.ec;
        }
        if (ClassConstants.STORE_MANAGER.isAssignableFrom(cls)) {
            return (T)this.ec.getStoreManager();
        }
        if (ClassConstants.METADATA_MANAGER.isAssignableFrom(cls)) {
            return (T)this.ec.getMetaDataManager();
        }
        if (ClassConstants.PERSISTENCE_NUCLEUS_CONTEXT.isAssignableFrom(cls)) {
            return (T)this.ec.getNucleusContext();
        }
        if (ClassConstants.NUCLEUS_CONTEXT.isAssignableFrom(cls)) {
            return (T)this.ec.getNucleusContext();
        }
        if (NucleusConnection.class.isAssignableFrom(cls)) {
            return (T)this.ec.getStoreManager().getNucleusConnection(this.ec);
        }
        return (T)this.throwException((RuntimeException)new PersistenceException("We don't support accessing object of type " + cls.getName() + " using unwrap() method"));
    }

    public Object getReference(Class entityClass, Object primaryKey) {
        this.assertIsOpen();
        this.assertEntity(entityClass);
        Object id = null;
        try {
            id = this.ec.newObjectId(entityClass, primaryKey);
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne);
        }
        try {
            return this.ec.findObject(id, false);
        }
        catch (NucleusObjectNotFoundException ne) {
            throw JPAAdapter.getJPAExceptionForNucleusException((NucleusException)((Object)ne));
        }
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.lock(entity, lockMode, null);
    }

    public void lock(Object entity, LockModeType lock, Map<String, Object> properties) {
        this.assertIsOpen();
        this.assertLockModeValid(lock);
        this.assertTransactionActive();
        this.assertEntity(entity);
        if (this.ec.getApiAdapter().isDetached(entity)) {
            throw new IllegalArgumentException(Localiser.msg((String)"EM.EntityIsDetached", (Object[])new Object[]{StringUtils.toJVMIDString((Object)entity), "" + this.ec.getApiAdapter().getIdForObject(entity)}));
        }
        if (!this.contains(entity)) {
            this.throwException((RuntimeException)new PersistenceException("Entity is not contained in this persistence context so cant lock it"));
        }
        if (properties != null) {
            this.ec.setProperties(properties);
        }
        AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(entity.getClass(), this.ec.getClassLoaderResolver());
        if (!(lock != LockModeType.OPTIMISTIC && lock != LockModeType.OPTIMISTIC_FORCE_INCREMENT || cmd.isVersioned())) {
            throw new PersistenceException("Object of type " + entity.getClass().getName() + " is not versioned so cannot lock optimistically!");
        }
        if (lock != null && lock != LockModeType.NONE) {
            this.ec.getLockManager().lock(this.ec.findStateManager(entity), JPAEntityManager.getLockModeForJPALockModeType(lock));
        }
    }

    public void persist(Object entity) {
        this.assertIsOpen();
        this.assertTransactionNotRequired();
        if (entity != null) {
            if (entity instanceof Collection) {
                this.persist((Collection)entity);
                return;
            }
            if (entity.getClass().isArray()) {
                this.persist((Object[])entity);
                return;
            }
        }
        this.assertEntity(entity);
        if (this.ec.exists(entity) && this.ec.getApiAdapter().isDetached(entity)) {
            this.throwException((RuntimeException)new EntityExistsException(Localiser.msg((String)"EM.EntityIsPersistent", (Object[])new Object[]{StringUtils.toJVMIDString((Object)entity)})));
        }
        try {
            this.ec.persistObject(entity, false);
        }
        catch (NucleusException ne) {
            this.throwException((RuntimeException)JPAAdapter.getJPAExceptionForNucleusException(ne));
        }
    }

    public void persist(Collection entities) {
        this.persist(entities.toArray());
    }

    public void persist(Object ... entities) {
        for (Object entity : entities) {
            this.assertEntity(entity);
            if (!this.ec.exists(entity) || !this.ec.getApiAdapter().isDetached(entity)) continue;
            this.throwException((RuntimeException)new EntityExistsException(Localiser.msg((String)"EM.EntityIsPersistent", (Object[])new Object[]{StringUtils.toJVMIDString((Object)entity)})));
        }
        try {
            this.ec.persistObjects(entities);
        }
        catch (NucleusException ne) {
            this.throwException((RuntimeException)JPAAdapter.getJPAExceptionForNucleusException(ne));
        }
    }

    public Object merge(Object entity) {
        this.assertIsOpen();
        this.assertTransactionNotRequired();
        if (entity != null) {
            if (entity instanceof Collection) {
                return this.merge((Collection)entity);
            }
            if (entity.getClass().isArray()) {
                return this.merge((Object[])entity);
            }
        }
        this.assertEntity(entity);
        if (this.ec.getApiAdapter().isDeleted(entity)) {
            throw new IllegalArgumentException(Localiser.msg((String)"EM.EntityIsDeleted", (Object[])new Object[]{StringUtils.toJVMIDString((Object)entity), "" + this.ec.getApiAdapter().getIdForObject(entity)}));
        }
        try {
            return this.ec.persistObject(entity, true);
        }
        catch (NucleusException ne) {
            this.throwException((RuntimeException)JPAAdapter.getJPAExceptionForNucleusException(ne));
            return null;
        }
    }

    public Collection merge(Collection entities) {
        Object[] merged = this.merge(entities.toArray());
        return Arrays.asList(merged);
    }

    public Object[] merge(Object ... entities) {
        for (Object entity : entities) {
            this.assertEntity(entity);
            if (!this.ec.getApiAdapter().isDeleted(entity)) continue;
            throw new IllegalArgumentException(Localiser.msg((String)"EM.EntityIsDeleted", (Object[])new Object[]{StringUtils.toJVMIDString((Object)entity), "" + this.ec.getApiAdapter().getIdForObject(entity)}));
        }
        try {
            return this.ec.persistObjects(entities);
        }
        catch (NucleusException ne) {
            this.throwException((RuntimeException)JPAAdapter.getJPAExceptionForNucleusException(ne));
            return null;
        }
    }

    public void detach(Object entity) {
        this.assertIsOpen();
        if (entity != null) {
            if (entity instanceof Collection) {
                this.detach((Collection)entity);
                return;
            }
            if (entity.getClass().isArray()) {
                this.detach((Object[])entity);
                return;
            }
        }
        this.assertEntity(entity);
        try {
            this.ec.detachObject((FetchPlanState)new DetachState(this.ec.getApiAdapter()), entity);
        }
        catch (NucleusException ne) {
            this.throwException((RuntimeException)JPAAdapter.getJPAExceptionForNucleusException(ne));
        }
    }

    public void detach(Collection entities) {
        this.detach(entities.toArray());
    }

    public void detach(Object ... entities) {
        try {
            this.ec.detachObjects((FetchPlanState)new DetachState(this.ec.getApiAdapter()), entities);
        }
        catch (NucleusException ne) {
            this.throwException((RuntimeException)JPAAdapter.getJPAExceptionForNucleusException(ne));
        }
    }

    public void refresh(Object entity) {
        this.refresh(entity, null, null);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.refresh(entity, null, properties);
    }

    public void refresh(Object entity, LockModeType lock) {
        this.refresh(entity, lock, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lock, Map<String, Object> properties) {
        this.assertIsOpen();
        this.assertLockModeValid(lock);
        this.assertTransactionNotRequired();
        this.assertEntity(entity);
        if (this.ec.getApiAdapter().getExecutionContext(entity) != this.ec) {
            throw new IllegalArgumentException(Localiser.msg((String)"EM.EntityIsNotManaged", (Object[])new Object[]{StringUtils.toJVMIDString((Object)entity)}));
        }
        if (!this.ec.exists(entity)) {
            this.throwException((RuntimeException)new EntityNotFoundException(Localiser.msg((String)"EM.EntityNotInDatastore", (Object[])new Object[]{StringUtils.toJVMIDString((Object)entity)})));
        }
        if (properties != null) {
            this.ec.setProperties(properties);
        }
        try {
            if (lock != null && lock != LockModeType.NONE) {
                this.ec.getLockManager().lock(this.ec.getApiAdapter().getIdForObject(entity), JPAEntityManager.getLockModeForJPALockModeType(lock));
            }
            this.ec.refreshObject(entity);
        }
        catch (NucleusException ne) {
            this.throwException((RuntimeException)JPAAdapter.getJPAExceptionForNucleusException(ne));
        }
    }

    public void remove(Object entity) {
        this.assertIsOpen();
        this.assertTransactionNotRequired();
        if (entity != null) {
            if (entity instanceof Collection) {
                this.remove((Collection)entity);
                return;
            }
            if (entity.getClass().isArray()) {
                this.remove((Object[])entity);
                return;
            }
        }
        this.assertEntity(entity);
        if (this.ec.getApiAdapter().isDetached(entity)) {
            throw new IllegalArgumentException(Localiser.msg((String)"EM.EntityIsDetached", (Object[])new Object[]{StringUtils.toJVMIDString((Object)entity), "" + this.ec.getApiAdapter().getIdForObject(entity)}));
        }
        try {
            this.ec.deleteObject(entity);
        }
        catch (NucleusException ne) {
            this.throwException((RuntimeException)JPAAdapter.getJPAExceptionForNucleusException(ne));
        }
    }

    public void remove(Collection entities) {
        this.remove(entities.toArray());
    }

    public void remove(Object ... entities) {
        for (Object entity : entities) {
            this.assertEntity(entity);
            if (!this.ec.getApiAdapter().isDetached(entity)) continue;
            throw new IllegalArgumentException(Localiser.msg((String)"EM.EntityIsDetached", (Object[])new Object[]{StringUtils.toJVMIDString((Object)entity), "" + this.ec.getApiAdapter().getIdForObject(entity)}));
        }
        try {
            this.ec.deleteObjects(entities);
        }
        catch (NucleusException ne) {
            this.throwException((RuntimeException)JPAAdapter.getJPAExceptionForNucleusException(ne));
        }
    }

    public void flush() {
        this.assertIsOpen();
        this.assertTransactionActive();
        try {
            this.ec.flush();
        }
        catch (NucleusException ne) {
            this.throwException((RuntimeException)JPAAdapter.getJPAExceptionForNucleusException(ne));
        }
    }

    public FlushModeType getFlushMode() {
        this.assertIsOpen();
        return this.flushMode;
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.assertIsOpen();
        this.flushMode = flushMode;
    }

    public LockModeType getLockMode(Object entity) {
        this.assertTransactionActive();
        this.assertEntity(entity);
        if (this.ec.getApiAdapter().getExecutionContext(entity) != this.ec) {
            throw new IllegalArgumentException(Localiser.msg((String)"EM.EntityIsNotManaged", (Object[])new Object[]{StringUtils.toJVMIDString((Object)entity)}));
        }
        if (this.ec.getApiAdapter().isDetached(entity)) {
            throw new IllegalArgumentException(Localiser.msg((String)"EM.EntityIsNotManaged", (Object[])new Object[]{StringUtils.toJVMIDString((Object)entity)}));
        }
        DNStateManager sm = this.ec.findStateManager(entity);
        return JPAEntityManager.getJPALockModeTypeForLockMode(this.ec.getLockManager().getLockMode(sm));
    }

    public EntityTransaction getTransaction() {
        if (this.tx == null) {
            throw new IllegalStateException(Localiser.msg((String)"EM.TransactionNotLocal"));
        }
        return this.tx;
    }

    public void joinTransaction() {
        this.assertIsOpen();
        if (this.tx != null) {
            throw new IllegalStateException(Localiser.msg((String)"EM.TransactionLocal"));
        }
        JTATransactionImpl ecTx = (JTATransactionImpl)this.ec.getTransaction();
        ecTx.joinTransaction();
        boolean active = ecTx.getIsActive();
        if (!active) {
            throw new TransactionRequiredException("Attempt to joinTransaction but UserTransaction is not present");
        }
    }

    public boolean isJoinedToTransaction() {
        if (this.tx != null) {
            return this.tx.isActive();
        }
        JTATransactionImpl ecTx = (JTATransactionImpl)this.ec.getTransaction();
        return ecTx.isJoined();
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> cq) {
        CriteriaQueryImpl criteria = (CriteriaQueryImpl)cq;
        String jpqlString = criteria.toString();
        TypedQuery query = null;
        QueryCompilation compilation = criteria.getCompilation(this.ec.getMetaDataManager(), this.ec.getClassLoaderResolver());
        query = criteria.getResultType() != null && criteria.getResultType() != compilation.getCandidateClass() ? this.createQuery(jpqlString, criteria.getResultType()) : this.createQuery(jpqlString);
        org.datanucleus.store.query.Query internalQuery = query.getInternalQuery();
        if (compilation.getExprResult() == null) {
            internalQuery.setResult(null);
        }
        internalQuery.setCompilation(compilation);
        return query;
    }

    public Query createQuery(CriteriaUpdate crit) {
        CriteriaUpdateImpl criteria = (CriteriaUpdateImpl)crit;
        String jpqlString = criteria.toString();
        QueryCompilation compilation = criteria.getCompilation(this.ec.getMetaDataManager(), this.ec.getClassLoaderResolver());
        JPAQuery query = this.createQuery(jpqlString);
        org.datanucleus.store.query.Query internalQuery = query.getInternalQuery();
        internalQuery.setCompilation(compilation);
        return query;
    }

    public Query createQuery(CriteriaDelete crit) {
        CriteriaDeleteImpl criteria = (CriteriaDeleteImpl)crit;
        String jpqlString = criteria.toString();
        QueryCompilation compilation = criteria.getCompilation(this.ec.getMetaDataManager(), this.ec.getClassLoaderResolver());
        JPAQuery query = this.createQuery(jpqlString);
        org.datanucleus.store.query.Query internalQuery = query.getInternalQuery();
        internalQuery.setCompilation(compilation);
        return query;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        this.assertIsOpen();
        return new CriteriaBuilderImpl(this.emf);
    }

    public <T> TypedQuery<T> createNamedQuery(String queryName, Class<T> resultClass) {
        return this.createNamedQuery(queryName).setResultClass(resultClass);
    }

    public JPAQuery createNamedQuery(String queryName) {
        this.assertIsOpen();
        if (queryName == null) {
            throw new IllegalArgumentException(Localiser.msg((String)"Query.NamedQueryNotFound", (Object[])new Object[]{queryName}));
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        QueryMetaData qmd = this.ec.getMetaDataManager().getMetaDataForQuery(null, clr, queryName);
        if (qmd == null) {
            throw new IllegalArgumentException(Localiser.msg((String)"Query.NamedQueryNotFound", (Object[])new Object[]{queryName}));
        }
        try {
            if (!this.ec.getStoreManager().supportsQueryLanguage(qmd.getLanguage())) {
                throw new IllegalArgumentException(Localiser.msg((String)"Query.LanguageNotSupportedByStore", (Object[])new Object[]{qmd.getLanguage()}));
            }
            if (qmd.getLanguage().equals(QueryLanguage.JPQL.toString())) {
                org.datanucleus.store.query.Query internalQuery = this.ec.getStoreManager().newQuery(qmd.getLanguage(), this.ec, qmd.getQuery());
                if (this.ec.getFlushMode() == FlushMode.QUERY) {
                    internalQuery.addExtension("datanucleus.query.flushbeforeexecution", (Object)Boolean.TRUE);
                }
                return new JPAQuery(this, internalQuery, qmd.getLanguage());
            }
            org.datanucleus.store.query.Query internalQuery = this.ec.getStoreManager().newQuery(qmd.getLanguage(), this.ec, qmd.getQuery());
            if (qmd.getResultClass() != null) {
                String resultClassName = qmd.getResultClass();
                Class resultClass = null;
                try {
                    resultClass = this.ec.getClassLoaderResolver().classForName(resultClassName);
                    if (this.ec.getApiAdapter().isPersistable(resultClass)) {
                        internalQuery.setCandidateClass(resultClass);
                    } else {
                        internalQuery.setResultClass(resultClass);
                    }
                    if (this.ec.getFlushMode() == FlushMode.QUERY) {
                        internalQuery.addExtension("datanucleus.query.flushbeforeexecution", (Object)Boolean.TRUE);
                    }
                    return new JPAQuery(this, internalQuery, qmd.getLanguage());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(Localiser.msg((String)"Query.ResultClassNotFound", (Object[])new Object[]{qmd.getName(), resultClassName}));
                }
            }
            if (qmd.getResultMetaDataName() != null) {
                QueryResultMetaData qrmd = this.ec.getMetaDataManager().getMetaDataForQueryResult(qmd.getResultMetaDataName());
                if (qrmd == null) {
                    throw new IllegalArgumentException(Localiser.msg((String)"Query.ResultSetMappingNotFound", (Object[])new Object[]{qmd.getResultMetaDataName()}));
                }
                internalQuery.setResultMetaData(qrmd);
                if (this.ec.getFlushMode() == FlushMode.QUERY) {
                    internalQuery.addExtension("datanucleus.query.flushbeforeexecution", (Object)Boolean.TRUE);
                }
                return new JPAQuery(this, internalQuery, qmd.getLanguage());
            }
            return new JPAQuery(this, internalQuery, qmd.getLanguage());
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public Query createNativeQuery(String queryString) {
        return this.createNativeQuery(queryString, (Class)null);
    }

    public Query createNativeQuery(String queryString, Class resultClass) {
        this.assertIsOpen();
        try {
            String nativeQueryLanguage = this.ec.getStoreManager().getNativeQueryLanguage();
            if (nativeQueryLanguage == null) {
                throw new IllegalArgumentException("This datastore does not support 'native' queries");
            }
            org.datanucleus.store.query.Query internalQuery = this.ec.getStoreManager().newQuery(nativeQueryLanguage, this.ec, queryString);
            if (resultClass != null) {
                if (this.ec.getApiAdapter().isPersistable(resultClass)) {
                    internalQuery.setCandidateClass(resultClass);
                } else {
                    internalQuery.setResultClass(resultClass);
                }
            }
            return new JPAQuery(this, internalQuery, nativeQueryLanguage);
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public Query createNativeQuery(String queryString, String resultSetMapping) {
        this.assertIsOpen();
        try {
            String nativeQueryLanguage = this.ec.getStoreManager().getNativeQueryLanguage();
            if (nativeQueryLanguage == null) {
                throw new IllegalArgumentException("This datastore does not support 'native' queries");
            }
            org.datanucleus.store.query.Query internalQuery = this.ec.getStoreManager().newQuery(nativeQueryLanguage, this.ec, queryString);
            QueryResultMetaData qrmd = this.ec.getMetaDataManager().getMetaDataForQueryResult(resultSetMapping);
            if (qrmd == null) {
                throw new IllegalArgumentException(Localiser.msg((String)"Query.ResultSetMappingNotFound", (Object[])new Object[]{resultSetMapping}));
            }
            internalQuery.setResultMetaData(qrmd);
            return new JPAQuery(this, internalQuery, nativeQueryLanguage);
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String procName) {
        if (procName == null) {
            throw new IllegalArgumentException(Localiser.msg((String)"Query.NamedStoredProcedureQueryNotFound", (Object[])new Object[]{procName}));
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        StoredProcQueryMetaData qmd = this.ec.getMetaDataManager().getMetaDataForStoredProcQuery(null, clr, procName);
        if (qmd == null) {
            throw new IllegalArgumentException(Localiser.msg((String)"Query.NamedStoredProcedureQueryNotFound", (Object[])new Object[]{procName}));
        }
        try {
            AbstractStoredProcedureQuery internalQuery = (AbstractStoredProcedureQuery)this.ec.getStoreManager().newQuery(QueryLanguage.STOREDPROC.toString(), this.ec, qmd.getProcedureName());
            if (qmd.getParameters() != null) {
                for (StoredProcQueryParameterMetaData parammd : qmd.getParameters()) {
                    Class type = clr.classForName(parammd.getType());
                    internalQuery.registerParameter(parammd.getName(), type, parammd.getMode());
                }
            }
            if (qmd.getResultClasses() != null) {
                Class[] resultClasses = new Class[qmd.getResultClasses().size()];
                int i = 0;
                for (String clsName : qmd.getResultClasses()) {
                    resultClasses[i++] = clr.classForName(clsName);
                }
                internalQuery.setResultClasses(resultClasses);
            } else if (qmd.getResultSetMappings() != null) {
                QueryResultMetaData[] qrmds = new QueryResultMetaData[qmd.getResultSetMappings().size()];
                int i = 0;
                for (String resultSetMappingName : qmd.getResultSetMappings()) {
                    qrmds[i] = this.ec.getMetaDataManager().getMetaDataForQueryResult(resultSetMappingName);
                    if (qrmds[i] == null) {
                        throw new IllegalArgumentException(Localiser.msg((String)"Query.ResultSetMappingNotFound", (Object[])new Object[]{resultSetMappingName}));
                    }
                    ++i;
                }
                internalQuery.setResultMetaData(qrmds);
            }
            return new JPAStoredProcedureQuery(this, (org.datanucleus.store.query.Query)internalQuery);
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procName) {
        this.assertIsOpen();
        try {
            org.datanucleus.store.query.Query internalQuery = this.ec.getStoreManager().newQuery(QueryLanguage.STOREDPROC.toString(), this.ec, procName);
            return new JPAStoredProcedureQuery(this, internalQuery);
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        this.assertIsOpen();
        try {
            org.datanucleus.store.query.Query internalQuery = this.ec.getStoreManager().newQuery(QueryLanguage.STOREDPROC.toString(), this.ec, procedureName);
            if (resultClasses != null && resultClasses.length > 0) {
                ((AbstractStoredProcedureQuery)internalQuery).setResultClasses(resultClasses);
            }
            return new JPAStoredProcedureQuery(this, internalQuery);
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        this.assertIsOpen();
        try {
            org.datanucleus.store.query.Query internalQuery = this.ec.getStoreManager().newQuery(QueryLanguage.STOREDPROC.toString(), this.ec, procedureName);
            if (resultSetMappings != null && resultSetMappings.length > 0) {
                QueryResultMetaData[] qrmds = new QueryResultMetaData[resultSetMappings.length];
                for (int i = 0; i < qrmds.length; ++i) {
                    qrmds[i] = this.ec.getMetaDataManager().getMetaDataForQueryResult(resultSetMappings[i]);
                    if (qrmds[i] != null) continue;
                    throw new IllegalArgumentException(Localiser.msg((String)"Query.ResultSetMappingNotFound", (Object[])new Object[]{resultSetMappings[i]}));
                }
                ((AbstractStoredProcedureQuery)internalQuery).setResultMetaData(qrmds);
            }
            return new JPAStoredProcedureQuery(this, internalQuery);
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public <T> TypedQuery<T> createQuery(String queryString, Class<T> resultClass) {
        JPAQuery jpaQuery = this.createQuery(queryString);
        if (resultClass != null) {
            jpaQuery.setResultClass(resultClass.getName().equals("javax.persistence.Tuple") ? JPAQueryTuple.class : resultClass);
        }
        return jpaQuery;
    }

    public JPAQuery createQuery(String queryString) {
        this.assertIsOpen();
        try {
            org.datanucleus.store.query.Query internalQuery = this.ec.getStoreManager().newQuery(QueryLanguage.JPQL.toString(), this.ec, queryString);
            return new JPAQuery(this, internalQuery, QueryLanguage.JPQL.toString());
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public void setProperty(String propertyName, Object value) {
        try {
            this.ec.setProperty(propertyName, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Property '" + propertyName + "' value=" + value + " invalid");
        }
    }

    public Map<String, Object> getProperties() {
        return this.ec.getProperties();
    }

    public Set<String> getSupportedProperties() {
        return this.ec.getSupportedProperties();
    }

    public Metamodel getMetamodel() {
        return this.emf.getMetamodel();
    }

    private void assertIsOpen() {
        if (this.closed) {
            throw new IllegalStateException(Localiser.msg((String)"EM.IsClosed"));
        }
    }

    private void assertTransactionActive() {
        if (!this.isTransactionActive()) {
            throw new TransactionRequiredException(Localiser.msg((String)"EM.TransactionRequired"));
        }
    }

    public boolean isTransactionActive() {
        if (this.tx != null) {
            return this.tx.isActive();
        }
        JTATransactionImpl jtaTxn = (JTATransactionImpl)this.ec.getTransaction();
        if (jtaTxn.isJoined()) {
            return true;
        }
        return jtaTxn.isActive();
    }

    private void assertLockModeValid(LockModeType lock) {
        if (lock != null && lock != LockModeType.NONE && !this.isTransactionActive()) {
            throw new TransactionRequiredException(Localiser.msg((String)"EM.TransactionRequired"));
        }
    }

    private void assertEntity(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException(Localiser.msg((String)"EM.EntityNotAnEntity", (Object[])new Object[]{entity}));
        }
        Class<?> cls = entity instanceof Class ? (Class<?>)entity : entity.getClass();
        try {
            this.ec.assertClassPersistable(cls);
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(Localiser.msg((String)"EM.EntityNotAnEntity", (Object[])new Object[]{cls.getName()}), ne);
        }
    }

    private void assertTransactionNotRequired() {
        if (this.isContainerManaged() && this.persistenceContextType == PersistenceContextType.TRANSACTION && !this.isTransactionActive()) {
            throw new TransactionRequiredException(Localiser.msg((String)"EM.TransactionRequired"));
        }
    }

    private Object throwException(RuntimeException re) {
        if (re instanceof PersistenceException) {
            Configuration conf = this.ec.getNucleusContext().getConfiguration();
            if (this.tx != null && this.tx.isActive() && conf.getBooleanProperty(JPAPropertyNames.PROPERTY_JPA_TRANSACTION_ROLLBACK_ON_EXCEPTION)) {
                this.getTransaction().setRollbackOnly();
            }
        }
        throw re;
    }

    public static LockMode getLockModeForJPALockModeType(LockModeType lock) {
        LockMode lockModeType = LockMode.LOCK_NONE;
        if (lock == LockModeType.OPTIMISTIC || lock == LockModeType.READ) {
            lockModeType = LockMode.LOCK_OPTIMISTIC_READ;
        } else if (lock == LockModeType.OPTIMISTIC_FORCE_INCREMENT || lock == LockModeType.WRITE) {
            lockModeType = LockMode.LOCK_OPTIMISTIC_WRITE;
        } else if (lock == LockModeType.PESSIMISTIC_READ) {
            lockModeType = LockMode.LOCK_PESSIMISTIC_READ;
        } else if (lock == LockModeType.PESSIMISTIC_FORCE_INCREMENT || lock == LockModeType.PESSIMISTIC_WRITE) {
            lockModeType = LockMode.LOCK_PESSIMISTIC_WRITE;
        }
        return lockModeType;
    }

    public static LockModeType getJPALockModeTypeForLockMode(LockMode lockMode) {
        if (lockMode == LockMode.LOCK_OPTIMISTIC_READ) {
            return LockModeType.OPTIMISTIC;
        }
        if (lockMode == LockMode.LOCK_OPTIMISTIC_WRITE) {
            return LockModeType.OPTIMISTIC_FORCE_INCREMENT;
        }
        if (lockMode == LockMode.LOCK_PESSIMISTIC_READ) {
            return LockModeType.PESSIMISTIC_READ;
        }
        if (lockMode == LockMode.LOCK_PESSIMISTIC_WRITE) {
            return LockModeType.PESSIMISTIC_WRITE;
        }
        return LockModeType.NONE;
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        return new JPAEntityGraph(this.ec.getMetaDataManager(), null, rootType);
    }

    public EntityGraph<?> createEntityGraph(String graphName) {
        EntityGraph entityGraph = this.emf.getNamedEntityGraph(graphName);
        if (entityGraph != null) {
            return ((JPAEntityGraph)entityGraph).cloneMutableEntityGraph();
        }
        return null;
    }

    public EntityGraph<?> getEntityGraph(String graphName) {
        EntityGraph entityGraph = this.emf.getNamedEntityGraph(graphName);
        if (entityGraph == null) {
            throw new IllegalArgumentException("There is no registered EntityGraph of name \"" + graphName + "\"");
        }
        return entityGraph;
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        EntityType entityType = this.getMetamodel().entity(entityClass);
        if (entityType == null) {
            throw new IllegalArgumentException("Provided class (\"" + entityClass.getName() + "\") is not an entity");
        }
        return this.emf.getEntityGraphsByType(entityClass);
    }
}

