/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityNotFoundException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.QueryTimeoutException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.api.jpa.JPAEntityManager;
import org.datanucleus.api.jpa.metadata.JPAXmlMetaDataHelper;
import org.datanucleus.api.jpa.state.LifeCycleStateFactory;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.exceptions.NucleusCanRetryException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.LifeCycleState;

public class JPAAdapter
implements ApiAdapter {
    private static final long serialVersionUID = 7676231809409935625L;
    protected static final Set<String> defaultPersistentTypeNames = new HashSet<String>();

    public String getName() {
        return "JPA";
    }

    public boolean isMemberDefaultPersistent(Class type) {
        String typeName = type.getName();
        if (defaultPersistentTypeNames.contains(typeName)) {
            return true;
        }
        if (Calendar.class.isAssignableFrom(type) || Enum.class.isAssignableFrom(type) || Serializable.class.isAssignableFrom(type)) {
            return true;
        }
        return this.isPersistable(type);
    }

    public String getXMLMetaDataForClass(AbstractClassMetaData cmd, String prefix, String indent) {
        return new JPAXmlMetaDataHelper().getXMLForMetaData(cmd, prefix, indent);
    }

    public String getDefaultMappingFileLocation() {
        return "META-INF/orm.xml";
    }

    public ExecutionContext getExecutionContext(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Persistable) {
            return (ExecutionContext)((Persistable)obj).dnGetExecutionContext();
        }
        if (obj instanceof JPAEntityManager) {
            return ((JPAEntityManager)obj).getExecutionContext();
        }
        return null;
    }

    public LifeCycleState getLifeCycleState(int stateType) {
        return LifeCycleStateFactory.getLifeCycleState(stateType);
    }

    public boolean isValidPrimaryKeyClass(Class pkClass, AbstractClassMetaData cmd, ClassLoaderResolver clr, int noOfPkFields, MetaDataManager mmgr) {
        return true;
    }

    public boolean allowPersistOfDeletedObject() {
        return true;
    }

    public boolean allowDeleteOfNonPersistentObject() {
        return true;
    }

    public boolean allowReadFieldOfDeletedObject() {
        return true;
    }

    public boolean clearLoadedFlagsOnDeleteObject() {
        return false;
    }

    public boolean getDefaultCascadePersistForField() {
        return false;
    }

    public boolean getDefaultCascadeAttachForField() {
        return false;
    }

    public boolean getDefaultCascadeDeleteForField() {
        return false;
    }

    public boolean getDefaultCascadeDetachForField() {
        return false;
    }

    public boolean getDefaultCascadeRefreshForField() {
        return false;
    }

    public boolean getDefaultDFGForPersistableField() {
        return true;
    }

    public Map<String, Object> getDefaultFactoryProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("datanucleus.DetachAllOnCommit", "true");
        props.put("datanucleus.DetachAllOnRollback", "true");
        props.put("datanucleus.CopyOnAttach", "true");
        props.put("datanucleus.RetainValues", "true");
        props.put("datanucleus.Optimistic", "true");
        props.put("datanucleus.transaction.nontx.atomic", "false");
        props.put("datanucleus.metadata.allowLoadAtRuntime", "false");
        props.put("datanucleus.identifier.namingFactory", "jpa");
        props.put("datanucleus.identifierFactory", "jpa");
        props.put("datanucleus.persistenceByReachabilityAtCommit", "false");
        props.put("datanucleus.manageRelationships", "false");
        props.put("datanucleus.manageRelationshipsChecks", "false");
        props.put("datanucleus.query.sql.allowAll", "true");
        props.put("datanucleus.maxFetchDepth", "-1");
        props.put("datanucleus.findObject.validateWhenCached", "false");
        props.put("datanucleus.useImplementationCreator", "false");
        props.put("datanucleus.allowAttachOfTransient", "true");
        props.put("datanucleus.metadata.useDiscriminatorClassNameByDefault", "false");
        props.put("datanucleus.metadata.useDiscriminatorForSingleTable", "true");
        props.put("datanucleus.rdbms.allowColumnReuse", "true");
        return props;
    }

    public boolean getDefaultPersistentPropertyWhenNotSpecified() {
        return true;
    }

    public RuntimeException getUserExceptionForException(String msg, Exception e) {
        return new PersistenceException(msg, (Throwable)e);
    }

    public RuntimeException getDataStoreExceptionForException(String msg, Exception e) {
        return new PersistenceException(msg, (Throwable)e);
    }

    public RuntimeException getApiExceptionForNucleusException(NucleusException ne) {
        return JPAAdapter.getJPAExceptionForNucleusException(ne);
    }

    public static PersistenceException getJPAExceptionForNucleusException(NucleusException ne) {
        if (ne instanceof ReachableObjectNotCascadedException) {
            throw new IllegalStateException(ne.getMessage(), ne);
        }
        if (ne instanceof org.datanucleus.store.query.QueryTimeoutException) {
            return new QueryTimeoutException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusDataStoreException) {
            if (ne.getNestedExceptions() != null) {
                return new PersistenceException(ne.getMessage(), ne.getCause());
            }
            return new PersistenceException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusCanRetryException) {
            if (ne.getNestedExceptions() != null) {
                return new PersistenceException(ne.getMessage(), ne.getCause());
            }
            return new PersistenceException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusObjectNotFoundException) {
            return new EntityNotFoundException(ne.getMessage());
        }
        if (ne instanceof NucleusUserException) {
            if (ne.getNestedExceptions() != null) {
                return new PersistenceException(ne.getMessage(), ne.getCause());
            }
            return new PersistenceException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusOptimisticException) {
            if (ne.getNestedExceptions() != null) {
                return new OptimisticLockException(ne.getMessage(), ne.getCause());
            }
            return new OptimisticLockException(ne.getMessage(), (Throwable)ne);
        }
        if (ne.getNestedExceptions() != null) {
            return new PersistenceException(ne.getMessage(), ne.getCause());
        }
        return new PersistenceException(ne.getMessage(), (Throwable)ne);
    }

    static {
        defaultPersistentTypeNames.add(ClassNameConstants.BOOLEAN);
        defaultPersistentTypeNames.add(ClassNameConstants.BYTE);
        defaultPersistentTypeNames.add(ClassNameConstants.CHAR);
        defaultPersistentTypeNames.add(ClassNameConstants.DOUBLE);
        defaultPersistentTypeNames.add(ClassNameConstants.FLOAT);
        defaultPersistentTypeNames.add(ClassNameConstants.INT);
        defaultPersistentTypeNames.add(ClassNameConstants.LONG);
        defaultPersistentTypeNames.add(ClassNameConstants.SHORT);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_BOOLEAN);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_BYTE);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_CHARACTER);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_DOUBLE);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_FLOAT);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_INTEGER);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_LONG);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_SHORT);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_STRING);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_UTIL_DATE);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_SQL_DATE);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_SQL_TIME);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_SQL_TIMESTAMP);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_MATH_BIGDECIMAL);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_MATH_BIGINTEGER);
        defaultPersistentTypeNames.add(ClassNameConstants.BYTE_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.CHAR_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_BYTE_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_CHARACTER_ARRAY);
    }
}

