/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.metadata;

import java.lang.reflect.Method;
import javax.persistence.AttributeConverter;

public class JPATypeConverterUtils {
    public static Class getAttributeTypeForAttributeConverter(Class<? extends AttributeConverter> converterCls, Class attrTypeFallback) {
        Class<?> attrType = attrTypeFallback;
        Method[] methods = converterCls.getMethods();
        if (methods != null) {
            for (int j = 0; j < methods.length; ++j) {
                Class<?> returnCls;
                if (!methods[j].getName().equals("convertToEntityAttribute") || (returnCls = methods[j].getReturnType()) == Object.class) continue;
                attrType = returnCls;
                break;
            }
        }
        return attrType;
    }

    public static Class getDatabaseTypeForAttributeConverter(Class<? extends AttributeConverter> converterCls, Class attrType, Class dbTypeFallback) {
        Class<?> dbType = dbTypeFallback;
        try {
            Class<?> returnCls = converterCls.getMethod("convertToDatabaseColumn", attrType).getReturnType();
            if (returnCls != Object.class) {
                dbType = returnCls;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dbType;
    }
}

