/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.criteria;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.datanucleus.query.expression.CaseExpression;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.SubqueryExpression;
import org.datanucleus.query.expression.VariableExpression;

public class JPQLHelper {
    public static String getJPQLForExpression(Expression expr) {
        if (expr instanceof DyadicExpression) {
            DyadicExpression dyExpr = (DyadicExpression)expr;
            Expression left = dyExpr.getLeft();
            Expression right = dyExpr.getRight();
            StringBuilder str = new StringBuilder();
            if (dyExpr.getOperator() == Expression.OP_CAST) {
                str.append("TREAT(");
                str.append(JPQLHelper.getJPQLForExpression(left));
                str.append(" AS ");
                str.append(((Literal)right).getLiteral());
                str.append(")");
                return str.toString();
            }
            str.append("(");
            if (left != null) {
                str.append(JPQLHelper.getJPQLForExpression(left));
            }
            if (right != null && right instanceof Literal && ((Literal)right).getLiteral() == null && (dyExpr.getOperator() == Expression.OP_EQ || dyExpr.getOperator() == Expression.OP_NOTEQ)) {
                str.append(dyExpr.getOperator() == Expression.OP_EQ ? " IS NULL" : " IS NOT NULL");
            } else {
                if (dyExpr.getOperator() == Expression.OP_AND) {
                    str.append(" AND ");
                } else if (dyExpr.getOperator() == Expression.OP_OR) {
                    str.append(" OR ");
                } else if (dyExpr.getOperator() == Expression.OP_ADD) {
                    str.append(" + ");
                } else if (dyExpr.getOperator() == Expression.OP_SUB) {
                    str.append(" - ");
                } else if (dyExpr.getOperator() == Expression.OP_MUL) {
                    str.append(" * ");
                } else if (dyExpr.getOperator() == Expression.OP_DIV) {
                    str.append(" / ");
                } else if (dyExpr.getOperator() == Expression.OP_EQ) {
                    str.append(" = ");
                } else if (dyExpr.getOperator() == Expression.OP_GT) {
                    str.append(" > ");
                } else if (dyExpr.getOperator() == Expression.OP_LT) {
                    str.append(" < ");
                } else if (dyExpr.getOperator() == Expression.OP_GTEQ) {
                    str.append(" >= ");
                } else if (dyExpr.getOperator() == Expression.OP_LTEQ) {
                    str.append(" <= ");
                } else if (dyExpr.getOperator() == Expression.OP_NOTEQ) {
                    str.append(" <> ");
                } else {
                    throw new UnsupportedOperationException("Dont currently support operator " + dyExpr.getOperator() + " in JPQL conversion");
                }
                if (right != null) {
                    str.append(JPQLHelper.getJPQLForExpression(right));
                }
            }
            str.append(")");
            return str.toString();
        }
        if (expr instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)expr;
            Expression exprLeft = expr.getLeft();
            if (exprLeft != null) {
                return JPQLHelper.getJPQLForExpression(exprLeft) + "." + primExpr.getId();
            }
            return primExpr.getId();
        }
        if (expr instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)expr;
            if (paramExpr.getPosition() >= 0) {
                return "?" + paramExpr.getPosition();
            }
            return ":" + paramExpr.getId();
        }
        if (expr instanceof InvokeExpression) {
            InvokeExpression invExpr = (InvokeExpression)expr;
            Expression invoked = invExpr.getLeft();
            List args = invExpr.getArguments();
            String method = invExpr.getOperation();
            if (method.equalsIgnoreCase("CURRENT_DATE")) {
                return "CURRENT_DATE";
            }
            if (method.equalsIgnoreCase("CURRENT_TIME")) {
                return "CURRENT_TIME";
            }
            if (method.equalsIgnoreCase("CURRENT_TIMESTAMP")) {
                return "CURRENT_TIMESTAMP";
            }
            if (method.equalsIgnoreCase("length")) {
                StringBuilder str = new StringBuilder("LENGTH(");
                str.append(JPQLHelper.getJPQLForExpression(invoked));
                if (args != null && !args.isEmpty()) {
                    Expression firstExpr = (Expression)args.get(0);
                    str.append(",").append(JPQLHelper.getJPQLForExpression(firstExpr));
                    if (args.size() == 2) {
                        Expression secondExpr = (Expression)args.get(1);
                        str.append(",").append(JPQLHelper.getJPQLForExpression(secondExpr));
                    }
                }
                str.append(")");
                return str.toString();
            }
            if (method.equals("toLowerCase")) {
                return "LOWER(" + JPQLHelper.getJPQLForExpression(invoked) + ")";
            }
            if (method.equals("toUpperCase")) {
                return "UPPER(" + JPQLHelper.getJPQLForExpression(invoked) + ")";
            }
            if (method.equalsIgnoreCase("isEmpty")) {
                StringBuilder str = new StringBuilder();
                str.append(JPQLHelper.getJPQLForExpression(invoked));
                str.append(" IS EMPTY");
                return str.toString();
            }
            if (method.equalsIgnoreCase("indexOf")) {
                StringBuilder str = new StringBuilder("LOCATE(");
                str.append(JPQLHelper.getJPQLForExpression(invoked));
                Expression firstExpr = (Expression)args.get(0);
                str.append(",").append(JPQLHelper.getJPQLForExpression(firstExpr));
                if (args.size() > 1) {
                    Expression secondExpr = (Expression)args.get(1);
                    str.append(",").append(JPQLHelper.getJPQLForExpression(secondExpr));
                }
                str.append(")");
                return str.toString();
            }
            if (method.equalsIgnoreCase("substring")) {
                StringBuilder str = new StringBuilder("SUBSTRING(");
                str.append(JPQLHelper.getJPQLForExpression(invoked));
                Expression firstExpr = (Expression)args.get(0);
                str.append(",").append(JPQLHelper.getJPQLForExpression(firstExpr));
                if (args.size() > 1) {
                    Expression secondExpr = (Expression)args.get(1);
                    str.append(",").append(JPQLHelper.getJPQLForExpression(secondExpr));
                }
                str.append(")");
                return str.toString();
            }
            if (method.equalsIgnoreCase("trim")) {
                StringBuilder str = new StringBuilder("TRIM(BOTH ");
                str.append(JPQLHelper.getJPQLForExpression(invoked));
                if (args.size() > 0) {
                    Expression trimChrExpr = (Expression)args.get(0);
                    str.append(JPQLHelper.getJPQLForExpression(trimChrExpr));
                }
                str.append(" FROM ");
                str.append(JPQLHelper.getJPQLForExpression(invoked));
                str.append(")");
                return str.toString();
            }
            if (method.equalsIgnoreCase("trimLeft")) {
                StringBuilder str = new StringBuilder("TRIM(LEADING ");
                str.append(JPQLHelper.getJPQLForExpression(invoked));
                if (args.size() > 0) {
                    Expression trimChrExpr = (Expression)args.get(0);
                    str.append(JPQLHelper.getJPQLForExpression(trimChrExpr));
                }
                str.append(" FROM ");
                str.append(JPQLHelper.getJPQLForExpression(invoked));
                str.append(")");
                return str.toString();
            }
            if (method.equalsIgnoreCase("trimLeft")) {
                StringBuilder str = new StringBuilder("TRIM(TRAILING ");
                str.append(JPQLHelper.getJPQLForExpression(invoked));
                if (args.size() > 0) {
                    Expression trimChrExpr = (Expression)args.get(0);
                    str.append(JPQLHelper.getJPQLForExpression(trimChrExpr));
                }
                str.append(" FROM ");
                str.append(JPQLHelper.getJPQLForExpression(invoked));
                str.append(")");
                return str.toString();
            }
            if (method.equalsIgnoreCase("matches")) {
                StringBuilder str = new StringBuilder();
                str.append(JPQLHelper.getJPQLForExpression(invoked));
                str.append(" LIKE ");
                Expression firstExpr = (Expression)args.get(0);
                str.append(JPQLHelper.getJPQLForExpression(firstExpr));
                if (args.size() > 1) {
                    Expression secondExpr = (Expression)args.get(1);
                    str.append(" ESCAPE ").append(JPQLHelper.getJPQLForExpression(secondExpr));
                }
                return str.toString();
            }
            if (method.equalsIgnoreCase("contains")) {
                StringBuilder str = new StringBuilder();
                Expression firstExpr = (Expression)args.get(0);
                str.append(JPQLHelper.getJPQLForExpression(firstExpr));
                str.append(" MEMBER OF ");
                str.append(JPQLHelper.getJPQLForExpression(invoked));
                return str.toString();
            }
            if (method.equalsIgnoreCase("COUNT")) {
                Expression argExpr = (Expression)args.get(0);
                if (argExpr instanceof DyadicExpression && ((DyadicExpression)argExpr).getOperator() == Expression.OP_DISTINCT) {
                    DyadicExpression dyExpr = (DyadicExpression)argExpr;
                    return "COUNT(DISTINCT " + JPQLHelper.getJPQLForExpression(dyExpr.getLeft()) + ")";
                }
                return "COUNT(" + JPQLHelper.getJPQLForExpression(argExpr) + ")";
            }
            if (method.equalsIgnoreCase("COALESCE")) {
                StringBuilder str = new StringBuilder("COALESCE(");
                for (int i = 0; i < args.size(); ++i) {
                    Expression argExpr = (Expression)args.get(i);
                    str.append(JPQLHelper.getJPQLForExpression(argExpr));
                    if (i >= args.size() - 1) continue;
                    str.append(",");
                }
                str.append(")");
                return str.toString();
            }
            if (method.equalsIgnoreCase("NULLIF")) {
                StringBuilder str = new StringBuilder("NULLIF(");
                for (int i = 0; i < args.size(); ++i) {
                    Expression argExpr = (Expression)args.get(i);
                    str.append(JPQLHelper.getJPQLForExpression(argExpr));
                    if (i >= args.size() - 1) continue;
                    str.append(",");
                }
                str.append(")");
                return str.toString();
            }
            if (method.equalsIgnoreCase("ABS")) {
                Expression argExpr = (Expression)args.get(0);
                return "ABS(" + JPQLHelper.getJPQLForExpression(argExpr) + ")";
            }
            if (method.equalsIgnoreCase("AVG")) {
                Expression argExpr = (Expression)args.get(0);
                return "AVG(" + JPQLHelper.getJPQLForExpression(argExpr) + ")";
            }
            if (method.equalsIgnoreCase("MAX")) {
                Expression argExpr = (Expression)args.get(0);
                return "MAX(" + JPQLHelper.getJPQLForExpression(argExpr) + ")";
            }
            if (method.equalsIgnoreCase("MIN")) {
                Expression argExpr = (Expression)args.get(0);
                return "MIN(" + JPQLHelper.getJPQLForExpression(argExpr) + ")";
            }
            if (method.equalsIgnoreCase("SQRT")) {
                Expression argExpr = (Expression)args.get(0);
                return "SQRT(" + JPQLHelper.getJPQLForExpression(argExpr) + ")";
            }
            if (method.equalsIgnoreCase("SUM")) {
                Expression argExpr = (Expression)args.get(0);
                return "SUM(" + JPQLHelper.getJPQLForExpression(argExpr) + ")";
            }
            if (method.equalsIgnoreCase("SQL_function")) {
                StringBuilder str = new StringBuilder("FUNCTION(");
                for (int i = 0; i < args.size(); ++i) {
                    Expression argExpr = (Expression)args.get(i);
                    str.append(JPQLHelper.getJPQLForExpression(argExpr));
                    if (i >= args.size() - 1) continue;
                    str.append(",");
                }
                str.append(")");
                return str.toString();
            }
            throw new UnsupportedOperationException("Dont currently support InvokeExpression (" + invExpr + ") conversion into JPQL");
        }
        if (expr instanceof Literal) {
            Literal litExpr = (Literal)expr;
            Object value = litExpr.getLiteral();
            if (value instanceof String || value instanceof Character) {
                return "'" + value.toString() + "'";
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? "TRUE" : "FALSE";
            }
            if (value instanceof Time) {
                SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
                String timeStr = formatter.format((Time)value);
                return "{t '" + timeStr + "'}";
            }
            if (value instanceof java.sql.Date) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                String dateStr = formatter.format((java.sql.Date)value);
                return "{d '" + dateStr + "'}";
            }
            if (value instanceof Timestamp) {
                return "{ts '" + value.toString() + "'}";
            }
            if (value instanceof Date) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String datetimeStr = formatter.format((Date)value);
                return "{ts '" + datetimeStr + "'}";
            }
            return litExpr.getLiteral().toString();
        }
        if (expr instanceof VariableExpression) {
            VariableExpression varExpr = (VariableExpression)expr;
            return varExpr.getId();
        }
        if (expr instanceof SubqueryExpression) {
            SubqueryExpression subqExpr = (SubqueryExpression)expr;
            return subqExpr.getKeyword() + " " + JPQLHelper.getJPQLForExpression(subqExpr.getRight());
        }
        if (expr instanceof CaseExpression) {
            CaseExpression caseExpr = (CaseExpression)expr;
            List conds = caseExpr.getConditions();
            Expression elseExpr = caseExpr.getElseExpression();
            StringBuilder str = new StringBuilder("CASE ");
            if (conds != null) {
                for (CaseExpression.ExpressionPair cond : conds) {
                    Expression whenExpr = cond.getWhenExpression();
                    Expression actionExpr = cond.getActionExpression();
                    str.append("WHEN ");
                    str.append(JPQLHelper.getJPQLForExpression(whenExpr));
                    str.append(" THEN ");
                    str.append(JPQLHelper.getJPQLForExpression(actionExpr));
                    str.append(" ");
                }
            }
            if (elseExpr != null) {
                str.append("ELSE ");
                str.append(JPQLHelper.getJPQLForExpression(elseExpr));
                str.append(" ");
            }
            str.append("END");
            return str.toString();
        }
        throw new UnsupportedOperationException("Dont currently support " + expr.getClass().getName() + " in JPQLHelper");
    }
}

