/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.AttributeNode;
import javax.persistence.Subgraph;
import org.datanucleus.api.jpa.JPAGraph;
import org.datanucleus.api.jpa.JPASubgraph;
import org.datanucleus.metadata.MetaDataManager;

public class JPAAttributeNode<T>
implements AttributeNode<T> {
    MetaDataManager mmgr;
    JPAGraph parent;
    String name;
    Map<Class, Subgraph> subgraphsByType = null;

    public JPAAttributeNode(MetaDataManager mmgr, JPAGraph parent, String name) {
        this.mmgr = mmgr;
        this.parent = parent;
        this.name = name;
    }

    public String getAttributeName() {
        return this.name;
    }

    public void addSubgraph(JPASubgraph<T> subgraph) {
        if (this.subgraphsByType == null) {
            this.subgraphsByType = new HashMap<Class, Subgraph>();
        }
        this.subgraphsByType.put(subgraph.getClassType(), subgraph);
    }

    public Map<Class, Subgraph> getSubgraphs() {
        if (this.subgraphsByType == null) {
            return Collections.EMPTY_MAP;
        }
        return this.subgraphsByType;
    }

    public Map<Class, Subgraph> getKeySubgraphs() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String toString() {
        return "\"" + this.name + "\"";
    }
}

