/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.lang.reflect.Field;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.QueryTimeoutException;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.jpa.JPAEntityManager;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.exceptions.NucleusCanRetryException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.state.StateManager;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.util.ClassUtils;

public class NucleusJPAHelper {
    public static Object getObjectId(Object obj) {
        if (obj instanceof Persistable) {
            return ((Persistable)obj).dnGetObjectId();
        }
        return null;
    }

    public static EntityManager getEntityManager(Object obj) {
        if (obj instanceof Persistable) {
            return (JPAEntityManager)((Persistable)obj).dnGetExecutionContext().getOwner();
        }
        return null;
    }

    public static boolean isPersistent(Object obj) {
        if (obj instanceof Persistable) {
            return ((Persistable)obj).dnIsPersistent();
        }
        return false;
    }

    public static boolean isDeleted(Object obj) {
        if (obj instanceof Persistable) {
            return ((Persistable)obj).dnIsDeleted();
        }
        return false;
    }

    public static boolean isDetached(Object obj) {
        if (obj instanceof Persistable) {
            return ((Persistable)obj).dnIsDetached();
        }
        return false;
    }

    public static boolean isTransactional(Object obj) {
        if (obj instanceof Persistable) {
            return ((Persistable)obj).dnIsTransactional();
        }
        return false;
    }

    public static String getObjectState(Object obj) {
        if (obj == null) {
            return null;
        }
        if (NucleusJPAHelper.isDetached(obj)) {
            return "detached";
        }
        if (NucleusJPAHelper.isPersistent(obj)) {
            if (NucleusJPAHelper.isTransactional(obj)) {
                if (NucleusJPAHelper.isDeleted(obj)) {
                    return "persistent-deleted";
                }
                return "persistent";
            }
            return "persistent";
        }
        return "transient";
    }

    public static Object[] getDetachedStateForObject(Object obj) {
        if (obj == null || !NucleusJPAHelper.isDetached(obj)) {
            return null;
        }
        try {
            Field fld = ClassUtils.getFieldForClass(obj.getClass(), (String)"dnDetachedState");
            fld.setAccessible(true);
            return (Object[])fld.get(obj);
        }
        catch (Exception e) {
            throw new NucleusException("Exception accessing dnDetachedState field", (Throwable)e);
        }
    }

    public static String[] getDirtyFields(Object obj, EntityManager em) {
        if (obj == null || !(obj instanceof Persistable)) {
            return null;
        }
        Persistable pc = (Persistable)obj;
        if (NucleusJPAHelper.isDetached(pc)) {
            ExecutionContext ec = ((JPAEntityManager)em).getExecutionContext();
            ObjectProvider op = ec.getNucleusContext().getObjectProviderFactory().newForDetached(ec, (Object)pc, pc.dnGetObjectId(), null);
            pc.dnReplaceStateManager((StateManager)op);
            op.retrieveDetachState(op);
            String[] dirtyFieldNames = op.getDirtyFieldNames();
            pc.dnReplaceStateManager(null);
            return dirtyFieldNames;
        }
        ExecutionContext ec = ((JPAEntityManager)em).getExecutionContext();
        ObjectProvider op = ec.findObjectProvider((Object)pc);
        return op == null ? null : op.getDirtyFieldNames();
    }

    public static String[] getLoadedFields(Object obj, EntityManager em) {
        if (obj == null || !(obj instanceof Persistable)) {
            return null;
        }
        Persistable pc = (Persistable)obj;
        if (NucleusJPAHelper.isDetached(pc)) {
            ExecutionContext ec = ((JPAEntityManager)em).getExecutionContext();
            ObjectProvider op = ec.getNucleusContext().getObjectProviderFactory().newForDetached(ec, (Object)pc, pc.dnGetObjectId(), null);
            pc.dnReplaceStateManager((StateManager)op);
            op.retrieveDetachState(op);
            String[] loadedFieldNames = op.getLoadedFieldNames();
            pc.dnReplaceStateManager(null);
            return loadedFieldNames;
        }
        ExecutionContext ec = ((JPAEntityManager)em).getExecutionContext();
        ObjectProvider op = ec.findObjectProvider((Object)pc);
        return op == null ? null : op.getLoadedFieldNames();
    }

    public static PersistenceException getJPAExceptionForNucleusException(NucleusException ne) {
        if (ne instanceof ReachableObjectNotCascadedException) {
            throw new IllegalStateException(ne.getMessage());
        }
        if (ne instanceof org.datanucleus.store.query.QueryTimeoutException) {
            return new QueryTimeoutException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusDataStoreException) {
            if (ne.getNestedExceptions() != null) {
                return new PersistenceException(ne.getMessage(), ne.getCause());
            }
            return new PersistenceException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusCanRetryException) {
            if (ne.getNestedExceptions() != null) {
                return new PersistenceException(ne.getMessage(), ne.getCause());
            }
            return new PersistenceException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusObjectNotFoundException) {
            return new EntityNotFoundException(ne.getMessage());
        }
        if (ne instanceof NucleusUserException) {
            if (ne.getNestedExceptions() != null) {
                return new PersistenceException(ne.getMessage(), ne.getCause());
            }
            return new PersistenceException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusOptimisticException) {
            if (ne.getNestedExceptions() != null) {
                return new OptimisticLockException(ne.getMessage(), ne.getCause());
            }
            return new OptimisticLockException(ne.getMessage(), (Throwable)ne);
        }
        if (ne.getNestedExceptions() != null) {
            return new PersistenceException(ne.getMessage(), ne.getCause());
        }
        return new PersistenceException(ne.getMessage(), (Throwable)ne);
    }
}

