/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.jpa.JPAEntityGraph;
import org.datanucleus.api.jpa.metadata.JPAEntityGraphRegistrationListener;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.EventListenerMetaData;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataManagerImpl;
import org.datanucleus.metadata.MetadataFileType;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.xml.MetaDataParser;
import org.datanucleus.util.NucleusLogger;

public class JPAMetaDataManager
extends MetaDataManagerImpl {
    protected List eventListeners = new ArrayList();
    protected List<JPAEntityGraphRegistrationListener> entityGraphListeners = new ArrayList<JPAEntityGraphRegistrationListener>();

    public JPAMetaDataManager(NucleusContext ctxt) {
        super(ctxt);
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            if (this.allowXML && this.allowAnnotations) {
                NucleusLogger.METADATA.debug((Object)("MetaDataManager : Input=(XML,Annotations), XML-Validation=" + this.validateXML));
            } else if (this.allowXML && !this.allowAnnotations) {
                NucleusLogger.METADATA.debug((Object)("MetaDataManager : Input=(XML), XML-Validation=" + this.validateXML));
            } else if (!this.allowXML && this.allowAnnotations) {
                NucleusLogger.METADATA.debug((Object)"MetaDataManager : Input=(Annotations)");
            } else {
                NucleusLogger.METADATA.debug((Object)"MetaDataManager : Input=(NONE)");
            }
        }
    }

    public synchronized void registerEntityGraphListener(JPAEntityGraphRegistrationListener listener) {
        this.entityGraphListeners.add(listener);
    }

    public synchronized void registerEntityGraph(JPAEntityGraph eg) {
        for (JPAEntityGraphRegistrationListener listener : this.entityGraphListeners) {
            listener.entityGraphRegistered(eg);
        }
    }

    public List getEventListeners() {
        return this.eventListeners;
    }

    protected FileMetaData parseFile(URL fileURL) {
        if (this.metaDataParser == null) {
            this.metaDataParser = new MetaDataParser((MetaDataManager)this, this.nucleusContext.getPluginManager(), this.validateXML);
        }
        this.metaDataParser.setNamespaceAware(this.supportXMLNamespaces);
        return (FileMetaData)this.metaDataParser.parseMetaDataURL(fileURL, "jpa");
    }

    protected void postProcessClassMetaData(AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        if (cmd.getListeners() != null) {
            List classListeners = cmd.getListeners();
            for (int k = 0; k < classListeners.size(); ++k) {
                EventListenerMetaData elmd = (EventListenerMetaData)classListeners.get(k);
                this.populateListenerMethodsForEventListener(elmd, clr);
            }
        }
    }

    public void registerFile(String fileURLString, FileMetaData filemd, ClassLoaderResolver clr) {
        if (fileURLString == null) {
            return;
        }
        if (this.fileMetaDataByURLString.get(fileURLString) != null) {
            return;
        }
        this.fileMetaDataByURLString.put(fileURLString, filemd);
        this.registerQueriesForFile(filemd);
        this.registerStoredProcQueriesForFile(filemd);
        this.registerSequencesForFile(filemd);
        this.registerTableGeneratorsForFile(filemd);
        this.registerQueryResultMetaDataForFile(filemd);
        if (filemd.getListeners() != null) {
            List fileListeners = filemd.getListeners();
            this.eventListeners.addAll(fileListeners);
            for (int i = 0; i < fileListeners.size(); ++i) {
                EventListenerMetaData elmd = (EventListenerMetaData)fileListeners.get(i);
                this.populateListenerMethodsForEventListener(elmd, clr);
            }
        }
        if (filemd.getType() == MetadataFileType.JPA_MAPPING_FILE || filemd.getType() == MetadataFileType.ANNOTATIONS) {
            for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
                PackageMetaData pmd = filemd.getPackage(i);
                for (int j = 0; j < pmd.getNoOfClasses(); ++j) {
                    DiscriminatorMetaData dismd;
                    ClassMetaData cmd = pmd.getClass(j);
                    if (this.classesWithoutPersistenceInfo.contains(cmd.getFullClassName())) {
                        this.classesWithoutPersistenceInfo.remove(cmd.getFullClassName());
                    }
                    if (cmd.getEntityName() != null) {
                        this.classMetaDataByEntityName.put(cmd.getEntityName(), cmd);
                    }
                    if (cmd.getInheritanceMetaData() != null && (dismd = cmd.getInheritanceMetaData().getDiscriminatorMetaData()) != null) {
                        if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                            this.classMetaDataByDiscriminatorName.put(cmd.getFullClassName(), cmd);
                        } else if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP && dismd.getValue() != null) {
                            this.classMetaDataByDiscriminatorName.put(dismd.getValue(), cmd);
                        }
                    }
                    this.registerMetaDataForClass(cmd.getFullClassName(), (AbstractClassMetaData)cmd);
                    this.postProcessClassMetaData((AbstractClassMetaData)cmd, clr);
                }
            }
        }
    }

    private void populateListenerMethodsForEventListener(EventListenerMetaData elmd, ClassLoaderResolver clr) {
        Class listenerClass = clr.classForName(elmd.getClassName());
        this.populateListenerMethodsForClassInEventListener(elmd, listenerClass, clr);
    }

    private void populateListenerMethodsForClassInEventListener(EventListenerMetaData elmd, Class cls, ClassLoaderResolver clr) {
        Method[] methods = cls.getDeclaredMethods();
        if (methods != null) {
            for (int i = 0; i < methods.length; ++i) {
                Annotation[] methodAnnots = methods[i].getAnnotations();
                if (methodAnnots == null) continue;
                for (int j = 0; j < methodAnnots.length; ++j) {
                    if (methodAnnots[j].annotationType() != PrePersist.class && methodAnnots[j].annotationType() != PostPersist.class && methodAnnots[j].annotationType() != PreRemove.class && methodAnnots[j].annotationType() != PostRemove.class && methodAnnots[j].annotationType() != PreUpdate.class && methodAnnots[j].annotationType() != PostUpdate.class && methodAnnots[j].annotationType() != PostLoad.class) continue;
                    elmd.addCallback(methodAnnots[j].annotationType().getName(), methods[i].getDeclaringClass().getName(), methods[i].getName());
                }
            }
        }
        if (cls.getSuperclass() == null || cls.getSuperclass() == Object.class) {
            return;
        }
        this.populateListenerMethodsForClassInEventListener(elmd, cls.getSuperclass(), clr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized AbstractClassMetaData getMetaDataForClassInternal(Class c, ClassLoaderResolver clr) {
        if (c.isArray()) {
            return null;
        }
        if (this.isClassWithoutPersistenceInfo(c.getName())) {
            return null;
        }
        AbstractClassMetaData acmd = (AbstractClassMetaData)this.classMetaDataByClass.get(c.getName());
        if (acmd != null) {
            return acmd;
        }
        if (!this.allowMetaDataLoad) {
            return null;
        }
        try {
            FileMetaData annFilemd;
            this.updateLock.lock();
            if (this.allowAnnotations && (annFilemd = this.loadAnnotationsForClass(c, clr, true, true)) != null) {
                ClassMetaData classMetaData = annFilemd.getPackage(0).getClass(0);
                return classMetaData;
            }
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug((Object)LOCALISER.msg("044043", (Object)c.getName()));
            }
            this.classesWithoutPersistenceInfo.add(c.getName());
            AbstractClassMetaData abstractClassMetaData = null;
            return abstractClassMetaData;
        }
        finally {
            this.updateLock.unlock();
        }
    }
}

