/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.util.Map;
import javax.persistence.AttributeNode;
import javax.persistence.Subgraph;
import org.datanucleus.api.jpa.JPAGraph;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPASubgraph<T>
extends JPAGraph<T>
implements Subgraph<T> {
    public JPASubgraph(MetaDataManager mmgr, Class<T> clsType) {
        super(mmgr, clsType);
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Graph(");
        str.append("type=").append(this.classType.getName());
        if (this.attributeNodeMap != null) {
            boolean hasSubgraphs = false;
            str.append(", attributes=[");
            int i = 0;
            for (AttributeNode attr : this.attributeNodeMap.values()) {
                if (i > 0) {
                    str.append(",");
                }
                if (!hasSubgraphs && attr.getSubgraphs() != null && attr.getSubgraphs().size() > 0) {
                    hasSubgraphs = true;
                }
                str.append(attr.toString());
                ++i;
            }
            str.append("]");
            if (hasSubgraphs) {
                str.append(", subgraphs=[");
                for (AttributeNode attr : this.attributeNodeMap.values()) {
                    Map subgraphs = attr.getSubgraphs();
                    if (subgraphs == null || subgraphs.size() <= 0) continue;
                    str.append(StringUtils.collectionToString(subgraphs.values()));
                }
                str.append("]");
            }
        }
        str.append(")");
        return str.toString();
    }
}

