/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.AttributeNode;
import javax.persistence.EntityGraph;
import javax.persistence.Subgraph;
import javax.persistence.metamodel.Attribute;
import org.datanucleus.api.jpa.JPAAttributeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAEntityGraph<T>
implements EntityGraph<T> {
    String name;
    Class<T> type;
    List<AttributeNode<?>> attributeNodes;
    boolean mutable = true;

    public JPAEntityGraph(String name, Class type) {
        this.name = name;
        this.type = type;
    }

    public JPAEntityGraph<T> cloneMutableEntityGraph() {
        JPAEntityGraph<T> eg = new JPAEntityGraph<T>(this.name, this.type);
        if (this.attributeNodes != null) {
            eg.attributeNodes = new ArrayList();
            eg.attributeNodes.addAll(this.attributeNodes);
        }
        return eg;
    }

    public void setNotMutable() {
        this.mutable = false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!this.mutable) {
            throw new IllegalStateException("This EntityGraph is not mutable");
        }
        this.name = name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public void addAttributeNodes(String ... attributeNames) {
        if (!this.mutable) {
            throw new IllegalStateException("This EntityGraph is not mutable");
        }
        if (this.attributeNodes == null) {
            this.attributeNodes = new ArrayList();
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            JPAAttributeNode node = new JPAAttributeNode(attributeNames[i]);
            this.attributeNodes.add(node);
        }
    }

    public void addAttributeNodes(Attribute<T, ?> ... attributes) {
        if (!this.mutable) {
            throw new IllegalStateException("This EntityGraph is not mutable");
        }
        if (this.attributeNodes == null) {
            this.attributeNodes = new ArrayList();
        }
        for (int i = 0; i < attributes.length; ++i) {
            JPAAttributeNode node = new JPAAttributeNode(attributes[i].getName());
            this.attributeNodes.add(node);
        }
    }

    public List<AttributeNode<?>> getAttributeNodes() {
        return this.attributeNodes;
    }

    public <X> Subgraph<X> addSubgraph(Attribute<T, X> attribute) {
        if (!this.mutable) {
            throw new IllegalStateException("This EntityGraph is not mutable");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public <X> Subgraph<? extends X> addSubgraph(Attribute<T, X> attribute, Class<? extends X> type) {
        if (!this.mutable) {
            throw new IllegalStateException("This EntityGraph is not mutable");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public <X> Subgraph<X> addSubgraph(String attributeName) {
        if (!this.mutable) {
            throw new IllegalStateException("This EntityGraph is not mutable");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public <X> Subgraph<X> addSubgraph(String attributeName, Class<X> type) {
        if (!this.mutable) {
            throw new IllegalStateException("This EntityGraph is not mutable");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public <X> Subgraph<X> addKeySubgraph(Attribute<T, X> attribute) {
        if (!this.mutable) {
            throw new IllegalStateException("This EntityGraph is not mutable");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public <X> Subgraph<? extends X> addKeySubgraph(Attribute<T, X> attribute, Class<? extends X> type) {
        if (!this.mutable) {
            throw new IllegalStateException("This EntityGraph is not mutable");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public <X> Subgraph<X> addKeySubgraph(String attributeName) {
        if (!this.mutable) {
            throw new IllegalStateException("This EntityGraph is not mutable");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public <X> Subgraph<X> addKeySubgraph(String attributeName, Class<X> type) {
        if (!this.mutable) {
            throw new IllegalStateException("This EntityGraph is not mutable");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public <T> Subgraph<? extends T> addSubclassSubgraph(Class<? extends T> type) {
        if (!this.mutable) {
            throw new IllegalStateException("This EntityGraph is not mutable");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        if (this.attributeNodes != null) {
            for (AttributeNode<?> attr : this.attributeNodes) {
                if (str.length() > 0) {
                    str.append(",");
                }
                str.append(attr);
            }
        }
        return "EntityGraph [" + this.name + "] type=" + this.getClass().getName() + " attributes=[" + str.toString() + "]";
    }
}

