/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.QueryTimeoutException;
import org.datanucleus.ClassConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.jpa.JPAEntityManager;
import org.datanucleus.api.jpa.JPAPersistenceManager;
import org.datanucleus.exceptions.NucleusCanRetryException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.util.Localiser;

public class NucleusJPAHelper {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ClassConstants.NUCLEUS_CONTEXT_LOADER);

    public static EntityManager getEntityManager(Object obj) {
        if (obj instanceof PersistenceCapable) {
            JPAPersistenceManager pm = (JPAPersistenceManager)((PersistenceCapable)obj).jdoGetPersistenceManager();
            if (pm == null) {
                return null;
            }
            return pm.getEntityManager();
        }
        return null;
    }

    public static boolean isPersistent(Object obj) {
        if (obj instanceof PersistenceCapable) {
            return ((PersistenceCapable)obj).jdoIsPersistent();
        }
        return false;
    }

    public static boolean isDeleted(Object obj) {
        if (obj instanceof PersistenceCapable) {
            return ((PersistenceCapable)obj).jdoIsDeleted();
        }
        return false;
    }

    public static boolean isDetached(Object obj) {
        if (obj instanceof PersistenceCapable) {
            return ((PersistenceCapable)obj).jdoIsDetached();
        }
        return false;
    }

    public static boolean isTransactional(Object obj) {
        if (obj instanceof PersistenceCapable) {
            return ((PersistenceCapable)obj).jdoIsTransactional();
        }
        return false;
    }

    public static String getObjectState(Object obj) {
        if (obj == null) {
            return null;
        }
        if (NucleusJPAHelper.isDetached(obj)) {
            return "detached";
        }
        if (NucleusJPAHelper.isPersistent(obj)) {
            if (NucleusJPAHelper.isTransactional(obj)) {
                if (NucleusJPAHelper.isDeleted(obj)) {
                    return "persistent-deleted";
                }
                return "persistent";
            }
            return "persistent";
        }
        return "transient";
    }

    public static String[] getDirtyFields(Object obj, PersistenceManager em) {
        if (obj == null || !(obj instanceof PersistenceCapable)) {
            return null;
        }
        PersistenceCapable pc = (PersistenceCapable)obj;
        if (NucleusJPAHelper.isDetached(pc)) {
            ExecutionContext ec = ((JPAEntityManager)em).getExecutionContext();
            ObjectProvider op = ec.newObjectProviderForDetached((Object)pc, pc.jdoGetObjectId(), null);
            pc.jdoReplaceStateManager((StateManager)op);
            op.retrieveDetachState(op);
            String[] dirtyFieldNames = op.getDirtyFieldNames();
            pc.jdoReplaceStateManager(null);
            return dirtyFieldNames;
        }
        ExecutionContext ec = ((JPAEntityManager)em).getExecutionContext();
        ObjectProvider sm = ec.findObjectProvider((Object)pc);
        if (sm == null) {
            return null;
        }
        return sm.getDirtyFieldNames();
    }

    public static String[] getLoadedFields(Object obj, EntityManager em) {
        if (obj == null || !(obj instanceof PersistenceCapable)) {
            return null;
        }
        PersistenceCapable pc = (PersistenceCapable)obj;
        if (NucleusJPAHelper.isDetached(pc)) {
            ExecutionContext ec = ((JPAEntityManager)em).getExecutionContext();
            pc.jdoGetObjectId();
            ObjectProvider op = ec.newObjectProviderForDetached((Object)pc, pc.jdoGetObjectId(), null);
            pc.jdoReplaceStateManager((StateManager)op);
            op.retrieveDetachState(op);
            String[] loadedFieldNames = op.getLoadedFieldNames();
            pc.jdoReplaceStateManager(null);
            return loadedFieldNames;
        }
        ExecutionContext ec = ((JPAEntityManager)em).getExecutionContext();
        ObjectProvider sm = ec.findObjectProvider((Object)pc);
        if (sm == null) {
            return null;
        }
        return sm.getLoadedFieldNames();
    }

    public static PersistenceException getJPAExceptionForJDOException(JDOException jdoe) {
        if (jdoe instanceof JDODataStoreException) {
            if (jdoe.getNestedExceptions() != null) {
                return new PersistenceException(jdoe.getMessage(), jdoe.getCause());
            }
            return new PersistenceException(jdoe.getMessage(), (Throwable)jdoe);
        }
        if (jdoe instanceof JDOObjectNotFoundException) {
            return new EntityNotFoundException(jdoe.getMessage());
        }
        if (jdoe instanceof JDOUserException) {
            if (jdoe.getNestedExceptions() != null) {
                return new PersistenceException(jdoe.getMessage(), jdoe.getCause());
            }
            return new PersistenceException(jdoe.getMessage(), (Throwable)jdoe);
        }
        if (jdoe instanceof JDOOptimisticVerificationException) {
            if (jdoe.getNestedExceptions() != null) {
                return new OptimisticLockException(jdoe.getMessage(), jdoe.getCause());
            }
            return new OptimisticLockException(jdoe.getMessage(), (Throwable)jdoe);
        }
        if (jdoe.getNestedExceptions() != null) {
            return new PersistenceException(jdoe.getMessage(), jdoe.getCause());
        }
        return new PersistenceException(jdoe.getMessage(), (Throwable)jdoe);
    }

    public static PersistenceException getJPAExceptionForNucleusException(NucleusException ne) {
        if (ne instanceof ReachableObjectNotCascadedException) {
            throw new IllegalStateException(ne.getMessage());
        }
        if (ne instanceof org.datanucleus.store.query.QueryTimeoutException) {
            return new QueryTimeoutException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusDataStoreException) {
            if (ne.getNestedExceptions() != null) {
                return new PersistenceException(ne.getMessage(), ne.getCause());
            }
            return new PersistenceException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusCanRetryException) {
            if (ne.getNestedExceptions() != null) {
                return new PersistenceException(ne.getMessage(), ne.getCause());
            }
            return new PersistenceException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusObjectNotFoundException) {
            return new EntityNotFoundException(ne.getMessage());
        }
        if (ne instanceof NucleusUserException) {
            if (ne.getNestedExceptions() != null) {
                return new PersistenceException(ne.getMessage(), ne.getCause());
            }
            return new PersistenceException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusOptimisticException) {
            if (ne.getNestedExceptions() != null) {
                return new OptimisticLockException(ne.getMessage(), ne.getCause());
            }
            return new OptimisticLockException(ne.getMessage(), (Throwable)ne);
        }
        if (ne.getNestedExceptions() != null) {
            return new PersistenceException(ne.getMessage(), ne.getCause());
        }
        return new PersistenceException(ne.getMessage(), (Throwable)ne);
    }

    public static JDOImplHelper getJDOImplHelper() {
        return (JDOImplHelper)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return JDOImplHelper.getInstance();
                }
                catch (SecurityException e) {
                    throw new JDOFatalUserException(LOCALISER.msg("026000"), (Throwable)e);
                }
            }
        });
    }
}

